/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.neql;

import com.tridium.neql.EvalOnIterator;
import java.util.Collection;
import java.util.LinkedList;
import javax.baja.neql.Expression;
import javax.baja.sys.Context;
import javax.baja.tag.Entity;

public class EvalOnExpression
extends Expression {
    private final Expression expr;
    private final Expression target;

    public EvalOnExpression(Expression expr, Expression target) {
        this.expr = expr;
        this.target = target;
    }

    @Override
    public int getNodeType() {
        return 19;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public Expression getTarget() {
        return this.target;
    }

    @Override
    public Collection<?> evaluate(Entity entity, Context context) {
        Collection<?> targets = this.target.evaluate(entity, context);
        LinkedList evaluations = new LinkedList();
        for (Entity target : targets) {
            evaluations.addAll(this.expr.evaluate(target, context));
        }
        return evaluations;
    }

    @Override
    protected boolean evalBoolean(Entity entity, Context context) {
        EvalOnIterator iterator = EvalOnIterator.make(this, entity, context);
        while (iterator.hasNext()) {
            if (!this.expr.evalBoolean(iterator.next(), context)) continue;
            return true;
        }
        return false;
    }
}

