/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.neql;

import java.util.Collection;
import java.util.Collections;
import javax.baja.data.BIDataValue;
import javax.baja.neql.Expression;
import javax.baja.neql.GetTagExpression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.tag.Entity;

public class ContextExpression
extends Expression {
    private final Expression expr;
    private final String key;

    public ContextExpression(Expression expr) {
        this.expr = expr;
        this.key = expr instanceof GetTagExpression ? ((GetTagExpression)expr).getKey() : null;
    }

    @Override
    public int getNodeType() {
        return 14;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public Collection<BObject> evaluate(Entity entity, Context context) {
        if (context == null) {
            return Collections.singletonList(BBoolean.FALSE);
        }
        String key = ((GetTagExpression)this.expr).getKey();
        BObject contextValue = context.getFacets().getFacet(key);
        if (contextValue != null) {
            return Collections.singletonList(contextValue);
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean evalBoolean(Entity entity, Context context) {
        BIDataValue value = this.getValue(context);
        return value != null && value != BBoolean.FALSE;
    }

    BIDataValue getValue(Context context) {
        if (context == null) {
            return null;
        }
        BObject value = context.getFacets().getFacet(this.key);
        return value instanceof BIDataValue ? (BIDataValue)value : null;
    }
}

