/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.neql.component;

import java.util.Stack;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordHistory;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

public class BogCursor
implements SlotCursor<Slot> {
    public static final int ALL = Integer.MAX_VALUE;
    private BComplex root;
    private int depth;
    private Type[] returnTypes;
    private boolean componentOnly;
    private boolean stop;
    private boolean stopped = false;
    private SlotCursor<Property> current;
    private int currentDepth = 0;
    private Stack nodeStack;
    private Context context;

    public BogCursor(BComponent root, Context context) {
        this((BComplex)root, Integer.MAX_VALUE, null, false, context);
    }

    public BogCursor(BComplex root, int depth, Type[] returnTypes, boolean stop, Context context) {
        Type[] typeArray;
        this.root = root;
        this.depth = depth;
        if (returnTypes == null || returnTypes.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = BComponent.TYPE;
        } else {
            typeArray = returnTypes;
        }
        this.returnTypes = typeArray;
        this.stop = stop;
        this.context = context;
        this.componentOnly = true;
        for (int i = 0; i < this.returnTypes.length; ++i) {
            if (this.returnTypes[i].is(BComponent.TYPE)) continue;
            this.componentOnly = false;
            break;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public BComplex root() {
        return this.root;
    }

    public BObject target() {
        return this.current.target();
    }

    public boolean next() {
        return this.next(this.returnTypes);
    }

    public boolean nextObject() {
        while (this.next(this.returnTypes)) {
            if (this.getTypeAccess() != 7) continue;
            return true;
        }
        return false;
    }

    public boolean nextComponent() {
        while (this.next(this.returnTypes)) {
            if (!this.get().isComponent()) continue;
            return true;
        }
        return false;
    }

    public boolean next(Class<?> cls) {
        while (this.next(this.returnTypes)) {
            BValue o = this.get();
            if (!cls.isInstance(o)) continue;
            return true;
        }
        return false;
    }

    public boolean next(Type[] returnTypes) {
        while (this.nextImpl()) {
            BValue o = this.get();
            if (o instanceof BPassword || o instanceof BPasswordHistory || o instanceof BICredentials || o instanceof BAbstractAuthenticator || !this.isMatch((BObject)o, returnTypes)) continue;
            if (this.stop) {
                this.stopped = true;
            }
            return true;
        }
        return false;
    }

    private boolean nextImpl() {
        if (this.depth == 0) {
            return false;
        }
        if (this.current == null) {
            if (!this.root.isComplex()) {
                return false;
            }
            this.current = this.root.asComplex().getProperties();
            if (this.componentOnly) {
                return this.current.nextComponent();
            }
            return this.current.next();
        }
        BComplex newRoot = null;
        SlotCursor newRootProps = null;
        boolean hasProps = false;
        if (!this.stopped && this.currentDepth + 1 < this.depth && (this.componentOnly ? this.current.get().isComponent() : this.current.get().isComplex())) {
            newRoot = (BComplex)this.current.get();
            newRootProps = null;
            newRootProps = newRoot.getProperties();
            if (this.componentOnly) {
                if (newRootProps.nextComponent()) {
                    hasProps = true;
                }
            } else if (newRootProps.next()) {
                hasProps = true;
            }
        }
        this.stopped = false;
        if (hasProps) {
            ++this.currentDepth;
            if (this.nodeStack == null) {
                this.nodeStack = new Stack();
            }
            this.nodeStack.push(this.current);
            this.current = newRootProps;
            return true;
        }
        while (!(!this.componentOnly ? this.current.next() : this.current.nextComponent())) {
            if (this.nodeStack == null || this.nodeStack.empty()) {
                return false;
            }
            this.current = (SlotCursor)this.nodeStack.pop();
            --this.currentDepth;
        }
        return true;
    }

    private boolean isMatch(BObject o, Type[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (!o.getType().is(types[i])) continue;
            return true;
        }
        return false;
    }

    public Slot slot() {
        return this.current.slot();
    }

    public Property property() {
        return this.current.property();
    }

    public int getTypeAccess() {
        return this.current.getTypeAccess();
    }

    public BValue get() {
        return this.current.get();
    }

    public void close() {
        this.depth = 0;
        this.current = null;
    }

    public boolean getBoolean() {
        return this.current.getBoolean();
    }

    public int getInt() {
        return this.current.getInt();
    }

    public long getLong() {
        return this.current.getLong();
    }

    public float getFloat() {
        return this.current.getFloat();
    }

    public double getDouble() {
        return this.current.getDouble();
    }

    public String getString() {
        return this.current.getString();
    }

    public Action action() {
        return this.slot().asAction();
    }

    public Topic topic() {
        return this.slot().asTopic();
    }
}

