/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.neql;

import com.tridium.neql.Constants;
import com.tridium.neql.ExprParser;
import com.tridium.neql.NeqlTokenizer;
import com.tridium.neql.RuntimeCompilerException;
import com.tridium.neql.Token;
import com.tridium.neql.UnexpectedTokenTypeException;
import javax.baja.neql.Expression;
import javax.baja.neql.Traverse;
import javax.baja.tag.Id;

public class TraverseParser
implements Constants {
    private NeqlTokenizer tokens;
    private Token current;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Traverse parse(NeqlTokenizer tokens) {
        boolean outgoing;
        this.tokens = tokens;
        this.next();
        Expression predicate = null;
        this.match(16);
        this.skipWhitespace();
        Id relationId = this.parseId();
        this.skipWhitespace();
        if (this.current.type != 6) throw new RuntimeCompilerException(this.current.index, "Expecting traverse operator: -> or -<");
        if (this.current.opType == 12) {
            this.matchOperator(12);
            outgoing = true;
        } else {
            if (this.current.opType != 11) throw new RuntimeCompilerException(this.current.index, "Expecting traverse operator: -> or -<");
            this.matchOperator(11);
            outgoing = false;
        }
        this.skipWhitespace();
        if (this.current.type != 17) return new Traverse(relationId, outgoing, predicate);
        this.match(17);
        this.skipWhitespace();
        tokens.push(this.current);
        predicate = new ExprParser().parse(tokens);
        this.next();
        return new Traverse(relationId, outgoing, predicate);
    }

    protected Id parseId() {
        String name;
        String namespace;
        Token tagToken = this.match(1);
        if (this.current.type == 18) {
            namespace = tagToken.lex;
            this.match(18);
            name = this.match((int)1).lex;
        } else {
            namespace = "";
            name = tagToken.lex;
        }
        return Id.newId((String)namespace, (String)name);
    }

    private Token next() {
        Token result = this.current;
        this.current = this.tokens.next();
        return result;
    }

    private Token match(int matchType) {
        Token result = this.current;
        if (this.current.type != matchType) {
            throw new UnexpectedTokenTypeException(this.current.index, matchType, this.current.type);
        }
        this.next();
        return result;
    }

    private Token skipWhitespace() {
        while (this.current.type == 0) {
            this.next();
        }
        return this.current;
    }

    private Token matchOperator(int matchOpType) {
        Token op = this.match(6);
        if (op.opType != matchOpType) {
            throw new UnexpectedTokenTypeException(this.current.index, 6, this.current.type);
        }
        return op;
    }
}

