/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtilsBacnet.model;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.schedule.BBacnetScheduleExport;
import com.tridium.bacnet.schedule.BBacnetScheduleImportExt;
import com.tridium.clUtils.model.BModelHelper;
import com.tridium.clUtils.model.IModelHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.io.ValueDocEncoder;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BBacnetScheduleModelHelper
extends BModelHelper {
    public static final Type TYPE = Sys.loadType(BBacnetScheduleModelHelper.class);
    public static final String LINK_TYPE = "remoteBacnetSchedule";
    public static final String DEVICE = "device";
    public static final String OBJECT = "object";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_ARRAY_INDEX = "index";

    public Type getType() {
        return TYPE;
    }

    protected void registerSelf() {
        TypeInfo[] typeInfos;
        for (TypeInfo typeInfo : typeInfos = Sys.getRegistry().getConcreteTypes(BBacnetScheduleImportExt.TYPE.getTypeInfo())) {
            BModelHelper.registerHelper((String)typeInfo.getTypeClassName(), (IModelHelper)this);
        }
        for (TypeInfo typeInfo : typeInfos = Sys.getRegistry().getConcreteTypes(BBacnetScheduleExport.TYPE.getTypeInfo())) {
            BModelHelper.registerHelper((String)typeInfo.getTypeClassName(), (IModelHelper)this);
        }
    }

    public void encodeLinks(ValueDocEncoder encoder, BComponent component) {
        log.finer(() -> String.format("BACnet schedule model helper encoding additional links on %s", component.getSlotPath()));
        BBacnetObjectIdentifier objectId = BBacnetScheduleModelHelper.getObjectId(component);
        BBacnetDevice device = BBacnetScheduleModelHelper.getDevice(component);
        if (device != null && objectId != null) {
            BBacnetListOf propRefs = BBacnetScheduleModelHelper.getPropertyReferences(device, objectId);
            Arrays.stream(propRefs.getChildren(BBacnetDeviceObjectPropertyReference.class)).forEach(dopr -> this.encodeLink(encoder, (BBacnetDeviceObjectPropertyReference)dopr));
        }
    }

    private static BBacnetObjectIdentifier getObjectId(Object target) {
        if (target instanceof BBacnetScheduleImportExt) {
            return ((BBacnetScheduleImportExt)target).getObjectId();
        }
        if (target instanceof BBacnetScheduleExport) {
            return ((BBacnetScheduleExport)target).getObjectId();
        }
        return null;
    }

    private static BBacnetDevice getDevice(Object target) {
        if (target instanceof BBacnetScheduleImportExt) {
            return (BBacnetDevice)((BBacnetScheduleImportExt)target).getDevice();
        }
        if (target instanceof BBacnetScheduleExport) {
            return (BBacnetDevice)((BBacnetScheduleExport)target).getDevice();
        }
        return null;
    }

    private static BBacnetListOf getPropertyReferences(BBacnetDevice device, BBacnetObjectIdentifier objectId) {
        BBacnetListOf propRefs = new BBacnetListOf(BBacnetDeviceObjectPropertyReference.TYPE);
        try {
            if (device.isOperational()) {
                byte[] encodedPropertyRefs = BBacnetNetwork.bacnet().getBacnetComm().readProperty(device.getAddress(), objectId, 54);
                propRefs = (BBacnetListOf)AsnUtil.fromAsn((int)-3, (byte[])encodedPropertyRefs, (BValue)propRefs);
            } else {
                log.fine(() -> String.format("Cannot get schedule target references for %s in %s; device is currently non-operational", objectId, device));
            }
        }
        catch (BacnetException bacnetExc) {
            log.log(Level.FINE, log.isLoggable(Level.FINER) ? bacnetExc : null, () -> String.format("Cannot get schedule target references for %s in %s: BacnetException %s", objectId, device, bacnetExc));
        }
        return propRefs;
    }

    private void encodeLink(ValueDocEncoder encoder, BBacnetDeviceObjectPropertyReference dopRef) {
        try {
            encoder.start("p");
            encoder.attr("linkType", LINK_TYPE);
            try {
                if (dopRef.isDeviceIdUsed()) {
                    encoder.attr(DEVICE, dopRef.getDeviceId().encodeToString());
                }
                encoder.attr(OBJECT, dopRef.getObjectId().encodeToString());
                encoder.attr(PROPERTY, BBacnetPropertyIdentifier.tag((int)dopRef.getPropertyId()));
                if (dopRef.isPropertyArrayIndexUsed()) {
                    encoder.attr(PROPERTY_ARRAY_INDEX, (double)dopRef.getPropertyArrayIndex());
                }
            }
            finally {
                encoder.end("p");
            }
        }
        catch (IOException e) {
            log.finer("Unable to encode external link: " + dopRef.toString());
        }
    }
}

