/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.installapp;

import com.tridium.template.ui.ApplicationTemplateInstallUtil;
import com.tridium.template.ui.installapp.BackupStepArtifact;
import com.tridium.template.ui.installapp.GeneralStepArtifact;
import com.tridium.template.ui.installapp.OptionalComponentsArtifact;
import com.tridium.template.ui.installapp.WizardUtil;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.WidgetUiHandler;
import com.tridium.ui.wizard.step.WizardStep;
import javax.baja.sys.Context;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;

public class ConfirmInstallApplicationTemplateUiHandler
extends WidgetUiHandler {
    private final ApplicationTemplateInstallUtil installInfo;
    private BLabel label = new BLabel();

    public static WizardStep makeWizardStep(ApplicationTemplateInstallUtil installInfo) {
        String description;
        String title;
        switch (installInfo.getSourceType()) {
            case 2: {
                title = "installApplication.confirmInstallApplicationExcelFile.title";
                description = "installApplication.confirmInstallApplicationExcelFile.description";
                break;
            }
            default: {
                title = "installApplication.confirmInstallApplicationTemplate.title";
                description = "installApplication.confirmInstallApplicationTemplate.description";
            }
        }
        WizardStep wizardStep = WizardUtil.makeStep(title, description, (WizardStep.IUiHandler)new ConfirmInstallApplicationTemplateUiHandler(installInfo));
        wizardStep.setForceFinishStep(true);
        return wizardStep;
    }

    private ConfirmInstallApplicationTemplateUiHandler(ApplicationTemplateInstallUtil installInfo) {
        this.label.setHalign(BHalign.left);
        this.installInfo = installInfo;
        this.setWidget(WizardUtil.wrapInCenter((BWidget)this.label));
    }

    public StepArtifact create(WizardStep step, StepModel model, IWizardView view, Context cx) {
        this.updateLabelText(model);
        WidgetUiHandler.WidgetStepArtifact stepArtifact = (WidgetUiHandler.WidgetStepArtifact)super.create(step, model, view, cx);
        return new GeneralStepArtifact(stepArtifact, this.installInfo);
    }

    public boolean restoreFromNext(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        this.updateLabelText(model);
        return super.restoreFromNext(artifact, model, view, cx);
    }

    public boolean restoreFromBack(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        this.updateLabelText(model);
        return super.restoreFromBack(artifact, model, view, cx);
    }

    private void updateLabelText(StepModel model) {
        StringBuilder message = new StringBuilder();
        if (this.installInfo.getSourceType() == 2) {
            message.append(WizardUtil.LEX.getText("installApplication.confirmInstallApplicationExcelFile.message", new Object[]{this.installInfo.getSourceFile().getFileName(), this.installInfo.getStation().getStationDisplayName(null)}));
        } else if (this.installInfo.getSourceType() == 1) {
            int optionalComponentCount;
            message.append(WizardUtil.LEX.getText("installApplication.confirmInstallApplicationTemplate.message", new Object[]{this.installInfo.getSourceFile().getFileName(), this.installInfo.getStation().getStationDisplayName(null)}));
            if (this.installInfo.doesStationSupportUpgradeAndOptionals() && (optionalComponentCount = OptionalComponentsArtifact.getOptionalComponentCount(model)) > 0) {
                int installedOptionalComponents = OptionalComponentsArtifact.getInstalledOptionalComponentCount(model);
                message.append("\n\n");
                if (installedOptionalComponents == 0) {
                    message.append(WizardUtil.LEX.getText("installApplication.confirmInstallApplicationTemplate.optionals.none", new Object[]{optionalComponentCount}));
                } else if (optionalComponentCount == installedOptionalComponents) {
                    message.append(WizardUtil.LEX.getText("installApplication.confirmInstallApplicationTemplate.optionals.all", new Object[]{optionalComponentCount}));
                } else {
                    message.append(WizardUtil.LEX.getText("installApplication.confirmInstallApplicationTemplate.optionals.counts", new Object[]{installedOptionalComponents, optionalComponentCount}));
                }
            }
        }
        message.append("\n\n");
        message.append(WizardUtil.LEX.get("installApplication.confirmInstallApplicationTemplate.backup." + (BackupStepArtifact.canPerformBackup(model) ? "yes" : "no")));
        this.label.setText(message.toString());
    }
}

