/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.file;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.file.types.bog.BBogSpace;
import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.neql.component.BNeqlComponentQueryHandler;
import com.tridium.sys.Nre;
import com.tridium.sys.tag.ComponentTags;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import com.tridium.tagdictionary.BNiagaraTagDictionary;
import com.tridium.tagdictionary.util.ImportUtil;
import com.tridium.tagdictionary.util.TagDictionaryUtil;
import com.tridium.template.BPasswordBinding;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.BTemplateService;
import com.tridium.template.TemplateConst;
import com.tridium.template.file.BMemoryFileSpace;
import com.tridium.template.file.BMemoryImageFile;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.file.EmbeddedPxScanner;
import com.tridium.template.file.EmbeddedPxSource;
import com.tridium.template.file.ImageFileRef;
import com.tridium.template.file.MemoryPxFileRef;
import com.tridium.template.file.NtplUtil;
import com.tridium.template.file.PxFileRef;
import com.tridium.template.file.TemplateManager;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.template.ui.BSelectInputDialog;
import com.tridium.template.ui.BSelectOutputDialog;
import com.tridium.template.ui.BSelectTagGroupDialog;
import com.tridium.template.ui.BTemplateManager;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.util.CompUtil;
import com.tridium.util.LinkUtil;
import com.tridium.util.PasswordUtil;
import com.tridium.workbench.util.BEditTagDialog;
import com.tridium.workbench.util.TagUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BPxView;
import javax.baja.converters.BIBooleanToSimple;
import javax.baja.converters.BIEnumToSimple;
import javax.baja.converters.BINumericToSimple;
import javax.baja.converters.BIStatusToSimple;
import javax.baja.data.BIDataValue;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BMemoryFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.types.image.BImageFile;
import javax.baja.file.types.log.BILogFile;
import javax.baja.file.types.text.BCsvFile;
import javax.baja.file.types.text.BJsonFile;
import javax.baja.file.types.text.BPxFile;
import javax.baja.fox.BFoxProxySession;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.neql.NeqlQuery;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.search.BResultsRequest;
import javax.baja.search.BSearchParams;
import javax.baja.search.BSearchResult;
import javax.baja.search.BSearchResultSet;
import javax.baja.search.BSearchService;
import javax.baja.search.BSearchTask;
import javax.baja.security.BPassword;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.space.Mark;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BLink;
import javax.baja.sys.BMarker;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Flags;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagInfo;
import javax.baja.tag.Tags;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.tagdictionary.BTagGroupInfoList;
import javax.baja.tagdictionary.BTagInfoList;
import javax.baja.ui.BBinding;
import javax.baja.ui.BPicture;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.px.PxProperty;
import javax.baja.util.BFormat;
import javax.baja.util.BUnrestrictedFolder;
import javax.baja.util.BUuid;
import javax.baja.util.CloseableIterator;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

public final class TmplUtil {
    public static final int INPUT = 0;
    public static final int OUTPUT = 10;
    public static final int RELATION = 20;
    public static final int NO_HINTS = 1;
    public static final int NONE_FOUND = 2;
    public static final int NONE_SELECTED = 3;
    public static final int ADDED_BINDING = 4;
    public static final int NOT_LINKED = 5;
    public static final int NOT_LINKED_TYPES = 6;
    public static final int NOT_LINKED_NO_OUT = 7;
    public static final int NOT_LINKED_NOT_COMP = 8;
    public static final int EXCEPTION = 99;
    public static final Logger log = Logger.getLogger("ntpl");
    private static final Lexicon lex = Lexicon.make((String)"template");
    private static int ACE_DEPTH = 4;

    private TmplUtil() {
    }

    public static Object[] findMatchingObjects(BTemplateManager.IoSlotInfo slotInfo, BSearchService searchService, BTemplateService templateService, BComponent base, Lexicon lex) {
        try {
            return TmplUtil.findMatchingObjects(slotInfo.bindHints, slotInfo.slotPathScope, slotInfo.resultsMessages, searchService, templateService, base, lex);
        }
        catch (Exception e) {
            slotInfo.results = 99;
            slotInfo.otherName = e.getMessage();
            slotInfo.otherSlot = e.getCause().toString();
            return null;
        }
    }

    private static SlotPath resolveSlotPathScope(String slotPathScope) {
        if (slotPathScope == null || slotPathScope.length() == 0) {
            return SlotPath.EMPTY_SLOT_PATH;
        }
        try {
            String[] rawNames = slotPathScope.split("/");
            ArrayList<String> escapedNames = new ArrayList<String>();
            for (String rawName : rawNames) {
                if (rawName.length() <= 0) continue;
                escapedNames.add(SlotPath.escape((String)rawName));
            }
            if (escapedNames.size() == 0) {
                return SlotPath.EMPTY_SLOT_PATH;
            }
            String[] pathNames = new String[escapedNames.size()];
            escapedNames.toArray(pathNames);
            return new SlotPath("slot", pathNames);
        }
        catch (Exception e) {
            log.warning(String.format("Template slot path scope %s is invalid: %s", slotPathScope, e.getLocalizedMessage()));
            return SlotPath.EMPTY_SLOT_PATH;
        }
    }

    public static Object[] findMatchingObjects(String bindHints, BSearchService searchService, BTemplateService templateService, BComponent base, Lexicon lex) {
        return TmplUtil.findMatchingObjects(bindHints, "", new ArrayList<String>(), searchService, templateService, base, lex);
    }

    public static Object[] findMatchingObjects(String bindHints, String slotPathScope, List<String> resultsMessages, BSearchService searchService, BTemplateService templateService, BComponent base, Lexicon lex) {
        BOrd searchTask;
        BSpace space = base.getSpace();
        boolean isOffline = space instanceof BBogSpace;
        BComponent rootComponent = ((BComponentSpace)space).getRootComponent();
        if (isOffline || searchService == null) {
            return TmplUtil.findMatchingObjects(bindHints, templateService, base, lex);
        }
        if (!searchService.getStatus().isValid()) {
            throw new RuntimeException(lex.getText("templateManager.searchService.notValid.exception"));
        }
        BComponent scope = rootComponent;
        if (slotPathScope != null && slotPathScope.length() > 0) {
            SlotPath escapedPath = TmplUtil.resolveSlotPathScope(slotPathScope);
            scope = BOrd.make((String)("station:|" + escapedPath));
        }
        try {
            BSearchParams bSearchParams = new BSearchParams("neql:" + bindHints, (BIObject)scope);
            searchTask = searchService.search(bSearchParams).relativizeToSession();
        }
        catch (ActionInvokeException aie) {
            if (TmplUtil.isSlotPathUnresolved(aie)) {
                log.log(Level.WARNING, String.format("Slot path scope '%s' cannot be resolved for bind hints '%s', so this search was not scoped", slotPathScope, bindHints));
                resultsMessages.add(lex.getText("templateManager.unscopedTemplateResult", new Object[]{slotPathScope, bindHints}));
                BSearchParams bSearchParams = new BSearchParams("neql:" + bindHints, (BIObject)rootComponent);
                searchTask = searchService.search(bSearchParams).relativizeToSession();
            }
            throw aie;
        }
        try {
            templateService.getComponentSpace().sync();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error syncing template service component space:" + e.getLocalizedMessage(), e);
        }
        BObject bObject = searchTask.get((BObject)templateService);
        BSearchTask task = null;
        if (bObject instanceof BSearchTask) {
            task = (BSearchTask)bObject;
        }
        BSearchResultSet results = null;
        boolean resultsComplete = false;
        int startItem = 0;
        Array foundObjs = new Array(BComponent.class);
        long maxTicks = Clock.ticks() + 60000L;
        while (!resultsComplete && Clock.ticks() < maxTicks) {
            resultsComplete = results != null && results.getResultsComplete();
            BResultsRequest resultsRequest = BResultsRequest.make((BOrd)searchTask, (int)startItem, (int)10);
            results = searchService.retrieveResults(resultsRequest);
            startItem += results.getResultCount();
            SlotCursor props = results.getResults().getProperties();
            while (props.next()) {
                BSearchResult result = (BSearchResult)props.get();
                BOrd ord = result.getOrd().relativizeToSession();
                BObject object = ord.get((BObject)templateService);
                BSimple epoch = result.getEpoch();
                if (!(object instanceof BComponent)) continue;
                BComponent comp = (BComponent)object;
                foundObjs.add((Object)comp);
            }
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error idling thread:" + e.getLocalizedMessage(), e);
            }
        }
        return foundObjs.trim();
    }

    private static boolean isSlotPathUnresolved(ActionInvokeException aie) {
        if (aie.getCause() instanceof UnresolvedException) {
            return true;
        }
        return aie.getCause() != null && aie.getCause().getMessage() != null && aie.getCause().getMessage().contains("UnresolvedException");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object[] findMatchingObjects(String bindHints, BTemplateService templateService, BComponent base, Lexicon lex) {
        BComponent rootComponent = ((BComponentSpace)base.getSpace()).getRootComponent();
        NeqlQuery ordQuery = new NeqlQuery(bindHints);
        BNeqlComponentQueryHandler queryHandler = new BNeqlComponentQueryHandler();
        OrdTarget scope = rootComponent.getSlotPathOrd().resolve((BObject)base);
        try (CloseableIterator results = queryHandler.query(scope, (OrdQuery)ordQuery);){
            Array foundObjs = new Array(BComponent.class);
            while (results.hasNext()) {
                Entity result = (Entity)results.next();
                if (!(result instanceof BComponent)) continue;
                BComponent comp = (BComponent)result;
                foundObjs.add((Object)comp);
            }
            Object[] objectArray = foundObjs.trim();
            return objectArray;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public static Object selectInputSource(BWidget owner, BTemplateManager.IoSlotInfo ioInfo, BTemplateConfig config, boolean allowRemember, Lexicon lex) {
        List<Object> selectedComps = TmplUtil.selectComponents(owner, ioInfo, false, allowRemember);
        if (selectedComps.isEmpty()) {
            return null;
        }
        TargetChoice choice = new TargetChoice();
        choice.targetPoint = (BComponent)selectedComps.get(0);
        int ordinal = 0;
        ArrayList<String> outSlots = new ArrayList<String>();
        outSlots.add("out");
        if (ioInfo.targetSlotHints != null && !ioInfo.targetSlotHints.isEmpty()) {
            for (String slotHint : TextUtil.split((String)ioInfo.targetSlotHints, (char)',')) {
                Property outProperty;
                if (outSlots.contains(slotHint) || (outProperty = choice.targetPoint.getProperty(slotHint.trim())) == null || Flags.isHidden((BComplex)choice.targetPoint, (Slot)outProperty)) continue;
                ordinal = 1;
                outSlots.add(slotHint.trim());
                break;
            }
        }
        BEnumRange outRange = BEnumRange.make((String[])outSlots.toArray(new String[0]));
        choice.targetSlotEnum = BDynamicEnum.make((int)ordinal, (BEnumRange)outRange);
        choice.selected = true;
        ArrayList<TargetChoice> targetChoices = new ArrayList<TargetChoice>();
        targetChoices.add(choice);
        ioInfo.lastSelected = targetChoices;
        return targetChoices;
    }

    public static Object selectRelationSource(BWidget owner, BTemplateManager.IoSlotInfo ioInfo, BTemplateConfig config, boolean allowRemember, Lexicon lex) {
        List<Object> selectedComps = TmplUtil.selectComponents(owner, ioInfo, true, allowRemember);
        if (selectedComps.isEmpty()) {
            return null;
        }
        if (ioInfo.allowMultiple) {
            return selectedComps;
        }
        return selectedComps.get(0);
    }

    private static List<Object> selectComponents(BWidget owner, BTemplateManager.IoSlotInfo ioInfo, boolean isRelation, boolean allowRemember) {
        if (ioInfo.choices == null || ioInfo.choices.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<BComponent> components = new ArrayList<BComponent>();
        for (Object linkSource : ioInfo.choices) {
            if (!(linkSource instanceof BComponent)) continue;
            components.add((BComponent)linkSource);
        }
        String userInfo = ioInfo.userTip;
        if (!ioInfo.resultsMessages.isEmpty()) {
            userInfo = ioInfo.userTip + " - " + TmplUtil.joinResponseMessages(ioInfo.resultsMessages);
        }
        BSelectInputDialog selectDialog = new BSelectInputDialog(owner, ioInfo.title, ioInfo.prompt, userInfo, ioInfo.isInput, isRelation, ioInfo.allowMultiple, components, allowRemember);
        ArrayList selectedComps = selectDialog.openDialog();
        ioInfo.dontAskAgain = selectDialog.getDontAskAgain();
        if (selectDialog.getResult() == 2) {
            ioInfo.abort = true;
            return Collections.emptyList();
        }
        if (selectedComps == null || selectedComps.isEmpty()) {
            ioInfo.results = isRelation ? 23 : 3;
            return Collections.emptyList();
        }
        if (isRelation) {
            if (ioInfo.allowMultiple) {
                ioInfo.lastSelected = selectDialog.getRemember() ? selectedComps : null;
            }
            ioInfo.lastSelected = selectDialog.getRemember() ? selectedComps.get(0) : null;
        }
        return selectedComps;
    }

    public static Object selectOutputTargets(BWidget owner, BTemplateManager.IoSlotInfo ioInfo, BTemplateConfig config, boolean isMultiple, Lexicon lex) {
        if (ioInfo.choices == null || ioInfo.choices.length == 0) {
            return null;
        }
        ArrayList<TargetChoice> targetChoices = new ArrayList<TargetChoice>();
        for (Object linkSource : ioInfo.choices) {
            if (!(linkSource instanceof BComponent)) continue;
            BComponent component = (BComponent)linkSource;
            TargetChoice choice = new TargetChoice();
            choice.targetPoint = component;
            choice.targetSlotEnum = TmplUtil.getComponentLinkableInputs(component, true);
            if (ioInfo.targetSlotHints != null && !ioInfo.targetSlotHints.isEmpty()) {
                for (String slotHint : TextUtil.split((String)ioInfo.targetSlotHints, (char)',')) {
                    try {
                        choice.targetSlotEnum = (BDynamicEnum)choice.targetSlotEnum.getRange().get(slotHint.trim());
                        break;
                    }
                    catch (InvalidEnumException invalidEnumException) {
                    }
                }
            }
            targetChoices.add(choice);
        }
        ArrayList selectResults = null;
        try {
            ArrayList tempResults;
            String userInfo = ioInfo.userTip;
            if (!ioInfo.resultsMessages.isEmpty()) {
                userInfo = ioInfo.userTip + " - " + TmplUtil.joinResponseMessages(ioInfo.resultsMessages);
            }
            BSelectOutputDialog selectDialog = new BSelectOutputDialog(owner, ioInfo.title, ioInfo.prompt, userInfo, ioInfo.isInput, ioInfo.allowMultiple, targetChoices, isMultiple);
            selectResults = tempResults = selectDialog.openDialog();
            ioInfo.dontAskAgain = selectDialog.getDontAskAgain();
            if (selectDialog.getResult() == 2) {
                ioInfo.abort = true;
                return null;
            }
            if (selectResults != null) {
                ioInfo.lastSelected = selectDialog.getRemember() ? selectResults : null;
                return selectResults;
            }
            ioInfo.results = ioInfo.isInput ? 3 : 13;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error selecting results:" + e.getLocalizedMessage(), e);
        }
        return null;
    }

    private static String joinResponseMessages(List<String> responseMessages) {
        StringJoiner responses = new StringJoiner("\n");
        for (String response : responseMessages) {
            responses.add(response);
        }
        return responses.toString();
    }

    public static int selectTagGroupChoices(BWidget owner, ArrayList<TagDictionaryUtil.ComponentTagGroupChoices> compTagGroupChoices, Lexicon lex) {
        if (compTagGroupChoices == null || compTagGroupChoices.isEmpty()) {
            return 2;
        }
        StringBuilder infoSb = new StringBuilder();
        infoSb.append(lex.getText("selectTagGroupDialog.info1"));
        infoSb.append("\n");
        infoSb.append(lex.getText("selectTagGroupDialog.info2"));
        infoSb.append("\n");
        infoSb.append(lex.getText("selectTagGroupDialog.info3"));
        BSelectTagGroupDialog selectDialog = new BSelectTagGroupDialog(owner, lex.getText("selectTagGroupDialog.title"), "", infoSb.toString(), false, false, true, compTagGroupChoices, false);
        selectDialog.setIsDeploy(false);
        ArrayList selectedComps = selectDialog.openDialog();
        return selectDialog.getResult();
    }

    public static TagDictionaryService makeTagDictionaryService() {
        BComponent service = (BComponent)TagUtil.getTagDictionaryServiceFromPalettes();
        HashMap<String, TagDictionary> namespaceMap = new HashMap<String, TagDictionary>();
        if (service instanceof BTagDictionaryService) {
            BTagDictionaryService tdService = (BTagDictionaryService)service;
            for (TagDictionary tagDictionary : tdService.getTagDictionaries()) {
                if (namespaceMap.containsKey(tagDictionary.getNamespace())) continue;
                namespaceMap.put(tagDictionary.getNamespace(), tagDictionary);
            }
            for (TagDictionary tagDictionary : TmplUtil.getTagDictionariesFromPalettes()) {
                TmplUtil.checkAddDictionary(tagDictionary, service, namespaceMap);
            }
            for (TagDictionary tagDictionary : TagUtil.getUserTagDictionaries()) {
                TmplUtil.checkAddDictionary(tagDictionary, service, namespaceMap);
            }
            BNiagaraTagDictionary niagaraStandardDictionary = (BNiagaraTagDictionary)tdService.getNiagara().getStandardDictionary();
            tdService.setNiagara((BNiagaraTagDictionary)niagaraStandardDictionary.newCopy());
        }
        return (TagDictionaryService)service;
    }

    static void checkAddDictionary(TagDictionary tagDictionary, BComponent service, HashMap<String, TagDictionary> namespaceMap) {
        String namespace = tagDictionary.getNamespace();
        if (namespaceMap.containsKey(namespace)) {
            return;
        }
        BComponent tagDictionaryComponent = (BComponent)tagDictionary;
        if (service.get(tagDictionaryComponent.getName()) != null) {
            return;
        }
        if (tagDictionaryComponent instanceof BTagDictionary) {
            BTagDictionary alternateTagDictionary = ((BTagDictionary)tagDictionaryComponent).getStandardDictionary();
            BOrd importOrd = ((BTagDictionary)tagDictionaryComponent).getImportDictionaryOrd();
            BValue defaultImportOrd = tagDictionaryComponent.getProperty("importDictionaryOrd").getDefaultValue();
            if (alternateTagDictionary != null) {
                tagDictionaryComponent = alternateTagDictionary;
            } else if (!defaultImportOrd.equals((Object)importOrd)) {
                try {
                    BIFile inFile = (BIFile)importOrd.resolve((BObject)tagDictionaryComponent).get();
                    if (inFile instanceof BJsonFile || inFile instanceof BCsvFile) {
                        ImportUtil.ImportTagDictionary((BTagDictionary)((BTagDictionary)tagDictionaryComponent), (BOrd)importOrd);
                    }
                }
                catch (UnresolvedException inFile) {
                    // empty catch block
                }
            }
            BTagInfoList tagInfoList = ((BTagDictionary)tagDictionaryComponent).getTagDefinitions();
            BTagGroupInfoList tagGroupInfoList = ((BTagDictionary)tagDictionaryComponent).getTagGroupDefinitions();
            if (tagInfoList.iterator().hasNext() || tagGroupInfoList.iterator().hasNext()) {
                Property addedTd = service.add(tagDictionaryComponent.getName(), tagDictionaryComponent.newCopy());
                service.setDisplayName(addedTd, BFormat.make((String)tagDictionary.getDisplayName(null)), null);
                namespaceMap.put(namespace, tagDictionary);
            }
        }
    }

    static Collection<TagDictionary> getTagDictionariesFromPalettes() {
        ArrayList<TagDictionary> result = new ArrayList<TagDictionary>();
        for (String string : new String[]{"haystack", "brick"}) {
            try {
                Nre.getModuleManager().loadModule(string, RuntimeProfile.rt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (String string : Nre.getModuleManager().getModules()) {
            BINavNode[] entries;
            if (string.isTransient() || string.isSynthetic()) continue;
            boolean hasPalette = false;
            try {
                hasPalette = string.bmodule().hasPalette();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!hasPalette) continue;
            BINavNode node = Sys.loadModule((String)string.getModuleName()).getNavChild("module.palette");
            for (BINavNode entry : entries = node.getNavChildren()) {
                if (entry instanceof TagDictionaryService) {
                    entry = entry.getNavChild("Niagara");
                }
                if (entry == null) continue;
                if (entry.getType().is(BTagDictionary.TYPE)) {
                    if (result.contains(entry)) continue;
                    result.add((TagDictionary)entry);
                }
                if (!(entry instanceof BUnrestrictedFolder)) continue;
                TmplUtil.addTagDictionariesFromPaletteFolder((BUnrestrictedFolder)entry, result);
            }
        }
        return result;
    }

    static void addTagDictionariesFromPaletteFolder(BUnrestrictedFolder folder, ArrayList<TagDictionary> result) {
        BINavNode[] entries;
        for (BINavNode entry : entries = folder.getNavChildren()) {
            if (entry.getType().is(BTagDictionary.TYPE) && !result.contains(entry)) {
                result.add((TagDictionary)entry);
            }
            if (!(entry instanceof BUnrestrictedFolder)) continue;
            TmplUtil.addTagDictionariesFromPaletteFolder((BUnrestrictedFolder)entry, result);
        }
    }

    private static BDynamicEnum getComponentLinkableInputs(BComponent component, boolean isInput) {
        Property[] componentProperties;
        ArrayList<String> slotList = new ArrayList<String>();
        slotList.add(SlotPath.escape((String)"----"));
        for (Property slot : componentProperties = component.getPropertiesArray()) {
            if (Flags.isReadonly((BComplex)component, (Slot)slot) && !isInput || !Flags.isFanIn((BComplex)component, (Slot)slot) && component.isLinkTarget((Slot)slot) || Flags.isHidden((BComplex)component, (Slot)slot)) continue;
            slotList.add(slot.getName());
        }
        BEnumRange slotRange = BEnumRange.make((String[])slotList.toArray(new String[0]));
        return BDynamicEnum.make((int)0, (BEnumRange)slotRange);
    }

    public static BindInfo formatBindResults(BTemplateManager.IoSlotInfo slotInfo, Lexicon lex) {
        BindInfo info = null;
        switch (slotInfo.results) {
            case 1: 
            case 11: {
                info = new BindInfo(lex.getText("templateManager.noBindHints", new Object[]{slotInfo.rootName, slotInfo.slot.getName(), slotInfo.bindHints}), BColor.red);
                break;
            }
            case 21: {
                info = new BindInfo(lex.getText("templateManager.relateNoBindHints", new Object[]{slotInfo.rootName, slotInfo.relationInfo.getRelationId(), slotInfo.bindHints}), BColor.red);
                break;
            }
            case 2: {
                info = new BindInfo(lex.getText("templateManager.noSourcesFound", new Object[]{slotInfo.rootName, slotInfo.slot.getName(), slotInfo.bindHints}), BColor.red);
                break;
            }
            case 12: {
                info = new BindInfo(lex.getText("templateManager.noTargetsFound", new Object[]{slotInfo.rootName, slotInfo.slot.getName(), slotInfo.bindHints}), BColor.red);
                break;
            }
            case 22: {
                info = new BindInfo(lex.getText("templateManager.noRelationFound", new Object[]{slotInfo.rootName, slotInfo.relationInfo.getRelationId(), slotInfo.bindHints}), BColor.red);
                break;
            }
            case 3: {
                info = new BindInfo(lex.getText("templateManager.input.notLinked.notSelected", new Object[]{slotInfo.rootName, slotInfo.slot.getName()}), BColor.red);
                break;
            }
            case 13: {
                info = new BindInfo(lex.getText("templateManager.outputNotLinked", new Object[]{slotInfo.rootName, slotInfo.slot.getName()}), BColor.red);
                break;
            }
            case 23: {
                info = new BindInfo(lex.getText("templateManager.relate.notRelated.notSelected", new Object[]{slotInfo.rootName, slotInfo.relationInfo.getRelationId()}), BColor.red);
                break;
            }
            case 4: {
                info = new BindInfo(lex.getText("templateManager.linkedTemplateInput", new Object[]{slotInfo.rootName, slotInfo.slot.getName(), slotInfo.otherName, slotInfo.otherSlot}), BColor.black);
                break;
            }
            case 14: {
                info = new BindInfo(lex.getText("templateManager.linkedTemplateOutput", new Object[]{slotInfo.rootName, slotInfo.slot.getName(), slotInfo.otherName, slotInfo.otherSlot}), BColor.black);
                break;
            }
            case 24: {
                info = new BindInfo(lex.getText("templateManager.addedTemplateRelation", new Object[]{slotInfo.relationInfo.getRelationId(), slotInfo.otherSlot, slotInfo.otherName}), BColor.black);
                break;
            }
            case 6: {
                info = new BindInfo(lex.getText("templateManager.input.notLinked.types", new Object[]{slotInfo.rootName, slotInfo.slot.getName(), slotInfo.otherName, slotInfo.otherSlot}), BColor.red);
                break;
            }
            case 7: {
                String slotName = "out";
                if (slotInfo.targetSlotHints != null && !slotInfo.targetSlotHints.isEmpty()) {
                    slotName = slotInfo.targetSlotHints;
                }
                info = new BindInfo(lex.getText("templateManager.input.notLinked.noOut", new Object[]{slotInfo.rootName, slotInfo.slot.getName(), slotInfo.otherName, slotName}), BColor.red);
                break;
            }
            case 8: {
                info = new BindInfo(lex.getText("templateManager.input.notLinked.notComponent", new Object[]{slotInfo.rootName, slotInfo.slot.getName(), slotInfo.otherName}), BColor.red);
                break;
            }
            case 15: {
                info = new BindInfo(lex.getText("templateManager.outputNotLinked", new Object[]{slotInfo.rootName, slotInfo.slot.getName()}), BColor.red);
                break;
            }
            case 99: {
                String exception;
                String string = exception = slotInfo.otherName != null ? slotInfo.otherName : slotInfo.otherSlot;
                String slorOrRelation = slotInfo.slot != null ? slotInfo.slot.getName() : (slotInfo.relationInfo != null ? slotInfo.relationInfo.getRelationId() : "?");
                info = new BindInfo(lex.getText("templateManager.search.exception", new Object[]{slotInfo.rootName, slorOrRelation, slotInfo.bindHints, exception}), BColor.red);
            }
        }
        return info;
    }

    private static BAbstractPxView getView(TypeInfo typInfo) {
        BPxView pv = new BPxView();
        if (typInfo != null) {
            pv.setMedia(typInfo.getTypeSpec());
        }
        return pv;
    }

    private static void getPxImageRefs(BWidget widgetRoot, ArrayList<ImageFileRef> imageRefs) {
        try {
            BComplex[] complexes = (BComplex[])CompUtil.getDescendants((BComponent)widgetRoot, BComplex.class);
            for (int j = 0; j < complexes.length; ++j) {
                SlotCursor cursor = complexes[j].getProperties();
                while (cursor.next()) {
                    BValue bValue = cursor.get();
                    Type typ = bValue.getType();
                    if (typ.is(BPicture.TYPE)) {
                        TmplUtil.addImage(((BPicture)bValue).getImage(), imageRefs);
                        continue;
                    }
                    if (typ.is(BINumericToSimple.TYPE)) {
                        TmplUtil.addImages(((BINumericToSimple)bValue).getMap().getValues(), imageRefs);
                        continue;
                    }
                    if (typ.is(BIEnumToSimple.TYPE)) {
                        TmplUtil.addImages(((BIEnumToSimple)bValue).getMap().getValues(), imageRefs);
                        continue;
                    }
                    if (typ.is(BIBooleanToSimple.TYPE)) {
                        TmplUtil.addImage(((BIBooleanToSimple)bValue).getTrueValue(), imageRefs);
                        TmplUtil.addImage(((BIBooleanToSimple)bValue).getFalseValue(), imageRefs);
                        continue;
                    }
                    if (typ.is(BIStatusToSimple.TYPE)) {
                        BIStatusToSimple ist = (BIStatusToSimple)bValue;
                        Property[] p = ist.getFrozenPropertiesArray();
                        for (int i = 0; i < p.length; ++i) {
                            BValue v = ist.get(p[0]);
                            if (!(v instanceof BImage)) continue;
                            TmplUtil.addImage((BImage)v, imageRefs);
                        }
                        continue;
                    }
                    if (!typ.is(BImage.TYPE)) continue;
                    TmplUtil.addImage((BImage)bValue, imageRefs);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error getting PX image references:" + e.getLocalizedMessage(), e);
        }
    }

    private static void relativizeOrds(BComplex cplx, BWidget w) {
        if (!cplx.isComponent()) {
            return;
        }
        SlotPath slotPath = cplx.asComponent().getSlotPath();
        String[] baseNames = slotPath.getNames();
        BBinding[] blbs = (BBinding[])CompUtil.getDescendants((BComponent)w, BBinding.class);
        for (int i = 0; i < blbs.length; ++i) {
            BOrd ord = blbs[i].getOrd();
            BOrd newOrd = TmplUtil.relativizeOrd(baseNames, ord);
            if (newOrd == null) continue;
            blbs[i].setOrd(newOrd);
        }
    }

    public static BImage[] getPxImageOrds(BComponent root) {
        BPxView[] pxViews = (BPxView[])CompUtil.getDescendants((BComponent)root, BPxView.class);
        Array imageArray = new Array(BImage.class);
        for (int i = 0; i < pxViews.length; ++i) {
            BOrd pxFileOrd = pxViews[i].getPxFile();
            BIFile pxFile = (BIFile)pxFileOrd.resolve((BObject)root).get();
            PxDecoder decoder = null;
            try {
                decoder = new PxDecoder(pxFile);
                BWidget widgetRoot = decoder.decodeDocument();
                PxProperty[] props = decoder.getPxProperties();
                BImage[] descendantsOrds = (BImage[])CompUtil.getDescendants((BComponent)widgetRoot, BImage.class);
                for (int j = 0; j < descendantsOrds.length; ++j) {
                    imageArray.add((Object)((BImage)descendantsOrds[j].newCopy()));
                }
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error getting PX image ORDs:" + e.getLocalizedMessage(), e);
            }
        }
        return (BImage[])imageArray.trim();
    }

    private static void addImages(BSimple[] sa, ArrayList<ImageFileRef> imageRefs) {
        for (int i = 0; i < sa.length; ++i) {
            TmplUtil.addImage(sa[i], imageRefs);
        }
    }

    private static void addImage(BSimple s, ArrayList<ImageFileRef> imageRefs) {
        if (!(s instanceof BImage)) {
            return;
        }
        TmplUtil.addImage((BImage)s, imageRefs);
    }

    private static void addImage(BImage im, ArrayList<ImageFileRef> imageRefs) {
        if (im.getOrdList().toString().startsWith("module:")) {
            return;
        }
        imageRefs.add(new ImageFileRef(im));
    }

    public static BNtplFile createInMemoryNtpl(BComponent c) throws Exception {
        return TmplUtil.createInMemoryNtplImpl(c, false);
    }

    public static BNtplFile createInMemoryApp(BComponent c) throws Exception {
        return TmplUtil.createInMemoryNtplImpl(c, true);
    }

    private static BNtplFile createInMemoryNtplImpl(BComponent c, boolean createAsApp) throws Exception {
        String myNam = c.getName();
        BComponent templateRoot = null;
        TemplateManifest manifest = new TemplateManifest();
        manifest.newCreation = true;
        manifest.vendor = Sys.getBajaModule().getVendor(RuntimeProfile.rt);
        manifest.isStation = c.getType().is(BStation.TYPE);
        if (manifest.isStation) {
            manifest.isApplication = createAsApp;
            myNam = ((BStation)c).getStationName();
            templateRoot = c;
        }
        ArrayList<LinkInfo> extLinks = TmplUtil.listExternalLinks(c);
        ArrayList<PasswordInfo> intPSWs = TmplUtil.listInternalBPasswords(c);
        ArrayList<TagGroupRelationInfo> tagGroupRelationInfos = TmplUtil.listTagGroupRelations(c);
        BUnrestrictedFolder folder = new BUnrestrictedFolder();
        BComponentSpace space = new BComponentSpace(null, null, null);
        space.setRootComponent((BComponent)folder);
        Mark mark = new Mark((BObject)c, myNam);
        BHistoryExt[] sourceHistoryExtensions = (BHistoryExt[])CompUtil.getDescendants((BComponent)c, BHistoryExt.class);
        BComponent params = null;
        if (manifest.isStation || manifest.isApplication) {
            params = new BComponent();
            params.add("exactConfig", (BValue)BBoolean.TRUE);
        }
        TransferResult transferResult = TransferStrategy.make((int)16, (Mark)mark, (BObject)folder, (BComponent)params, null).transfer();
        BComponent copiedRoot = folder.get(transferResult.getInsertNames()[0]).asComponent();
        BHistoryExt[] copiedHistoryExtensions = (BHistoryExt[])CompUtil.getDescendants((BComponent)folder, BHistoryExt.class);
        HashMap historyMap = new HashMap();
        for (BHistoryExt ext : sourceHistoryExtensions) {
            CompUtil.slotPathFromAncestor((BComplex)c, (BComplex)ext).ifPresent(slotPath -> historyMap.put(slotPath.toString(), ext.getEnabled()));
        }
        if (c instanceof BHistoryExt) {
            CompUtil.slotPathFromAncestor((BComplex)c, (BComplex)c).ifPresent(slotPath -> historyMap.put(slotPath.toString(), ((BHistoryExt)c).getEnabled()));
        }
        for (BHistoryExt ext : copiedHistoryExtensions) {
            Optional slotPath2 = CompUtil.slotPathFromAncestor((BComplex)copiedRoot, (BComplex)ext);
            boolean enabled = (Boolean)historyMap.get(slotPath2.isPresent() ? ((SlotPath)slotPath2.get()).toString() : "");
            ext.setEnabled(enabled);
        }
        if (!manifest.isStation) {
            try {
                templateRoot = folder.getChildComponents()[0];
                BTemplateConfig.removeConfigFromRoot((BComponent)templateRoot);
                folder.setDisplayName(templateRoot.getPropertyInParent(), BFormat.DEFAULT, null);
                TmplUtil.addExternalLinks(templateRoot, extLinks);
                TmplUtil.addPasswordConfig(templateRoot, intPSWs);
                TmplUtil.addTagGroupTags(templateRoot, tagGroupRelationInfos);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error creating in-memory NTPL file:" + e.getLocalizedMessage(), e);
            }
        }
        PasswordUtil.forceClearReversiblePasswords((BComponent)folder);
        BMemoryFileStore fs = BMemoryFileSpace.INSTANCE.makeMemoryStore(myNam + ".bog");
        BBogFile bogFile = new BBogFile((BIFileStore)fs);
        fs.setFile((BIFile)bogFile);
        ValueDocEncoder encoder = new ValueDocEncoder(bogFile.getOutputStream());
        encoder.setZipped(true);
        encoder.setEncodeComments(true);
        encoder.encodeDocument((BValue)folder);
        encoder.close();
        ArrayList<SubtemplateInfo> stAl = TmplUtil.listSubtemplates(templateRoot);
        for (SubtemplateInfo stInfo : stAl) {
            manifest.addSubtemplate(stInfo.getDeployName(), stInfo.getVendor(), stInfo.getVersion(), stInfo.getDeployOrd().toString(), stInfo.getNtplFileOrd().toString());
        }
        PxFileRef[] pxRefs = null;
        BImageFile[] imageFiles = null;
        BDataFile[] stationFiles = null;
        if (!manifest.isStation && !manifest.isApplication) {
            ArrayList<String> pxOrds = new ArrayList<String>();
            ArrayList<String> imageOrds = new ArrayList<String>();
            TmplUtil.findPxAndImageOrds(c, pxOrds, imageOrds);
            ArrayList<PxFileRef> pxFileRefArray = new ArrayList<PxFileRef>();
            ArrayList<BImageFile> imageFileArray = new ArrayList<BImageFile>();
            TmplUtil.loadPxFilesIntoMemory(c, pxOrds, pxFileRefArray);
            TmplUtil.loadImageFilesIntoMemory(c, imageOrds, imageFileArray);
            pxRefs = pxFileRefArray.toArray(new PxFileRef[0]);
            imageFiles = imageFileArray.toArray(new BImageFile[0]);
            for (PxFileRef pxFileRef : pxRefs) {
                manifest.addResource(pxFileRef.getPxName(), "px", ((MemoryPxFileRef)pxFileRef).getFileSystemOrd().encodeToString());
            }
            for (PxFileRef pxFileRef : imageFiles) {
                manifest.addResource(pxFileRef.getFileName(), "image", ((BMemoryImageFile)pxFileRef).getLocalImageOrd().encodeToString());
            }
        } else {
            ArrayList<BDataFile> stationFileList = new ArrayList<BDataFile>();
            TmplUtil.addInMemoryStationFiles(stationFileList, c, "^", manifest);
            if (!stationFileList.isEmpty()) {
                stationFiles = stationFileList.toArray(new BDataFile[0]);
            }
        }
        fs = BMemoryFileSpace.INSTANCE.makeMemoryStore(myNam + (createAsApp ? ".napl" : ".ntpl"));
        BWbDeployableNtplFile nf = new BWbDeployableNtplFile(fs, manifest, bogFile, pxRefs, imageFiles, stationFiles);
        fs.setFile((BIFile)nf);
        return nf;
    }

    private static void findPxAndImageOrds(BComponent c, ArrayList<String> pxOrds, ArrayList<String> imageOrds) {
        EmbeddedPxScanner.findPxAndImageOrds((EmbeddedPxSource)new LocalPxSource(c), (BComponent)c, pxOrds, imageOrds);
    }

    private static void loadPxFilesIntoMemory(BComponent root, List<String> ords, List<PxFileRef> pxFileRefArray) throws IOException {
        HashSet<String> resourceFileNames = new HashSet<String>();
        for (String ord : ords) {
            BIFile file;
            try {
                file = (BIFile)BOrd.make((String)ord).resolve((BObject)root).get();
            }
            catch (UnresolvedException e) {
                log.log(Level.WARNING, "Missing px file: " + ord, e);
                continue;
            }
            String resourceFileName = TmplUtil.addUniqueFileNameToSet(file.getFileName(), resourceFileNames);
            BMemoryFileStore store = BMemoryFileSpace.INSTANCE.makeMemoryStore("px/" + resourceFileName);
            BPxFile newFile = new BPxFile((BIFileStore)store);
            MemoryPxFileRef ref = new MemoryPxFileRef(newFile, file.getOrdInSpace(), newFile.getAbsoluteOrd(), newFile.getFileName());
            try (InputStream in = file.getInputStream();
                 OutputStream out = newFile.getOutputStream();){
                FileUtil.pipe((InputStream)in, (OutputStream)out);
            }
            pxFileRefArray.add((PxFileRef)ref);
        }
    }

    private static void loadImageFilesIntoMemory(BComponent root, List<String> ords, List<BImageFile> imageFiles) throws IOException {
        HashSet<String> resourceFileNames = new HashSet<String>();
        for (String ord : ords) {
            BIFile file;
            try {
                file = (BIFile)BOrd.make((String)ord).resolve((BObject)root).get();
            }
            catch (UnresolvedException e) {
                log.log(Level.WARNING, "Missing image file: " + ord, e);
                continue;
            }
            String resourceFileName = TmplUtil.addUniqueFileNameToSet(file.getFileName(), resourceFileNames);
            BMemoryFileStore store = BMemoryFileSpace.INSTANCE.makeMemoryStore("images/" + resourceFileName);
            BMemoryImageFile newFile = new BMemoryImageFile((BIFileStore)store, file.getOrdInSpace());
            try (InputStream in = file.getInputStream();
                 OutputStream out = newFile.getOutputStream();){
                FileUtil.pipe((InputStream)in, (OutputStream)out);
            }
            imageFiles.add((BImageFile)newFile);
        }
    }

    private static String addUniqueFileNameToSet(String fileName, Set<String> fileNames) {
        String uniqueFileName = fileName;
        if (fileNames.contains(fileName)) {
            int suffix = 1;
            String namePart = null;
            String extPart = null;
            int extStart = fileName.lastIndexOf(46);
            if (extStart > 0) {
                namePart = fileName.substring(0, extStart);
                extPart = fileName.substring(extStart + 1);
            }
            while (fileNames.contains(uniqueFileName = namePart == null ? fileName + suffix++ : namePart + suffix++ + "." + extPart)) {
            }
        }
        fileNames.add(uniqueFileName);
        return uniqueFileName;
    }

    private static void addInMemoryStationFiles(ArrayList<BDataFile> stationFileList, BComponent rootComponent, String baseFilePath, TemplateManifest manifest) {
        BOrd fileOrd = BOrd.make((String)(rootComponent.getOrdInHost().toString() + "|file:" + baseFilePath));
        if (fileOrd != null) {
            try {
                fileOrd.resolve((BObject)rootComponent).get();
                TmplUtil.addInMemoryStationFiles(stationFileList, rootComponent, fileOrd, manifest);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void addInMemoryStationFiles(ArrayList<BDataFile> stationFiles, BComponent rootComponent, BOrd ord, TemplateManifest manifest) throws FileAlreadyExistsException {
        BObject bObj = ord.resolve((BObject)rootComponent).get();
        if (bObj instanceof BDirectory) {
            BDirectory dir = (BDirectory)bObj;
            BINavNode[] children = dir.getNavChildren();
            if (children != null && children.length > 0) {
                for (BINavNode n : children) {
                    if (!(n instanceof BAbstractFile)) continue;
                    TmplUtil.addInMemoryStationFiles(stationFiles, rootComponent, ((BAbstractFile)n).getAbsoluteOrd(), manifest);
                }
            }
        } else if (bObj instanceof BDataFile && !(bObj instanceof BILogFile)) {
            BDataFile dFile = (BDataFile)bObj;
            String dFileOrd = dFile.getOrdInSpace().encodeToString();
            String dFileOrdTruncated = dFileOrd.replace("file:^", "shared/");
            String fname = dFile.getFileName();
            BMemoryFileStore fs = BMemoryFileSpace.INSTANCE.makeMemoryStore(dFileOrdTruncated);
            BDataFile newF = new BDataFile((BIFileStore)fs);
            fs.setFile((BIFile)newF);
            NtplUtil.copyFile((BIFile)dFile, (BIFile)newF);
            stationFiles.add(newF);
            manifest.addResource(fname, "data", dFileOrd);
        }
    }

    public static ArrayList<SubtemplateInfo> listSubtemplates(BComponent root) {
        BTemplateConfig[] subTmplCfg = (BTemplateConfig[])CompUtil.getDescendants((BComponent)root, BTemplateConfig.class);
        ArrayList<SubtemplateInfo> stAl = new ArrayList<SubtemplateInfo>();
        TemplateManager tmInstance = new TemplateManager();
        tmInstance.initTemplateMap();
        for (BTemplateConfig tc : subTmplCfg) {
            String tVersion;
            BComplex tcParent = tc.getParent();
            if (tcParent == root) continue;
            BComponent stRoot = tcParent.asComponent();
            BUuid uID = tc.getManifest().uID;
            Optional optVendor = stRoot.tags().get(TemplateConst.TEMPLATE_VENDOR_TAG_ID);
            Optional optVersion = stRoot.tags().get(TemplateConst.TEMPLATE_VERSION_TAG_ID);
            String string = tVersion = optVersion.isPresent() ? ((BIDataValue)optVersion.get()).toString() : "";
            if (!optVendor.isPresent()) continue;
            String tVendor = ((BIDataValue)optVendor.get()).toString();
            TemplateManager.TemplateInfo templateInfo = null;
            templateInfo = uID != null ? tmInstance.getTemplate(uID, tVendor) : tmInstance.getTemplate(tc.getTemplateName(), tVendor);
            if (templateInfo == null) {
                System.out.println("Template doesn't exist in WB: " + tVendor + ":" + uID);
                continue;
            }
            BOrd ntpFileOrd = templateInfo.getNtpFileOrd();
            stAl.add(new SubtemplateInfo(stRoot.getName(), tVendor, tVersion, stRoot.getSlotPathOrd(), ntpFileOrd));
        }
        return stAl;
    }

    public static ArrayList<PasswordInfo> listInternalBPasswords(BComponent root) {
        BOrd rootOrd = root.getSlotPathOrd();
        ArrayList<PasswordInfo> intPSWs = new ArrayList<PasswordInfo>();
        ArrayList<BComponent> componentList = new ArrayList<BComponent>();
        TmplUtil.listComponents(componentList, root);
        String[] namesRoot = root.getSlotPath().getNames();
        for (BComponent comp : componentList) {
            if (comp instanceof BTemplateConfig) continue;
            for (Property property : comp.getProperties()) {
                PasswordOrdProp ordProp;
                if (comp.get(property).isComponent() || (ordProp = TmplUtil.findPasswordProp(comp, property, namesRoot)) == null) continue;
                if (ordProp.parentProperty == null) {
                    intPSWs.add(new PasswordInfo(ordProp.parent, ordProp.property.getName(), ordProp.isDynamic));
                    continue;
                }
                intPSWs.add(new PasswordInfo(ordProp.parent, ordProp.parentProperty.getName(), ordProp.property.getName(), ordProp.isDynamic));
            }
        }
        return intPSWs;
    }

    public static PasswordOrdProp findPasswordProp(BComponent parentComp, Property property, String[] namesRoot) {
        BValue value = parentComp.get(property);
        if (value.getType().is(BPassword.TYPE)) {
            return new PasswordOrdProp(TmplUtil.relativizeOrd(namesRoot, parentComp.getSlotPathOrd()), property, property.isDynamic());
        }
        if (value.getType().is(BComplex.TYPE)) {
            for (Property complexProp : value.asComplex().getProperties()) {
                BValue complexPropValue = value.asComplex().get(complexProp);
                if (!complexPropValue.getType().is(BPassword.TYPE)) continue;
                return new PasswordOrdProp(TmplUtil.relativizeOrd(namesRoot, parentComp.getSlotPathOrd()), property, complexProp, complexProp.isDynamic());
            }
        }
        return null;
    }

    public static boolean hasPasswordProp(BComplex complex) {
        for (Property complexProp : complex.getProperties()) {
            BValue complexPropValue = complex.get(complexProp);
            if (!complexPropValue.getType().is(BPassword.TYPE)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<LinkInfo> listExternalLinks(BComponent root) {
        BOrd rootOrd = root.getSlotPathOrd();
        ArrayList<LinkInfo> extLinks = new ArrayList<LinkInfo>();
        ArrayList<BComponent> componentList = new ArrayList<BComponent>();
        TmplUtil.listComponents(componentList, root);
        HashMap<BOrd, BComponent> handleMap = new HashMap<BOrd, BComponent>();
        for (BComponent component : componentList) {
            handleMap.put(component.getHandleOrd(), component);
        }
        String[] namesRoot = root.getSlotPath().getNames();
        for (BComponent comp : componentList) {
            for (BLink bLink : comp.getLinks()) {
                int flags;
                String ord;
                if (LinkUtil.isCompositeLink((BLink)bLink) || !(ord = bLink.getSourceOrd().toString()).startsWith("h:") || handleMap.containsKey(bLink.getSourceOrd()) || bLink.getParent().equals((Object)root) && ((flags = root.getFlags(root.getSlot(bLink.getTargetSlotName()))) & 0x1000) == 0) continue;
                try {
                    BComponent linkSource = bLink.getSourceOrd().resolve((BObject)root).get().asComponent();
                    String bindHints = TmplUtil.getBindHints(linkSource);
                    BOrd bOrdComp = TmplUtil.relativizeOrd(namesRoot, comp.getSlotPathOrd());
                    extLinks.add(new LinkInfo(bOrdComp, bLink.getTargetSlotName(), true, bindHints));
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "LinkSource error", e);
                }
            }
            for (BLink bLink : comp.getKnobs()) {
                BLink[] links;
                BOrd targetOrd = bLink.getTargetOrd();
                String ord = targetOrd.toString();
                if (!ord.startsWith("h:") || handleMap.containsKey(targetOrd)) continue;
                BComponent targetComp = targetOrd.resolve((BObject)root).get().asComponent();
                targetComp.lease();
                Slot targetSlot = targetComp.getSlot(bLink.getTargetSlotName());
                for (BLink link : links = targetComp.getLinks(targetSlot)) {
                    if (LinkUtil.isCompositeLink((BLink)link) || comp.getHandleOrd().equals((Object)root.getHandleOrd()) || !link.getSourceSlotName().equals(bLink.getSourceSlotName()) || !link.getSourceOrd().equals((Object)comp.getHandleOrd())) continue;
                    String bindHints = TmplUtil.getBindHints(targetComp);
                    BOrd slotPathOrd = comp.getSlotPathOrd();
                    if (slotPathOrd == null) continue;
                    BOrd bOrdComp = TmplUtil.relativizeOrd(namesRoot, slotPathOrd);
                    extLinks.add(new LinkInfo(bOrdComp, link.getSourceSlotName(), false, bindHints));
                }
            }
        }
        return extLinks;
    }

    public static ArrayList<TagGroupRelationInfo> listTagGroupRelations(BComponent root) {
        ArrayList<TagGroupRelationInfo> tagGroupInfo = new ArrayList<TagGroupRelationInfo>();
        ArrayList<BComponent> componentList = new ArrayList<BComponent>();
        String[] namesRoot = root.getSlotPath().getNames();
        TmplUtil.listComponents(componentList, root);
        for (BComponent comp : componentList) {
            BRelation[] relations;
            for (BRelation relation : relations = (BRelation[])comp.getChildren(BRelation.class)) {
                Entity endpoint;
                if (!relation.getId().equals((Object)BNiagaraTagDictionary.TAG_GROUP_RELATION) || (endpoint = relation.getEndpoint()) == null || !(endpoint instanceof BTagGroupInfo)) continue;
                BTagGroupInfo tgi = (BTagGroupInfo)endpoint;
                String tagGroupId = tgi.getGroupId().getQName();
                tgi.lease(2);
                Iterator tags = tgi.getTags();
                ArrayList<Tag> groupTags = new ArrayList<Tag>();
                while (tags.hasNext()) {
                    TagInfo tagInfo = (TagInfo)tags.next();
                    groupTags.add(tagInfo.makeTag());
                }
                if (groupTags.size() <= 0) continue;
                String slotName = relation.getPropertyInParent().getName();
                BOrd bOrdComp = TmplUtil.relativizeOrd(namesRoot, comp.getSlotPathOrd());
                tagGroupInfo.add(new TagGroupRelationInfo(bOrdComp, tagGroupId, slotName, groupTags));
            }
        }
        return tagGroupInfo;
    }

    public static void markComponentTags(BComponent comp) {
        for (BComponent c : (BComponent[])CompUtil.getDescendants((BComponent)comp, BComponent.class)) {
            for (Tag tag : new ComponentTags(c)) {
                int tagFlags;
                Property p = c.getProperty(SlotPath.escape((String)tag.getId().getQName()));
                c.setFlags((Slot)p, c.getFlags((Slot)p) | Integer.MIN_VALUE);
                if (!c.getType().is(BTemplateConfig.TYPE) || ((tagFlags = c.getFlags((Slot)p)) & 0x4000) == 0) continue;
                c.setFlags((Slot)p, tagFlags &= 0xFFFFBFFF);
            }
        }
    }

    public static void setTagDictionaryServiceForTemplateComponentSpace(BComponent root) {
        BComponentSpace space = Objects.requireNonNull(root.getComponentSpace());
        BComponent templateRoot = Objects.requireNonNull(root.getParent().getParentComponent());
        BTagDictionaryService[] tagDictionaryServices = (BTagDictionaryService[])templateRoot.getChildren(BTagDictionaryService.class);
        if (tagDictionaryServices != null && tagDictionaryServices.length > 0) {
            space.setTagDictionaryService((TagDictionaryService)tagDictionaryServices[0]);
        } else {
            BTagDictionaryService tagDictionaryService = (BTagDictionaryService)TmplUtil.makeTagDictionaryService();
            if (tagDictionaryService != null) {
                Property mtdsProp = templateRoot.add("mockTagDictionaryService", tagDictionaryService.newCopy(), 0, null);
                tagDictionaryService = (BTagDictionaryService)templateRoot.get(mtdsProp);
                space.setTagDictionaryService((TagDictionaryService)tagDictionaryService);
            }
        }
    }

    public static void convertTagsToTagGroupRelations(BComponent comp) {
        BTagDictionaryService tdService = (BTagDictionaryService)comp.getTagDictionaryService();
        BTagGroupInfo[] tagGroups = (BTagGroupInfo[])CompUtil.getDescendants((BComponent)tdService, BTagGroupInfo.class);
        TmplUtil.convertTagsToTagGroupRelationsForComponent(tagGroups, comp);
        for (BComponent c : (BComponent[])CompUtil.getDescendants((BComponent)comp, BComponent.class)) {
            TmplUtil.convertTagsToTagGroupRelationsForComponent(tagGroups, c);
        }
    }

    private static void convertTagsToTagGroupRelationsForComponent(BTagGroupInfo[] tagGroups, BComponent c) {
        block0: for (Tag tag : new ComponentTags(c)) {
            Property p = c.getProperty(SlotPath.escape((String)tag.getId().getQName()));
            if (!c.getSlotFacets((Slot)p).getb("tg__", false)) continue;
            for (BTagGroupInfo tagGroup : tagGroups) {
                BRelation addRelation;
                if (!tagGroup.getGroupId().equals((Object)tag.getId()) || TmplUtil.hasRelation(addRelation = new BRelation(BNiagaraTagDictionary.TAG_GROUP_RELATION, tagGroup.getSlotPathOrd()), c)) continue;
                c.remove(p);
                c.add("r?", (BValue)addRelation, 1);
                continue block0;
            }
        }
    }

    public static void convertTagGroupRelationsToTags(BComponent comp) {
        for (BRelation relation : (BRelation[])CompUtil.getDescendants((BComponent)comp, BRelation.class)) {
            if (relation instanceof BLink || !relation.getId().equals((Object)BNiagaraTagDictionary.TAG_GROUP_RELATION)) continue;
            Entity entity = relation.getEndpoint();
            BComponent parent = relation.getParent().asComponent();
            parent.remove((BComplex)relation);
            if (!(entity instanceof BTagGroupInfo)) continue;
            BTagGroupInfo tagGroupInfo = (BTagGroupInfo)entity;
            String name = SlotPath.escape((String)tagGroupInfo.getGroupId().getQName());
            CompUtil.setOrAdd((BComponent)parent, (String)name, (BValue)BMarker.MARKER, (int)16384, (BFacets)BEditTagDialog.TAG_GROUP_FACETS, null);
        }
    }

    private static boolean hasRelation(BRelation relation, BComponent component) {
        boolean hasRelation = false;
        for (BRelation existingRelation : (BRelation[])component.getChildren(BRelation.class)) {
            if (!existingRelation.getId().equals((Object)relation.getId()) || !existingRelation.getEndpointOrd().equals((Object)relation.getEndpointOrd())) continue;
            hasRelation = true;
            break;
        }
        return hasRelation;
    }

    private static String getBindHints(BComponent comp) {
        comp.lease();
        String bindHints = "";
        for (Tag tag : new ComponentTags(comp).getAll()) {
            if (!tag.getValue().getType().is(BMarker.TYPE)) continue;
            String tagId = tag.getId().toString();
            bindHints = bindHints + (bindHints.isEmpty() ? tagId : " and " + tagId);
        }
        Collection tagGroupRelations = comp.relations().getAll(Id.newId((String)"n:tagGroup"), 2);
        for (Relation groupRelation : tagGroupRelations) {
            BObject bObject = null;
            BOrd tgOrd = groupRelation.getEndpointOrd();
            bObject = tgOrd != null && !tgOrd.isNull() ? tgOrd.resolve((BObject)comp).get() : (BObject)groupRelation.getEndpoint();
            if (bObject == null || !(bObject instanceof BTagGroupInfo)) continue;
            BTagGroupInfo tagGroup = (BTagGroupInfo)bObject;
            tagGroup.lease(3);
            Iterator tags = tagGroup.getTags();
            while (tags.hasNext()) {
                Tag tag = ((TagInfo)tags.next()).makeTag();
                if (!(tag.getValue() instanceof BMarker)) continue;
                bindHints = bindHints + (bindHints.isEmpty() ? tag.getId().toString() : " and " + tag.getId().toString());
            }
        }
        return bindHints;
    }

    private static void listComponents(ArrayList<BComponent> list, BComponent comp) {
        list.add(comp);
        SlotCursor cursor = comp.getProperties();
        while (cursor.nextComponent()) {
            TmplUtil.listComponents(list, cursor.get().asComponent());
        }
    }

    private static void addPasswordConfig(BComponent root, ArrayList<PasswordInfo> intPSWs) {
        if (intPSWs.isEmpty()) {
            return;
        }
        BTemplateConfig templateConfig = BTemplateConfig.createConfigForRoot((BComponent)root);
        for (PasswordInfo passwordInfo : intPSWs) {
            BComponent pswComp = passwordInfo.getParentOrd().resolve((BObject)root).get().asComponent();
            String[] names = pswComp.getSlotPath().getNames();
            BOrd pswCompOrd = pswComp.getHandleOrd();
            if (passwordInfo.isDynamic()) {
                pswCompOrd = pswComp.getSlotPathOrd();
            }
            BPasswordBinding binding = null;
            binding = passwordInfo.getParentSlotName() != null ? new BPasswordBinding(pswCompOrd, passwordInfo.getParentSlotName(), passwordInfo.getSlotName(), passwordInfo.isDynamic()) : new BPasswordBinding(pswCompOrd, passwordInfo.getSlotName(), passwordInfo.isDynamic());
            templateConfig.add(null, (BValue)binding, 5, BFacets.NULL, null);
        }
    }

    private static void addTagGroupTags(BComponent root, ArrayList<TagGroupRelationInfo> tagGroupRelationInfos) {
        for (TagGroupRelationInfo tagGroupRelationInfo : tagGroupRelationInfos) {
            BComponent tagGroupComp = tagGroupRelationInfo.getSourceOrd().resolve((BObject)root).get().asComponent();
            Slot slot = tagGroupComp.getSlot(tagGroupRelationInfo.getRelationSlotName());
            if (slot == null) continue;
            tagGroupComp.remove(tagGroupRelationInfo.getRelationSlotName());
        }
        BComponent templateRoot = root.getParent().getParentComponent();
        for (TagGroupRelationInfo tagGroupRelationInfo : tagGroupRelationInfos) {
            BTagDictionary tagDictionary;
            BTagGroupInfoList tagGroupInfos;
            Optional tagGroupInfo;
            Id tgId;
            Optional tdOptional;
            BComponent tagGroupComp = tagGroupRelationInfo.getSourceOrd().resolve((BObject)root).get().asComponent();
            String tagGroupTagName = SlotPath.escape((String)tagGroupRelationInfo.getTagGroupId());
            BTagDictionaryService tdService = null;
            if (templateRoot != null) {
                try {
                    tdService = (BTagDictionaryService)templateRoot.get("mockTagDictionaryService");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tdService == null && (tdService = (BTagDictionaryService)TmplUtil.makeTagDictionaryService()) != null) {
                    Property mtdsProp = templateRoot.add("mockTagDictionaryService", tdService.newCopy(), 0, null);
                    tdService = (BTagDictionaryService)templateRoot.get(mtdsProp);
                }
            }
            if (tdService == null || !(tdOptional = tdService.getTagDictionary((tgId = Id.newId((String)SlotPath.unescape((String)tagGroupTagName))).getDictionary())).isPresent() || !(tagGroupInfo = (tagGroupInfos = (tagDictionary = (BTagDictionary)tdOptional.get()).getTagGroupDefinitions()).getTagGroup(tgId)).isPresent()) continue;
            BTagGroupInfo tgi = (BTagGroupInfo)tagGroupInfo.get();
            BOrd slotPathOrd = tgi.getSlotPathOrd();
            BRelation tgRelation = new BRelation(Id.newId((String)"n:tagGroup"), slotPathOrd);
            String name = SlotPath.escape((String)tgi.getGroupId().getQName());
            Property property = tagGroupComp.add(name, (BValue)tgRelation, 1, BEditTagDialog.TAG_GROUP_FACETS, null);
        }
    }

    private static void addExternalLinks(BComponent root, ArrayList<LinkInfo> extLinks) {
        for (LinkInfo linkInfo : extLinks) {
            BComponent linkComp = linkInfo.getOrd().resolve((BObject)root).get().asComponent();
            TmplUtil.addCompositeSlot(linkInfo, linkComp, root);
        }
    }

    private static void addCompositeSlot(LinkInfo linkInfo, BComponent linkComp, BComponent root) {
        Slot childSlot = linkComp.getSlot(linkInfo.getSlotName());
        int childFlags = childSlot.getDefaultFlags();
        linkComp.setFlags(childSlot, childFlags);
        BValue value = null;
        BFacets facets = linkComp.getSlotFacets(childSlot);
        if (facets == null) {
            facets = BFacets.NULL;
        }
        if (childSlot.isAction() || childSlot.isTopic()) {
            String msg = childSlot.isAction() ? "action" : "topic";
            log.info("External link to " + msg + " not supported.");
            return;
        }
        value = linkComp.get((Property)childSlot).newCopy();
        int flags = linkInfo.isInput() ? 4104 : 4105;
        flags |= childFlags;
        flags &= 0xFFFFFFFD;
        String addName = linkComp.getName() + '_' + linkInfo.getSlotName();
        Property prop = root.getProperty(addName);
        if (prop == null) {
            root.add(addName, value, flags, facets, null);
            if (!linkInfo.isInput()) {
                BLink link = new BLink(linkComp.getHandleOrd(), linkInfo.getSlotName(), addName, true);
                link.tags().set(BNiagaraTagDictionary.BIND_HINTS, (BIDataValue)BString.make((String)linkInfo.bindHints));
                root.add(null, (BValue)link, 4096, BFacets.NULL, null);
                log.info("External link detected from " + addName);
            } else {
                BLink link = new BLink(root.getHandleOrd(), addName, linkInfo.getSlotName(), true);
                link.tags().set(BNiagaraTagDictionary.BIND_HINTS, (BIDataValue)BString.make((String)linkInfo.bindHints));
                linkComp.add(null, (BValue)link, 4096, BFacets.NULL, null);
                link.activate();
                log.info("External link detected to " + addName);
            }
        } else {
            Knob[] knobs;
            BLink[] links = root.getLinks((Slot)prop);
            if (links != null && links.length > 0) {
                TmplUtil.checkAddBindHints(links[0], linkInfo.bindHints);
            }
            if ((knobs = root.getKnobs((Slot)prop)) != null && knobs.length > 0) {
                BLink link = knobs[0].getLink();
                TmplUtil.checkAddBindHints(link, linkInfo.bindHints);
            }
        }
    }

    private static void checkAddBindHints(BLink link, String bindHints) {
        boolean addBindHints;
        Tags tags = link.tags();
        StringBuilder sb = new StringBuilder();
        Optional optBindHints = tags.get(BNiagaraTagDictionary.BIND_HINTS);
        boolean bl = addBindHints = !optBindHints.isPresent();
        if (optBindHints.isPresent()) {
            String curBindHints = ((BString)optBindHints.get()).getString();
            addBindHints = true;
            tags.removeAll(BNiagaraTagDictionary.BIND_HINTS);
            if (!curBindHints.isEmpty() && !curBindHints.contains(bindHints)) {
                if (curBindHints.startsWith("(")) {
                    sb.append(curBindHints).append(" or (").append(bindHints).append(')');
                } else {
                    sb.append('(').append(curBindHints).append(") or (").append(bindHints).append(")");
                }
                bindHints = sb.toString();
            } else {
                bindHints = curBindHints;
            }
        }
        if (addBindHints) {
            tags.set(BNiagaraTagDictionary.BIND_HINTS, (BIDataValue)BString.make((String)bindHints));
        }
    }

    public static BOrd relativizeOrd(String[] baseNames, BOrd oldOrd) {
        OrdQuery[] q;
        if (oldOrd.isNull()) {
            return null;
        }
        try {
            q = oldOrd.parse();
        }
        catch (Throwable e) {
            return null;
        }
        if (q.length == 0) {
            return null;
        }
        int n = 0;
        if (q[n].getScheme().equals("station")) {
            ++n;
            if (q.length == 1) {
                return null;
            }
        }
        if (!q[n].getScheme().equals("slot")) {
            return null;
        }
        SlotPath path = (SlotPath)q[n];
        String[] names = path.getNames();
        if (names.length == 0 || baseNames.length == 0) {
            return null;
        }
        if (!names[0].equals(baseNames[0])) {
            return null;
        }
        String rel = TmplUtil.relative(baseNames, names);
        Array queries = new Array(OrdQuery.class);
        queries.add((Object)new SlotPath("slot", rel));
        for (int i = n + 1; i < q.length; ++i) {
            queries.add((Object)q[i]);
        }
        return BOrd.make((OrdQuery[])((OrdQuery[])queries.trim()));
    }

    private static String relative(String[] from, String[] to) {
        int i;
        int a;
        if (!from[0].equals(to[0])) {
            throw new IllegalStateException();
        }
        StringBuilder sb = new StringBuilder();
        for (a = 1; a < to.length && a < from.length && from[a].equals(to[a]); ++a) {
        }
        int b = from.length - a;
        for (i = 0; i < b; ++i) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append("..");
        }
        for (i = a; i < to.length; ++i) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(to[i]);
        }
        return sb.toString();
    }

    public static BOrd[] getPxViewOrds(BComponent root) {
        Array array = new Array(BOrd.class);
        TmplUtil.appendPxViews(root, (Array<BOrd>)array);
        return (BOrd[])array.trim();
    }

    private static void appendPxViews(BComponent root, Array<BOrd> array) {
        BPxView[] pxViews = (BPxView[])root.getChildren(BPxView.class);
        for (int i = 0; i < pxViews.length; ++i) {
            array.add((Object)((BOrd)pxViews[i].getPxFile().newCopy()));
        }
        BComponent[] childComps = root.getChildComponents();
        for (int j = 0; j < childComps.length; ++j) {
            TmplUtil.appendPxViews(childComps[j], array);
        }
    }

    public static BIFile makeFile(BDirectory dir, String fileName) {
        FilePath filePath = dir.getFilePath();
        try {
            return BFileSystem.INSTANCE.makeFile(filePath.merge(fileName));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot create file:" + e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static PxFileRef makeNewPx(String fname) {
        BMemoryFileStore fs = BMemoryFileSpace.INSTANCE.makeMemoryStore("px/" + fname);
        BPxFile newF = new BPxFile((BIFileStore)fs);
        fs.setFile((BIFile)newF);
        return new MemoryPxFileRef(newF, BOrd.make((String)("file:^px/" + fname)), newF.getAbsoluteOrd(), fname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, BVersion>> checkModuleDependencies(BNtplFile file, HashMap<String, BVersion> nreModules, boolean checkSubtemplates, boolean checkPxFiles) {
        ArrayList<BNtplFile> ntplFiles = new ArrayList<BNtplFile>();
        LinkedHashMap<String, BVersion> modulesMissing = new LinkedHashMap<String, BVersion>();
        LinkedHashMap<String, BVersion> pxModulesMissing = new LinkedHashMap<String, BVersion>();
        LinkedHashMap<String, BVersion> versionsMissing = new LinkedHashMap<String, BVersion>();
        ArrayList<String> pxModules = new ArrayList<String>();
        ntplFiles.add(file);
        if (checkSubtemplates) {
            Object[] subs;
            for (Object obj : subs = file.getTemplateManifest().subtemplates.trim()) {
                String ord;
                BNtplFile local;
                if (!(obj instanceof TemplateManifest.Subtemplate) || ntplFiles.contains(local = (BNtplFile)BOrd.make((String)(ord = ((TemplateManifest.Subtemplate)obj).ntplFileOrd)).get())) continue;
                ntplFiles.add(local);
            }
        }
        for (BNtplFile ntplFile : ntplFiles) {
            PxFileRef[] pxFileRefs;
            BDependency[] bDeps;
            boolean closeNtplFile = !ntplFile.isOpen();
            try {
                bDeps = ntplFile.getTemplateManifest().getDependencies();
                pxFileRefs = ntplFile.getPxFiles();
            }
            finally {
                if (closeNtplFile) {
                    ntplFile.close();
                }
            }
            if (checkPxFiles) {
                for (PxFileRef pxFileRef : pxFileRefs) {
                    try {
                        BPxFile pxFile = pxFileRef.getPxFile();
                        String[] modules = TmplUtil.getModulesFromPxFile(pxFile);
                        pxModules.addAll(Arrays.asList(modules));
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Error checking module dependencies:" + e.getLocalizedMessage(), e);
                    }
                }
            }
            for (PxFileRef pxFileRef : bDeps) {
                if (nreModules.get(pxFileRef.getPartName()) == null) {
                    modulesMissing.put(pxFileRef.getPartName(), BVersion.ZERO);
                    continue;
                }
                if (nreModules.get(pxFileRef.getPartName()).compareTo((Object)new BVersion(pxFileRef.getVersion().getVendorVersion().toString())) >= 0) continue;
                versionsMissing.put(pxFileRef.getPartName(), pxFileRef.getVersion());
            }
            if (!checkPxFiles) continue;
            for (String s : pxModules) {
                String wb = s + "-wb";
                String string = s + "-rt";
                if (nreModules.get(wb) != null || nreModules.get(string) != null || nreModules.get(s) != null) continue;
                pxModulesMissing.put(s, BVersion.ZERO);
            }
        }
        ArrayList<Map<String, BVersion>> dependencyCheckResults = new ArrayList<Map<String, BVersion>>();
        dependencyCheckResults.add(modulesMissing);
        dependencyCheckResults.add(versionsMissing);
        dependencyCheckResults.add(pxModulesMissing);
        return dependencyCheckResults;
    }

    public static boolean stationHasAce(BStation station) {
        BISession session = station.getSession();
        if (session instanceof BFoxProxySession) {
            Optional useService = Optional.empty();
            try {
                useService = ((BFoxProxySession)session).rpc(BOrd.make((String)"type:template:TemplateService"), "mustUseServiceToMakeTemplate", new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (useService.isPresent()) {
                return (Boolean)useService.get();
            }
        }
        station.lease(ACE_DEPTH);
        return CompUtil.hasDescendant((BComponent)station, (String)"ace:AceNetwork");
    }

    private static String[] getModulesFromPxFile(BPxFile pxFile) {
        String[] modules = new String[]{""};
        try {
            XParser parser = XParser.make((InputStream)pxFile.getInputStream());
            XElem root = parser.parse();
            XElem elem = root.elem("import");
            if (elem == null) {
                throw new XException("Missing <import> element", root);
            }
            XElem[] moduleElems = elem.elems("module");
            modules = new String[moduleElems.length];
            for (int i = 0; i < moduleElems.length; ++i) {
                modules[i] = moduleElems[i].get("name");
            }
        }
        catch (Exception e) {
            log.warning(e.getLocalizedMessage());
        }
        return modules;
    }

    private static class LocalPxSource
    implements EmbeddedPxSource {
        private final BComponent root;

        LocalPxSource(BComponent root) {
            this.root = root;
        }

        public BPxFile getPxFile(BOrd ord) {
            OrdTarget target = ord.resolve((BObject)this.root);
            return (BPxFile)target.get();
        }
    }

    public static class SubtemplateInfo {
        private String deployName;
        private String vendor;
        private String version;
        private BOrd deployOrd;
        private BOrd ntplFileOrd;

        public SubtemplateInfo() {
        }

        public SubtemplateInfo(String deployName, String vendor, String version, BOrd deployOrd, BOrd ntplFileOrd) {
            this.deployName = deployName;
            this.vendor = vendor;
            this.version = version;
            this.deployOrd = deployOrd;
            this.ntplFileOrd = ntplFileOrd;
        }

        public void setDeployName(String deployName) {
            this.deployName = deployName;
        }

        public void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setDeployOrd(BOrd deployOrd) {
            this.deployOrd = deployOrd;
        }

        public void setNtplFileOrd(BOrd ntplFileOrd) {
            this.ntplFileOrd = ntplFileOrd;
        }

        public String getDeployName() {
            return this.deployName;
        }

        public String getVendor() {
            return this.vendor;
        }

        public String getVersion() {
            return this.version;
        }

        public BOrd getDeployOrd() {
            return this.deployOrd;
        }

        public BOrd getNtplFileOrd() {
            return this.ntplFileOrd;
        }
    }

    public static class TagGroupRelationInfo {
        private String tagGroupId = "";
        private BOrd sourceOrd = BOrd.DEFAULT;
        private String relationSlotName = "";
        private ArrayList<Tag> tagGroupTags = new ArrayList();

        public TagGroupRelationInfo() {
        }

        public TagGroupRelationInfo(BOrd sourceOrd, String tagGroupId, String relationSlotName, ArrayList<Tag> tagGroupTags) {
            this.sourceOrd = sourceOrd;
            this.tagGroupId = tagGroupId;
            this.relationSlotName = relationSlotName;
            this.tagGroupTags = tagGroupTags;
        }

        public void setSourceOrd(BOrd ord) {
            this.sourceOrd = ord;
        }

        public void setRelationSlotName(String relationSlotName) {
            this.relationSlotName = relationSlotName;
        }

        public void setTagGroupTags(ArrayList<Tag> tagGroupTags) {
            this.tagGroupTags = tagGroupTags;
        }

        public void setTagGroupId(String tagGroupId) {
            this.tagGroupId = tagGroupId;
        }

        public BOrd getSourceOrd() {
            return this.sourceOrd;
        }

        public String getRelationSlotName() {
            return this.relationSlotName;
        }

        public String getTagGroupId() {
            return this.tagGroupId;
        }

        public ArrayList<Tag> getTagGroupTags() {
            return this.tagGroupTags;
        }

        public String getTagGroupList() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Tag tag : this.tagGroupTags) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(tag.getId().getQName());
                ++i;
            }
            return sb.toString();
        }
    }

    public static class LinkInfo {
        private BOrd ord;
        private String slotName;
        private boolean isInput;
        private String bindHints;

        public LinkInfo() {
        }

        public LinkInfo(BOrd ord, String slotName, boolean isInput, String bindHints) {
            this.ord = ord;
            this.slotName = slotName;
            this.isInput = isInput;
            this.bindHints = bindHints;
        }

        private static LinkInfo make(BOrd ord, String slotName, boolean isInput, String bindHints) {
            return new LinkInfo(ord, slotName, isInput, bindHints);
        }

        public void setOrd(BOrd ord) {
            this.ord = ord;
        }

        public void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        public void setIsInput(boolean isInput) {
            this.isInput = isInput;
        }

        public BOrd getOrd() {
            return this.ord;
        }

        public String getSlotName() {
            return this.slotName;
        }

        public boolean isInput() {
            return this.isInput;
        }
    }

    public static class PasswordInfo {
        private BOrd parentOrd;
        private String slotName;
        private String parentSlotName;
        private boolean isDynamic;

        public PasswordInfo() {
        }

        public PasswordInfo(BOrd parentOrd, String slotName, boolean isDynamic) {
            this.parentOrd = parentOrd;
            this.slotName = slotName;
            this.parentSlotName = "";
            this.isDynamic = isDynamic;
        }

        public PasswordInfo(BOrd parentOrd, String parentSlotName, String slotName, boolean isDynamic) {
            this.parentOrd = parentOrd;
            this.slotName = slotName;
            this.parentSlotName = parentSlotName;
            this.isDynamic = isDynamic;
        }

        public void setParentOrd(BOrd parentOrd) {
            this.parentOrd = parentOrd;
        }

        public void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        public void setIsDynamic(boolean isDynamic) {
            this.isDynamic = isDynamic;
        }

        public BOrd getParentOrd() {
            return this.parentOrd;
        }

        public String getSlotName() {
            return this.slotName;
        }

        public String getParentSlotName() {
            return this.parentSlotName;
        }

        public boolean isDynamic() {
            return this.isDynamic;
        }
    }

    private static class PasswordOrdProp {
        BOrd parent;
        Property property;
        Property parentProperty;
        boolean isDynamic;

        PasswordOrdProp(BOrd parent, Property property, boolean isDynamic) {
            this.parent = parent;
            this.property = property;
            this.parentProperty = null;
            this.isDynamic = isDynamic;
        }

        PasswordOrdProp(BOrd parent, Property parentProperty, Property property, boolean isDynamic) {
            this.parent = parent;
            this.property = property;
            this.parentProperty = parentProperty;
            this.isDynamic = isDynamic;
        }
    }

    public static class BindInfo {
        String info;
        BColor forground;

        public BindInfo(String info, BColor forground) {
            this.info = info;
            this.forground = forground;
        }

        public String getInfo() {
            return this.info;
        }

        public BColor getForground() {
            return this.forground;
        }
    }

    public static class TargetChoice
    implements Comparable<TargetChoice> {
        public BComponent targetPoint;
        public BDynamicEnum targetSlotEnum;
        public boolean selected;

        public String getSelectString() {
            return SlotPath.unescape((String)this.targetPoint.getSlotPath().toString());
        }

        @Override
        public int compareTo(TargetChoice targetChoice) {
            return this.getSelectString().compareTo(targetChoice.getSelectString());
        }
    }
}

