/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.excel.CTCol;
import com.tridium.excel.Cell;
import com.tridium.excel.CellRangeAddress;
import com.tridium.excel.CellStyle;
import com.tridium.excel.CellType;
import com.tridium.excel.ClientAnchor;
import com.tridium.excel.Comment;
import com.tridium.excel.CreationHelper;
import com.tridium.excel.DataFormatter;
import com.tridium.excel.Drawing;
import com.tridium.excel.EncryptionInfo;
import com.tridium.excel.Encryptor;
import com.tridium.excel.ExcelFileObject;
import com.tridium.excel.ExcelFileSystem;
import com.tridium.excel.ExcelUtils;
import com.tridium.excel.FillPatternType;
import com.tridium.excel.Font;
import com.tridium.excel.IndexedColors;
import com.tridium.excel.Name;
import com.tridium.excel.RichTextString;
import com.tridium.excel.Row;
import com.tridium.excel.Sheet;
import com.tridium.excel.Workbook;
import com.tridium.neql.component.ComponentTreeIterator;
import com.tridium.sys.tag.ComponentTags;
import com.tridium.sys.transfer.DeployToComp;
import com.tridium.template.BConfigBinding;
import com.tridium.template.BRelationInfo;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.BTemplateService;
import com.tridium.template.api.NiagaraTemplate;
import com.tridium.template.api.OptionalComponent;
import com.tridium.template.api.TemplateElement;
import com.tridium.template.api.TemplateProperty;
import com.tridium.template.api.TemplateValue;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.file.TemplateManager;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.template.ui.BTemplateManager;
import com.tridium.template.ui.BulkDeployWorkbook;
import com.tridium.template.ui.TemplateDeployWorker;
import com.tridium.template.ui.UpdateUtil;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.template.ui.file.TmplUtil;
import com.tridium.util.CompUtil;
import com.tridium.util.ThrowableUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDriverContainer;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.history.BIArchiveFolder;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.io.BIEncodable;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.search.BSearchService;
import javax.baja.security.BPassword;
import javax.baja.space.BComponentSpace;
import javax.baja.space.Mark;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BIService;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;
import javax.baja.util.BFolder;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BServiceContainer;
import javax.baja.util.BUuid;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

public class BulkDeployUtil {
    public static final Level IMPORT_LOG_LEVEL = Level.FINE;
    public static final Lexicon lex = Lexicon.make((String)"template");
    public static final Logger log = Logger.getLogger("template.bulkDeploy");
    protected static final String SLOT_NAME_SEPARATOR = ".";
    private static final String SLOT_NAME_SEPARATOR_REGEX = "\\.";
    public static final int EXCEL_HEADER_ROWS = 6;
    public static final int EXCEL_HEADER_ROWS_WITH_SLOT_PATH_SCOPE = 7;
    public static final int EXCEL_APPLICATION_HEADER_ROWS = 6;
    public static final int EXCEL_COLUMN_FREEZE = 2;
    public static final int EXCEL_APP_COLUMN_FREEZE = 2;
    private BTemplateService templateService;
    private BSearchService searchService;
    private StyleVault styleVault;
    public static final int DEVICE_INFO_COLUMN_COUNT = 5;
    public static final int COMPONENT_INFO_COLUMN_COUNT = 5;
    public static final int APP_INFO_COLUMN_COUNT = 2;
    public static final int CELL_COMMENT_OFFSET_COLUMN = 5;
    public static final int CELL_COMMENT_OFFSET_ROW = 5;
    public static final int CELL_COMMENT_MAX_STRING_LENGTH = 60;
    protected static final int PARENT_SLOTPATH = 0;
    protected static final int DEPLOYED_NAME = 1;
    protected static final int DISPLAY_NAME = 2;
    protected static final int WS_POSITION = 3;
    protected static final int UNIQUE_DEVICE = 4;
    protected static final int HISTORY_EXT = 5;
    protected static final int APP_UNIQUE_DEVICE = 1;
    protected static final int TEMPLATE_HEADER_LABEL_COLUMN = 0;
    protected static final int TEMPLATE_HEADER_TEXT_COLUMN = 1;
    protected static final int TEMPLATE_TITLE_LABEL_COLUMN = 0;
    protected static final int TEMPLATE_TITLE_INFO_COLUMN = 1;
    protected static final int TEMPLATE_VERSION_LABEL_COLUMN = 0;
    protected static final int TEMPLATE_VERSION_INFO_COLUMN = 1;
    protected static final int INPUT_DEFS_INDEX = 0;
    protected static final int OUTPUT_DEFS_INDEX = 1;
    protected static final int RELATION_DEFS_INDEX = 2;
    protected static final int CONFIG_DEFS_INDEX = 3;
    protected static final int OPTIONAL_DEFS_INDEX = 4;
    protected static final int OPTIONAL_CONFIG_DEFS_INDEX = 5;
    protected static final int TAG_DEFS_INDEX = 6;
    protected static final String TEMPLATE_EXPORT_VERSION = "1.3";
    protected static final String TEMPLATE_EXPORT_VERSION_NAME = "version";
    protected static final String TEMPLATE_VENDOR_NAME = "templateVendor";
    protected static final String TEMPLATE_FILE_NAME = "templateFile";
    protected static final String TEMPLATE_TITLE_NAME = "templateTitle";
    protected static final String TEMPLATE_VERSION_NAME = "templateVersion";
    protected static final String TEMPLATE_UID_NAME = "templateUID";
    protected static final String TEMPLATE_TYPE_NAME = "templateType";
    protected static final String TEMPLATE_SHEET_INFO_COLUMNS_NAME = "infoColumns";
    protected static final String TEMPLATE_INPUTS_COUNT_NAME = "inputsCount";
    protected static final String TEMPLATE_OUTPUTS_COUNT_NAME = "outputsCount";
    protected static final String TEMPLATE_RELATIONS_COUNT_NAME = "relationsCount";
    protected static final String TEMPLATE_CONFIGS_COUNT_NAME = "configsCount";
    protected static final String TEMPLATE_OPTIONALS_COUNT_NAME = "optionalsCount";
    protected static final String TEMPLATE_OPTIONAL_CONFIGS_COUNT_NAME = "optionalConfigsCount";
    protected static final String TEMPLATE_TAG_COUNT_NAME = "tagCount";
    protected static final String KEEP_PRIVATE_NAME = "keepPrivate";
    protected static final String DEFAULT_TARGET_SLOT = "in10";
    protected static final String DEFAULT_SOURCE_SLOT = "out";
    protected static final String DEFAULT_SLOT_PATH_SCOPE = "";
    protected static final String SOURCE_SLOT_MIN_VERSION = "1.1";
    protected static final String SLOT_PATH_SCOPE_MIN_VERSION = "1.3";
    public static final String TEMPLATE_TYPE_COMPONENT = "Component";
    public static final String TEMPLATE_TYPE_DEVICE = "Device";
    public static final String TEMPLATE_TYPE_APPLICATION = "Application";
    protected static final BHistoryExt[] HISTORY_EXTS = new BHistoryExt[0];
    protected static final String[] STRINGS = new String[0];
    protected static final BOrd[] BORDS = new BOrd[0];

    public HashSet<Tag> getStringTagsInTemplate(BWbDeployableNtplFile ntplFile) {
        BComponent templateBase = ntplFile.getBaseComponent();
        HashSet<Tag> tags = new HashSet<Tag>();
        ComponentTreeIterator iterator = new ComponentTreeIterator(templateBase);
        while (iterator.hasNext()) {
            ComponentTags componentTags;
            Entity entity = iterator.next();
            if (!(entity.tags() instanceof ComponentTags) || (componentTags = (ComponentTags)entity.tags()).isEmpty()) continue;
            componentTags.forEach(tag -> {
                if (tag.getValue().getType().is(BString.TYPE)) {
                    tags.add((Tag)tag);
                }
            });
        }
        return tags;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File exportTemplateToExcel(BIFile exportPath, BPassword encryptPassword, BWbDeployableNtplFile[] ntplFiles, Map<BWbDeployableNtplFile, HashSet<Tag>> tagMap, StringBuilder replyMessage) {
        File exportBase = BFileSystem.INSTANCE.pathToLocalFile(exportPath.getFilePath());
        File exportFile = new File(exportBase.getParent(), exportBase.getName());
        boolean useOldExcelFormat = exportPath.getExtension().equalsIgnoreCase("xls");
        try (FileOutputStream excelExport = new FileOutputStream(exportFile);
             Workbook wb = ExcelUtils.createWorkbook((!useOldExcelFormat ? 1 : 0) != 0);){
            BulkDeployUtil.setTemplateExportVersion(wb);
            this.styleVault = new StyleVault(wb);
            for (BWbDeployableNtplFile ntplFile : ntplFiles) {
                BTemplateConfig templateConfig;
                BComponent templateBase;
                String templateFileName = ntplFile.getFileName();
                TemplateManifest manifest = ntplFile.getTemplateManifest();
                String templateName = manifest.vendor + '-' + templateFileName;
                Sheet templateSheet = wb.createSheet(templateName);
                this.setDefaultCellStyle(templateSheet);
                BulkDeployUtil.setTemplateFile(templateSheet, templateFileName);
                try {
                    templateBase = ntplFile.getBaseComponent();
                    templateConfig = BTemplateConfig.getConfigForRoot((BComponent)templateBase);
                    if (templateConfig == null) {
                        log.log(Level.WARNING, lex.getText("bulkDeploy.excelExport.templateConfigNotFound", new Object[]{templateFileName}));
                        File file = null;
                        return file;
                    }
                }
                catch (Exception e) {
                    String message = lex.getText("bulkDeploy.excelExport.exportFileError", new Object[]{exportFile.toString()});
                    if (BulkDeployUtil.isModuleNotFoundException(e)) {
                        message = lex.getText("bulkDeploy.excelExport.moduleNotFoundError", new Object[]{ntplFile.getTitle()});
                    }
                    log.log(Level.WARNING, message, e);
                    replyMessage.append(message);
                    File file = null;
                    return file;
                }
                try {
                    BulkDeployUtil.setTemplateVendor(templateSheet, manifest.vendor);
                    BulkDeployUtil.setTemplateTitle(templateSheet, manifest.title);
                    BulkDeployUtil.setTemplateVersion(templateSheet, manifest.version);
                    BulkDeployUtil.setTemplateUID(templateSheet, templateConfig.getUID().encodeToString());
                    BulkDeployUtil.setTemplateTypeName(templateSheet, this.buildTemplateTypeName(manifest));
                }
                catch (IOException e) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelExport.templateIdError", new Object[]{templateFileName}), e);
                    File file = null;
                    if (wb != null) {
                        if (var12_16 != null) {
                            try {
                                wb.close();
                            }
                            catch (Throwable throwable) {
                                var12_16.addSuppressed(throwable);
                            }
                        } else {
                            wb.close();
                        }
                    }
                    if (excelExport == null) return file;
                    if (var10_11 == null) {
                        excelExport.close();
                        return file;
                    }
                    try {
                        excelExport.close();
                        return file;
                    }
                    catch (Throwable throwable) {
                        var10_11.addSuppressed(throwable);
                        return file;
                    }
                }
                HashSet<Tag> tags = tagMap.get((Object)ntplFile);
                this.getTemplateConfigContents(templateBase, templateConfig, manifest, tags, templateSheet);
                if (ExcelUtils.isXmlFormat((ExcelFileObject)templateSheet)) {
                    templateSheet.lockSelectLockedCells(false);
                    templateSheet.lockSelectUnlockedCells(false);
                    templateSheet.lockFormatColumns(false);
                    templateSheet.lockFormatRows(false);
                    templateSheet.lockFormatCells(true);
                    templateSheet.lockInsertColumns(true);
                    templateSheet.lockInsertRows(true);
                    templateSheet.lockInsertHyperlinks(true);
                    templateSheet.lockDeleteColumns(true);
                    templateSheet.lockDeleteRows(true);
                    templateSheet.lockSort(true);
                    templateSheet.lockAutoFilter(true);
                    templateSheet.lockPivotTables(true);
                    templateSheet.lockObjects(true);
                    templateSheet.lockScenarios(true);
                    templateSheet.enableLocking();
                }
                ntplFile.closeIfOpen();
            }
            if (encryptPassword != null && !useOldExcelFormat || this.templatesHaveConfigPasswords(ntplFiles)) {
                BulkDeployUtil.setKeepPrivateFlag(wb);
                Row noteRow = wb.getSheetAt(wb.getActiveSheetIndex()).getRow(1);
                BulkDeployUtil.generateCell(noteRow, 0, lex.getText("templateSideBar.privacyNote"), this.styleVault.getInfoCellStyle());
                BulkDeployUtil.generateCell(noteRow, 1, lex.getText("templateSideBar.privacyMessage"), this.styleVault.getStringCellStyle());
            }
            if (encryptPassword == null) {
                wb.write((OutputStream)excelExport);
                return exportFile;
            }
            if (useOldExcelFormat) {
                ExcelUtils.setCurrentUserPassword((String)encryptPassword.getValue());
                wb.write((OutputStream)excelExport);
                ExcelUtils.setCurrentUserPassword(null);
                return exportFile;
            }
            ExcelFileSystem fs = ExcelUtils.makeFileSystem();
            EncryptionInfo info = ExcelUtils.makeEncryptionInfo();
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(encryptPassword.getValue());
            try (OutputStream os = enc.getDataStream(fs);){
                wb.write(os);
            }
            fs.writeFilesystem((OutputStream)excelExport);
            return exportFile;
        }
        catch (Exception e) {
            String message = lex.getText("bulkDeploy.excelExport.exportFileError", new Object[]{exportFile.toString()});
            log.log(Level.WARNING, message, e);
            replyMessage.append(message);
            return null;
        }
    }

    public File exportApplicationTemplateToExcel(BIFile exportPath, BPassword encryptPassword, NiagaraTemplate template, StringBuilder replyMessage) {
        ArrayList<NiagaraTemplate> templates = new ArrayList<NiagaraTemplate>();
        templates.add(template);
        return this.exportApplicationTemplateToExcel(exportPath, encryptPassword, templates, replyMessage);
    }

    public File exportApplicationTemplateToExcel(BIFile exportPath, BPassword encryptPassword, List<NiagaraTemplate> templates, StringBuilder replyMessage) {
        File exportBase = BFileSystem.INSTANCE.pathToLocalFile(exportPath.getFilePath());
        File exportFile = new File(exportBase.getParent(), exportBase.getName());
        boolean useOldExcelFormat = exportPath.getExtension().equalsIgnoreCase("xls");
        try (FileOutputStream excelExport = new FileOutputStream(exportFile);){
            this.exportApplicationTemplateToExcel(excelExport, encryptPassword, useOldExcelFormat, templates);
        }
        catch (Exception e) {
            String message = lex.getText("bulkDeploy.excelExport.exportFileError", new Object[]{exportFile.toString()});
            log.log(Level.WARNING, message, e);
            replyMessage.append(message);
            return null;
        }
        return exportFile;
    }

    /*
     * WARNING - void declaration
     */
    public void exportApplicationTemplateToExcel(OutputStream exportStream, BPassword encryptPassword, boolean useOldExcelFormat, List<NiagaraTemplate> templates) throws IOException, GeneralSecurityException {
        block36: {
            try (Workbook wb = ExcelUtils.createWorkbook((!useOldExcelFormat ? 1 : 0) != 0);){
                BulkDeployUtil.setTemplateExportVersion(wb);
                this.styleVault = new StyleVault(wb);
                boolean hasSensitiveDataConfig = false;
                for (NiagaraTemplate niagaraTemplate : templates) {
                    hasSensitiveDataConfig |= niagaraTemplate.hasSensitiveDataConfig();
                }
                ArrayList templateGroups = new ArrayList();
                for (NiagaraTemplate niagaraTemplate : templates) {
                    boolean groupFound = false;
                    for (int i = 0; i < templateGroups.size(); ++i) {
                        List templateGroup = (List)templateGroups.get(i);
                        if (!((NiagaraTemplate)templateGroup.get(0)).getUid().equals(niagaraTemplate.getUid())) continue;
                        if (niagaraTemplate.isCompatibleWith((NiagaraTemplate)templateGroup.get(0))) {
                            templateGroup.add(niagaraTemplate);
                            groupFound = true;
                            break;
                        }
                        if (!((NiagaraTemplate)templateGroup.get(0)).isCompatibleWith(niagaraTemplate)) continue;
                        templateGroup.add(0, niagaraTemplate);
                        for (int j = i + 1; j < templateGroups.size(); ++j) {
                            if (!((NiagaraTemplate)((List)templateGroups.get(j)).get(0)).isCompatibleWith(niagaraTemplate)) continue;
                            List otherGroup = (List)templateGroups.get(j);
                            templateGroups.remove(j);
                            templateGroup.addAll(otherGroup);
                            --j;
                        }
                        groupFound = true;
                        break;
                    }
                    if (groupFound) continue;
                    ArrayList<NiagaraTemplate> newGroup = new ArrayList<NiagaraTemplate>();
                    newGroup.add(niagaraTemplate);
                    templateGroups.add(newGroup);
                }
                for (List list : templateGroups) {
                    NiagaraTemplate mainTemplate = (NiagaraTemplate)list.get(0);
                    String templateFileName = mainTemplate.getFileName();
                    String vendor = mainTemplate.getVendor();
                    String templateName = (vendor.isEmpty() ? DEFAULT_SLOT_PATH_SCOPE : mainTemplate.getVendor() + '-') + templateFileName;
                    Sheet templateSheet = wb.createSheet(templateName);
                    this.setDefaultCellStyle(templateSheet);
                    BulkDeployUtil.setTemplateFile(templateSheet, templateFileName);
                    BulkDeployUtil.setTemplateVendor(templateSheet, vendor);
                    BulkDeployUtil.setTemplateTitle(templateSheet, mainTemplate.getTitle());
                    BulkDeployUtil.setTemplateVersion(templateSheet, mainTemplate.getVersion());
                    BulkDeployUtil.setTemplateUID(templateSheet, mainTemplate.getUid());
                    BulkDeployUtil.setTemplateTypeName(templateSheet, mainTemplate.getTemplateType().friendlyName());
                    this.getApplicationTemplateConfigContents(mainTemplate, list, templateSheet);
                    if (!ExcelUtils.isXmlFormat((ExcelFileObject)templateSheet)) continue;
                    templateSheet.lockSelectLockedCells(false);
                    templateSheet.lockSelectUnlockedCells(false);
                    templateSheet.lockFormatColumns(false);
                    templateSheet.lockFormatRows(false);
                    templateSheet.lockFormatCells(true);
                    templateSheet.lockInsertColumns(true);
                    templateSheet.lockInsertRows(true);
                    templateSheet.lockInsertHyperlinks(true);
                    templateSheet.lockDeleteColumns(true);
                    templateSheet.lockDeleteRows(true);
                    templateSheet.lockSort(true);
                    templateSheet.lockAutoFilter(true);
                    templateSheet.lockPivotTables(true);
                    templateSheet.lockObjects(true);
                    templateSheet.lockScenarios(true);
                    templateSheet.enableLocking();
                }
                if (encryptPassword != null && !useOldExcelFormat || hasSensitiveDataConfig) {
                    void var10_24;
                    void var9_16;
                    BulkDeployUtil.setKeepPrivateFlag(wb);
                    if (wb.getNumberOfSheets() < 1) {
                        Sheet sheet = wb.createSheet();
                    } else {
                        Sheet sheet = wb.getSheetAt(0);
                    }
                    Row row = var9_16.getRow(1);
                    if (row == null) {
                        Row row2 = var9_16.createRow(1);
                    }
                    BulkDeployUtil.generateCell((Row)var10_24, 0, lex.getText("templateSideBar.privacyNote"), this.styleVault.getInfoCellStyle());
                    BulkDeployUtil.generateCell((Row)var10_24, 1, lex.getText("templateSideBar.privacyMessage"), this.styleVault.getStringCellStyle());
                }
                if (encryptPassword == null) {
                    wb.write(exportStream);
                    break block36;
                }
                if (useOldExcelFormat) {
                    ExcelUtils.setCurrentUserPassword((String)encryptPassword.getValue());
                    wb.write(exportStream);
                    ExcelUtils.setCurrentUserPassword(null);
                    break block36;
                }
                ExcelFileSystem excelFileSystem = ExcelUtils.makeFileSystem();
                EncryptionInfo encryptionInfo = ExcelUtils.makeEncryptionInfo();
                Encryptor enc = encryptionInfo.getEncryptor();
                enc.confirmPassword(encryptPassword.getValue());
                try (OutputStream os = enc.getDataStream(excelFileSystem);){
                    wb.write(os);
                }
                excelFileSystem.writeFilesystem(exportStream);
            }
        }
    }

    private void setDefaultCellStyle(Sheet sheet) {
        if (ExcelUtils.isXmlFormat((ExcelFileObject)sheet)) {
            CTCol cTCol = sheet.addCTCol();
            cTCol.setMin(1L);
            cTCol.setMax(16384L);
            cTCol.setStyle((long)this.styleVault.getEmptyCellStyle().getIndex());
        }
    }

    private static boolean isModuleNotFoundException(Throwable e) {
        while (e != null) {
            if (e instanceof ModuleNotFoundException) {
                return true;
            }
            e = ThrowableUtil.getCause((Throwable)e);
        }
        return false;
    }

    private List<Property> getOrderedConfigSlots(BTemplateConfig templateConfig) {
        ArrayList<Property> list = new ArrayList<Property>();
        SlotCursor sc = templateConfig.getProperties();
        BConfigBinding[] configBindings = templateConfig.getConfigBindings();
        block0: for (Property p : sc) {
            for (BConfigBinding cb : configBindings) {
                if (!p.getName().equals(cb.getSourceSlot())) continue;
                list.add(p);
                continue block0;
            }
        }
        return list;
    }

    private void getTemplateConfigContents(BComponent templateBase, BTemplateConfig templateConfig, TemplateManifest manifest, HashSet<Tag> tags, Sheet templateSheet) {
        int excelInstanceInfoColumns;
        Slot[] inputSlots = templateConfig.getInputSlots();
        Slot[] outputSlots = templateConfig.getOutputSlots();
        ArrayList relations = templateConfig.getRelationInfos();
        List optionalComponents = manifest.optional.list();
        Row firstRow = templateSheet.createRow(0);
        Row secondRow = templateSheet.createRow(1);
        Row thirdRow = templateSheet.createRow(2);
        Row fourthRow = templateSheet.createRow(3);
        Row fifthRow = templateSheet.createRow(4);
        Row sixthRow = templateSheet.createRow(5);
        Row seventhRow = templateSheet.createRow(6);
        String description = manifest.description;
        String info = SlotPath.unescape((String)manifest.info);
        BulkDeployUtil.generateCell(firstRow, 0, lex.getText("templateSideBar.description"), this.styleVault.getInfoCellStyle());
        Cell labelCell = BulkDeployUtil.generateCell(firstRow, 1, description, this.styleVault.getStringCellStyle());
        if (info == null && !info.isEmpty()) {
            BulkDeployUtil.setCellComment(templateSheet, labelCell, info);
        }
        BulkDeployUtil.generateCell(thirdRow, 0, lex.getText("excel.label.templateTitle"), this.styleVault.getInfoCellStyle());
        BulkDeployUtil.generateCell(thirdRow, 1, manifest.title, this.styleVault.getStringCellStyle());
        BulkDeployUtil.generateCell(fourthRow, 0, lex.getText("excel.label.templateVersion"), this.styleVault.getInfoCellStyle());
        BulkDeployUtil.generateCell(fourthRow, 1, manifest.version, this.styleVault.getStringCellStyle());
        int uniqueDeviceColumn = 4;
        int columnFreezePane = 2;
        TemplateType templateType = manifest.isApplication ? TemplateType.APPLICATION : (templateBase instanceof BDevice ? TemplateType.DEVICE : TemplateType.COMPONENT);
        switch (templateType) {
            case APPLICATION: {
                excelInstanceInfoColumns = 2;
                break;
            }
            case DEVICE: {
                excelInstanceInfoColumns = 5;
                break;
            }
            default: {
                excelInstanceInfoColumns = 5;
            }
        }
        for (int i = 0; i < excelInstanceInfoColumns; ++i) {
            templateSheet.setDefaultColumnStyle(i, this.styleVault.getStringCellStyle());
        }
        if (templateType == TemplateType.APPLICATION) {
            excelInstanceInfoColumns = 2;
            labelCell = BulkDeployUtil.generateCell(seventhRow, 0, lex.getText("templateSideBar.rowName"), this.styleVault.getInstanceCellStyle());
            BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.rowNameHelp"));
            uniqueDeviceColumn = 1;
            columnFreezePane = 2;
        } else {
            if (templateType == TemplateType.DEVICE) {
                excelInstanceInfoColumns = 5;
                labelCell = BulkDeployUtil.generateCell(seventhRow, 0, lex.getText("templateSideBar.network"), this.styleVault.getInstanceCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.networkHelp"));
                labelCell = BulkDeployUtil.generateCell(seventhRow, 1, lex.getText("templateSideBar.device"), this.styleVault.getInstanceCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.deviceHelp"));
            } else {
                excelInstanceInfoColumns = 5;
                labelCell = BulkDeployUtil.generateCell(seventhRow, 0, lex.getText("templateSideBar.rootOrd"), this.styleVault.getInstanceCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.rootOrdHelp"));
                labelCell = BulkDeployUtil.generateCell(seventhRow, 1, lex.getText("templateSideBar.deployedName"), this.styleVault.getInstanceCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.deployedNameHelp"));
            }
            labelCell = BulkDeployUtil.generateCell(seventhRow, 2, lex.getText("templateSideBar.display"), this.styleVault.getOptionalCellStyle());
            BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.displayHelp"));
            labelCell = BulkDeployUtil.generateCell(seventhRow, 3, lex.getText("templateSideBar.position"), this.styleVault.getOptionalCellStyle());
            BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.positionHelp"));
        }
        labelCell = BulkDeployUtil.generateCell(seventhRow, uniqueDeviceColumn, lex.getText("templateSideBar.uniqueDevice"), this.styleVault.getOptionalCellStyle());
        BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.uniqueDeviceHelp"));
        BulkDeployUtil.setTemplateSheetInfoColumns(templateSheet, excelInstanceInfoColumns);
        int configColumnOffset = excelInstanceInfoColumns;
        try {
            Cell propertyCell;
            BString slotPathScope;
            BString bindHints;
            BString userTip;
            boolean includeTags;
            int i;
            if (inputSlots.length > 0) {
                BulkDeployUtil.generateCell(firstRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getInputCellStyle());
                labelCell = BulkDeployUtil.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.slotName"), this.styleVault.getInputCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.slotNameInHelp"));
                BulkDeployUtil.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.label"), this.styleVault.getInputCellStyle());
                labelCell = BulkDeployUtil.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.bindHints"), this.styleVault.getInputCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.bindHintsHelp"));
                labelCell = BulkDeployUtil.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.targetSlotHints"), this.styleVault.getInputCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.targetSlotHintsHelp"));
                labelCell = BulkDeployUtil.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.slotPathScope"), this.styleVault.getInputCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.slotPathScopeHelp", new Object[]{"third"}));
                labelCell = BulkDeployUtil.generateCell(seventhRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getInputCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                CellRangeAddress inputRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)(++configColumnOffset), (int)(configColumnOffset + inputSlots.length * 3 - 1));
                templateSheet.addMergedRegion(inputRange);
                BulkDeployUtil.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.inputs"), this.styleVault.getInputCellStyle());
                for (i = 0; i < inputSlots.length * 3; ++i) {
                    templateSheet.setDefaultColumnStyle(configColumnOffset + i, this.styleVault.getStringCellStyle());
                }
                configColumnOffset += inputSlots.length * 3;
            }
            BulkDeployUtil.setInputsCount(templateSheet, inputSlots.length * 3);
            if (outputSlots.length > 0) {
                BulkDeployUtil.generateCell(firstRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getOutputCellStyle());
                labelCell = BulkDeployUtil.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.slotName"), this.styleVault.getOutputCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.slotNameOutHelp"));
                BulkDeployUtil.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.label"), this.styleVault.getOutputCellStyle());
                labelCell = BulkDeployUtil.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.bindHints"), this.styleVault.getOutputCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.bindHintsHelp"));
                labelCell = BulkDeployUtil.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.targetSlotHints"), this.styleVault.getOutputCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.targetSlotHintsHelp"));
                labelCell = BulkDeployUtil.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.slotPathScope"), this.styleVault.getOutputCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.slotPathScopeHelp", new Object[]{"third"}));
                labelCell = BulkDeployUtil.generateCell(seventhRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getOutputCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                CellRangeAddress outputRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)(++configColumnOffset), (int)(configColumnOffset + outputSlots.length * 3 - 1));
                templateSheet.addMergedRegion(outputRange);
                BulkDeployUtil.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.outputs"), this.styleVault.getOutputCellStyle());
                for (i = 0; i < outputSlots.length * 3; ++i) {
                    templateSheet.setDefaultColumnStyle(configColumnOffset + i, this.styleVault.getStringCellStyle());
                }
                configColumnOffset += outputSlots.length * 3;
            }
            BulkDeployUtil.setOutputsCount(templateSheet, outputSlots.length * 3);
            if (!relations.isEmpty()) {
                BulkDeployUtil.generateCell(firstRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getRelationCellStyle());
                labelCell = BulkDeployUtil.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.label"), this.styleVault.getRelationCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userTipHelp"));
                BulkDeployUtil.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.relationId"), this.styleVault.getRelationCellStyle());
                labelCell = BulkDeployUtil.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.relateHints"), this.styleVault.getRelationCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.relateHintsHelp"));
                BulkDeployUtil.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.direction"), this.styleVault.getRelationCellStyle());
                labelCell = BulkDeployUtil.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.slotPathScope"), this.styleVault.getRelationCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.slotPathScopeHelp", new Object[]{"second"}));
                labelCell = BulkDeployUtil.generateCell(seventhRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getRelationCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                ++configColumnOffset;
                if (relations.size() > 1) {
                    CellRangeAddress relationRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + relations.size() * 2 - 1));
                    templateSheet.addMergedRegion(relationRange);
                }
                BulkDeployUtil.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.relations"), this.styleVault.getRelationCellStyle());
                for (int i2 = 0; i2 < relations.size() * 2; ++i2) {
                    templateSheet.setDefaultColumnStyle(configColumnOffset + i2, this.styleVault.getStringCellStyle());
                }
                configColumnOffset += relations.size() * 2;
            }
            BulkDeployUtil.setRelationsCount(templateSheet, relations.size() * 2);
            ArrayList<BindingProperties> normalBindingList = new ArrayList<BindingProperties>();
            ArrayList<OptionalBindingProperties> optionalBindingList = new ArrayList<OptionalBindingProperties>();
            List<Property> configSlots = this.getOrderedConfigSlots(templateConfig);
            for (Property p : configSlots) {
                Optional configBindingOpt = templateConfig.getConfigBinding((Slot)p);
                if (!configBindingOpt.isPresent()) continue;
                BConfigBinding configBinding = (BConfigBinding)configBindingOpt.get();
                if (BulkDeployUtil.isOptionalConfiguration(configBinding, optionalComponents, templateBase)) {
                    OptionalBindingProperties optionalBindingProps = new OptionalBindingProperties(configBinding, optionalComponents, templateBase, templateConfig);
                    optionalBindingList.add(optionalBindingProps);
                    continue;
                }
                BindingProperties bindingProps = new BindingProperties(configBinding, templateConfig);
                normalBindingList.add(bindingProps);
            }
            int configBindingsColumnCount = BulkDeployUtil.getConfigPropertyCount(normalBindingList);
            if (configBindingsColumnCount > 0) {
                BulkDeployUtil.generateCell(firstRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getConfigCellStyle());
                BulkDeployUtil.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.slotName"), this.styleVault.getConfigCellStyle());
                BulkDeployUtil.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.label"), this.styleVault.getConfigCellStyle());
                BulkDeployUtil.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.slotType"), this.styleVault.getConfigCellStyle());
                BulkDeployUtil.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.defaultValue"), this.styleVault.getConfigCellStyle());
                BulkDeployUtil.generateCell(sixthRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getConfigCellStyle());
                labelCell = BulkDeployUtil.generateCell(seventhRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getConfigCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                ++configColumnOffset;
                if (configBindingsColumnCount > 1) {
                    CellRangeAddress configRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + configBindingsColumnCount - 1));
                    templateSheet.addMergedRegion(configRange);
                }
                BulkDeployUtil.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.configs"), this.styleVault.getConfigCellStyle());
                configColumnOffset += configBindingsColumnCount;
            }
            BulkDeployUtil.setConfigsCount(templateSheet, configBindingsColumnCount);
            int optionalColumnConfigCount = BulkDeployUtil.getConfigPropertyCount(optionalBindingList);
            if (!optionalComponents.isEmpty()) {
                BulkDeployUtil.generateCell(firstRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getOptionalConfigCellStyle());
                BulkDeployUtil.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.optionalSlot"), this.styleVault.getOptionalConfigCellStyle());
                BulkDeployUtil.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.optionalSlotType"), this.styleVault.getOptionalConfigCellStyle());
                BulkDeployUtil.generateCell(fourthRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getOptionalConfigCellStyle());
                BulkDeployUtil.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.installOptional"), this.styleVault.getOptionalConfigCellStyle());
                BulkDeployUtil.generateCell(sixthRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getOptionalConfigCellStyle());
                labelCell = BulkDeployUtil.generateCell(seventhRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getOptionalConfigCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                ++configColumnOffset;
                if (optionalComponents.size() > 1) {
                    CellRangeAddress optionalRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + optionalComponents.size() - 1));
                    templateSheet.addMergedRegion(optionalRange);
                }
                BulkDeployUtil.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.optional"), this.styleVault.getOptionalConfigCellStyle());
                configColumnOffset += optionalComponents.size();
                if (optionalColumnConfigCount > 0) {
                    BulkDeployUtil.generateCell(firstRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getOptionalConfigCellStyle());
                    BulkDeployUtil.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.slotName"), this.styleVault.getOptionalConfigCellStyle());
                    BulkDeployUtil.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.label"), this.styleVault.getOptionalConfigCellStyle());
                    BulkDeployUtil.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.slotType"), this.styleVault.getOptionalConfigCellStyle());
                    BulkDeployUtil.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.defaultValue"), this.styleVault.getOptionalConfigCellStyle());
                    BulkDeployUtil.generateCell(sixthRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getOptionalConfigCellStyle());
                    labelCell = BulkDeployUtil.generateCell(seventhRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getOptionalConfigCellStyle());
                    BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                    templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                    ++configColumnOffset;
                    for (BOrd optionalOrd : optionalComponents) {
                        String relativeSlotPath = DEFAULT_SLOT_PATH_SCOPE;
                        int configsForOptionalComponent = 0;
                        BComponent optionalComponent = optionalOrd.resolve((BObject)templateBase).get().asComponent();
                        for (OptionalBindingProperties optionalBindingProp : optionalBindingList) {
                            Optional<BComponent> parentComponent = BulkDeployUtil.getComponentForOptionalConfig(optionalBindingProp.configBinding, optionalComponents, templateBase);
                            if (!parentComponent.isPresent() || parentComponent.get() != optionalComponent) continue;
                            relativeSlotPath = optionalBindingProp.relativeSlotPath;
                            configsForOptionalComponent += optionalBindingProp.properties.size();
                        }
                        if (configsForOptionalComponent == 0) continue;
                        if (configsForOptionalComponent > 1) {
                            CellRangeAddress optionalComponentRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + configsForOptionalComponent - 1));
                            templateSheet.addMergedRegion(optionalComponentRange);
                        }
                        BulkDeployUtil.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.optionalConfigs", new Object[]{relativeSlotPath}), this.styleVault.getOptionalConfigCellStyle());
                        configColumnOffset += configsForOptionalComponent;
                    }
                }
            }
            BulkDeployUtil.setOptionalCount(templateSheet, optionalComponents.size());
            BulkDeployUtil.setOptionalConfigurationCount(templateSheet, optionalColumnConfigCount);
            int tagColumnCount = 0;
            boolean bl = includeTags = tags != null && !tags.isEmpty();
            if (includeTags) {
                BulkDeployUtil.generateCell(firstRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getTagCellStyle());
                BulkDeployUtil.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.tagId"), this.styleVault.getTagCellStyle());
                BulkDeployUtil.generateCell(thirdRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getTagCellStyle());
                BulkDeployUtil.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.slotType"), this.styleVault.getTagCellStyle());
                BulkDeployUtil.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.defaultValue"), this.styleVault.getTagCellStyle());
                BulkDeployUtil.generateCell(sixthRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getTagCellStyle());
                labelCell = BulkDeployUtil.generateCell(seventhRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getTagCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                ++configColumnOffset;
                if (tags.size() > 1) {
                    CellRangeAddress tagRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + tags.size() - 1));
                    templateSheet.addMergedRegion(tagRange);
                }
                BulkDeployUtil.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.tags"), this.styleVault.getTagCellStyle());
                for (int i3 = 0; i3 < tags.size(); ++i3) {
                    templateSheet.setDefaultColumnStyle(configColumnOffset + i3, this.styleVault.getStringCellStyle());
                }
                tagColumnCount += tags.size();
            }
            BulkDeployUtil.setTagCount(templateSheet, tagColumnCount);
            int propertyRowPosition = excelInstanceInfoColumns + (inputSlots.length > 0 ? 1 : 0);
            for (Slot input : inputSlots) {
                Tags inputTags = templateConfig.getInputSlotTags(input);
                userTip = BString.make((String)input.getName());
                bindHints = BString.DEFAULT;
                BString sourceSlotHint = BString.DEFAULT;
                slotPathScope = BString.DEFAULT;
                if (inputTags != null) {
                    userTip = inputTags.get(Id.newId((String)"n:userTip")).filter(biDataValue -> !biDataValue.toString().isEmpty()).orElse((BIDataValue)BString.make((String)input.getName()));
                    bindHints = (BIDataValue)inputTags.get(Id.newId((String)"n:bindHints")).orElse(BString.DEFAULT);
                    sourceSlotHint = (BIDataValue)inputTags.get(Id.newId((String)"n:targetSlotHint")).orElse(BString.make((String)DEFAULT_SOURCE_SLOT));
                    if (inputTags.contains(BTemplateManager.SLOT_PATH_SCOPE)) {
                        slotPathScope = (BIDataValue)inputTags.get(BTemplateManager.SLOT_PATH_SCOPE).orElse(BString.DEFAULT);
                    }
                }
                propertyCell = secondRow.createCell(propertyRowPosition);
                propertyCell.setCellValue(input.getName());
                propertyCell = thirdRow.createCell(propertyRowPosition);
                propertyCell.setCellValue(userTip.toString());
                propertyCell = fourthRow.createCell(propertyRowPosition);
                propertyCell.setCellValue(bindHints.toString());
                propertyCell = seventhRow.createCell(propertyRowPosition);
                propertyCell.setCellStyle(this.styleVault.stringCellStyle);
                propertyCell = fifthRow.createCell(++propertyRowPosition);
                propertyCell.setCellValue(sourceSlotHint.toString());
                propertyCell = seventhRow.createCell(propertyRowPosition);
                propertyCell.setCellStyle(this.styleVault.stringCellStyle);
                propertyCell = sixthRow.createCell(++propertyRowPosition);
                if (slotPathScope.equals(BString.DEFAULT)) {
                    templateSheet.setColumnWidth(propertyCell.getColumnIndex(), 765);
                } else {
                    propertyCell.setCellValue(slotPathScope.toString());
                }
                propertyCell = seventhRow.createCell(propertyRowPosition);
                propertyCell.setCellStyle(this.styleVault.stringCellStyle);
                ++propertyRowPosition;
            }
            propertyRowPosition += outputSlots.length > 0 ? 1 : 0;
            for (Slot output : outputSlots) {
                Tags outputTags = templateConfig.getOutputSlotTags(output);
                userTip = BString.make((String)output.getName());
                bindHints = BString.DEFAULT;
                BString targetSlotHint = BString.DEFAULT;
                slotPathScope = BString.DEFAULT;
                if (outputTags != null) {
                    userTip = outputTags.get(Id.newId((String)"n:userTip")).filter(biDataValue -> !biDataValue.toString().isEmpty()).orElse((BIDataValue)BString.make((String)output.getName()));
                    bindHints = (BIDataValue)outputTags.get(Id.newId((String)"n:bindHints")).orElse(BString.DEFAULT);
                    targetSlotHint = (BIDataValue)outputTags.get(Id.newId((String)"n:targetSlotHint")).orElse(BString.make((String)DEFAULT_TARGET_SLOT));
                    slotPathScope = (BIDataValue)outputTags.get(Id.newId((String)"n:slotPathScope")).orElse(BString.DEFAULT);
                    if (outputTags.contains(BTemplateManager.SLOT_PATH_SCOPE)) {
                        slotPathScope = (BIDataValue)outputTags.get(BTemplateManager.SLOT_PATH_SCOPE).orElse(BString.DEFAULT);
                    }
                }
                propertyCell = secondRow.createCell(propertyRowPosition);
                propertyCell.setCellValue(output.getName());
                propertyCell = thirdRow.createCell(propertyRowPosition);
                propertyCell.setCellValue(userTip.toString());
                propertyCell = fourthRow.createCell(propertyRowPosition);
                propertyCell.setCellValue(bindHints.toString());
                propertyCell = seventhRow.createCell(propertyRowPosition);
                propertyCell.setCellStyle(this.styleVault.stringCellStyle);
                propertyCell = fifthRow.createCell(++propertyRowPosition);
                propertyCell.setCellValue(targetSlotHint.toString());
                propertyCell = seventhRow.createCell(propertyRowPosition);
                propertyCell.setCellStyle(this.styleVault.stringCellStyle);
                propertyCell = sixthRow.createCell(++propertyRowPosition);
                if (slotPathScope.equals(BString.DEFAULT)) {
                    templateSheet.setColumnWidth(propertyCell.getColumnIndex(), 765);
                } else {
                    propertyCell.setCellValue(slotPathScope.toString());
                }
                propertyCell = seventhRow.createCell(propertyRowPosition);
                propertyCell.setCellStyle(this.styleVault.stringCellStyle);
                ++propertyRowPosition;
            }
            propertyRowPosition += relations.isEmpty() ? 0 : 1;
            for (BRelationInfo relation : relations) {
                Cell propertyCell2 = secondRow.createCell(propertyRowPosition);
                propertyCell2.setCellValue(relation.getUserTip());
                propertyCell2 = thirdRow.createCell(propertyRowPosition);
                propertyCell2.setCellValue(relation.getRelationId());
                propertyCell2 = fourthRow.createCell(propertyRowPosition);
                propertyCell2.setCellValue(relation.getRelateHints());
                propertyCell2 = fifthRow.createCell(propertyRowPosition);
                propertyCell2.setCellValue(relation.getInbound() ? lex.getText("templateRelationEditor.in") : lex.getText("templateRelationEditor.out"));
                propertyCell2 = seventhRow.createCell(propertyRowPosition);
                propertyCell2.setCellStyle(this.styleVault.stringCellStyle);
                propertyCell2 = sixthRow.createCell(++propertyRowPosition);
                if (relation.getSlotPathScope().isEmpty()) {
                    templateSheet.setColumnWidth(propertyCell2.getColumnIndex(), 765);
                } else {
                    propertyCell2.setCellValue(relation.getSlotPathScope());
                }
                propertyCell2 = seventhRow.createCell(propertyRowPosition);
                propertyCell2.setCellStyle(this.styleVault.stringCellStyle);
                ++propertyRowPosition;
            }
            if (configBindingsColumnCount > 0) {
                ++propertyRowPosition;
                for (BindingProperties normalBindingProps : normalBindingList) {
                    Row[] rows = new Row[]{secondRow, thirdRow, fourthRow, fifthRow, sixthRow};
                    propertyRowPosition += this.addConfigColumn(normalBindingProps, rows, propertyRowPosition);
                }
            }
            HashMap<String, Boolean> optionalHighlight = new HashMap<String, Boolean>();
            boolean lastHighlight = true;
            propertyRowPosition += !optionalComponents.isEmpty() ? 1 : 0;
            for (BOrd optionalOrd : optionalComponents) {
                String optionalSlot = BulkDeployUtil.getRelativeSlotPathForOptionalComponent(optionalOrd, templateBase);
                String optionalSlotType = optionalOrd.resolve((BObject)templateBase).get().getType().toString();
                lastHighlight = !lastHighlight;
                optionalHighlight.put(optionalSlot, lastHighlight);
                Cell propertyCell3 = secondRow.createCell(propertyRowPosition);
                propertyCell3.setCellValue(optionalSlot);
                this.setHighlightedCellStyle(lastHighlight, propertyCell3);
                propertyCell3 = thirdRow.createCell(propertyRowPosition);
                propertyCell3.setCellValue(optionalSlotType);
                this.setHighlightedCellStyle(lastHighlight, propertyCell3);
                propertyCell3 = fourthRow.createCell(propertyRowPosition);
                this.setHighlightedCellStyle(lastHighlight, propertyCell3);
                propertyCell3 = fifthRow.createCell(propertyRowPosition);
                propertyCell3.setCellValue(lex.getText("templateSideBar.true"));
                this.setHighlightedCellStyle(lastHighlight, propertyCell3);
                propertyCell3 = sixthRow.createCell(propertyRowPosition);
                propertyCell3.setCellStyle(this.styleVault.stringCellStyle);
                propertyCell3 = seventhRow.createCell(propertyRowPosition);
                propertyCell3.setCellStyle(this.styleVault.stringCellStyle);
                ++propertyRowPosition;
            }
            if (optionalColumnConfigCount > 0) {
                ++propertyRowPosition;
                for (OptionalBindingProperties optionalBindingProps : optionalBindingList) {
                    Row[] rows = new Row[]{secondRow, thirdRow, fourthRow, fifthRow, sixthRow};
                    int addedPositions = this.addConfigColumn(optionalBindingProps, rows, propertyRowPosition);
                    Optional<BComponent> parentComponent = BulkDeployUtil.getComponentForOptionalConfig(optionalBindingProps.configBinding, optionalComponents, templateBase);
                    if (parentComponent.isPresent()) {
                        boolean highlight = (Boolean)optionalHighlight.get(optionalBindingProps.relativeSlotPath);
                        for (int i4 = 0; i4 < addedPositions; ++i4) {
                            int thisRowPosition = propertyRowPosition + i4;
                            for (int n = 0; n < 4; ++n) {
                                Cell highlightCell = rows[n].getCell(thisRowPosition);
                                this.setHighlightedCellStyle(highlight, highlightCell);
                            }
                            templateSheet.setDefaultColumnStyle(configColumnOffset + i4, this.styleVault.getEmptyCellStyle());
                        }
                    }
                    propertyRowPosition += addedPositions;
                }
            }
            if (includeTags) {
                AtomicInteger lambdaInt = new AtomicInteger(propertyRowPosition += tags.isEmpty() ? 0 : 1);
                tags.forEach(tag -> {
                    Cell propertyCell = secondRow.createCell(lambdaInt.get());
                    propertyCell.setCellValue(tag.getId().getQName());
                    propertyCell = fourthRow.createCell(lambdaInt.get());
                    propertyCell.setCellValue(tag.getValue().getType().toString());
                    BulkDeployUtil.setCellComment(templateSheet, propertyCell, lex.getText("templateSideBar.slotTypeStringHelp"));
                    propertyCell = fifthRow.createCell(lambdaInt.get());
                    propertyCell.setCellValue(tag.getValue().toString(null));
                    propertyCell = sixthRow.createCell(lambdaInt.get());
                    propertyCell.setCellStyle(this.styleVault.stringCellStyle);
                    propertyCell = seventhRow.createCell(lambdaInt.get());
                    propertyCell.setCellStyle(this.styleVault.stringCellStyle);
                    lambdaInt.incrementAndGet();
                });
                propertyRowPosition = lambdaInt.get();
            }
            for (int i5 = 0; i5 < propertyRowPosition; ++i5) {
                templateSheet.autoSizeColumn(i5);
            }
            templateSheet.createFreezePane(columnFreezePane, 7);
        }
        catch (Exception e) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelExport.columnError"), e);
        }
    }

    private void getApplicationTemplateConfigContents(NiagaraTemplate mainTemplate, List<NiagaraTemplate> templates, Sheet templateSheet) {
        int i;
        Row firstRow = templateSheet.createRow(0);
        Row secondRow = templateSheet.createRow(1);
        Row thirdRow = templateSheet.createRow(2);
        Row fourthRow = templateSheet.createRow(3);
        Row fifthRow = templateSheet.createRow(4);
        Row sixthRow = templateSheet.createRow(5);
        Row[] headerRows = new Row[]{secondRow, thirdRow, fourthRow, fifthRow, sixthRow};
        ArrayList<Row> templateRows = new ArrayList<Row>();
        for (int i2 = 0; i2 < templates.size(); ++i2) {
            templateRows.add(templateSheet.createRow(i2 + 6));
        }
        String description = mainTemplate.getDescription();
        String info = mainTemplate.getInfo();
        BulkDeployUtil.generateCell(firstRow, 0, lex.getText("templateSideBar.description"), this.styleVault.getInfoCellStyle());
        Cell labelCell = BulkDeployUtil.generateCell(firstRow, 1, description, this.styleVault.getStringCellStyle());
        if (!info.isEmpty()) {
            BulkDeployUtil.setCellComment(templateSheet, labelCell, info);
        }
        for (int i3 = 0; i3 < 2; ++i3) {
            templateSheet.setDefaultColumnStyle(i3, this.styleVault.getStringCellStyle());
        }
        BulkDeployUtil.generateCell(thirdRow, 0, lex.getText("excel.label.templateTitle"), this.styleVault.getInfoCellStyle());
        BulkDeployUtil.generateCell(thirdRow, 1, mainTemplate.getTitle(), this.styleVault.getStringCellStyle());
        BulkDeployUtil.generateCell(fourthRow, 0, lex.getText("excel.label.templateVersion"), this.styleVault.getInfoCellStyle());
        BulkDeployUtil.generateCell(fourthRow, 1, mainTemplate.getVersion(), this.styleVault.getStringCellStyle());
        labelCell = BulkDeployUtil.generateCell(sixthRow, 0, lex.getText("templateSideBar.rowName"), this.styleVault.getInstanceCellStyle());
        BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.rowNameHelp"));
        int uniqueDeviceColumn = 1;
        int columnFreezePane = 2;
        for (i = 0; i < templates.size(); ++i) {
            NiagaraTemplate template = templates.get(i);
            Cell nameCell = ((Row)templateRows.get(i)).createCell(0);
            nameCell.setCellValue(template.getBaseName() + '-' + template.getTitle() + '-' + template.getVersion());
            nameCell.setCellStyle(this.styleVault.getStringCellStyle());
        }
        labelCell = BulkDeployUtil.generateCell(sixthRow, uniqueDeviceColumn, lex.getText("templateSideBar.uniqueDevice"), this.styleVault.getOptionalCellStyle());
        BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.uniqueDeviceHelp"));
        for (i = 0; i < templates.size(); ++i) {
            Cell uniqueIdCell = ((Row)templateRows.get(i)).createCell(1);
            uniqueIdCell.setCellValue(templates.get(i).getBaseName());
        }
        BulkDeployUtil.setTemplateSheetInfoColumns(templateSheet, 2);
        int configColumnOffset = 2;
        BulkDeployUtil.setInputsCount(templateSheet, 0);
        BulkDeployUtil.setOutputsCount(templateSheet, 0);
        BulkDeployUtil.setRelationsCount(templateSheet, 0);
        int configBindingsColumnCount = mainTemplate.requiredPropertyElements().size();
        if (configBindingsColumnCount > 0) {
            BulkDeployUtil.generateCell(firstRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getConfigCellStyle());
            BulkDeployUtil.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.slotName"), this.styleVault.getConfigCellStyle());
            BulkDeployUtil.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.label"), this.styleVault.getConfigCellStyle());
            BulkDeployUtil.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.slotType"), this.styleVault.getConfigCellStyle());
            BulkDeployUtil.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.defaultValue"), this.styleVault.getConfigCellStyle());
            labelCell = BulkDeployUtil.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getConfigCellStyle());
            BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
            templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
            ++configColumnOffset;
            if (configBindingsColumnCount > 1) {
                CellRangeAddress configRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + configBindingsColumnCount - 1));
                templateSheet.addMergedRegion(configRange);
            }
            BulkDeployUtil.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.configs"), this.styleVault.getConfigCellStyle());
            configColumnOffset += configBindingsColumnCount;
        }
        BulkDeployUtil.setConfigsCount(templateSheet, configBindingsColumnCount);
        int optionalColumnConfigCount = 0;
        List optionalComponents = mainTemplate.optionalComponents();
        for (OptionalComponent optionalComponent : optionalComponents) {
            optionalColumnConfigCount += optionalComponent.propertyElements().size();
        }
        if (!optionalComponents.isEmpty()) {
            BulkDeployUtil.generateCell(firstRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getOptionalConfigCellStyle());
            BulkDeployUtil.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.optionalSlot"), this.styleVault.getOptionalConfigCellStyle());
            BulkDeployUtil.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.optionalSlotType"), this.styleVault.getOptionalConfigCellStyle());
            BulkDeployUtil.generateCell(fourthRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getOptionalConfigCellStyle());
            BulkDeployUtil.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.installOptional"), this.styleVault.getOptionalConfigCellStyle());
            labelCell = BulkDeployUtil.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getOptionalConfigCellStyle());
            BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
            templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
            ++configColumnOffset;
            if (optionalComponents.size() > 1) {
                CellRangeAddress optionalRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + optionalComponents.size() - 1));
                templateSheet.addMergedRegion(optionalRange);
            }
            BulkDeployUtil.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.optional"), this.styleVault.getOptionalConfigCellStyle());
            configColumnOffset += optionalComponents.size();
            if (optionalColumnConfigCount > 0) {
                BulkDeployUtil.generateCell(firstRow, configColumnOffset, DEFAULT_SLOT_PATH_SCOPE, this.styleVault.getOptionalConfigCellStyle());
                BulkDeployUtil.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.slotName"), this.styleVault.getOptionalConfigCellStyle());
                BulkDeployUtil.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.label"), this.styleVault.getOptionalConfigCellStyle());
                BulkDeployUtil.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.slotType"), this.styleVault.getOptionalConfigCellStyle());
                BulkDeployUtil.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.defaultValue"), this.styleVault.getOptionalConfigCellStyle());
                labelCell = BulkDeployUtil.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getOptionalConfigCellStyle());
                BulkDeployUtil.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                ++configColumnOffset;
                for (OptionalComponent optionalComponent : optionalComponents) {
                    if (optionalComponent.propertyElements().isEmpty()) continue;
                    if (optionalComponent.propertyElements().size() > 1) {
                        CellRangeAddress optionalComponentRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + optionalComponent.propertyElements().size() - 1));
                        templateSheet.addMergedRegion(optionalComponentRange);
                    }
                    BulkDeployUtil.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.optionalConfigs", new Object[]{BulkDeployUtil.getOptionalComponentSlot(optionalComponent.getPath())}), this.styleVault.getOptionalConfigCellStyle());
                    configColumnOffset += optionalComponent.propertyElements().size();
                }
            }
        }
        BulkDeployUtil.setOptionalCount(templateSheet, optionalComponents.size());
        BulkDeployUtil.setOptionalConfigurationCount(templateSheet, optionalColumnConfigCount);
        BulkDeployUtil.setTagCount(templateSheet, 0);
        int propertyRowPosition = 2;
        if (configBindingsColumnCount > 0) {
            ++propertyRowPosition;
            propertyRowPosition = this.setValuesForElements(mainTemplate.requiredPropertyElements(), templates, headerRows, templateRows, propertyRowPosition, false);
        }
        propertyRowPosition += optionalComponents.isEmpty() ? 0 : 1;
        boolean highlight = true;
        for (OptionalComponent optionalComponent : optionalComponents) {
            String optionalPath = optionalComponent.getPath();
            String optionalSlot = BulkDeployUtil.getOptionalComponentSlot(optionalPath);
            String optionalSlotType = optionalComponent.getNType();
            Cell propertyCell = secondRow.createCell(propertyRowPosition);
            propertyCell.setCellValue(optionalSlot);
            this.setHighlightedCellStyle(highlight, propertyCell);
            propertyCell = thirdRow.createCell(propertyRowPosition);
            propertyCell.setCellValue(optionalSlotType);
            this.setHighlightedCellStyle(highlight, propertyCell);
            propertyCell = fourthRow.createCell(propertyRowPosition);
            this.setHighlightedCellStyle(highlight, propertyCell);
            propertyCell = fifthRow.createCell(propertyRowPosition);
            propertyCell.setCellValue(lex.getText("templateSideBar.true"));
            this.setHighlightedCellStyle(highlight, propertyCell);
            propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
            propertyCell = sixthRow.createCell(propertyRowPosition);
            propertyCell.setCellStyle(this.styleVault.stringCellStyle);
            for (int templateIdx = 0; templateIdx < templates.size(); ++templateIdx) {
                if (templates.get(templateIdx).hasComponent(optionalComponent.getPath())) continue;
                propertyCell = ((Row)templateRows.get(templateIdx)).createCell(propertyRowPosition);
                propertyCell.setCellValue(lex.getText("templateSideBar.false"));
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
            }
            ++propertyRowPosition;
            highlight = !highlight;
        }
        if (optionalColumnConfigCount > 0) {
            ++propertyRowPosition;
            highlight = true;
            for (OptionalComponent optionalComponent : optionalComponents) {
                propertyRowPosition = this.setValuesForElements(optionalComponent.propertyElements(), templates, headerRows, templateRows, propertyRowPosition, highlight);
                highlight = !highlight;
            }
        }
        for (int i4 = 0; i4 < propertyRowPosition; ++i4) {
            templateSheet.autoSizeColumn(i4);
        }
        templateSheet.createFreezePane(columnFreezePane, 6);
    }

    private int setValuesForElements(List<TemplateElement> mainElements, List<NiagaraTemplate> templates, Row[] headerRows, List<Row> templateRows, int startingColumnNumber, boolean highlight) {
        int columnNumber = startingColumnNumber;
        for (TemplateElement mainElement : mainElements) {
            ArrayList<TemplateElement> elementsInColumn = new ArrayList<TemplateElement>();
            for (NiagaraTemplate template : templates) {
                TemplateElement secondaryElement;
                TemplateProperty secondaryProperty = template.getProperty(mainElement.property().getName());
                TemplateElement templateElement = secondaryElement = secondaryProperty == null ? null : secondaryProperty.getElement(mainElement.getName());
                if (secondaryElement == null || secondaryElement.presentValue().isMissing() || secondaryElement.presentValue().isEqualValue(mainElement.defaultValue())) {
                    elementsInColumn.add(null);
                    continue;
                }
                elementsInColumn.add(secondaryElement);
            }
            this.setCellValueAndFormatColumn(headerRows, templateRows, mainElement, elementsInColumn, columnNumber);
            for (int n = 0; n < 3; ++n) {
                Cell highlightCell = headerRows[n].getCell(columnNumber);
                this.setHighlightedCellStyle(highlight, highlightCell);
            }
            ++columnNumber;
        }
        return columnNumber;
    }

    private void setHighlightedCellStyle(boolean isHighlighted, Cell cell) {
        if (isHighlighted) {
            cell.setCellStyle(this.styleVault.getHighlightCellStyle());
        }
    }

    private static String getOptionalComponentSlot(String optionalComponentPath) {
        if (optionalComponentPath.startsWith("Drivers/")) {
            return optionalComponentPath.substring("Drivers/".length());
        }
        return optionalComponentPath;
    }

    private int addConfigColumn(BindingProperties configBindingProps, Row[] rows, int propertyRowPosition) throws IOException {
        String userTip = configBindingProps.configBinding.getUserTip();
        for (BindingProperty entry : configBindingProps.properties) {
            this.setCellValueAndFormatColumn(rows, entry.property, entry.value, propertyRowPosition, entry.name, userTip);
            ++propertyRowPosition;
        }
        return configBindingProps.properties.size();
    }

    private static String getRelativeSlotPathForOptionalComponent(BOrd optionalOrd, BComponent templateBase) {
        BComponent optionalComponent = optionalOrd.resolve((BObject)templateBase).get().asComponent();
        return BulkDeployUtil.getRelativeSlotPathForOptionalComponent(optionalComponent, templateBase);
    }

    private static String getRelativeSlotPathForOptionalComponent(BComponent optionalComponent, BComponent templateBase) {
        BDriverContainer[] containers = (BDriverContainer[])CompUtil.getDescendants((BComponent)templateBase, BDriverContainer.class);
        Optional relativeSlotPath = CompUtil.slotPathFromAncestor((BComplex)containers[0], (BComplex)optionalComponent);
        return relativeSlotPath.isPresent() ? ((SlotPath)relativeSlotPath.get()).toDisplayString() : optionalComponent.getSlotPathOrd().toString();
    }

    private static Optional<BComponent> getComponentForOptionalConfig(BConfigBinding configBinding, List<BOrd> optionalComponents, BComponent templateBase) {
        BObject configTargetObject = configBinding.getTargetOrd().resolve((BObject)templateBase).get();
        for (BOrd optionalOrd : optionalComponents) {
            BComplex parentObject;
            Optional slotPath;
            Optional slotPath2;
            BComponent optionalComponent = optionalOrd.resolve((BObject)templateBase).get().asComponent();
            if (!(configTargetObject instanceof BComplex ? (slotPath2 = CompUtil.slotPathFromAncestor((BComplex)optionalComponent, (BComplex)((BComplex)configTargetObject))).isPresent() : (slotPath = CompUtil.slotPathFromAncestor((BComplex)optionalComponent, (BComplex)(parentObject = configBinding.getTargetOrd().resolve((BObject)templateBase).getParent()))).isPresent())) continue;
            return Optional.of(optionalComponent);
        }
        return Optional.empty();
    }

    private static boolean isOptionalConfiguration(BConfigBinding configBinding, List<BOrd> optionalComponents, BComponent templateBase) {
        BObject configTargetObject = configBinding.getTargetOrd().resolve((BObject)templateBase).get();
        for (BOrd optionalOrd : optionalComponents) {
            BComplex parentObject;
            Optional slotPath;
            Optional slotPath2;
            BComponent optionalComponent = optionalOrd.resolve((BObject)templateBase).get().asComponent();
            if (!(configTargetObject instanceof BComplex ? (slotPath2 = CompUtil.slotPathFromAncestor((BComplex)optionalComponent, (BComplex)((BComplex)configTargetObject))).isPresent() : (slotPath = CompUtil.slotPathFromAncestor((BComplex)optionalComponent, (BComplex)(parentObject = configBinding.getTargetOrd().resolve((BObject)templateBase).getParent()))).isPresent())) continue;
            return true;
        }
        return false;
    }

    private static int getConfigPropertyCount(List<? extends BindingProperties> bindingList) {
        int propertyCount = 0;
        for (BindingProperties bindingProperties : bindingList) {
            propertyCount += bindingProperties.properties.size();
        }
        return propertyCount;
    }

    public static BHistoryExt[] unconfigurableHistoryExtensions(BComponent templateBase) {
        BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)templateBase);
        return BulkDeployUtil.unconfigurableHistoryExtensions(templateBase, templateConfig);
    }

    private static BHistoryExt[] unconfigurableHistoryExtensions(BComponent templateBase, BTemplateConfig templateConfig) {
        BConfigBinding[] configBindings;
        BHistoryExt[] allHistoryExtensions = (BHistoryExt[])CompUtil.getDescendants((BComponent)templateBase, BHistoryExt.class);
        HashSet<BHistoryExt> unconfigurableHistoryExtensions = null;
        for (BConfigBinding configBinding : configBindings = (BConfigBinding[])templateConfig.getChildren(BConfigBinding.class)) {
            BObject target;
            if (!Objects.equals(configBinding.getTargetSlot(), BHistoryExt.enabled.getName()) || !((target = configBinding.getTargetOrd().resolve((BObject)templateConfig).get()) instanceof BHistoryExt)) continue;
            BHistoryExt targetHistoryExt = (BHistoryExt)target;
            if (unconfigurableHistoryExtensions == null) {
                unconfigurableHistoryExtensions = new HashSet<BHistoryExt>(Arrays.asList(allHistoryExtensions));
            }
            unconfigurableHistoryExtensions.remove(targetHistoryExt);
        }
        if (unconfigurableHistoryExtensions == null) {
            return allHistoryExtensions;
        }
        return unconfigurableHistoryExtensions.toArray(HISTORY_EXTS);
    }

    private static Cell generateCell(Row row, int column, String value, CellStyle style) {
        Cell newCell = row.createCell(column);
        if (value.isEmpty()) {
            newCell.setBlank();
        } else {
            newCell.setCellValue(value);
        }
        if (style != null) {
            newCell.setCellStyle(style);
        }
        return newCell;
    }

    private void setCellValueAndFormatColumn(Row[] rows, Property configProperty, BValue configPropertyValue, int propertyRowPosition, String slotName, String userTip) throws IOException {
        Sheet sheet = rows[0].getSheet();
        Cell propertyCell = rows[0].createCell(propertyRowPosition);
        String cellValue = SlotPath.unescape((String)slotName);
        propertyCell.setCellValue(cellValue);
        propertyCell = rows[1].createCell(propertyRowPosition);
        propertyCell.setCellValue(userTip);
        Cell slotTypeCell = rows[2].createCell(propertyRowPosition);
        slotTypeCell.setCellValue(configProperty.getType().toString());
        if (configProperty.getType().is(BStatusValue.TYPE)) {
            if (configProperty.getType().is(BStatusNumeric.TYPE)) {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getDataCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellValue(((BStatusNumeric)configPropertyValue).getValue());
                propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                BulkDeployUtil.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeNumberHelp"));
            } else if (configProperty.getType().is(BStatusBoolean.TYPE)) {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellValue(((BStatusValue)configPropertyValue).valueToString(null));
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                BulkDeployUtil.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeBooleanHelp"));
            } else if (configProperty.getType().is(BStatusEnum.TYPE)) {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellValue(((BStatusValue)configPropertyValue).valueToString(null));
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                String commentText = BulkDeployUtil.getEnumCellComment(((BIEnum)configPropertyValue).getEnum());
                BulkDeployUtil.setCellComment(sheet, slotTypeCell, commentText);
            } else {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellValue(((BStatusValue)configPropertyValue).valueToString(null));
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                BulkDeployUtil.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeStringHelp"));
            }
        } else if (configProperty.getType().is(BSimple.TYPE)) {
            if (configProperty.getType().is(BNumber.TYPE)) {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getDataCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellValue(((BNumber)configPropertyValue).getDouble());
                propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                if (configProperty.getType().is(BInteger.TYPE) || configProperty.getType().is(BLong.TYPE)) {
                    BulkDeployUtil.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeIntHelp"));
                } else {
                    BulkDeployUtil.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeNumberHelp"));
                }
            } else if (configProperty.getType().is(BBoolean.TYPE)) {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellValue(((BIEncodable)configPropertyValue).encodeToString());
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                BulkDeployUtil.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeBooleanHelp"));
            } else if (configProperty.getType().is(BEnum.TYPE)) {
                if (configProperty.getType().is(BDynamicEnum.TYPE)) {
                    sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getDataCellStyle());
                    propertyCell = rows[3].createCell(propertyRowPosition);
                    propertyCell.setCellValue(((BEnum)configPropertyValue).getTag());
                    propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                } else {
                    sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                    propertyCell = rows[3].createCell(propertyRowPosition);
                    propertyCell.setCellValue(((BIEncodable)configPropertyValue).encodeToString());
                    propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                }
                String commentText = BulkDeployUtil.getEnumCellComment((BEnum)configPropertyValue);
                BulkDeployUtil.setCellComment(sheet, slotTypeCell, commentText);
            } else if (configProperty.getType().is(BPassword.TYPE)) {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getPasswordCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellStyle(this.styleVault.getPasswordCellStyle());
                BulkDeployUtil.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeStringHelp"));
            } else {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellValue(((BIEncodable)configPropertyValue).encodeToString());
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                BulkDeployUtil.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeStringHelp"));
            }
        } else {
            sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
            propertyCell = rows[3].createCell(propertyRowPosition);
            propertyCell.setCellValue(configPropertyValue.toString());
            propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
            BulkDeployUtil.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeStringHelp"));
        }
        propertyCell = rows[4].createCell(propertyRowPosition);
        propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
    }

    private void setCellValueAndFormatColumn(Row[] rows, List<Row> templateRows, TemplateElement mainElement, List<TemplateElement> elementsInColumn, int columnNumber) {
        Sheet sheet = rows[0].getSheet();
        Cell propertyCell = rows[0].createCell(columnNumber);
        String cellValue = SlotPath.unescape((String)mainElement.getFullName());
        propertyCell.setCellValue(cellValue);
        propertyCell = rows[1].createCell(columnNumber);
        propertyCell.setCellValue(mainElement.property().getUserTip());
        Cell slotTypeCell = rows[2].createCell(columnNumber);
        TemplateValue presentValue = mainElement.presentValue();
        TemplateValue defaultValue = mainElement.defaultValue();
        slotTypeCell.setCellValue(presentValue.getNType());
        switch (presentValue.getType()) {
            case NUMERIC: {
                sheet.setDefaultColumnStyle(columnNumber, this.styleVault.getDataCellStyle());
                propertyCell = rows[3].createCell(columnNumber);
                if (!defaultValue.isMissing()) {
                    propertyCell.setCellValue(defaultValue.getNumericValue());
                }
                propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                BulkDeployUtil.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeNumberHelp"));
                for (int i = 0; i < templateRows.size(); ++i) {
                    if (elementsInColumn.get(i) == null) continue;
                    propertyCell = templateRows.get(i).createCell(columnNumber);
                    propertyCell.setCellValue(elementsInColumn.get(i).presentValue().getNumericValue());
                    propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                }
                break;
            }
            case INTEGER: {
                sheet.setDefaultColumnStyle(columnNumber, this.styleVault.getDataCellStyle());
                propertyCell = rows[3].createCell(columnNumber);
                if (!defaultValue.isMissing()) {
                    propertyCell.setCellValue(defaultValue.getNumericValue());
                }
                propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                BulkDeployUtil.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeIntHelp"));
                for (int i = 0; i < templateRows.size(); ++i) {
                    if (elementsInColumn.get(i) == null) continue;
                    propertyCell = templateRows.get(i).createCell(columnNumber);
                    propertyCell.setCellValue(elementsInColumn.get(i).presentValue().getNumericValue());
                    propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                }
                break;
            }
            case BOOLEAN: {
                sheet.setDefaultColumnStyle(columnNumber, this.styleVault.getStringCellStyle());
                propertyCell = rows[3].createCell(columnNumber);
                if (!defaultValue.isMissing()) {
                    propertyCell.setCellValue(BBoolean.toString((boolean)defaultValue.getBooleanValue(), null));
                }
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                BulkDeployUtil.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeBooleanHelp"));
                for (int i = 0; i < templateRows.size(); ++i) {
                    if (elementsInColumn.get(i) == null) continue;
                    propertyCell = templateRows.get(i).createCell(columnNumber);
                    propertyCell.setCellValue(BBoolean.toString((boolean)elementsInColumn.get(i).presentValue().getBooleanValue(), null));
                    propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                }
                break;
            }
            case ENUM: {
                Map enumValues = presentValue.getDefinedEnumValues();
                if (enumValues.isEmpty()) {
                    sheet.setDefaultColumnStyle(columnNumber, this.styleVault.getDataCellStyle());
                } else {
                    sheet.setDefaultColumnStyle(columnNumber, this.styleVault.getStringCellStyle());
                }
                propertyCell = rows[3].createCell(columnNumber);
                if (!defaultValue.isMissing()) {
                    int enumValue = (int)defaultValue.getIntegerValue();
                    if (enumValues.containsKey(enumValue)) {
                        propertyCell.setCellValue((String)enumValues.get(enumValue));
                    } else {
                        propertyCell.setCellValue((double)enumValue);
                    }
                }
                if (enumValues.isEmpty()) {
                    propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                } else {
                    propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                }
                String commentText = BulkDeployUtil.getEnumCellComment(enumValues);
                BulkDeployUtil.setCellComment(sheet, slotTypeCell, commentText);
                for (int i = 0; i < templateRows.size(); ++i) {
                    if (elementsInColumn.get(i) == null) continue;
                    propertyCell = templateRows.get(i).createCell(columnNumber);
                    int enumValue = (int)elementsInColumn.get(i).presentValue().getIntegerValue();
                    if (enumValues.containsKey(enumValue)) {
                        propertyCell.setCellValue((String)enumValues.get(enumValue));
                    } else {
                        propertyCell.setCellValue((double)enumValue);
                    }
                    if (enumValues.isEmpty()) {
                        propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                        continue;
                    }
                    propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                }
                break;
            }
            case PASSWORD: {
                sheet.setDefaultColumnStyle(columnNumber, this.styleVault.getPasswordCellStyle());
                propertyCell = rows[3].createCell(columnNumber);
                propertyCell.setCellStyle(this.styleVault.getPasswordCellStyle());
                BulkDeployUtil.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeStringHelp"));
                break;
            }
            default: {
                sheet.setDefaultColumnStyle(columnNumber, this.styleVault.getStringCellStyle());
                propertyCell = rows[3].createCell(columnNumber);
                if (!defaultValue.isMissing()) {
                    propertyCell.setCellValue(defaultValue.getStringValue());
                }
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                BulkDeployUtil.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeStringHelp"));
                for (int i = 0; i < templateRows.size(); ++i) {
                    if (elementsInColumn.get(i) == null) continue;
                    propertyCell = templateRows.get(i).createCell(columnNumber);
                    propertyCell.setCellValue(elementsInColumn.get(i).presentValue().getStringValue());
                    propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                }
            }
        }
        propertyCell = rows[4].createCell(columnNumber);
        propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
    }

    private static String getEnumCellComment(BEnum tags) {
        BEnumRange range = tags.getRange();
        if (range.isNull()) {
            return lex.getText("templateSideBar.slotTypeEnumEmptyHelp");
        }
        StringBuilder sb = new StringBuilder(lex.getText("templateSideBar.slotTypeEnumHelp")).append('\n');
        int currentLineLength = 0;
        boolean first = true;
        for (int i : range.getOrdinals()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            if (currentLineLength > 60) {
                sb.append('\n');
                currentLineLength = 0;
            }
            String tag = range.getTag(i);
            sb.append(tag);
            currentLineLength += tag.length() + 2;
        }
        return sb.toString();
    }

    private static String getEnumCellComment(Map<Integer, String> enumValues) {
        if (enumValues.isEmpty()) {
            return lex.getText("templateSideBar.slotTypeEnumEmptyHelp");
        }
        StringBuilder sb = new StringBuilder(lex.getText("templateSideBar.slotTypeEnumHelp")).append('\n');
        int currentLineLength = 0;
        boolean first = true;
        for (String enumValue : enumValues.values()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            if (currentLineLength > 60) {
                sb.append('\n');
                currentLineLength = 0;
            }
            sb.append(enumValue);
            currentLineLength += enumValue.length() + 2;
        }
        return sb.toString();
    }

    private static void setCellComment(Sheet sheet, Cell cell, String text) {
        CreationHelper factory = sheet.getWorkbook().getCreationHelper();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex());
        anchor.setCol2(cell.getColumnIndex() + 5);
        anchor.setRow1(cell.getRow().getRowNum());
        anchor.setRow2(cell.getRow().getRowNum() + 5);
        Drawing drawing = sheet.createDrawingPatriarch();
        Comment comment = drawing.createCellComment(anchor);
        comment.setAuthor("Niagara Template Exporter");
        RichTextString rts = factory.createRichTextString(text);
        comment.setString(rts);
        cell.setCellComment(comment);
    }

    public static Map<String, String> getTemplateTitlesFromExcel(BulkDeployWorkbook workbook) {
        List<DeployedWorksheet> deployedWorksheets = BulkDeployUtil.loadDeployedWorksheets(workbook);
        HashMap<String, String> templateTitles = new HashMap<String, String>();
        if (deployedWorksheets == null || deployedWorksheets.isEmpty()) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.importFileError", new Object[]{workbook.getName()}));
        }
        for (DeployedWorksheet deployedWorksheet : deployedWorksheets) {
            for (DeployedRoot deployedRoot : deployedWorksheet.deployedRoots) {
                templateTitles.put(deployedWorksheet.title, deployedRoot.deployName);
            }
        }
        return templateTitles;
    }

    public void deployTemplatesFromExcel(BulkDeployWorkbook bulkDeployWorkbook, BComponent root, TemplateDeployWorker worker) {
        List<DeployedWorksheet> deployedWorksheets = BulkDeployUtil.loadDeployedWorksheets(bulkDeployWorkbook);
        if (deployedWorksheets == null || deployedWorksheets.isEmpty()) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.importFileError", new Object[]{bulkDeployWorkbook.getName()}));
            return;
        }
        int templateInstanceCount = deployedWorksheets.stream().mapToInt(deployedWorksheet -> deployedWorksheet.deployedRoots.size()).sum();
        int processedInstances = 0;
        int totalProgress = 0;
        HashMap<BComponent, BNameMap> displayNames = new HashMap<BComponent, BNameMap>();
        for (DeployedWorksheet deployedWorksheet2 : deployedWorksheets) {
            for (DeployedRoot deployedRoot : deployedWorksheet2.deployedRoots) {
                int currentProgress;
                BComponent deployedRootComponent;
                if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                    log.log(IMPORT_LOG_LEVEL, "Copying type " + deployedWorksheet2.templateType + " template " + deployedWorksheet2.title + " version " + deployedWorksheet2.version + " parent component " + deployedRoot.parentComponentSlotPath + " to target component" + deployedRoot.deployName);
                }
                switch (deployedWorksheet2.templateType) {
                    case "Application": {
                        deployedRootComponent = root;
                        break;
                    }
                    default: {
                        deployedRootComponent = this.resolveDeployComponent(deployedRoot, root);
                    }
                }
                if (deployedRootComponent == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.rootNotResolvedError", new Object[]{deployedRoot.deployName, deployedWorksheet2.title}));
                    continue;
                }
                deployedRootComponent.lease();
                BINavNode templateObject = deployedRootComponent.getNavChild(deployedRoot.deployName);
                if (templateObject != null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.templateComponentExistsError", new Object[]{deployedRoot.deployName, deployedRootComponent.getNavName()}));
                    continue;
                }
                BNtplFile ntplFile = this.copyTemplateToStation(deployedWorksheet2, deployedRootComponent);
                if (ntplFile == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.templateFileCopyError", new Object[]{deployedWorksheet2.title}));
                    continue;
                }
                HashMap<String, BFormat> componentDisplayNames = new HashMap<String, BFormat>();
                BComponent deployedTemplateComponent = BulkDeployUtil.installTemplateToStation(deployedWorksheet2, deployedRoot, deployedRootComponent, ntplFile, componentDisplayNames);
                if (deployedTemplateComponent == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.templateNotResolvedError", new Object[]{deployedRoot.parentComponentSlotPath, deployedWorksheet2.title}));
                    continue;
                }
                deployedRoot.deployedTemplate = deployedTemplateComponent;
                if (!componentDisplayNames.isEmpty()) {
                    BNameMap nameMap = BNameMap.make(componentDisplayNames);
                    if (displayNames.containsKey(deployedRootComponent)) {
                        BNameMap mergedNameMap = BNameMap.make((BNameMap)((BNameMap)displayNames.get(deployedRootComponent)), (BNameMap)nameMap);
                        displayNames.put(deployedRootComponent, mergedNameMap);
                    } else {
                        displayNames.put(deployedRootComponent, nameMap);
                    }
                }
                if (worker == null) continue;
                if ((currentProgress = (int)((double)(++processedInstances) * 70.0 / (double)templateInstanceCount)) > totalProgress) {
                    totalProgress = currentProgress;
                    String progressMessage = lex.getText("bulkDeploy.progress.update.deploy", new Object[]{deployedWorksheet2.title, deployedRoot.deployName});
                    worker.updateProgress(totalProgress, progressMessage);
                }
                if (worker.isRunning()) continue;
                if (worker.isCanceled()) {
                    log.log(Level.INFO, lex.getText("bulkDeploy.progress.cancel", new Object[]{bulkDeployWorkbook.getName()}));
                } else {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.progress.cancelInternal", new Object[]{bulkDeployWorkbook.getName()}));
                }
                return;
            }
        }
        if (!displayNames.isEmpty()) {
            displayNames.forEach((key, value) -> {
                log.log(Level.FINER, String.format("Component: %s, Display name: %s", key.getName(), value.encodeToString()));
                this.updateTemplateDisplayNames((BComponent)key, (BNameMap)value);
            });
        }
        HashMap<String, List<String>> accumulatedResponses = new HashMap<String, List<String>>();
        for (DeployedWorksheet deployedWorksheet3 : deployedWorksheets) {
            for (DeployedRoot deployedRoot : deployedWorksheet3.deployedRoots) {
                int currentProgress;
                List<String> deployResponses = this.applyConfigurations(deployedWorksheet3, deployedRoot);
                if (!deployResponses.isEmpty()) {
                    String key2 = deployedRoot.parentComponentSlotPath + '/' + deployedRoot.deployName;
                    accumulatedResponses.put(key2, deployResponses);
                }
                if (worker == null) continue;
                if ((currentProgress = (int)((double)(++processedInstances) * 30.0 / (double)templateInstanceCount) + 70) > totalProgress) {
                    totalProgress = currentProgress;
                    String progressMessage = lex.getText("bulkDeploy.progress.update.config", new Object[]{deployedWorksheet3.title, deployedRoot.deployName});
                    worker.updateProgress(totalProgress, progressMessage);
                }
                if (worker.isRunning()) continue;
                if (worker.isCanceled()) {
                    log.log(Level.INFO, lex.getText("bulkDeploy.progress.cancel", new Object[]{bulkDeployWorkbook.getName()}));
                } else {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.progress.cancelInternal", new Object[]{bulkDeployWorkbook.getName()}));
                }
                return;
            }
        }
        if (!accumulatedResponses.isEmpty()) {
            worker.setDeployMessages(accumulatedResponses);
        }
    }

    public void updateTemplateDisplayNames(BComponent deployRootComponent, BNameMap templateDisplayNames) {
        BNameMap existingDisplayNames = (BNameMap)deployRootComponent.get("displayNames");
        if (existingDisplayNames == null) {
            deployRootComponent.add("displayNames", (BValue)templateDisplayNames);
        } else if (existingDisplayNames.isNull()) {
            deployRootComponent.remove("displayNames");
            deployRootComponent.add("displayNames", (BValue)templateDisplayNames);
        } else {
            BNameMap mergedNameMap = BNameMap.make((BNameMap)existingDisplayNames, (BNameMap)templateDisplayNames);
            deployRootComponent.remove("displayNames");
            deployRootComponent.add("displayNames", (BValue)mergedNameMap);
        }
    }

    private static boolean supportInputSlot(DeployedWorksheet worksheet) {
        Version templateVersion = new Version(worksheet.templateExportVersion);
        Version inputSlotVersion = new Version(SOURCE_SLOT_MIN_VERSION);
        return templateVersion.compareTo(inputSlotVersion) >= 0;
    }

    private static boolean supportSlotPathScope(BulkDeployWorkbook bulkDeployWorkbook) {
        Version sourceSlotVersion = new Version("1.3");
        Version templateVersion = new Version(bulkDeployWorkbook.getTemplateExportVersion());
        return templateVersion.compareTo(sourceSlotVersion) >= 0;
    }

    private static int getExcelHeaderRows(Workbook wb, String templateType) {
        Version sourceSlotVersion;
        if (templateType == null) {
            return 6;
        }
        if (TEMPLATE_TYPE_APPLICATION.contentEquals(templateType)) {
            return 6;
        }
        Version templateVersion = new Version(BulkDeployUtil.getTemplateExportVersion(wb));
        return templateVersion.compareTo(sourceSlotVersion = new Version("1.3")) >= 0 ? 7 : 6;
    }

    public static List<DeployedWorksheet> loadDeployedWorksheets(BulkDeployWorkbook bulkDeployWorkbook) {
        ArrayList<DeployedWorksheet> deployedWorksheets = new ArrayList<DeployedWorksheet>();
        if (bulkDeployWorkbook == null || !bulkDeployWorkbook.isValid()) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.importFileUndefined"));
            return deployedWorksheets;
        }
        Workbook wb = bulkDeployWorkbook.getWorkbook();
        String templateExportVersion = BulkDeployUtil.getTemplateExportVersion(wb);
        if (templateExportVersion == null) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.importFileInvalid"));
            return deployedWorksheets;
        }
        if (!"1.3".equals(templateExportVersion)) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.importFileVersionMismatch"), new Object[]{templateExportVersion, "1.3"});
        }
        boolean isSlotPathScopeSupported = BulkDeployUtil.supportSlotPathScope(bulkDeployWorkbook);
        Iterator sheetIterator = wb.sheetIterator();
        while (sheetIterator.hasNext()) {
            int n;
            int n2;
            String templateType;
            int headerRowCount;
            Sheet sheet = (Sheet)sheetIterator.next();
            int lastRowNum = sheet.getLastRowNum();
            int realLastRow = lastRowNum + 1;
            if (realLastRow <= (headerRowCount = BulkDeployUtil.getExcelHeaderRows(wb, templateType = BulkDeployUtil.getTemplateTypeName(sheet))) || sheet.getSheetName().startsWith("#")) continue;
            String templateFile = BulkDeployUtil.getTemplateFile(sheet);
            String vendor = BulkDeployUtil.getTemplateVendor(sheet);
            String title = BulkDeployUtil.getTemplateTitle(sheet);
            String version = BulkDeployUtil.getTemplateVersion(sheet);
            BUuid uid = BUuid.make((String)BulkDeployUtil.getTemplateUID(sheet));
            int excelInstanceInfoColumns = BulkDeployUtil.getTemplateSheetInfoColumns(sheet);
            if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                log.log(IMPORT_LOG_LEVEL, "Deploying template " + title + " version " + version);
            }
            int[] configCounts = new int[]{0, 0, 0, 0, 0, 0, 0};
            BulkDeployUtil.loadConfigItemCounts(sheet, configCounts);
            if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                log.log(IMPORT_LOG_LEVEL, () -> String.format("Inputs = %d, Outputs = %d, Relations = %d, Configs = %d, Optionals = %d, OptionalConfigs = %d, Tags = %d", configCounts[0], configCounts[1], configCounts[2], configCounts[3], configCounts[4], configCounts[5], configCounts[6]));
            }
            Row secondRow = sheet.getRow(1);
            Row thirdRow = sheet.getRow(2);
            Row fourthRow = sheet.getRow(3);
            Row fifthRow = sheet.getRow(4);
            Row sixthRow = null;
            if (isSlotPathScopeSupported) {
                sixthRow = sheet.getRow(5);
            }
            DeployedWorksheet newWorksheet = new DeployedWorksheet();
            newWorksheet.title = title;
            newWorksheet.vendor = vendor;
            newWorksheet.version = version;
            newWorksheet.uid = uid;
            newWorksheet.templateType = templateType;
            newWorksheet.templateFile = templateFile;
            newWorksheet.templateExportVersion = templateExportVersion;
            newWorksheet.isSlotPathScopeSupported = isSlotPathScopeSupported;
            int columnOffset = excelInstanceInfoColumns;
            if (configCounts[0] > 0) {
                boolean isInputSlotSupported = BulkDeployUtil.supportInputSlot(newWorksheet);
                int columnsPerInput = 1;
                if (isInputSlotSupported) {
                    columnsPerInput = 2;
                }
                if (isSlotPathScopeSupported) {
                    columnsPerInput = 3;
                }
                int inputCount = configCounts[0] / columnsPerInput;
                ++columnOffset;
                for (int n3 = 0; n3 < inputCount; ++n3) {
                    String[] inputs = new String[6];
                    inputs[0] = BulkDeployUtil.getCell(secondRow, columnOffset);
                    inputs[1] = BulkDeployUtil.getCell(thirdRow, columnOffset);
                    inputs[2] = BulkDeployUtil.getCell(fourthRow, columnOffset);
                    if (isInputSlotSupported) {
                        inputs[3] = BulkDeployUtil.getCell(fifthRow, ++columnOffset);
                    }
                    if (sixthRow != null) {
                        inputs[4] = BulkDeployUtil.getCell(sixthRow, ++columnOffset);
                    }
                    newWorksheet.inputDefs.add(inputs);
                    ++columnOffset;
                }
            }
            if (configCounts[1] > 0) {
                int columnsPerOutput = isSlotPathScopeSupported ? 3 : 2;
                int outputCount = configCounts[1] / columnsPerOutput;
                ++columnOffset;
                for (n2 = 0; n2 < outputCount; ++n2) {
                    String[] outputs = new String[6];
                    outputs[0] = BulkDeployUtil.getCell(secondRow, columnOffset);
                    outputs[1] = BulkDeployUtil.getCell(thirdRow, columnOffset);
                    outputs[2] = BulkDeployUtil.getCell(fourthRow, columnOffset);
                    outputs[3] = BulkDeployUtil.getCell(fifthRow, ++columnOffset);
                    if (sixthRow != null) {
                        outputs[4] = BulkDeployUtil.getCell(sixthRow, ++columnOffset);
                    }
                    newWorksheet.outputDefs.add(outputs);
                    ++columnOffset;
                }
            }
            if (configCounts[2] > 0) {
                int columnsPerRelation = isSlotPathScopeSupported ? 2 : 1;
                int relationCount = configCounts[2] / columnsPerRelation;
                ++columnOffset;
                for (n2 = 0; n2 < relationCount; ++n2) {
                    String[] relations = new String[6];
                    relations[0] = BulkDeployUtil.getCell(secondRow, columnOffset);
                    relations[1] = BulkDeployUtil.getCell(thirdRow, columnOffset);
                    relations[2] = BulkDeployUtil.getCell(fourthRow, columnOffset);
                    relations[3] = BulkDeployUtil.getCell(fifthRow, columnOffset);
                    if (sixthRow != null) {
                        relations[4] = BulkDeployUtil.getCell(sixthRow, ++columnOffset);
                    }
                    newWorksheet.relationDefs.add(relations);
                    ++columnOffset;
                }
            }
            if (configCounts[3] > 0) {
                ++columnOffset;
                for (n = 0; n < configCounts[3]; ++n) {
                    ArrayList<String> configs = new ArrayList<String>();
                    configs.add(BulkDeployUtil.getCell(secondRow, columnOffset));
                    configs.add(BulkDeployUtil.getCell(thirdRow, columnOffset));
                    String valueType = BulkDeployUtil.getCell(fourthRow, columnOffset);
                    configs.add(valueType);
                    configs.add(BulkDeployUtil.getCellOrNull(fifthRow, columnOffset, BulkDeployUtil.isStringType(valueType)));
                    newWorksheet.configDefs.add(configs.toArray(STRINGS));
                    ++columnOffset;
                }
            }
            if (configCounts[4] > 0) {
                ++columnOffset;
                for (n = 0; n < configCounts[4]; ++n) {
                    ArrayList<String> optionals = new ArrayList<String>();
                    optionals.add(BulkDeployUtil.getCell(secondRow, columnOffset));
                    optionals.add(BulkDeployUtil.getCell(thirdRow, columnOffset));
                    optionals.add(BulkDeployUtil.getCell(fifthRow, columnOffset));
                    newWorksheet.optionalDefs.add(optionals.toArray(STRINGS));
                    ++columnOffset;
                }
            }
            if (configCounts[5] > 0) {
                ++columnOffset;
                for (n = 0; n < configCounts[5]; ++n) {
                    ArrayList<String> optionalConfigs = new ArrayList<String>();
                    optionalConfigs.add(BulkDeployUtil.getCell(secondRow, columnOffset));
                    optionalConfigs.add(BulkDeployUtil.getCell(thirdRow, columnOffset));
                    String valueType = BulkDeployUtil.getCell(fourthRow, columnOffset);
                    optionalConfigs.add(valueType);
                    optionalConfigs.add(BulkDeployUtil.getCellOrNull(fifthRow, columnOffset, BulkDeployUtil.isStringType(valueType)));
                    newWorksheet.optionalConfigDefs.add(optionalConfigs.toArray(STRINGS));
                    ++columnOffset;
                }
            }
            if (configCounts[6] > 0) {
                ++columnOffset;
                for (n = 0; n < configCounts[6]; ++n) {
                    ArrayList<String> tags = new ArrayList<String>();
                    tags.add(BulkDeployUtil.getCell(secondRow, columnOffset));
                    tags.add(BulkDeployUtil.getCell(fourthRow, columnOffset));
                    tags.add(BulkDeployUtil.getCell(fifthRow, columnOffset));
                    newWorksheet.tagDefs.add(tags.toArray(STRINGS));
                    ++columnOffset;
                }
            }
            int i = headerRowCount;
            while (i < realLastRow) {
                StringBuilder deviceTargetStr;
                String deployName;
                Row primaryRow;
                if (BulkDeployUtil.isCommentRow(primaryRow = sheet.getRow(i++)) || BulkDeployUtil.isSecondaryRow(primaryRow)) {
                    if (!log.isLoggable(IMPORT_LOG_LEVEL)) continue;
                    log.log(IMPORT_LOG_LEVEL, "Skipping blank, comment, or untethered secondary row #" + i);
                    continue;
                }
                ArrayList<Row> rowList = new ArrayList<Row>();
                rowList.add(primaryRow);
                Row nextRow = sheet.getRow(i);
                while (BulkDeployUtil.isSecondaryRow(nextRow)) {
                    rowList.add(nextRow);
                    nextRow = sheet.getRow(++i);
                }
                String rootComponentName = BulkDeployUtil.getCell((Row)rowList.get(0), 0);
                String displayName = DEFAULT_SLOT_PATH_SCOPE;
                String position = DEFAULT_SLOT_PATH_SCOPE;
                String deviceTarget = DEFAULT_SLOT_PATH_SCOPE;
                boolean enableHistories = false;
                if (TEMPLATE_TYPE_APPLICATION.contentEquals(templateType)) {
                    if (rootComponentName == null || rootComponentName.isEmpty()) {
                        log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.stationEmptyError", new Object[]{title}));
                        continue;
                    }
                    deployName = rootComponentName;
                    if (excelInstanceInfoColumns > 1) {
                        deviceTargetStr = new StringBuilder();
                        for (Row row : rowList) {
                            String uniqueDevice = BulkDeployUtil.getCell(row, 1);
                            if (uniqueDevice.isEmpty()) {
                                log.log(Level.INFO, lex.getText("bulkDeploy.excelImport.targetDeviceNotFound", new Object[]{deployName}));
                            }
                            deviceTargetStr.append(uniqueDevice).append(',');
                        }
                        deviceTarget = deviceTargetStr.toString();
                        if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                            log.log(IMPORT_LOG_LEVEL, "Device target = " + deviceTarget);
                        }
                    }
                } else {
                    deployName = BulkDeployUtil.getCell((Row)rowList.get(0), 1);
                    if (deployName == null || deployName.isEmpty()) {
                        log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.deployEmptyError", new Object[]{title}));
                        continue;
                    }
                    if (excelInstanceInfoColumns > 2) {
                        displayName = BulkDeployUtil.getCell((Row)rowList.get(0), 2);
                        if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                            log.log(IMPORT_LOG_LEVEL, "Display name = " + displayName);
                        }
                    }
                    if (excelInstanceInfoColumns > 3) {
                        position = BulkDeployUtil.getCell((Row)rowList.get(0), 3);
                        if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                            log.log(IMPORT_LOG_LEVEL, "Position = " + position);
                        }
                    }
                    if (excelInstanceInfoColumns > 4) {
                        deviceTargetStr = new StringBuilder();
                        for (Row row : rowList) {
                            String uniqueDevice = BulkDeployUtil.getCell(row, 4);
                            if (uniqueDevice.isEmpty()) {
                                log.log(Level.INFO, lex.getText("bulkDeploy.excelImport.targetDeviceNotFound", new Object[]{deployName}));
                            }
                            deviceTargetStr.append(uniqueDevice).append(',');
                        }
                        deviceTarget = deviceTargetStr.toString();
                        if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                            log.log(IMPORT_LOG_LEVEL, "Device target = " + deviceTarget);
                        }
                    }
                    if (excelInstanceInfoColumns > 5) {
                        enableHistories = BulkDeployUtil.getCellAsBoolean((Row)rowList.get(0), 5);
                    }
                }
                DeployedRoot newRoot = new DeployedRoot();
                newRoot.parentComponentSlotPath = rootComponentName == null ? DEFAULT_SLOT_PATH_SCOPE : rootComponentName;
                newRoot.deployName = deployName;
                newRoot.displayName = displayName;
                newRoot.position = position;
                newRoot.deviceTarget = new ArrayList(rowList.size());
                newRoot.isSlotPathScopeSupported = isSlotPathScopeSupported;
                for (String deviceTargetValue : deviceTarget.split(",")) {
                    if (deviceTargetValue.isEmpty()) continue;
                    newRoot.deviceTarget.add(deviceTargetValue.trim());
                    if (!log.isLoggable(IMPORT_LOG_LEVEL)) continue;
                    log.log(IMPORT_LOG_LEVEL, "Device target = " + deviceTargetValue);
                }
                newRoot.enableHistories = enableHistories;
                columnOffset = excelInstanceInfoColumns;
                if (configCounts[0] > 0) {
                    boolean isInputSlotSupported = BulkDeployUtil.supportInputSlot(newWorksheet);
                    int columnsPerInput = 1;
                    if (isInputSlotSupported) {
                        columnsPerInput = 2;
                    }
                    if (isSlotPathScopeSupported) {
                        columnsPerInput = 3;
                    }
                    int inputCount = configCounts[0] / columnsPerInput;
                    newRoot.inputs = new ArrayList();
                    ++columnOffset;
                    for (int n4 = 0; n4 < inputCount; ++n4) {
                        String inputName;
                        DeployedIOR input = new DeployedIOR();
                        String[] inputDef = newWorksheet.inputDefs.get(n4);
                        if (inputDef == null || inputDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.inputDefinitionError", new Object[]{deployName}));
                            continue;
                        }
                        input.name = inputName = BulkDeployUtil.getCell((Row)rowList.get(0), columnOffset);
                        Object inputSlotName = DEFAULT_SOURCE_SLOT;
                        Object slotPathScope = DEFAULT_SLOT_PATH_SCOPE;
                        if (isInputSlotSupported) {
                            inputSlotName = BulkDeployUtil.getCell((Row)rowList.get(0), ++columnOffset);
                            if ((inputSlotName == null || ((String)inputSlotName).isEmpty()) && ((String)(inputSlotName = inputDef[3])).isEmpty()) {
                                inputSlotName = DEFAULT_SOURCE_SLOT;
                            }
                            input.slot = inputSlotName;
                            if (isSlotPathScopeSupported && ((slotPathScope = BulkDeployUtil.getCell((Row)rowList.get(0), ++columnOffset)) == null || ((String)slotPathScope).isEmpty())) {
                                slotPathScope = inputDef[4];
                            }
                            input.scope = slotPathScope;
                        }
                        newRoot.inputs.add(input);
                        if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                            log.log(IMPORT_LOG_LEVEL, "Input name " + inputName + " slot " + (String)inputSlotName + (isSlotPathScopeSupported ? " scope " + (String)slotPathScope : DEFAULT_SLOT_PATH_SCOPE));
                        }
                        ++columnOffset;
                    }
                }
                if (configCounts[1] > 0) {
                    int columnsPerOutput = isSlotPathScopeSupported ? 3 : 2;
                    int outputCount = configCounts[1] / columnsPerOutput;
                    newRoot.outputs = new HashMap();
                    ++columnOffset;
                    for (int outputIndex = 0; outputIndex < outputCount; ++outputIndex) {
                        String[] outputDef = newWorksheet.outputDefs.get(outputIndex);
                        if (outputDef == null || outputDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.outputDefinitionError", new Object[]{deployName}));
                            continue;
                        }
                        ArrayList<DeployedIOR> namedOutputs = new ArrayList<DeployedIOR>();
                        newRoot.outputs.put(outputDef[0], namedOutputs);
                        for (Row row : rowList) {
                            DeployedIOR output = new DeployedIOR();
                            String outputName = BulkDeployUtil.getCell(row, columnOffset);
                            if (outputName.isEmpty()) {
                                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.outputComponentNotFound", new Object[]{deployName}));
                                continue;
                            }
                            output.name = outputName;
                            String outputSlotName = BulkDeployUtil.getCell(row, columnOffset + 1);
                            if (outputSlotName == null || outputSlotName.isEmpty()) {
                                outputSlotName = outputDef[3];
                            }
                            output.slot = outputSlotName;
                            String slotPathScope = DEFAULT_SLOT_PATH_SCOPE;
                            if (isSlotPathScopeSupported && ((slotPathScope = BulkDeployUtil.getCell(row, columnOffset + 2)) == null || slotPathScope.isEmpty())) {
                                slotPathScope = outputDef[4];
                            }
                            output.scope = slotPathScope;
                            namedOutputs.add(output);
                            if (!log.isLoggable(IMPORT_LOG_LEVEL)) continue;
                            log.log(IMPORT_LOG_LEVEL, "Output name " + outputName + " slot " + outputSlotName + (isSlotPathScopeSupported ? " scope " + slotPathScope : DEFAULT_SLOT_PATH_SCOPE));
                        }
                        columnOffset += columnsPerOutput;
                    }
                }
                if (configCounts[2] > 0) {
                    int columnsPerRelation = isSlotPathScopeSupported ? 2 : 1;
                    int relationCount = configCounts[2] / columnsPerRelation;
                    newRoot.relations = new HashMap();
                    ++columnOffset;
                    for (int relationIndex = 0; relationIndex < relationCount; ++relationIndex) {
                        String[] relationDef = newWorksheet.relationDefs.get(relationIndex);
                        if (relationDef == null || relationDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.relationDefinitionError", new Object[]{deployName}));
                            continue;
                        }
                        String relationId = relationDef[1];
                        String direction = relationDef[3];
                        ArrayList<DeployedIOR> namedRelations = new ArrayList<DeployedIOR>();
                        newRoot.relations.put(relationId + direction, namedRelations);
                        for (Row row : rowList) {
                            DeployedIOR relation = new DeployedIOR();
                            String relationName = BulkDeployUtil.getCell(row, columnOffset);
                            if (relationName.isEmpty()) {
                                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.relationComponentNotFound", new Object[]{deployName, direction}));
                                continue;
                            }
                            relation.name = relationName;
                            String slotPathScope = DEFAULT_SLOT_PATH_SCOPE;
                            if (isSlotPathScopeSupported && ((slotPathScope = BulkDeployUtil.getCell(row, columnOffset + 1)) == null || slotPathScope.isEmpty())) {
                                slotPathScope = relationDef[4];
                            }
                            relation.scope = slotPathScope;
                            namedRelations.add(relation);
                            if (!log.isLoggable(IMPORT_LOG_LEVEL)) continue;
                            log.log(IMPORT_LOG_LEVEL, "Relation id " + relationId + " direction " + direction + " name list " + relationName + (isSlotPathScopeSupported ? " scope " + slotPathScope : DEFAULT_SLOT_PATH_SCOPE));
                        }
                        columnOffset += columnsPerRelation;
                    }
                }
                if (configCounts[3] > 0) {
                    DeployedRoot.access$1202(newRoot, new String[configCounts[3]]);
                    ++columnOffset;
                    for (int n5 = 0; n5 < configCounts[3]; ++n5) {
                        String configValue;
                        boolean stringType = false;
                        String[] configDef = newWorksheet.configDefs.get(n5);
                        if (configDef == null || configDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.configDefinitionError", new Object[]{deployName}));
                            continue;
                        }
                        if (configDef.length >= 2) {
                            stringType = BulkDeployUtil.isStringType(configDef[2]);
                        }
                        ((DeployedRoot)newRoot).configs[n5] = configValue = BulkDeployUtil.getCellOrNull((Row)rowList.get(0), columnOffset, stringType);
                        ++columnOffset;
                    }
                }
                if (configCounts[4] > 0) {
                    DeployedRoot.access$1302(newRoot, new String[configCounts[4]]);
                    ++columnOffset;
                    for (int n6 = 0; n6 < configCounts[4]; ++n6) {
                        String[] optionalDef = newWorksheet.optionalDefs.get(n6);
                        if (optionalDef == null || optionalDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.optionalsDefinitionError", new Object[]{deployName}));
                            continue;
                        }
                        String optionalName = BulkDeployUtil.getCellOrNull((Row)rowList.get(0), columnOffset, true);
                        if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                            log.log(IMPORT_LOG_LEVEL, "Optional value " + optionalName);
                        }
                        ((DeployedRoot)newRoot).optionals[n6] = optionalName;
                        ++columnOffset;
                    }
                }
                if (configCounts[5] > 0) {
                    DeployedRoot.access$1402(newRoot, new String[configCounts[5]]);
                    ++columnOffset;
                    for (int n7 = 0; n7 < configCounts[5]; ++n7) {
                        String optionalConfigValue;
                        boolean stringType = false;
                        String[] optionalConfigDef = newWorksheet.optionalConfigDefs.get(n7);
                        if (optionalConfigDef == null || optionalConfigDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.optionalsConfigDefinitionError", new Object[]{deployName}));
                            continue;
                        }
                        if (optionalConfigDef.length >= 2) {
                            Type t = Sys.getType((String)optionalConfigDef[2]);
                            stringType = t.is(BString.TYPE) || t.is(BStatusString.TYPE) || t.is(BEnum.TYPE) || t.is(BStatusEnum.TYPE) || t.is(BFrozenEnum.TYPE);
                        }
                        ((DeployedRoot)newRoot).optionalConfigs[n7] = optionalConfigValue = BulkDeployUtil.getCellOrNull((Row)rowList.get(0), columnOffset, stringType);
                        ++columnOffset;
                    }
                }
                if (configCounts[6] > 0) {
                    DeployedRoot.access$1502(newRoot, new String[configCounts[6]]);
                    ++columnOffset;
                    for (int n8 = 0; n8 < configCounts[6]; ++n8) {
                        String configValue;
                        String[] tagDef = newWorksheet.tagDefs.get(n8);
                        if (tagDef == null || tagDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.tagDefinitionError", new Object[]{deployName}));
                            continue;
                        }
                        boolean stringType = true;
                        ((DeployedRoot)newRoot).tags[n8] = configValue = BulkDeployUtil.getCellOrNull((Row)rowList.get(0), columnOffset, stringType);
                        ++columnOffset;
                    }
                }
                if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                    log.log(IMPORT_LOG_LEVEL, () -> String.format("Root = %s, Deploy Name = %s, Device Target = %s, Enable Histories = %s", newRoot.parentComponentSlotPath, newRoot.deployName, newRoot.deviceTarget, newRoot.enableHistories));
                }
                newWorksheet.deployedRoots.add(newRoot);
            }
            deployedWorksheets.add(newWorksheet);
        }
        return deployedWorksheets;
    }

    private static boolean isCommentRow(Row row) {
        if (row == null) {
            return true;
        }
        boolean isBlank = true;
        boolean isComment = false;
        Iterator it = row.cellIterator();
        block4: while (isBlank && it.hasNext()) {
            Cell cell = (Cell)it.next();
            switch (cell.getCellType()) {
                case BLANK: {
                    continue block4;
                }
                case STRING: {
                    String value = cell.getStringCellValue().trim();
                    isBlank = value.isEmpty();
                    isComment = cell.getColumnIndex() < 2 && value.startsWith("#");
                    continue block4;
                }
            }
            isBlank = false;
        }
        return isBlank || isComment;
    }

    private static boolean isSecondaryRow(Row row) {
        return !BulkDeployUtil.isCommentRow(row) && BulkDeployUtil.getCell(row, 0).isEmpty() && BulkDeployUtil.getCell(row, 1).isEmpty();
    }

    private static boolean isStringType(String valueType) {
        Type t = Sys.getType((String)valueType);
        return t.is(BString.TYPE) || t.is(BStatusString.TYPE) || t.is(BEnum.TYPE) || t.is(BStatusEnum.TYPE) || t.is(BFrozenEnum.TYPE);
    }

    private static void setTemplateExportVersion(Workbook workbook) {
        BulkDeployUtil.addWorkbookConstant(workbook, TEMPLATE_EXPORT_VERSION_NAME, "1.3");
    }

    private static void setKeepPrivateFlag(Workbook workbook) {
        BulkDeployUtil.addWorkbookConstant(workbook, KEEP_PRIVATE_NAME, BBoolean.TRUE.toString());
    }

    private static void setTemplateFile(Sheet sheet, String templateFile) {
        BulkDeployUtil.addSheetConstant(sheet, TEMPLATE_FILE_NAME, templateFile);
    }

    private static void setTemplateVendor(Sheet sheet, String templateVendor) {
        BulkDeployUtil.addSheetConstant(sheet, TEMPLATE_VENDOR_NAME, templateVendor);
    }

    private static void setTemplateTitle(Sheet sheet, String templateTitle) {
        BulkDeployUtil.addSheetConstant(sheet, TEMPLATE_TITLE_NAME, templateTitle);
    }

    private static void setTemplateVersion(Sheet sheet, String templateVersion) {
        BulkDeployUtil.addSheetConstant(sheet, TEMPLATE_VERSION_NAME, templateVersion);
    }

    private static void setTemplateUID(Sheet sheet, String templateUID) throws IOException {
        BulkDeployUtil.addSheetConstant(sheet, TEMPLATE_UID_NAME, templateUID);
    }

    private static void setTemplateTypeName(Sheet sheet, String templateTypeName) {
        BulkDeployUtil.addSheetConstant(sheet, TEMPLATE_TYPE_NAME, templateTypeName);
    }

    private static void setTemplateSheetInfoColumns(Sheet sheet, int infoColumns) {
        BulkDeployUtil.addSheetConstant(sheet, TEMPLATE_SHEET_INFO_COLUMNS_NAME, Integer.toString(infoColumns));
    }

    private static void setInputsCount(Sheet sheet, int count) {
        BulkDeployUtil.addSheetConstant(sheet, TEMPLATE_INPUTS_COUNT_NAME, Integer.toString(count));
    }

    private static void setOutputsCount(Sheet sheet, int count) {
        BulkDeployUtil.addSheetConstant(sheet, TEMPLATE_OUTPUTS_COUNT_NAME, Integer.toString(count));
    }

    private static void setRelationsCount(Sheet sheet, int count) {
        BulkDeployUtil.addSheetConstant(sheet, TEMPLATE_RELATIONS_COUNT_NAME, Integer.toString(count));
    }

    private static void setConfigsCount(Sheet sheet, int count) {
        BulkDeployUtil.addSheetConstant(sheet, TEMPLATE_CONFIGS_COUNT_NAME, Integer.toString(count));
    }

    private static void setOptionalCount(Sheet sheet, int count) {
        BulkDeployUtil.addSheetConstant(sheet, TEMPLATE_OPTIONALS_COUNT_NAME, Integer.toString(count));
    }

    private static void setOptionalConfigurationCount(Sheet sheet, int count) {
        BulkDeployUtil.addSheetConstant(sheet, TEMPLATE_OPTIONAL_CONFIGS_COUNT_NAME, Integer.toString(count));
    }

    private static void setTagCount(Sheet sheet, int count) {
        BulkDeployUtil.addSheetConstant(sheet, TEMPLATE_TAG_COUNT_NAME, Integer.toString(count));
    }

    private String buildTemplateTypeName(TemplateManifest manifest) {
        if (manifest.isApplication) {
            return TEMPLATE_TYPE_APPLICATION;
        }
        TemplateManager tm = TemplateManager.INSTANCE;
        TemplateManager.TemplateInfo templateInfo = tm.getTemplate(manifest.uID, manifest.vendor);
        if (templateInfo.getRootType().is(BDevice.TYPE)) {
            return TEMPLATE_TYPE_DEVICE;
        }
        return TEMPLATE_TYPE_COMPONENT;
    }

    private static void addWorkbookConstant(Workbook workbook, String constantName, String constantValue) {
        BulkDeployUtil.addSheetOrWorkbookConstant(workbook, -1, constantName, constantValue);
    }

    private static void addSheetConstant(Sheet sheet, String constantName, String constantValue) {
        Workbook workbook = sheet.getWorkbook();
        int sheetIndex = workbook.getSheetIndex(sheet.getSheetName());
        BulkDeployUtil.addSheetOrWorkbookConstant(workbook, sheetIndex, constantName, constantValue);
    }

    private static void addSheetOrWorkbookConstant(Workbook workbook, int sheetIndex, String constantName, String constantValue) {
        Name name = workbook.createName();
        name.setSheetIndex(sheetIndex);
        name.setNameName(constantName);
        name.setRefersToFormula('\"' + constantValue + '\"');
    }

    private static String getTemplateExportVersion(Workbook workbook) {
        return BulkDeployUtil.getWorkbookConstant(workbook, TEMPLATE_EXPORT_VERSION_NAME);
    }

    private static String getTemplateFile(Sheet sheet) {
        return BulkDeployUtil.getSheetConstant(sheet, TEMPLATE_FILE_NAME);
    }

    private static String getTemplateVendor(Sheet sheet) {
        return BulkDeployUtil.getSheetConstant(sheet, TEMPLATE_VENDOR_NAME);
    }

    private static String getTemplateTitle(Sheet sheet) {
        return BulkDeployUtil.getSheetConstant(sheet, TEMPLATE_TITLE_NAME);
    }

    private static String getTemplateVersion(Sheet sheet) {
        return BulkDeployUtil.getSheetConstant(sheet, TEMPLATE_VERSION_NAME);
    }

    private static String getTemplateUID(Sheet sheet) {
        return BulkDeployUtil.getSheetConstant(sheet, TEMPLATE_UID_NAME);
    }

    private static String getTemplateTypeName(Sheet sheet) {
        return BulkDeployUtil.getSheetConstant(sheet, TEMPLATE_TYPE_NAME);
    }

    private static int getTemplateSheetInfoColumns(Sheet sheet) {
        String result = BulkDeployUtil.getSheetConstant(sheet, TEMPLATE_SHEET_INFO_COLUMNS_NAME);
        if (result == null) {
            return 5;
        }
        return Integer.parseInt(result);
    }

    private static void loadConfigItemCounts(Sheet sheet, int[] configCounts) {
        String inputsCount = BulkDeployUtil.getSheetConstant(sheet, TEMPLATE_INPUTS_COUNT_NAME);
        String outputsCount = BulkDeployUtil.getSheetConstant(sheet, TEMPLATE_OUTPUTS_COUNT_NAME);
        String relationsCount = BulkDeployUtil.getSheetConstant(sheet, TEMPLATE_RELATIONS_COUNT_NAME);
        String configsCount = BulkDeployUtil.getSheetConstant(sheet, TEMPLATE_CONFIGS_COUNT_NAME);
        String optionalsCount = BulkDeployUtil.getSheetConstant(sheet, TEMPLATE_OPTIONALS_COUNT_NAME);
        String optionalConfigsCount = BulkDeployUtil.getSheetConstant(sheet, TEMPLATE_OPTIONAL_CONFIGS_COUNT_NAME);
        String tagCount = BulkDeployUtil.getSheetConstant(sheet, TEMPLATE_TAG_COUNT_NAME);
        if (inputsCount != null) {
            configCounts[0] = Integer.parseInt(inputsCount);
        }
        if (outputsCount != null) {
            configCounts[1] = Integer.parseInt(outputsCount);
        }
        if (relationsCount != null) {
            configCounts[2] = Integer.parseInt(relationsCount);
        }
        if (configsCount != null) {
            configCounts[3] = Integer.parseInt(configsCount);
        }
        if (optionalsCount != null) {
            configCounts[4] = Integer.parseInt(optionalsCount);
        }
        if (optionalConfigsCount != null) {
            configCounts[5] = Integer.parseInt(optionalConfigsCount);
        }
        if (tagCount != null) {
            configCounts[6] = Integer.parseInt(tagCount);
        }
    }

    private static String getWorkbookConstant(Workbook workbook, String name) {
        return BulkDeployUtil.getSheetOrWorkbookConstant(workbook, -1, name);
    }

    private static String getSheetConstant(Sheet sheet, String name) {
        Workbook workbook = sheet.getWorkbook();
        int sheetIndex = workbook.getSheetIndex(sheet.getSheetName());
        return BulkDeployUtil.getSheetOrWorkbookConstant(workbook, sheetIndex, name);
    }

    private static String getSheetOrWorkbookConstant(Workbook workbook, int sheetIndex, String name) {
        String formula;
        String value = null;
        Name constantName = BulkDeployUtil.getNamedRange(workbook, sheetIndex, name);
        if (constantName != null && (formula = constantName.getRefersToFormula()).startsWith("\"") && formula.endsWith("\"") && formula.length() >= 2) {
            value = formula.substring(1, formula.length() - 1);
        }
        return value;
    }

    private static Name getNamedRange(Workbook workbook, int sheetIndex, String nameName) {
        List names = workbook.getNames(nameName);
        Name foundName = null;
        for (Name name : names) {
            if (name.getSheetIndex() != sheetIndex) continue;
            foundName = name;
            break;
        }
        return foundName;
    }

    protected BComponent resolveDeployComponent(DeployedRoot deployedRoot, BComponent root) {
        String escapedParentComponentSlotPath = BulkDeployUtil.escapeSlotPathNames(deployedRoot.parentComponentSlotPath);
        BOrd deployRootOrd = BOrd.make((String)(root.getSlotPathOrd() + escapedParentComponentSlotPath));
        if (log.isLoggable(IMPORT_LOG_LEVEL)) {
            log.log(IMPORT_LOG_LEVEL, "deployRootOrd = " + deployRootOrd);
        }
        try {
            deployRootOrd.resolve((BObject)root);
        }
        catch (UnresolvedException e) {
            SlotPath deployRootSlotPath = new SlotPath("slot", escapedParentComponentSlotPath);
            String[] slotPathElements = deployRootSlotPath.getNames();
            BComponent nextComponent = root;
            for (String element : slotPathElements) {
                if ((nextComponent = this.getNextChild(nextComponent, element)) != null) continue;
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.rootTargetError", new Object[]{deployedRoot.parentComponentSlotPath}));
                return null;
            }
        }
        BComponent deployRootComponent = deployRootOrd.resolve((BObject)root).getComponent();
        if (deployRootComponent == null) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.rootTargetError", new Object[]{deployedRoot.parentComponentSlotPath}));
            return null;
        }
        if (!deployRootComponent.isMounted()) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.notMountedError", new Object[]{deployedRoot.parentComponentSlotPath}));
            return null;
        }
        return deployRootComponent;
    }

    protected BComponent getNextChild(BComponent parentComponent, String childName) {
        BValue childValue = parentComponent.get(childName);
        if (childValue == null) {
            log.log(Level.FINE, "Creating missing slot path node " + childName);
            Type newFolderType = BFolder.TYPE;
            if (parentComponent instanceof BIPointFolder) {
                newFolderType = ((BIPointFolder)parentComponent).getPointFolderType();
            } else if (parentComponent instanceof BIDeviceFolder) {
                newFolderType = ((BIDeviceFolder)parentComponent).getDeviceFolderType();
            } else if (parentComponent instanceof BIArchiveFolder) {
                newFolderType = ((BIArchiveFolder)parentComponent).getArchiveFolderType();
            }
            BComponent nextChild = newFolderType.getInstance().asComponent();
            parentComponent.add(childName, (BValue)nextChild);
            BComponent createdChild = parentComponent.get(childName).asComponent();
            return createdChild;
        }
        return childValue.asComponent();
    }

    private BWbDeployableNtplFile getTemplFileFromWorksheet(DeployedWorksheet worksheet) {
        TemplateManager.TemplateInfo deployTemplateInfo;
        TemplateManager tmInstance = new TemplateManager();
        tmInstance.initTemplateMap();
        if (log.isLoggable(IMPORT_LOG_LEVEL)) {
            log.log(IMPORT_LOG_LEVEL, "Locate template file for UID" + worksheet.uid + " and vendor " + worksheet.vendor);
        }
        if ((deployTemplateInfo = tmInstance.getTemplate(worksheet.uid, worksheet.vendor)) == null) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.templateFileNotFound", new Object[]{worksheet.title}));
            return null;
        }
        BNtplFile ntplFile = deployTemplateInfo.getNtplFile();
        if (ntplFile instanceof BWbDeployableNtplFile) {
            return (BWbDeployableNtplFile)ntplFile;
        }
        return BWbDeployableNtplFile.make(ntplFile);
    }

    protected BNtplFile copyTemplateToStation(DeployedWorksheet worksheet, BComponent deployRootComponent) {
        BWbDeployableNtplFile deployableNtplFile = this.getTemplFileFromWorksheet(worksheet);
        if (UpdateUtil.updateNtplFile(deployableNtplFile, deployRootComponent)) {
            return deployableNtplFile;
        }
        return null;
    }

    protected boolean updateNtplFile(BWbDeployableNtplFile ntplFile, BComponent target) {
        return UpdateUtil.updateNtplFile(ntplFile, target);
    }

    protected static BComponent installTemplateToStation(DeployedWorksheet worksheet, DeployedRoot deployedRoot, BComponent deployRootComponent, BNtplFile ntplFile, Map<String, BFormat> componentDisplayNames) {
        try {
            if (!(ntplFile instanceof BWbDeployableNtplFile)) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.templateFileNotFound", new Object[]{worksheet.title}));
                return null;
            }
            String escapedName = SlotPath.escape((String)deployedRoot.deployName);
            BComponent params = new BComponent();
            params.add("exact", (BValue)BBoolean.TRUE);
            Mark mark = new Mark((BObject)ntplFile, escapedName);
            mark.copyTo((BObject)deployRootComponent, params, DeployToComp.NoPostLink);
            BComponent deployedTemplateComponent = deployRootComponent.get(escapedName).asComponent();
            if (deployedTemplateComponent == null) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.deploymentError", new Object[]{worksheet.title, deployedRoot.deployName}));
                return null;
            }
            BulkDeployUtil.setComponentPosition(deployedTemplateComponent, deployedRoot.position);
            if (deployedRoot.enableHistories) {
                BHistoryExt[] unconfigurableHistories;
                for (BHistoryExt historyExt : unconfigurableHistories = BulkDeployUtil.unconfigurableHistoryExtensions(deployedTemplateComponent)) {
                    historyExt.setEnabled(true);
                }
            }
            if (deployedRoot.displayName != null && !deployedRoot.displayName.isEmpty()) {
                try {
                    componentDisplayNames.put(deployRootComponent.getProperty(escapedName).getName(), BFormat.make((String)deployedRoot.displayName));
                }
                catch (Exception e) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.displayNameError", new Object[]{deployedRoot.displayName, deployedRoot.deployName}), e);
                }
            }
            return deployedTemplateComponent;
        }
        catch (Exception e) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.postDeployError", new Object[]{worksheet.title, deployedRoot.deployName}), e);
            return null;
        }
    }

    public List<String> applyConfigurations(DeployedWorksheet deployedWorksheet, DeployedRoot deployedRoot) {
        return this.setConfigurationsFromWorksheet(deployedWorksheet, deployedRoot, false);
    }

    public List<String> updateConfigurations(DeployedWorksheet deployedWorksheet, DeployedRoot deployedRoot) {
        return this.setConfigurationsFromWorksheet(deployedWorksheet, deployedRoot, true);
    }

    private List<String> setConfigurationsFromWorksheet(DeployedWorksheet deployedWorksheet, DeployedRoot deployedRoot, boolean whenNoValueKeepCurrent) {
        BLink link;
        String slotPathScope;
        String bindHints;
        String slotName;
        ArrayList<String> responseMessages = new ArrayList<String>();
        if (deployedWorksheet == null || deployedRoot == null) {
            return responseMessages;
        }
        log.log(IMPORT_LOG_LEVEL, "Bulk deploy inputs/outputs/relations/configs");
        BComponent deployedTemplateComponent = deployedRoot.deployedTemplate;
        if (deployedTemplateComponent == null) {
            return responseMessages;
        }
        BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)deployedTemplateComponent);
        if (templateConfig == null) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.invalidTemplateError", new Object[]{deployedTemplateComponent.getName()}));
            return responseMessages;
        }
        if (deployedRoot.inputs != null && !deployedRoot.inputs.isEmpty()) {
            for (int n = 0; n < deployedRoot.inputs.size(); ++n) {
                BComponent sourceComponent;
                Object[] choices;
                Slot inputSlot;
                String[] inputDef = deployedWorksheet.inputDefs.get(n);
                if (inputDef == null || inputDef.length == 0) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.inputDefinitionError", new Object[]{deployedTemplateComponent.getName()}));
                    continue;
                }
                slotName = inputDef[0];
                bindHints = inputDef[2];
                slotPathScope = DEFAULT_SLOT_PATH_SCOPE;
                if (deployedRoot.isSlotPathScopeSupported) {
                    slotPathScope = inputDef[4];
                }
                if ((inputSlot = deployedTemplateComponent.getSlot(slotName)) == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.missingInputSlotError", new Object[]{deployedTemplateComponent.getName(), slotName}));
                    continue;
                }
                DeployedIOR input = (DeployedIOR)deployedRoot.inputs.get(n);
                if (input.scope != null && !input.scope.isEmpty()) {
                    slotPathScope = input.scope;
                }
                if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                    log.log(IMPORT_LOG_LEVEL, "Input slot name = " + slotName + ", bind hints = " + bindHints + ", slot path scope = " + slotPathScope);
                }
                try {
                    choices = TmplUtil.findMatchingObjects(bindHints, slotPathScope, responseMessages, this.getSearchService(deployedTemplateComponent), this.getTemplateService(deployedTemplateComponent), (BComponent)templateConfig, lex);
                }
                catch (Exception ignored) {
                    choices = null;
                }
                if (choices == null || choices.length == 0) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.inputBindingError", new Object[]{deployedTemplateComponent.getName(), slotName}));
                    continue;
                }
                String sourceName = input.name;
                String sourceSlotName = DEFAULT_SOURCE_SLOT;
                if (input.slot != null && !input.slot.isEmpty()) {
                    sourceSlotName = input.slot;
                }
                if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                    log.log(IMPORT_LOG_LEVEL, "Input name " + sourceName + " slot " + sourceSlotName);
                }
                if ((sourceComponent = BulkDeployUtil.getNamedComponentFromChoices(choices, BulkDeployUtil.escapeSlotPathNames(sourceName), BulkDeployUtil.getEscapedNameFromSlotPath(sourceName))) == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.inputSourceError", new Object[]{sourceName, deployedTemplateComponent.getName()}));
                    continue;
                }
                Property sourceProp = sourceComponent.getProperty(sourceSlotName);
                if (sourceProp == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.sourceSlotError", new Object[]{sourceComponent.getName(), deployedTemplateComponent.getName()}));
                    continue;
                }
                LinkCheck linkCheck = deployedTemplateComponent.checkLink(sourceComponent, (Slot)sourceProp, inputSlot, null);
                if (!linkCheck.isValid()) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.inputLinkError", new Object[]{sourceComponent.getName(), deployedTemplateComponent.getName(), linkCheck.getInvalidReason()}));
                    continue;
                }
                link = deployedTemplateComponent.makeLink(sourceComponent, (Slot)sourceProp, inputSlot, null);
                deployedTemplateComponent.add(null, (BValue)link);
            }
        }
        if (deployedRoot.outputs != null && !deployedRoot.outputs.isEmpty()) {
            for (int outputDefIndex = 0; outputDefIndex < deployedWorksheet.outputDefs.size(); ++outputDefIndex) {
                List namedOutputs;
                String[] outputDef = deployedWorksheet.outputDefs.get(outputDefIndex);
                slotName = DEFAULT_SLOT_PATH_SCOPE;
                bindHints = DEFAULT_SLOT_PATH_SCOPE;
                slotPathScope = DEFAULT_SLOT_PATH_SCOPE;
                if (outputDef == null || outputDef.length == 0) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.outputDefinitionError", new Object[]{deployedTemplateComponent.getName()}));
                    continue;
                }
                slotName = outputDef[0];
                bindHints = outputDef[2];
                if (deployedRoot.isSlotPathScopeSupported) {
                    slotPathScope = outputDef[4];
                }
                if ((namedOutputs = (List)deployedRoot.outputs.get(slotName)) == null || namedOutputs.isEmpty()) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.outputDefinitionError", new Object[]{deployedTemplateComponent.getName()}));
                    continue;
                }
                for (DeployedIOR deployedOutput : namedOutputs) {
                    BComponent targetComponent;
                    Object[] choices;
                    if (deployedOutput.scope != null && !deployedOutput.scope.isEmpty()) {
                        slotPathScope = deployedOutput.scope;
                    }
                    if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                        log.log(IMPORT_LOG_LEVEL, "Output slot name = " + slotName + ", bind hints = " + bindHints + ", slot path scope = " + slotPathScope);
                    }
                    try {
                        choices = TmplUtil.findMatchingObjects(bindHints, slotPathScope, responseMessages, this.getSearchService(deployedTemplateComponent), this.getTemplateService(deployedTemplateComponent), (BComponent)templateConfig, lex);
                    }
                    catch (Exception ignored) {
                        choices = null;
                    }
                    if (choices == null || choices.length == 0) {
                        log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.outputBindingError", new Object[]{deployedTemplateComponent.getName(), slotName}));
                        continue;
                    }
                    String outputName = deployedOutput.name;
                    if (outputName == null || outputName.isEmpty()) {
                        log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.outputComponentNotFound", new Object[]{outputName, deployedTemplateComponent.getName()}));
                        continue;
                    }
                    String outputSlotName = deployedOutput.slot;
                    if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                        log.log(IMPORT_LOG_LEVEL, "Output name " + outputName + " slot " + outputSlotName);
                    }
                    if ((targetComponent = BulkDeployUtil.getNamedComponentFromChoices(choices, BulkDeployUtil.escapeSlotPathNames(outputName), BulkDeployUtil.getEscapedNameFromSlotPath(outputName))) == null) {
                        log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.outputTargetError", new Object[]{outputName, deployedTemplateComponent.getName()}));
                        continue;
                    }
                    Slot targetSlot = targetComponent.getSlot(outputSlotName);
                    if (targetSlot == null) {
                        log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.targetSlotError", new Object[]{targetComponent.getName(), deployedTemplateComponent.getName()}));
                        continue;
                    }
                    link = new BLink(deployedTemplateComponent.getHandleOrd(), slotName, outputSlotName, true);
                    targetComponent.add(null, (BValue)link);
                    targetComponent.lease(1);
                }
            }
        }
        if (deployedRoot.relations != null) {
            for (int relationIndex = 0; relationIndex < deployedRoot.relations.size(); ++relationIndex) {
                List namedRelations;
                String[] relationDef = deployedWorksheet.relationDefs.get(relationIndex);
                if (relationDef == null || relationDef.length == 0) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.relationDefinitionError", new Object[]{deployedTemplateComponent.getName()}));
                    continue;
                }
                String label = relationDef[0];
                String relationId = relationDef[1];
                String relateHints = relationDef[2];
                String direction = relationDef[3];
                String slotPathScope2 = DEFAULT_SLOT_PATH_SCOPE;
                if (deployedRoot.isSlotPathScopeSupported) {
                    slotPathScope2 = relationDef[4];
                }
                if ((namedRelations = (List)deployedRoot.relations.get(relationId + direction)) == null || namedRelations.isEmpty()) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.relationDefinitionError", new Object[]{deployedTemplateComponent.getName()}));
                    continue;
                }
                for (DeployedIOR deployedRelation : namedRelations) {
                    Object[] choices;
                    if (deployedRelation.scope != null && !deployedRelation.scope.isEmpty()) {
                        slotPathScope2 = deployedRelation.scope;
                    }
                    if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                        log.log(IMPORT_LOG_LEVEL, "Relation name = " + label + ", bind hints = " + relateHints + ", direction = " + direction + ", slot path scope = " + slotPathScope2);
                    }
                    try {
                        choices = TmplUtil.findMatchingObjects(relateHints, slotPathScope2, responseMessages, this.getSearchService(deployedTemplateComponent), this.getTemplateService(deployedTemplateComponent), (BComponent)templateConfig, lex);
                    }
                    catch (Exception ignored) {
                        choices = null;
                    }
                    if (choices == null || choices.length == 0) {
                        log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.relationBindingError", new Object[]{deployedTemplateComponent.getName(), label}));
                        continue;
                    }
                    String relationNames = deployedRelation.name;
                    HashSet<String> createdRelations = new HashSet<String>();
                    for (String relationName : relationNames.split(",")) {
                        BComponent externalComponent;
                        relationName = relationName.trim();
                        if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                            log.log(IMPORT_LOG_LEVEL, "Relation name " + relationName);
                        }
                        if ((externalComponent = BulkDeployUtil.getNamedComponentFromChoices(choices, BulkDeployUtil.escapeSlotPathNames(relationName), BulkDeployUtil.getEscapedNameFromSlotPath(relationName))) == null) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.relationComponentError", new Object[]{deployedTemplateComponent.getName(), relationName}));
                            continue;
                        }
                        String path = externalComponent.getSlotPath().getBody() + ':' + direction;
                        if (createdRelations.contains(path)) {
                            log.log(IMPORT_LOG_LEVEL, lex.getText("bulkDeploy.excelImport.duplicateRelation", new Object[]{path}));
                            continue;
                        }
                        createdRelations.add(path);
                        Id id = Id.newId((String)relationId);
                        BOrd endPointOrd = direction.equals(lex.getText("templateRelationEditor.out")) ? externalComponent.getHandleOrd() : deployedTemplateComponent.getHandleOrd();
                        BComponent relationOwner = direction.equals(lex.getText("templateRelationEditor.out")) ? deployedTemplateComponent : externalComponent;
                        BRelation newRelation = new BRelation(id, endPointOrd);
                        relationOwner.relations().add((Relation)newRelation);
                        relationOwner.lease();
                    }
                }
            }
        }
        templateConfig.subscribed();
        if (deployedRoot.configs != null) {
            BulkDeployUtil.setConfigsFromWorksheet(deployedWorksheet, deployedRoot, deployedTemplateComponent, templateConfig, whenNoValueKeepCurrent);
        }
        if (deployedRoot.optionalConfigs != null) {
            BulkDeployUtil.setOptionalConfigsFromWorksheet(deployedWorksheet, deployedRoot, deployedTemplateComponent, templateConfig, whenNoValueKeepCurrent);
        }
        if (deployedRoot.tags != null) {
            this.setTagsFromWorksheet(deployedWorksheet, deployedRoot, deployedTemplateComponent);
        }
        return responseMessages;
    }

    public static void setConfigsFromWorksheet(DeployedWorksheet deployedWorksheet, DeployedRoot deployedRoot, BComponent deployedTemplateComponent, BTemplateConfig templateConfig, boolean whenNoValueKeepCurrent) {
        BulkDeployUtil.setTemplateConfigProperty(deployedRoot.configs, deployedWorksheet.configDefs, deployedTemplateComponent, templateConfig, whenNoValueKeepCurrent);
    }

    public static void setOptionalConfigsFromWorksheet(DeployedWorksheet deployedWorksheet, DeployedRoot deployedRoot, BComponent deployedTemplateComponent, BTemplateConfig templateConfig, boolean whenNoValueKeepCurrent) {
        BulkDeployUtil.setTemplateConfigProperty(deployedRoot.optionalConfigs, deployedWorksheet.optionalConfigDefs, deployedTemplateComponent, templateConfig, whenNoValueKeepCurrent);
    }

    private static void setTemplateConfigProperty(String[] rootConfigDefs, List<String[]> deployedConfigDefs, BComponent deployedTemplateComponent, BTemplateConfig templateConfig, boolean whenNoValueKeepCurrent) {
        BStruct newInstance = null;
        String previousSlotName = DEFAULT_SLOT_PATH_SCOPE;
        for (int n = 0; n < rootConfigDefs.length; ++n) {
            String[] configDef = deployedConfigDefs.get(n);
            if (configDef == null || configDef.length == 0) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.configDefinitionError", new Object[]{deployedTemplateComponent.getName()}));
                continue;
            }
            String slotName = SlotPath.escape((String)configDef[0]);
            String slotType = configDef[2];
            String defaultValue = configDef[3];
            if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                log.log(IMPORT_LOG_LEVEL, "Configuration name = " + slotName + ", slot type = " + slotType);
            }
            String[] propertyNames = null;
            Property configProp = templateConfig.getProperty(slotName);
            if (configProp == null) {
                propertyNames = BulkDeployUtil.getPropertyNamesForConfigSlot(slotName);
                Property property = configProp = propertyNames.length > 0 ? templateConfig.getProperty(propertyNames[0]) : null;
            }
            if (configProp == null) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.configComponentError", new Object[]{deployedTemplateComponent.getName(), SlotPath.unescape((String)slotName)}));
                continue;
            }
            try {
                String configValue;
                if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                    log.log(IMPORT_LOG_LEVEL, "  Template Config Property = " + configProp.getName());
                }
                if ((configValue = rootConfigDefs[n]) == null) {
                    configValue = defaultValue;
                }
                if (configProp.getType().is(BStruct.TYPE) && !configProp.getType().is(BStatusValue.TYPE)) {
                    Property structProp;
                    TypeInfo slotTypeInfo = configProp.getType().getTypeInfo();
                    if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                        log.log(IMPORT_LOG_LEVEL, "Slot type info = " + slotTypeInfo);
                    }
                    if (!previousSlotName.contentEquals(configProp.getName())) {
                        if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                            log.log(IMPORT_LOG_LEVEL, "  Create new BStruct instance of " + slotTypeInfo.getTypeName());
                        }
                        previousSlotName = configProp.getName();
                        newInstance = (BStruct)slotTypeInfo.getInstance();
                    }
                    if (propertyNames.length > 1 && (structProp = ((BComplex)configProp.getDefaultValue()).getProperty(propertyNames[1])) != null) {
                        BValue configPropertyValue = null;
                        if (configValue != null) {
                            configPropertyValue = BulkDeployUtil.setConfigValue(structProp, configValue, slotType);
                        }
                        if (configPropertyValue == null && !whenNoValueKeepCurrent) {
                            configPropertyValue = structProp.getDefaultValue().newCopy();
                        }
                        if (configPropertyValue != null) {
                            newInstance.set(structProp.getName(), configPropertyValue);
                        }
                    }
                    templateConfig.set(configProp.getName(), newInstance);
                    continue;
                }
                BValue configPropertyValue = null;
                if (configValue != null) {
                    configPropertyValue = BulkDeployUtil.setConfigValue(configProp, configValue, slotType);
                }
                if (configPropertyValue == null && !whenNoValueKeepCurrent) {
                    configPropertyValue = configProp.getDefaultValue().newCopy();
                }
                if (configPropertyValue == null) continue;
                templateConfig.set(configProp.getName(), configPropertyValue);
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.configComponentError", new Object[]{deployedTemplateComponent.getName(), slotName}), e);
            }
        }
    }

    protected static String[] getPropertyNamesForConfigSlot(String configSlotName) {
        String[] names = SlotPath.unescape((String)configSlotName).split(SLOT_NAME_SEPARATOR_REGEX);
        for (int i = 0; i < names.length; ++i) {
            names[i] = SlotPath.escape((String)names[i]);
        }
        return names;
    }

    public void setTagsFromWorksheet(DeployedWorksheet deployedWorksheet, DeployedRoot deployedRoot, BComponent deployedTemplateComponent) {
        for (int n = 0; n < deployedRoot.tags.length; ++n) {
            String configValue;
            String[] tagDef = deployedWorksheet.tagDefs.get(n);
            if (tagDef == null || tagDef.length == 0) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.tagDefinitionError", new Object[]{deployedTemplateComponent.getName()}));
                continue;
            }
            String tagId = tagDef[0];
            String slotType = tagDef[1];
            String defaultValue = tagDef[2];
            if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                log.log(IMPORT_LOG_LEVEL, "TagId = " + tagId + ", slot type = " + slotType + ", default = " + defaultValue);
            }
            if ((configValue = deployedRoot.tags[n]) == null) {
                configValue = defaultValue;
            }
            if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                log.log(IMPORT_LOG_LEVEL, "Applying value = " + configValue);
            }
            Tag newTag = Tag.newTag((String)tagId, (String)configValue);
            if (deployedWorksheet.templateType.equals(TEMPLATE_TYPE_APPLICATION)) {
                Object[] choices;
                BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)deployedTemplateComponent);
                if (templateConfig == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.invalidTemplateError", new Object[]{deployedTemplateComponent.getName()}));
                    return;
                }
                templateConfig.lease();
                try {
                    choices = TmplUtil.findMatchingObjects(tagId, DEFAULT_SLOT_PATH_SCOPE, new ArrayList<String>(), this.getSearchService(deployedTemplateComponent), this.getTemplateService(deployedTemplateComponent), (BComponent)templateConfig, lex);
                }
                catch (Exception ignored) {
                    if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                        log.log(IMPORT_LOG_LEVEL, " No components found with tag = " + tagId);
                    }
                    choices = null;
                }
                for (Object choice : choices) {
                    if (!(choice instanceof BComponent)) continue;
                    BComponent component = (BComponent)choice;
                    component.lease();
                    if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                        log.log(IMPORT_LOG_LEVEL, " TO Entity component at = " + component.getSlotPath());
                    }
                    component.tags().set(newTag);
                }
                continue;
            }
            ComponentTreeIterator iterator = new ComponentTreeIterator(deployedTemplateComponent);
            while (iterator.hasNext()) {
                Entity entity = iterator.next();
                BComponent component = (BComponent)entity;
                if (!entity.tags().contains(newTag.getId())) continue;
                component.lease();
                if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                    log.log(IMPORT_LOG_LEVEL, " TO Entity component at = " + component.getSlotPath());
                }
                entity.tags().set(newTag);
            }
        }
    }

    public boolean templatesHaveConfigPasswords(BWbDeployableNtplFile[] files) {
        boolean hasConfigPasswords = false;
        for (BWbDeployableNtplFile file : files) {
            if (this.templateHasConfigPasswords(file)) {
                hasConfigPasswords = true;
            }
            file.closeIfOpen();
        }
        return hasConfigPasswords;
    }

    public boolean templateHasConfigPasswords(BWbDeployableNtplFile file) {
        BComponent templateBase = file.getBaseComponent();
        if (templateBase == null) {
            return false;
        }
        BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)templateBase);
        if (templateConfig == null) {
            return false;
        }
        BConfigBinding[] configBindings = templateConfig.getConfigBindings();
        if (configBindings == null) {
            return false;
        }
        for (BConfigBinding configBinding : configBindings) {
            String slotName = configBinding.getSourceSlot();
            Property configProperty = templateConfig.getProperty(slotName);
            if (configProperty == null) continue;
            if (configProperty.getType().is(BPassword.TYPE)) {
                return true;
            }
            if (!configProperty.getType().is(BStruct.TYPE) || configProperty.getType().is(BStatusValue.TYPE)) continue;
            for (Property property : ((BComplex)configProperty.getDefaultValue()).getPropertiesArray()) {
                if (!property.getType().is(BPassword.TYPE)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setComponentPosition(BComponent component, String positionStr) {
        BWsAnnotation position = BulkDeployUtil.buildWsPosition(positionStr);
        if (position == null) {
            return;
        }
        Slot wsAnnotation = component.getSlot("wsAnnotation");
        if (wsAnnotation == null) {
            component.add("wsAnnotation", (BValue)position);
        } else if (wsAnnotation.isProperty()) {
            component.set((Property)wsAnnotation, (BValue)position);
        }
    }

    private static BWsAnnotation buildWsPosition(String positionStr) {
        if (positionStr == null || positionStr.isEmpty()) {
            return null;
        }
        String[] values = positionStr.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        BWsAnnotation position = null;
        try {
            switch (values.length) {
                case 2: {
                    position = BWsAnnotation.make((int)Integer.parseInt(values[0]), (int)Integer.parseInt(values[1]));
                    break;
                }
                case 3: {
                    position = BWsAnnotation.make((int)Integer.parseInt(values[0]), (int)Integer.parseInt(values[1]), (int)Integer.parseInt(values[2]));
                    break;
                }
                case 4: {
                    position = BWsAnnotation.make((int)Integer.parseInt(values[0]), (int)Integer.parseInt(values[1]), (int)Integer.parseInt(values[2]), (int)Integer.parseInt(values[3]));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return position;
    }

    private static BValue setConfigValue(Property configProp, String configValue, String slotType) throws IOException {
        TypeInfo slotTypeInfo = Sys.getRegistry().getType(slotType);
        if (log.isLoggable(IMPORT_LOG_LEVEL)) {
            log.log(IMPORT_LOG_LEVEL, "Slot type info = " + slotTypeInfo);
        }
        BObject slotInstance = slotTypeInfo.getInstance();
        BValue configPropertyValue = null;
        if (configProp.getType().is(BStatusValue.TYPE)) {
            configPropertyValue = (BValue)slotTypeInfo.getInstance();
            if (configProp.getType().is(BStatusNumeric.TYPE)) {
                ((BStatusNumeric)configPropertyValue).setValue(Double.parseDouble(configValue));
            } else if (configProp.getType().is(BStatusBoolean.TYPE)) {
                ((BStatusBoolean)configPropertyValue).setValue(Boolean.parseBoolean(configValue.toLowerCase()));
            } else if (configProp.getType().is(BStatusString.TYPE)) {
                ((BStatusString)configPropertyValue).setValue(configValue);
            } else if (configProp.getType().is(BStatusEnum.TYPE)) {
                BValue defaultValue = configProp.getDefaultValue();
                BEnumRange range = ((BIEnum)defaultValue).getEnum().getRange();
                if (range.isNull()) {
                    ((BStatusEnum)configPropertyValue).setValue(BDynamicEnum.make((int)Double.valueOf(configValue).intValue()));
                } else {
                    BEnum selectedValue = range.get(configValue);
                    if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                        log.log(IMPORT_LOG_LEVEL, "BStatusEnum value = " + selectedValue.getTag());
                    }
                    if (selectedValue != null) {
                        ((BStatusEnum)configPropertyValue).setValue(selectedValue);
                    }
                }
            }
        } else if (configProp.getType().is(BSimple.TYPE)) {
            if (configProp.getType().is(BInteger.TYPE)) {
                String converted = Integer.toString(Double.valueOf(configValue).intValue());
                configPropertyValue = BInteger.make((String)converted);
            } else if (configProp.getType().is(BLong.TYPE)) {
                String converted = Long.toString(Double.valueOf(configValue).longValue());
                configPropertyValue = BLong.make((String)converted);
            } else if (configProp.getType().is(BBoolean.TYPE)) {
                configPropertyValue = BBoolean.make((boolean)Boolean.parseBoolean(configValue.toLowerCase()));
            } else if (configProp.getType().is(BFrozenEnum.TYPE)) {
                BEnum selectedValue = ((BIEnum)slotInstance).getEnum().getRange().get(configValue);
                if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                    log.log(IMPORT_LOG_LEVEL, "BFrozenEnum value = " + selectedValue.getTag());
                }
                configPropertyValue = (BValue)((BIEncodable)slotInstance).decodeFromString(configValue);
            } else if (configProp.getType().is(BDynamicEnum.TYPE)) {
                BValue defaultValue = configProp.getDefaultValue();
                BEnumRange range = ((BIEnum)defaultValue).getEnum().getRange();
                BEnum selectedValue = range.get(configValue);
                if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                    log.log(IMPORT_LOG_LEVEL, "BDynamicEnum value = " + selectedValue.getTag());
                }
                int selectedOrdinal = selectedValue.getOrdinal();
                configPropertyValue = BDynamicEnum.make((int)selectedOrdinal, (BEnumRange)range);
            } else {
                configPropertyValue = (BValue)((BIEncodable)slotInstance).decodeFromString(configValue);
            }
        }
        return configPropertyValue;
    }

    protected BSearchService getSearchService(BComponent base) {
        if (this.searchService != null) {
            return this.searchService;
        }
        BIService service = BulkDeployUtil.getService(BSearchService.TYPE, base);
        if (service == null) {
            return null;
        }
        this.searchService = (BSearchService)service;
        return this.searchService;
    }

    protected BTemplateService getTemplateService(BComponent base) {
        if (this.templateService != null) {
            return this.templateService;
        }
        BIService service = BulkDeployUtil.getService(BTemplateService.TYPE, base);
        if (service == null) {
            return null;
        }
        this.templateService = (BTemplateService)service;
        return this.templateService;
    }

    private static BIService getService(Type serviceType, BComponent base) {
        BComponentSpace space = base.getComponentSpace();
        if (space == null) {
            return null;
        }
        BComponent root = space.getRootComponent();
        BServiceContainer[] serviceContainer = (BServiceContainer[])root.getChildren(BServiceContainer.class);
        if (serviceContainer == null || serviceContainer.length == 0) {
            return null;
        }
        BIService[] services = (BIService[])serviceContainer[0].getChildren(serviceType.getTypeClass());
        if (services == null || services.length == 0) {
            return null;
        }
        return services[0];
    }

    private static String getCell(Row row, int cellNum) {
        String result = BulkDeployUtil.getCellOrNull(row, cellNum, false);
        if (result == null) {
            return DEFAULT_SLOT_PATH_SCOPE;
        }
        return result;
    }

    private static String getCellOrNull(Row row, int cellNum, boolean forceString) {
        Cell cell = row.getCell(cellNum);
        if (cell == null || cell.getCellType() == CellType.BLANK) {
            return null;
        }
        if (forceString && cell.getCellType() != CellType.STRING) {
            DataFormatter formatter = ExcelUtils.makeDataFormatter();
            return formatter.formatCellValue(cell);
        }
        return cell.toString();
    }

    private static boolean getCellAsBoolean(Row row, int cellNum) {
        Cell cell = row.getCell(cellNum);
        if (cell == null) {
            return false;
        }
        switch (cell.getCellType()) {
            case BLANK: 
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case NUMERIC: {
                return cell.getNumericCellValue() != 0.0;
            }
        }
        return Boolean.parseBoolean(cell.toString());
    }

    private static String getEscapedNameFromSlotPath(String name) {
        if (name == null || name.isEmpty()) {
            return DEFAULT_SLOT_PATH_SCOPE;
        }
        String[] names = name.split("/");
        return SlotPath.escape((String)names[names.length - 1]);
    }

    private static String escapeSlotPathNames(String name) {
        String[] names = name.split("/");
        StringJoiner sj = new StringJoiner("/");
        for (String node : names) {
            sj.add(SlotPath.escape((String)node));
        }
        return sj.toString();
    }

    private static BComponent getNamedComponentFromChoices(Object[] choices, String path, String name) {
        for (Object choice : choices) {
            BComponent component;
            if (!(choice instanceof BComponent) || !(component = (BComponent)choice).getSlotPath().toString().contains(path) || !component.getName().equals(name)) continue;
            return component;
        }
        return null;
    }

    public BOrdList getSelectedOptionalsFromWorkbook(BWbDeployableNtplFile applicationTemplateFile, DeployedWorksheet deployedWorksheet, DeployedRoot deployedRoot) {
        Array optionalComponentOrds = applicationTemplateFile.getTemplateManifest().optional;
        if (optionalComponentOrds.isEmpty()) {
            return BOrdList.DEFAULT;
        }
        ArrayList<BOrd> optionalOrdList = new ArrayList<BOrd>();
        String[] rootOptionals = deployedRoot.getOptionals();
        if (rootOptionals != null) {
            block0: for (int i = 0; i < rootOptionals.length; ++i) {
                String optionalInstallValue = rootOptionals[i];
                String[] optionalColumnInfo = deployedWorksheet.optionalDefs.get(i);
                if (optionalInstallValue == null) {
                    optionalInstallValue = optionalColumnInfo[2];
                }
                String optionalSlotPath = optionalColumnInfo[0];
                for (BOrd optionalComponentOrd : optionalComponentOrds) {
                    OrdQuery[] queries = optionalComponentOrd.parse();
                    SlotPath path = (SlotPath)queries[queries.length - 1];
                    if (!path.getBody().contains(optionalSlotPath)) continue;
                    if (Boolean.parseBoolean(optionalInstallValue.toLowerCase())) continue block0;
                    String[] names = path.getNames();
                    StringBuilder friendlyName = new StringBuilder(names[1]);
                    for (int j = 2; j < names.length; ++j) {
                        friendlyName.append('/').append(names[j]);
                    }
                    optionalOrdList.add(BOrd.make((OrdQuery)new SlotPath(friendlyName.toString())));
                    continue block0;
                }
            }
        }
        return BOrdList.make((BOrd[])optionalOrdList.toArray(BORDS));
    }

    private static enum TemplateType {
        COMPONENT,
        DEVICE,
        APPLICATION;

    }

    private static class StyleVault {
        private Font boldFont = null;
        private CellStyle infoCellStyle = null;
        private CellStyle instanceCellStyle = null;
        private CellStyle optionalCellStyle = null;
        private CellStyle inputCellStyle = null;
        private CellStyle outputCellStyle = null;
        private CellStyle relationCellStyle = null;
        private CellStyle configCellStyle = null;
        private CellStyle optionalConfigCellStyle = null;
        private CellStyle highlightCellStyle = null;
        private CellStyle tagCellStyle = null;
        private CellStyle dataCellStyle = null;
        private final CellStyle dataCellStyleRO = null;
        private CellStyle stringCellStyle = null;
        private final CellStyle stringCellStyleRO = null;
        private CellStyle passwordCellStyle = null;
        private final CellStyle passwordCellStyleRO = null;
        private CellStyle emptyCellStyle = null;
        private final Workbook workbook;

        StyleVault(Workbook workbook) {
            this.workbook = workbook;
        }

        CellStyle getInfoCellStyle() {
            if (this.infoCellStyle == null) {
                Font infoFont = this.workbook.createFont();
                infoFont.setBold(true);
                infoFont.setColor(ExcelUtils.getColorIndex((IndexedColors)IndexedColors.DARK_BLUE));
                this.infoCellStyle = this.workbook.createCellStyle();
                this.infoCellStyle.setFont(infoFont);
                this.infoCellStyle.setLocked(false);
            }
            return this.infoCellStyle;
        }

        CellStyle getInstanceCellStyle() {
            if (this.instanceCellStyle == null) {
                this.instanceCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.GREY_25_PERCENT));
            }
            return this.instanceCellStyle;
        }

        CellStyle getOptionalCellStyle() {
            if (this.optionalCellStyle == null) {
                this.optionalCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.GREY_40_PERCENT));
            }
            return this.optionalCellStyle;
        }

        CellStyle getInputCellStyle() {
            if (this.inputCellStyle == null) {
                this.inputCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.PALE_BLUE));
            }
            return this.inputCellStyle;
        }

        CellStyle getOutputCellStyle() {
            if (this.outputCellStyle == null) {
                this.outputCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.SKY_BLUE));
            }
            return this.outputCellStyle;
        }

        CellStyle getRelationCellStyle() {
            if (this.relationCellStyle == null) {
                this.relationCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.LIGHT_GREEN));
            }
            return this.relationCellStyle;
        }

        CellStyle getConfigCellStyle() {
            if (this.configCellStyle == null) {
                this.configCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.LIGHT_YELLOW));
            }
            return this.configCellStyle;
        }

        CellStyle getOptionalConfigCellStyle() {
            if (this.optionalConfigCellStyle == null) {
                this.optionalConfigCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.GOLD));
            }
            return this.optionalConfigCellStyle;
        }

        CellStyle getHighlightCellStyle() {
            if (this.highlightCellStyle == null) {
                this.highlightCellStyle = this.generateColorCellStyle(ExcelUtils.getColorIndex((IndexedColors)IndexedColors.GREY_25_PERCENT));
            }
            return this.highlightCellStyle;
        }

        CellStyle getTagCellStyle() {
            if (this.tagCellStyle == null) {
                this.tagCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.LEMON_CHIFFON));
            }
            return this.tagCellStyle;
        }

        CellStyle getDataCellStyle() {
            if (this.dataCellStyle == null) {
                this.dataCellStyle = this.generateDataCellStyle();
            }
            return this.dataCellStyle;
        }

        CellStyle getStringCellStyle() {
            if (this.stringCellStyle == null) {
                this.stringCellStyle = this.generateDataCellStyle();
                this.stringCellStyle.setQuotePrefixed(true);
                this.stringCellStyle.setDataFormat(ExcelUtils.getBuiltinFormat((String)"TEXT"));
            }
            return this.stringCellStyle;
        }

        CellStyle getPasswordCellStyle() {
            if (this.passwordCellStyle == null) {
                this.passwordCellStyle = this.generateDataCellStyle();
                this.passwordCellStyle.setHidden(true);
                this.passwordCellStyle.setQuotePrefixed(true);
                CreationHelper creationHelper = this.workbook.getCreationHelper();
                short formatIndex = creationHelper.createDataFormat().getFormat(";;;**");
                this.passwordCellStyle.setDataFormat(formatIndex);
            }
            return this.passwordCellStyle;
        }

        CellStyle getEmptyCellStyle() {
            if (this.emptyCellStyle == null) {
                this.emptyCellStyle = this.generateCellStyle(null, (short)0, false);
            }
            return this.emptyCellStyle;
        }

        private CellStyle generateDataCellStyle() {
            return this.generateCellStyle(null, (short)0, false);
        }

        private CellStyle generateHeaderCellStyle(Font font, short color) {
            return this.generateCellStyle(font, color, true);
        }

        private CellStyle generateCellStyle(Font font, short color, boolean header) {
            CellStyle newStyle = this.workbook.createCellStyle();
            if (font != null) {
                newStyle.setFont(font);
            }
            newStyle.setHidden(false);
            newStyle.setLocked(header);
            newStyle.setQuotePrefixed(header);
            if (color != 0) {
                newStyle.setFillForegroundColor(color);
                newStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            return newStyle;
        }

        private CellStyle generateColorCellStyle(short color) {
            CellStyle newStyle = this.workbook.createCellStyle();
            newStyle.setFillForegroundColor(color);
            newStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            return newStyle;
        }

        private Font getBoldFont() {
            if (this.boldFont == null) {
                this.boldFont = this.workbook.createFont();
                this.boldFont.setBold(true);
            }
            return this.boldFont;
        }
    }

    static class BindingProperty {
        Property property;
        BValue value;
        String name;

        BindingProperty(Property property, BValue value, String name) {
            this.property = property;
            this.value = value;
            this.name = name;
        }
    }

    static class BindingProperties {
        BConfigBinding configBinding;
        List<BindingProperty> properties;

        BindingProperties(BConfigBinding binding, BTemplateConfig templateConfig) {
            this.configBinding = binding;
            this.properties = new ArrayList<BindingProperty>();
            String slotName = this.configBinding.getSourceSlot();
            Property configProperty = templateConfig.getProperty(slotName);
            BValue configPropertyValue = templateConfig.get(slotName);
            if (configPropertyValue != null) {
                if (configProperty.getType().is(BStruct.TYPE) && !configProperty.getType().is(BStatusValue.TYPE)) {
                    Property[] structProperties;
                    for (Property structProperty : structProperties = ((BComplex)configPropertyValue).getPropertiesArray()) {
                        this.properties.add(new BindingProperty(structProperty, ((BComplex)configPropertyValue).get(structProperty), slotName + BulkDeployUtil.SLOT_NAME_SEPARATOR + structProperty.getName()));
                    }
                } else {
                    this.properties.add(new BindingProperty(configProperty, configPropertyValue, slotName));
                }
            }
        }
    }

    static class OptionalBindingProperties
    extends BindingProperties {
        BComponent parentComponent;
        String relativeSlotPath = "";

        OptionalBindingProperties(BConfigBinding binding, List<BOrd> optionalComponents, BComponent templateBase, BTemplateConfig templateConfig) {
            super(binding, templateConfig);
            Optional parentComponent = BulkDeployUtil.getComponentForOptionalConfig(binding, optionalComponents, templateBase);
            if (parentComponent.isPresent()) {
                this.parentComponent = (BComponent)parentComponent.get();
                this.relativeSlotPath = BulkDeployUtil.getRelativeSlotPathForOptionalComponent((BComponent)parentComponent.get(), templateBase);
            }
        }
    }

    public static class DeployedWorksheet {
        public String title;
        public String vendor;
        public String version;
        public BUuid uid;
        public String templateType;
        public String templateFile;
        public String templateExportVersion;
        public List<DeployedRoot> deployedRoots = new ArrayList<DeployedRoot>();
        public List<String[]> inputDefs = new ArrayList<String[]>();
        public List<String[]> outputDefs = new ArrayList<String[]>();
        public List<String[]> relationDefs = new ArrayList<String[]>();
        public List<String[]> configDefs = new ArrayList<String[]>();
        public List<String[]> optionalDefs = new ArrayList<String[]>();
        public List<String[]> optionalConfigDefs = new ArrayList<String[]>();
        public List<String[]> tagDefs = new ArrayList<String[]>();
        public boolean isSlotPathScopeSupported;
    }

    public static class DeployedRoot {
        private String parentComponentSlotPath;
        private String deployName;
        private String displayName;
        private String position;
        private List<String> deviceTarget;
        private boolean enableHistories;
        private List<DeployedIOR> inputs;
        private Map<String, List<DeployedIOR>> outputs;
        private Map<String, List<DeployedIOR>> relations;
        private String[] configs;
        private String[] optionals;
        private String[] optionalConfigs;
        private String[] tags;
        private BComponent deployedTemplate;
        private boolean isSlotPathScopeSupported;

        public void setDeployedTemplate(BComponent deployedTemplate) {
            this.deployedTemplate = deployedTemplate;
        }

        public String getParentComponentSlotPath() {
            return this.parentComponentSlotPath;
        }

        public String getDeployName() {
            return this.deployName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getPosition() {
            return this.position;
        }

        public List<String> getDeviceTarget() {
            return this.deviceTarget;
        }

        public boolean isEnableHistories() {
            return this.enableHistories;
        }

        public List<DeployedIOR> getInputs() {
            return this.inputs;
        }

        public Map<String, List<DeployedIOR>> getOutputs() {
            return this.outputs;
        }

        public Map<String, List<DeployedIOR>> getRelations() {
            return this.relations;
        }

        public String[] getConfigs() {
            return this.configs == null ? null : (String[])this.configs.clone();
        }

        public String[] getOptionals() {
            return this.optionals == null ? null : (String[])this.optionals.clone();
        }

        public String[] getOptionalConfigs() {
            return this.optionalConfigs == null ? null : (String[])this.optionalConfigs.clone();
        }

        public String[] getTags() {
            return this.tags == null ? null : (String[])this.tags.clone();
        }

        public BComponent getDeployedTemplate() {
            return this.deployedTemplate;
        }

        static /* synthetic */ String[] access$1202(DeployedRoot x0, String[] x1) {
            x0.configs = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1302(DeployedRoot x0, String[] x1) {
            x0.optionals = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1402(DeployedRoot x0, String[] x1) {
            x0.optionalConfigs = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1502(DeployedRoot x0, String[] x1) {
            x0.tags = x1;
            return x1;
        }
    }

    public static class DeployedIOR {
        public String name;
        public String slot;
        public String scope;

        DeployedIOR() {
        }
    }
}

