/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.sys.transfer.FileToFile;
import com.tridium.template.BTemplateService;
import com.tridium.template.api.NiagaraTemplate;
import com.tridium.template.file.BNewNtplFromTemporary;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.job.BMakeTemplateJob;
import com.tridium.template.ui.BTemplateOptions;
import com.tridium.template.ui.TemplateUiUtil;
import com.tridium.template.ui.file.TmplUtil;
import java.security.AccessController;
import java.util.Objects;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="template")
@NiagaraSingleton
public class BTemplateOrdScheme
extends BOrdScheme {
    @Generated
    public static final BTemplateOrdScheme INSTANCE = new BTemplateOrdScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BTemplateOrdScheme.class);
    private static final int JOB_CHECK_SLEEP_TIME = 200;

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BTemplateOrdScheme() {
        super("template");
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        BComponent target;
        String queryBody = query.getBody();
        boolean createApp = "createApp".equals(queryBody);
        if ((createApp || "create".equals(queryBody)) && (target = base.getComponent()) != null) {
            return this.buildOrdTarget(base, target, createApp);
        }
        return null;
    }

    private OrdTarget buildOrdTarget(OrdTarget base, BComponent target, boolean createApp) {
        if (target instanceof BStation) {
            BStation station = (BStation)target;
            boolean preferOnStationBuilds = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.template.preferBuildingOnStation"));
            if (preferOnStationBuilds || TmplUtil.stationHasAce(station)) {
                return this.buildTemporaryFile(base, station, createApp);
            }
        }
        return this.buildInMemoryFile(base, target, createApp);
    }

    private OrdTarget buildInMemoryFile(OrdTarget base, BComponent target, boolean createApp) {
        OrdTarget result;
        BComponentSpace sp = target.getComponentSpace();
        if (sp != null) {
            sp.update(target, Integer.MAX_VALUE);
        }
        try {
            result = createApp ? new OrdTarget(base, (BObject)TmplUtil.createInMemoryApp(target)) : new OrdTarget(base, (BObject)TmplUtil.createInMemoryNtpl(target));
        }
        catch (Exception e) {
            throw new UnresolvedException("Unable to create in memory template", (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OrdTarget buildTemporaryFile(OrdTarget base, BStation station, boolean createApp) {
        try {
            BNtplFile destFile;
            boolean templateServiceIsCapable;
            BComponentSpace space = station.getComponentSpace();
            boolean isOnline = space != null && space.isProxyComponentSpace();
            BTemplateService templateService = TemplateUiUtil.resolveTemplateService(station);
            boolean bl = templateService != null && templateService.getAction(createApp ? "makeApplicationTemplate" : "makeStationTemplate") != null ? true : (templateServiceIsCapable = false);
            if (isOnline && templateServiceIsCapable && TemplateUiUtil.isSuperUser((BComponent)station)) {
                BMakeTemplateJob job = this.startMakingTemplateInService(station, templateService, createApp);
                while (!job.getJobState().isComplete()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        if (job.getJobState().isComplete()) break;
                        throw new RuntimeException(e);
                    }
                }
                if (!BJobState.success.equals((Object)job.getJobState())) throw new UnresolvedException("Failed to create template");
                BOrd fileOrd = job.getTemplateFileOrd();
                BIFile sourceFile = (BIFile)fileOrd.get((BObject)station);
                String templateName = job.getTemplateName();
                FilePath destDirectoryPath = new FilePath("~temp");
                BDirectory destDirectory = BFileSystem.INSTANCE.makeDir(destDirectoryPath);
                String destFilename = FileToFile.getUniqueFilename((BDirectory)destDirectory, (String)(templateName + "." + (createApp ? "napl" : "ntpl")));
                destFile = (BNtplFile)BFileSystem.INSTANCE.makeFile(destDirectoryPath.merge(destFilename));
                BajaFileUtil.pipe((BIFile)sourceFile, (BIFile)destFile);
                sourceFile.delete();
            } else {
                NiagaraTemplate template = createApp ? NiagaraTemplate.createApplicationFrom((BStation)station) : NiagaraTemplate.createStationTemplateFrom((BStation)station);
                FilePath destPath = new FilePath("~temp");
                BDirectory destDirectory = BFileSystem.INSTANCE.makeDir(destPath);
                String destName = FileToFile.getUniqueFilename((BDirectory)destDirectory, (String)template.getFileName());
                destFile = (BNtplFile)template.save(destPath.merge(destName)).get();
            }
            if (destFile == null) return null;
            return new OrdTarget(base, (BObject)new BNewNtplFromTemporary(destFile));
        }
        catch (Exception e) {
            throw new UnresolvedException("Unable to create template", (Throwable)e);
        }
    }

    private BMakeTemplateJob startMakingTemplateInService(BStation station, BTemplateService templateService, boolean createApp) throws Exception {
        BOrd makeTemplateJobOrd = createApp ? templateService.makeApplicationTemplate(BBoolean.make((boolean)BTemplateOptions.get().getUseMinorVersionOnDeployment())) : templateService.makeStationTemplate(BBoolean.make((boolean)BTemplateOptions.get().getUseMinorVersionOnDeployment()));
        BComponentSpace componentSpace = Objects.requireNonNull(station.getComponentSpace());
        componentSpace.sync();
        return (BMakeTemplateJob)makeTemplateJobOrd.relativizeToSession().get((BObject)station);
    }
}

