/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.SecureIdentityException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.UserTokenPolicies;
import com.prosysopc.ua.server.NodeBuilderException;
import com.prosysopc.ua.server.ServerUserIdentity;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManagerListener;
import com.prosysopc.ua.server.UaInstantiationException;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.UaServerException;
import com.prosysopc.ua.server.UserValidator;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.core.UserTokenType;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.types.opcua.server.BuildInfoTypeNode;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.poll.BNPollScheduler;
import com.tridium.nre.firewall.IpProtocol;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.security.SecretChars;
import com.tridium.opcUaCore.BOpcTcpSecurityModes;
import com.tridium.opcUaCore.BOpcTcpSecurityPolicies;
import com.tridium.opcUaCore.BOpcUserAuthenticationMethods;
import com.tridium.opcUaCore.OpcUaSecurityMode;
import com.tridium.opcUaServer.BOpcTcpEndpoint;
import com.tridium.opcUaServer.BOpcUaBuildInfo;
import com.tridium.opcUaServer.BOpcUaNamespace;
import com.tridium.opcUaServer.BOpcUaServerDeviceFolder;
import com.tridium.opcUaServer.BOpcUaServerSessions;
import com.tridium.opcUaServer.event.BOpcUaAlarmClass;
import com.tridium.opcUaServer.event.BOpcUaAlarmRecipient;
import com.tridium.opcUaServer.util.OpcUaServerCertificateValidator;
import com.tridium.opcUaServer.util.OpcUaServerUtil;
import com.tridium.opcUaServer.util.OpcUaUserValidator;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.util.CompUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.firewall.BIpProtocolEnum;
import javax.baja.firewall.BServerPort;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.ModuleInfo;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.security.dashboard.BISecurityDashboardProvider;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BModule;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollScheduler", type="BNPollScheduler", defaultValue="new BNPollScheduler()"), @NiagaraProperty(name="opcUaServerName", type="String", defaultValue="N4OpcUaServer"), @NiagaraProperty(name="certAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", flags=4, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="opcTcpEndpoint", type="BOpcTcpEndpoint", defaultValue="new BOpcTcpEndpoint()"), @NiagaraProperty(name="userAuthenticationMethods", type="BOpcUserAuthenticationMethods", defaultValue="BOpcUserAuthenticationMethods.DEFAULT"), @NiagaraProperty(name="caCertificate", type="String", defaultValue="", flags=5, facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:UserTrustCertificateAliasFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:CertificateAliasEditor\")"), @Facet(value="BFacets.make(\"storeId\", BString.make(\"USER_TRUST_STORE\"))"), @Facet(value="BFacets.make(\"purposeId\", BString.make(\"\"))")}), @NiagaraProperty(name="minWorkerThreads", type="int", defaultValue="Math.max(8, OpcUaServerUtil.getBaseThreadCount(Runtime.getRuntime().availableProcessors()))", facets={@Facet(name="BFacets.MIN", value="Math.max(8, OpcUaServerUtil.getBaseThreadCount(Runtime.getRuntime().availableProcessors()))")}), @NiagaraProperty(name="maxSessionCount", type="int", defaultValue="500"), @NiagaraProperty(name="maxSessionTimeout", type="BRelTime", defaultValue="BRelTime.makeMinutes(5)"), @NiagaraProperty(name="maxSubcriptionCount", type="int", defaultValue="50"), @NiagaraProperty(name="maxMonitoredItemsPerSubscription", type="int", defaultValue="10000"), @NiagaraProperty(name="opcTcpConnectionAddress", type="String", defaultValue="", flags=3), @NiagaraProperty(name="serverInfo", type="BOpcUaBuildInfo", defaultValue="new BOpcUaBuildInfo()", flags=3), @NiagaraProperty(name="sessionInfo", type="BOpcUaServerSessions", defaultValue="new BOpcUaServerSessions()", flags=3)})
@NiagaraActions(value={@NiagaraAction(name="shutdown", parameterType="BInteger", defaultValue="BInteger.make(5)", flags=20), @NiagaraAction(name="restart", flags=20)})
public class BOpcUaServer
extends BNNetwork
implements SessionManagerListener,
BISecurityDashboardProviderAgent,
BISecurityDashboardProvider {
    @Generated
    public static final Property pollScheduler = BOpcUaServer.newProperty((int)0, (BValue)new BNPollScheduler(), null);
    @Generated
    public static final Property opcUaServerName = BOpcUaServer.newProperty((int)0, (String)"N4OpcUaServer", null);
    @Generated
    public static final Property certAliasAndPassword = BOpcUaServer.newProperty((int)4, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property opcTcpEndpoint = BOpcUaServer.newProperty((int)0, (BValue)new BOpcTcpEndpoint(), null);
    @Generated
    public static final Property userAuthenticationMethods = BOpcUaServer.newProperty((int)0, (BValue)BOpcUserAuthenticationMethods.DEFAULT, null);
    @Generated
    public static final Property caCertificate = BOpcUaServer.newProperty((int)5, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:UserTrustCertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"storeId", (BIDataValue)BString.make((String)"USER_TRUST_STORE"))), (BFacets)BFacets.make((String)"purposeId", (BIDataValue)BString.make((String)""))));
    @Generated
    public static final Property minWorkerThreads = BOpcUaServer.newProperty((int)0, (int)Math.max(8, OpcUaServerUtil.getBaseThreadCount(Runtime.getRuntime().availableProcessors())), (BFacets)BFacets.make((String)"min", (int)Math.max(8, OpcUaServerUtil.getBaseThreadCount(Runtime.getRuntime().availableProcessors()))));
    @Generated
    public static final Property maxSessionCount = BOpcUaServer.newProperty((int)0, (int)500, null);
    @Generated
    public static final Property maxSessionTimeout = BOpcUaServer.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), null);
    @Generated
    public static final Property maxSubcriptionCount = BOpcUaServer.newProperty((int)0, (int)50, null);
    @Generated
    public static final Property maxMonitoredItemsPerSubscription = BOpcUaServer.newProperty((int)0, (int)10000, null);
    @Generated
    public static final Property opcTcpConnectionAddress = BOpcUaServer.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property serverInfo = BOpcUaServer.newProperty((int)3, (BValue)new BOpcUaBuildInfo(), null);
    @Generated
    public static final Property sessionInfo = BOpcUaServer.newProperty((int)3, (BValue)new BOpcUaServerSessions(), null);
    @Generated
    public static final Action shutdown = BOpcUaServer.newAction((int)20, (BValue)BInteger.make((int)5), null);
    @Generated
    public static final Action restart = BOpcUaServer.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaServer.class);
    boolean debug = false;
    public UaServer server;
    private BServerPort bServerPort = new BServerPort();
    private CountDownLatch syncShutdownServerStart;
    private static final int SERVER_NORMAL_SHUTDOWN_DELAY = 5;
    private static final int SERVER_FORCED_SHUTDOWN_DELAY = 0;
    private static final int SERVER_RESTART_DELAY = 1;
    public static final String APP_NAME = "N4_OpcUaServer";
    public static final Lexicon LEX = Lexicon.make(BOpcUaServer.class);
    private static final Logger logger = Logger.getLogger("opcUaServer.server");

    @Generated
    public BNPollScheduler getPollScheduler() {
        return (BNPollScheduler)this.get(pollScheduler);
    }

    @Generated
    public void setPollScheduler(BNPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    @Generated
    public String getOpcUaServerName() {
        return this.getString(opcUaServerName);
    }

    @Generated
    public void setOpcUaServerName(String v) {
        this.setString(opcUaServerName, v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getCertAliasAndPassword() {
        return (BCertificateAliasAndPassword)this.get(certAliasAndPassword);
    }

    @Generated
    public void setCertAliasAndPassword(BCertificateAliasAndPassword v) {
        this.set(certAliasAndPassword, (BValue)v, null);
    }

    @Generated
    public BOpcTcpEndpoint getOpcTcpEndpoint() {
        return (BOpcTcpEndpoint)this.get(opcTcpEndpoint);
    }

    @Generated
    public void setOpcTcpEndpoint(BOpcTcpEndpoint v) {
        this.set(opcTcpEndpoint, (BValue)v, null);
    }

    @Generated
    public BOpcUserAuthenticationMethods getUserAuthenticationMethods() {
        return (BOpcUserAuthenticationMethods)this.get(userAuthenticationMethods);
    }

    @Generated
    public void setUserAuthenticationMethods(BOpcUserAuthenticationMethods v) {
        this.set(userAuthenticationMethods, (BValue)v, null);
    }

    @Generated
    public String getCaCertificate() {
        return this.getString(caCertificate);
    }

    @Generated
    public void setCaCertificate(String v) {
        this.setString(caCertificate, v, null);
    }

    @Generated
    public int getMinWorkerThreads() {
        return this.getInt(minWorkerThreads);
    }

    @Generated
    public void setMinWorkerThreads(int v) {
        this.setInt(minWorkerThreads, v, null);
    }

    @Generated
    public int getMaxSessionCount() {
        return this.getInt(maxSessionCount);
    }

    @Generated
    public void setMaxSessionCount(int v) {
        this.setInt(maxSessionCount, v, null);
    }

    @Generated
    public BRelTime getMaxSessionTimeout() {
        return (BRelTime)this.get(maxSessionTimeout);
    }

    @Generated
    public void setMaxSessionTimeout(BRelTime v) {
        this.set(maxSessionTimeout, (BValue)v, null);
    }

    @Generated
    public int getMaxSubcriptionCount() {
        return this.getInt(maxSubcriptionCount);
    }

    @Generated
    public void setMaxSubcriptionCount(int v) {
        this.setInt(maxSubcriptionCount, v, null);
    }

    @Generated
    public int getMaxMonitoredItemsPerSubscription() {
        return this.getInt(maxMonitoredItemsPerSubscription);
    }

    @Generated
    public void setMaxMonitoredItemsPerSubscription(int v) {
        this.setInt(maxMonitoredItemsPerSubscription, v, null);
    }

    @Generated
    public String getOpcTcpConnectionAddress() {
        return this.getString(opcTcpConnectionAddress);
    }

    @Generated
    public void setOpcTcpConnectionAddress(String v) {
        this.setString(opcTcpConnectionAddress, v, null);
    }

    @Generated
    public BOpcUaBuildInfo getServerInfo() {
        return (BOpcUaBuildInfo)this.get(serverInfo);
    }

    @Generated
    public void setServerInfo(BOpcUaBuildInfo v) {
        this.set(serverInfo, (BValue)v, null);
    }

    @Generated
    public BOpcUaServerSessions getSessionInfo() {
        return (BOpcUaServerSessions)this.get(sessionInfo);
    }

    @Generated
    public void setSessionInfo(BOpcUaServerSessions v) {
        this.set(sessionInfo, (BValue)v, null);
    }

    @Generated
    public void shutdown(BInteger parameter) {
        this.invoke(shutdown, (BValue)parameter, null);
    }

    @Generated
    public void restart() {
        this.invoke(restart, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "opcUaServer");
    }

    public void started() throws Exception {
        if (!Flags.has((BComplex)this, (Slot)certAliasAndPassword, (int)0x10000000)) {
            Flags.add((BComponent)this, (Slot)certAliasAndPassword, null, (int[])new int[]{0x10000000});
            this.setFlags((Slot)certAliasAndPassword, this.getFlags((Slot)certAliasAndPassword) & 0xFFFFFFFB);
            this.getCertAliasAndPassword().setFacets((Slot)BCertificateAliasAndPassword.alias, BFacets.make((String)"purposeId", (String)KeyPurpose.SERVER_CERT.name()));
        }
        this.initializeAlarmService();
        super.started();
        this.startServer(false);
    }

    public void stopped() throws Exception {
        if (this.server != null && this.server.isRunning()) {
            this.doShutdown(BInteger.make((int)5));
            this.bServerPort.stopped();
        }
        super.stopped();
    }

    public final AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.remove("ndriver:NDeviceManager");
        return list;
    }

    private void initializeAlarmService() {
        BComponent service = Sys.getService((Type)BAlarmService.TYPE);
        if (service instanceof BAlarmService) {
            BOpcUaAlarmClass[] children = (BOpcUaAlarmClass[])service.getChildren(BOpcUaAlarmClass.class);
            if (children == null || children.length == 0) {
                Property classProp = service.add("OpcUaAlarmClass?", (BValue)new BOpcUaAlarmClass());
                Property recipientProp = service.add("OpcUaAlarmRecipient?", (BValue)new BOpcUaAlarmRecipient());
                BOpcUaAlarmClass almClass = (BOpcUaAlarmClass)service.get(classProp);
                BOpcUaAlarmRecipient recipient = (BOpcUaAlarmRecipient)service.get(recipientProp);
                recipient.add("l?", (BValue)recipient.makeLink((BComponent)almClass, (Slot)BAlarmClass.alarm, (Slot)BAlarmRecipient.routeAlarm, null));
            }
            if (children != null && children.length != 0) {
                this.getAlarmSourceInfo().setAlarmClass(children[0].getName());
            }
        }
    }

    private void startServer(boolean isRestart) {
        if (this.getStatus().isDisabled()) {
            return;
        }
        if (Sys.getService((Type)TYPE) != this) {
            this.configFail(LEX.getText("opcUaServer.moreThanOneServer"));
            throw new IllegalStateException(LEX.getText("opcUaServer.moreThanOneServer"));
        }
        try {
            if (!this.isServerLicensed()) {
                return;
            }
            AccessController.doPrivileged(() -> {
                if (this.server != null && this.server.isRunning()) {
                    String msg = "Received server " + (isRestart ? "re" : "") + "start request when the server is already running. Shutting down the current server...";
                    logger.log(Level.INFO, msg);
                    if (isRestart) {
                        this.doShutdown(BInteger.make((int)1));
                    } else {
                        this.doShutdown(BInteger.make((int)0));
                    }
                }
                if (this.syncShutdownServerStart != null) {
                    try {
                        if (!this.syncShutdownServerStart.await(5L, TimeUnit.SECONDS)) {
                            logger.log(Level.WARNING, "Server start request timed out while waiting for the existing server to stop.");
                            return null;
                        }
                    }
                    catch (Exception e) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.SEVERE, "Exception occurred while waiting for existing server to shutdown", e);
                        }
                        logger.log(Level.SEVERE, "Exception occurred while waiting for existing server to shutdown");
                    }
                }
                if (this.server != null && this.server.isRunning()) {
                    logger.log(Level.WARNING, "Failed to shutdown the existing server. Cannot start a new server.");
                    return null;
                }
                String serverName = this.getOpcUaServerName();
                this.initialize(this.getOpcTcpEndpoint().getPort(), this.getOpcTcpEndpoint().getEnabled(), serverName.isEmpty() ? APP_NAME : serverName);
                this.server.start();
                if (this.server != null && this.server.isRunning()) {
                    this.configOk();
                    logger.log(Level.INFO, "OpcUaServer started on port " + this.server.getPort());
                }
                ApplicationIdentity applicationIdentity = this.server.getApplicationIdentity();
                ApplicationDescription applicationDescription = applicationIdentity.getApplicationDescription();
                for (String epUrls : applicationDescription.getDiscoveryUrls()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("OpcUaServer registered at endpoint: " + epUrls);
                    }
                    if (!epUrls.startsWith("opc.tcp:")) continue;
                    this.setOpcTcpConnectionAddress(epUrls);
                }
                this.createAddressSpace(isRestart);
                return null;
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred while starting server", e);
        }
    }

    private boolean isServerLicensed() {
        try {
            this.getLicenseFeature();
        }
        catch (FeatureNotLicensedException e) {
            this.setFaultCause(LEX.getText("opcUaServer.licensed"));
            return false;
        }
        return true;
    }

    public void doRestart() {
        if (this.getStatus().isDisabled()) {
            return;
        }
        if (this.server != null && this.server.isRunning()) {
            try {
                AccessController.doPrivileged(() -> {
                    this.syncShutdownServerStart = new CountDownLatch(1);
                    LocalizedText reason = new LocalizedText("OpcUaServer restarting...", Locale.ENGLISH);
                    this.server.shutdown(1, reason);
                    this.server.close();
                    this.server = null;
                    StackUtils.shutdown();
                    this.syncShutdownServerStart.countDown();
                    this.syncShutdownServerStart = null;
                    logger.log(Level.INFO, reason.getText());
                    return null;
                });
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while shutting down server", e);
            }
        }
        this.startServer(true);
    }

    public void doShutdown(BInteger delay) {
        if (this.server != null && this.server.isRunning()) {
            try {
                AccessController.doPrivileged(() -> {
                    this.syncShutdownServerStart = new CountDownLatch(1);
                    LocalizedText reason = new LocalizedText("OpcUaServer stopped", Locale.ENGLISH);
                    if (this.getStatus().isDisabled()) {
                        reason = new LocalizedText("OpcUaServer has been disabled", Locale.ENGLISH);
                    }
                    this.server.shutdown(delay.getInt(), reason);
                    this.server.close();
                    this.server = null;
                    StackUtils.shutdown();
                    this.syncShutdownServerStart.countDown();
                    this.syncShutdownServerStart = null;
                    logger.log(Level.INFO, reason.getText());
                    return null;
                });
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while shutting down server", e);
            }
        } else {
            logger.log(Level.INFO, "OpcUaServer is already shut down or closed by user");
        }
    }

    public String getNetworkName() {
        return "OpcUaServer";
    }

    public Type getDeviceFolderType() {
        return BOpcUaServerDeviceFolder.TYPE;
    }

    public Type getDeviceType() {
        return BOpcUaNamespace.TYPE;
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning() || Context.decoding.equals(cx)) {
            super.changed(p, cx);
            return;
        }
        if (p.equals(status)) {
            if (this.getStatus().isDisabled()) {
                if (this.server != null && this.server.isRunning()) {
                    this.doShutdown(BInteger.make((int)5));
                }
            } else {
                this.startServer(true);
            }
        }
        if (p.equals(userAuthenticationMethods) || p.equals(opcTcpEndpoint) || p.equals(certAliasAndPassword) || p.equals(opcUaServerName)) {
            this.doRestart();
        }
        super.changed(p, cx);
    }

    private void initialize(int port, boolean tcpEnable, String applicationName) throws SecureIdentityException, IOException, UaServerException {
        try {
            AccessController.doPrivileged(() -> {
                logger.fine("Initializing OpcUaServer...");
                if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) {
                    int adjustedNonBlockingPriority = 7;
                    int adjustedBlockingPriority = 7;
                    int adjustedSelectorPriority = 5;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("OPCUA using adjustedNonBlockingPriority = " + adjustedNonBlockingPriority);
                        logger.fine("OPCUA using adjustedBlockingPriority = " + adjustedBlockingPriority);
                        logger.fine("OPCUA using adjustedSelectorPriority = " + adjustedSelectorPriority);
                    }
                    StackUtils.setNonBlockingWorkExecutorThreadPriority((Integer)adjustedNonBlockingPriority);
                    StackUtils.setBlockingWorkExecutorThreadPriority((Integer)adjustedBlockingPriority);
                    StackUtils.setAsyncSelectorThreadPriority((Integer)adjustedSelectorPriority);
                }
                StackUtils.setBlockingWorkerThreadPoolCoreSize((int)this.getMinWorkerThreads());
                StackUtils.getBlockingWorkExecutor();
                StackUtils.getNonBlockingWorkExecutor();
                this.server = new UaServer();
                if (tcpEnable) {
                    this.bServerPort.setPublicServerPort(this.getOpcTcpEndpoint().getPort());
                    this.bServerPort.setIpProtocol(BIpProtocolEnum.make((int)IpProtocol.TCP.ordinal()));
                    this.bServerPort.setRuleHintOverride("OPCUA.server." + this.getName());
                    this.server.setPort(UaApplication.Protocol.OpcTcp, this.bServerPort.getBindingPort());
                }
                this.server.setServerName("OPCUA/" + applicationName);
                HashSet<InetAddress> bindAddresses = new HashSet<InetAddress>();
                bindAddresses.add(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}));
                this.server.setBindAddresses(bindAddresses);
                OpcUaServerCertificateValidator validator = new OpcUaServerCertificateValidator(port);
                this.server.setCertificateValidator((CertificateValidator)validator);
                ApplicationDescription appDescription = new ApplicationDescription();
                String hostName = Sys.getHostName();
                appDescription.setApplicationName(new LocalizedText(applicationName + "@" + hostName));
                appDescription.setApplicationUri("urn:" + hostName + ":OPCUA:" + applicationName);
                appDescription.setProductUri("urn:tridium.com:OPCUA:" + applicationName);
                appDescription.setApplicationType(ApplicationType.Server);
                BCertificateAliasAndPassword aliasAndPassword = this.getCertAliasAndPassword();
                ICryptoManager cryptoManager = CertManagerFactory.getInstance();
                IKeyStore keyStore = cryptoManager.getKeyStore();
                X509Certificate serverCert = keyStore.getCertificate(aliasAndPassword.getAlias());
                PrivKey privKey = new PrivKey(BOpcUaServer.getServerPrivateKey(keyStore, aliasAndPassword));
                ApplicationIdentity identity = new ApplicationIdentity(new Cert(serverCert), privKey);
                identity.setApplicationDescription(appDescription);
                this.server.setApplicationIdentity(identity);
                List securityModes = OpcUaSecurityMode.makeSecurityModes((BOpcTcpSecurityModes)this.getOpcTcpEndpoint().getSecurityMode(), (BOpcTcpSecurityPolicies)this.getOpcTcpEndpoint().getSecurityPolicies());
                this.server.getSecurityModes().addAll(securityModes);
                BOpcUserAuthenticationMethods userAuthenticationMethods = this.getUserAuthenticationMethods();
                if (userAuthenticationMethods.includes(1)) {
                    this.server.addUserTokenPolicy(UserTokenPolicies.ANONYMOUS);
                }
                if (userAuthenticationMethods.includes(2)) {
                    this.server.addUserTokenPolicy(new UserTokenPolicy("username_plain", UserTokenType.UserName, null, null, SecurityPolicy.NONE.getPolicyUri()));
                }
                if (userAuthenticationMethods.includes(4)) {
                    BOpcTcpSecurityPolicies securityPolicies = this.getOpcTcpEndpoint().getSecurityPolicies();
                    if (securityPolicies.includes(1)) {
                        this.server.addUserTokenPolicy(UserTokenPolicies.SECURE_CERTIFICATE_BASIC128RSA15);
                    }
                    if (securityPolicies.includes(4)) {
                        this.server.addUserTokenPolicy(UserTokenPolicies.SECURE_CERTIFICATE_BASIC256SHA256);
                    }
                    if (securityPolicies.includes(2)) {
                        this.server.addUserTokenPolicy(UserTokenPolicies.SECURE_CERTIFICATE_BASIC256);
                    }
                }
                this.server.setUserValidator((UserValidator)new OpcUaUserValidator(validator));
                this.server.init();
                this.initBuildInfo();
                this.server.getSessionManager().setMaxSessionCount(this.getMaxSessionCount());
                this.server.getSessionManager().setMaxSessionTimeout((double)this.getMaxSessionTimeout().getMillis());
                this.server.getSubscriptionManager().setMaxSubscriptionCount(this.getMaxSubcriptionCount());
                this.server.getSubscriptionManager().setMaxMonitoredItemsPerSubscription(this.getMaxMonitoredItemsPerSubscription());
                this.server.getSessionManager().addListener((SessionManagerListener)this);
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            logger.log(Level.SEVERE, "Exception occurred while initializing server", pae);
        }
    }

    private void createAddressSpace(boolean isRestart) throws StatusException, UaInstantiationException, NodeBuilderException {
        BOpcUaNamespace[] nodeSpaces;
        this.loadInformationModels();
        logger.fine("Creating OPCUA address space");
        for (BOpcUaNamespace nodeSpace : nodeSpaces = (BOpcUaNamespace[])CompUtil.getDescendants((BComponent)this, BOpcUaNamespace.class)) {
            try {
                nodeSpace.startNodeSpace(isRestart);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while starting node space", e);
            }
        }
    }

    private void loadInformationModels() {
    }

    private void initBuildInfo() {
        BuildInfoTypeNode buildInfo = this.server.getNodeManagerRoot().getServerData().getServerStatusNode().getBuildInfoNode();
        buildInfo.setProductName(APP_NAME);
        BModule module = Sys.getModuleForClass(BOpcUaServer.class);
        String classVersion = BModule.getClassVersion(BOpcUaServer.class).toString();
        String classVendor = BModule.getClassVendor(BOpcUaServer.class);
        buildInfo.setManufacturerName(classVendor);
        buildInfo.setSoftwareVersion(classVersion);
        int splitIndex = classVersion.lastIndexOf(".");
        String substring = classVersion.substring(splitIndex + 1);
        buildInfo.setBuildNumber(substring);
        ModuleInfo moduleInfo = module.getModuleInfo(RuntimeProfile.rt);
        if (moduleInfo instanceof NModuleInfo) {
            long buildTime = ((NModuleInfo)moduleInfo).getBuildTime();
            GregorianCalendar c = new GregorianCalendar();
            c.setTimeInMillis(buildTime);
            buildInfo.setBuildDate(DateTime.fromInstant((Instant)c.toInstant()));
        }
    }

    public boolean onActivateSession(Session session, ServerUserIdentity serverUserIdentity) throws StatusException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("onActivateSession " + session.getSessionName() + " " + serverUserIdentity.getName());
        }
        return true;
    }

    public void onActivateSessionError(Session session, UserIdentityToken userIdentityToken, Exception e) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("onActivateSessionError " + session.getSessionName() + " " + e);
        }
    }

    public void onAfterActivateSession(Session session) {
        this.getSessionInfo().addSession(session);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("onAfterActivateSession " + session.getSessionName());
        }
    }

    public void onCancelSession(Session session) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("onCancelSession " + session.getSessionName());
        }
    }

    public void onCloseSession(Session session, boolean b) {
        this.getSessionInfo().removeSession(session);
        OpcUaUserValidator.invalidateSessionForNodeId(session.getSessionId());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("onCloseSession " + session.getSessionName() + " " + b);
        }
    }

    public void onCreateSession(Session session) throws StatusException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("onCreateSession " + session.getSessionName());
        }
    }

    protected boolean useAutoManager() {
        return false;
    }

    private static RSAPrivateKey getServerPrivateKey(IKeyStore keyStore, BCertificateAliasAndPassword aliasAndPassword) throws Exception {
        if (aliasAndPassword.getPassword().isDefault()) {
            return (RSAPrivateKey)keyStore.getKey(aliasAndPassword.getAlias(), null);
        }
        try (SecretChars passwordChars = AccessController.doPrivileged(() -> ((BPassword)aliasAndPassword.getPassword()).getSecretChars());){
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyStore.getKey(aliasAndPassword.getAlias(), passwordChars.get());
            return rSAPrivateKey;
        }
    }

    public BOpcUaNamespace getNamespace(String namespaceName) {
        BOpcUaNamespace[] nodeSpaces;
        for (BOpcUaNamespace nodeSpace : nodeSpaces = (BOpcUaNamespace[])CompUtil.getDescendants((BComponent)this, BOpcUaNamespace.class)) {
            if (!namespaceName.equals(nodeSpace.getName())) continue;
            return nodeSpace;
        }
        return null;
    }

    public BOpcUaNamespace getNamespace(int namespaceIndex) {
        BOpcUaNamespace[] nodeSpaces;
        for (BOpcUaNamespace nodeSpace : nodeSpaces = (BOpcUaNamespace[])CompUtil.getDescendants((BComponent)this, BOpcUaNamespace.class)) {
            if (namespaceIndex != nodeSpace.getNamespaceIndex()) continue;
            return nodeSpace;
        }
        return null;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"opcUaServer.securityDashboard.title");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        BOpcTcpSecurityModes secMode = this.getOpcTcpEndpoint().getSecurityMode();
        BOpcTcpSecurityPolicies secPolicies = this.getOpcTcpEndpoint().getSecurityPolicies();
        BOpcUserAuthenticationMethods authenticationMethods = this.getUserAuthenticationMethods();
        if (secMode.includes(1)) {
            items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"opcUaServer.securityDashboard.SecurityModeUnsafe.none.title", (BSimple[])new BSimple[]{BString.make((String)"securityDashboard.opcuaServerSecurityModeUnsafe"), BString.make((String)secMode.toString(Context.NULL))}), (String)"opcUaServer.securityDashboard.SecurityModeUnsafe.none.description"));
        } else if (secPolicies.includes(1)) {
            items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"opcUaServer.securityDashboard.SecurityModeUnsafe.signBasic128Rsa15.title", (BSimple[])new BSimple[]{BString.make((String)"securityDashboard.opcuaServerSecurityModeUnsafe."), BString.make((String)secPolicies.toString(Context.NULL))}), (String)"opcUaServer.securityDashboard.SecurityModeUnsafe.signBasic128Rsa15.description"));
        } else {
            items.add(SecurityDashboardItem.makeOk((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"opcUaServer.securityDashboard.SecurityModeOk.title", (BSimple[])new BSimple[]{BString.make((String)"securityDashboard.opcuaServerSecurityModeUnsafe"), BString.make((String)secMode.toString(Context.NULL))}), (String)"opcUaServer.securityDashboard.SecurityModeOk.description"));
        }
        if (authenticationMethods.includes(1)) {
            items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"opcUaServer.securityDashboard.authenticationModeUnsafe.title", (BSimple[])new BSimple[]{BString.make((String)"securityDashboard.opcuaServerUserAuthenticationModeUnsafe"), BString.make((String)authenticationMethods.toString(Context.NULL))}), (String)"opcUaServer.securityDashboard.authenticationModeUnsafe.description"));
        } else {
            items.add(SecurityDashboardItem.makeOk((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"opcUaServer.securityDashboard.authenticationModeOk.title", (BSimple[])new BSimple[]{BString.make((String)"securityDashboard.opcuaServerUserAuthenticationModeUnsafe"), BString.make((String)authenticationMethods.toString(Context.NULL))}), (String)"opcUaServer.securityDashboard.authenticationModeOk.description"));
        }
        return items;
    }
}

