/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.EventManagerListener;
import com.prosysopc.ua.server.HistoryManagerListener;
import com.prosysopc.ua.server.NodeManagerListener;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServerUserIdentity;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.instantiation.NodeBuilderConfiguration;
import com.prosysopc.ua.server.instantiation.UaNodeBuilderConfiguration;
import com.prosysopc.ua.server.io.IoManagerListener;
import com.prosysopc.ua.server.nodes.CacheVariable;
import com.prosysopc.ua.server.nodes.UaVariableNode;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AccessRestrictionType;
import com.prosysopc.ua.stack.core.DataTypeIdentifiers;
import com.prosysopc.ua.stack.core.EUInformation;
import com.prosysopc.ua.stack.core.EnumValueType;
import com.prosysopc.ua.stack.core.Range;
import com.prosysopc.ua.stack.core.ReferenceTypeIdentifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.UserTokenType;
import com.prosysopc.ua.stack.core.VariableIdentifiers;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.prosysopc.ua.types.opcua.AnalogItemType;
import com.prosysopc.ua.types.opcua.BaseDataVariableType;
import com.prosysopc.ua.types.opcua.FolderType;
import com.prosysopc.ua.types.opcua.MultiStateValueDiscreteType;
import com.prosysopc.ua.types.opcua.OffNormalAlarmType;
import com.prosysopc.ua.types.opcua.TwoStateDiscreteType;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.DiscreteAlarmTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import com.prosysopc.ua.types.opcua.server.LimitAlarmTypeNode;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.opcUaCore.BOpcTcpSecurityModes;
import com.tridium.opcUaCore.BOpcUserAuthenticationMethods;
import com.tridium.opcUaCore.enums.BUaDataType;
import com.tridium.opcUaCore.units.OpcUaUnitConverter;
import com.tridium.opcUaServer.BOpcUaServer;
import com.tridium.opcUaServer.event.BOpcUaServerAlarmDeviceExt;
import com.tridium.opcUaServer.export.BIOpcExport;
import com.tridium.opcUaServer.history.OpcUaHistorian;
import com.tridium.opcUaServer.node.OpcUaIoManagerListener;
import com.tridium.opcUaServer.node.OpcUaNodeManagerListener;
import com.tridium.opcUaServer.point.BIOpcUaServerPointFolder;
import com.tridium.opcUaServer.point.BOpcUaServerPointDeviceExt;
import com.tridium.opcUaServer.point.BOpcUaServerPointFolder;
import com.tridium.opcUaServer.point.BOpcUaServerProxyExt;
import com.tridium.opcUaServer.util.OpcUaServerUtil;
import com.tridium.util.CompUtil;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75, facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_READONLY)")}, override=true), @NiagaraProperty(name="namespaceUrl", type="String", defaultValue="http://www.tridium.com/OPCUA/", flags=1), @NiagaraProperty(name="namespaceIndex", type="int", defaultValue="-1", flags=67), @NiagaraProperty(name="uaNodeId", type="String", defaultValue="", flags=67), @NiagaraProperty(name="namespaceFolderName", type="String", defaultValue="", flags=64), @NiagaraProperty(name="pointsFolderName", type="String", defaultValue="", flags=64), @NiagaraProperty(name="points", type="BOpcUaServerPointDeviceExt", defaultValue="new BOpcUaServerPointDeviceExt()"), @NiagaraProperty(name="AlarmExt", type="BOpcUaServerAlarmDeviceExt", defaultValue="new BOpcUaServerAlarmDeviceExt()", flags=1)})
public class BOpcUaNamespace
extends BNDevice {
    @Generated
    public static final Property status = BOpcUaNamespace.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl((String)"ed.ro"));
    @Generated
    public static final Property namespaceUrl = BOpcUaNamespace.newProperty((int)1, (String)"http://www.tridium.com/OPCUA/", null);
    @Generated
    public static final Property namespaceIndex = BOpcUaNamespace.newProperty((int)67, (int)-1, null);
    @Generated
    public static final Property uaNodeId = BOpcUaNamespace.newProperty((int)67, (String)"", null);
    @Generated
    public static final Property namespaceFolderName = BOpcUaNamespace.newProperty((int)64, (String)"", null);
    @Generated
    public static final Property pointsFolderName = BOpcUaNamespace.newProperty((int)64, (String)"", null);
    @Generated
    public static final Property points = BOpcUaNamespace.newProperty((int)0, (BValue)new BOpcUaServerPointDeviceExt(), null);
    @Generated
    public static final Property AlarmExt = BOpcUaNamespace.newProperty((int)1, (BValue)new BOpcUaServerAlarmDeviceExt(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaNamespace.class);
    private final Map<String, BControlPoint> controlPointsMap = new HashMap<String, BControlPoint>();
    private static final Lexicon lex = Lexicon.make(BOpcUaServer.class);
    private static final AccessLevelType AL_EXPORT = AccessLevelType.of((AccessLevelType.Options[])new AccessLevelType.Options[]{AccessLevelType.Options.CurrentRead});
    private static final AccessLevelType AL_EXPORT_HISTORY = AccessLevelType.of((AccessLevelType.Options[])new AccessLevelType.Options[]{AccessLevelType.Options.CurrentRead, AccessLevelType.Options.HistoryRead});
    private static final AccessLevelType AL_IMPORT = AccessLevelType.of((AccessLevelType.Options[])new AccessLevelType.Options[]{AccessLevelType.Options.CurrentRead, AccessLevelType.Options.CurrentWrite});
    private static final AccessLevelType AL_IMPORT_HISTORY = AccessLevelType.of((AccessLevelType.Options[])new AccessLevelType.Options[]{AccessLevelType.Options.CurrentRead, AccessLevelType.Options.CurrentWrite, AccessLevelType.Options.HistoryRead});
    private static final String NAMESPACE_URL = "http://www.tridium.com/OPCUA/";
    private final NodeManagerListener myNodeManagerListener = new OpcUaNodeManagerListener(this);
    private final OpcUaHistorian myHistorian = new OpcUaHistorian();
    private UaServer server;
    private NodeManagerUaNode uaNodeManager;
    private OpcUaIoManagerListener ioManagerListener;
    private FolderTypeNode nsRootFolder;
    private FolderTypeNode myPointsFolder;
    private final Logger logger = Logger.getLogger("opcUaServer.namespace");
    private static final int DEFAULT_PRECISION = 2;

    @Generated
    public String getNamespaceUrl() {
        return this.getString(namespaceUrl);
    }

    @Generated
    public void setNamespaceUrl(String v) {
        this.setString(namespaceUrl, v, null);
    }

    @Generated
    public int getNamespaceIndex() {
        return this.getInt(namespaceIndex);
    }

    @Generated
    public void setNamespaceIndex(int v) {
        this.setInt(namespaceIndex, v, null);
    }

    @Generated
    public String getUaNodeId() {
        return this.getString(uaNodeId);
    }

    @Generated
    public void setUaNodeId(String v) {
        this.setString(uaNodeId, v, null);
    }

    @Generated
    public String getNamespaceFolderName() {
        return this.getString(namespaceFolderName);
    }

    @Generated
    public void setNamespaceFolderName(String v) {
        this.setString(namespaceFolderName, v, null);
    }

    @Generated
    public String getPointsFolderName() {
        return this.getString(pointsFolderName);
    }

    @Generated
    public void setPointsFolderName(String v) {
        this.setString(pointsFolderName, v, null);
    }

    @Generated
    public BOpcUaServerPointDeviceExt getPoints() {
        return (BOpcUaServerPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BOpcUaServerPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public BOpcUaServerAlarmDeviceExt getAlarmExt() {
        return (BOpcUaServerAlarmDeviceExt)this.get(AlarmExt);
    }

    @Generated
    public void setAlarmExt(BOpcUaServerAlarmDeviceExt v) {
        this.set(AlarmExt, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BOpcUaServer.TYPE;
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning() || Context.decoding.equals(cx)) {
            super.changed(p, cx);
            return;
        }
        if (p.equals(status)) {
            if (!this.getStatus().isDisabled()) {
                try {
                    this.startNodeSpace(true);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Exception occurred while starting the Namespace", e);
                }
            } else {
                this.stopNodeSpace();
            }
        }
        if (p.equals(namespaceUrl)) {
            this.getOpcUaServer().doRestart();
        }
    }

    public OpcUaIoManagerListener getIoManagerListener() {
        return this.ioManagerListener;
    }

    public void started() throws Exception {
        super.started();
        this.startNodeSpace(false);
        this.getAlarmSourceInfo().setAlarmClass(this.getOpcUaServer().getAlarmSourceInfo().getAlarmClass());
    }

    public void stopped() throws Exception {
        this.stopNodeSpace();
        super.stopped();
    }

    public void stopNodeSpace() {
        this.server = this.getOpcUaServer().server;
        if (this.server == null) {
            return;
        }
        if (this.uaNodeManager == null) {
            return;
        }
        int index = this.uaNodeManager.getNamespaceIndex();
        NodeManagerTable nodeManager = this.server.getAddressSpace();
        nodeManager.removeNodeManager(index);
    }

    public void startNodeSpace(boolean isRestart) throws Exception {
        if (!this.isRunning()) {
            return;
        }
        this.server = this.getOpcUaServer().server;
        if (this.getStatus().isDisabled() || this.server == null) {
            return;
        }
        AccessController.doPrivileged(() -> {
            String namespaceUrl = isRestart || !NAMESPACE_URL.equals(this.getNamespaceUrl()) ? this.getNamespaceUrl() : this.getNamespaceUrl() + this.getName();
            this.setNamespaceUrl(namespaceUrl);
            this.uaNodeManager = new NodeManagerUaNode(this.server, namespaceUrl);
            int ns = this.uaNodeManager.getNamespaceIndex();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("NodeManager created for namespace " + namespaceUrl + " at index " + ns);
            }
            this.setNamespaceIndex(ns);
            this.uaNodeManager.addListener(this.myNodeManagerListener);
            this.ioManagerListener = new OpcUaIoManagerListener();
            this.ioManagerListener.setOpcUaNamespace(this);
            this.initializeControlPointsMap();
            this.uaNodeManager.getIoManager().addListeners(new IoManagerListener[]{this.ioManagerListener});
            this.myHistorian.init();
            this.uaNodeManager.getHistoryManager().setListener((HistoryManagerListener)this.myHistorian);
            this.getAlarmExt().init();
            this.uaNodeManager.getEventManager().setListener((EventManagerListener)this.getAlarmExt());
            FolderType objectsFolder = this.server.getNodeManagerRoot().getObjectsFolder();
            String namespaceFolderName = this.getNamespaceFolderName();
            String namespaceName = namespaceFolderName.isEmpty() ? this.getName() : namespaceFolderName;
            this.setNamespaceFolderName(namespaceName);
            NodeId myObjectsFolderId = new NodeId(ns, namespaceName);
            this.nsRootFolder = (FolderTypeNode)this.uaNodeManager.createInstance(FolderTypeNode.class, namespaceName, myObjectsFolderId);
            UaNode rootNode = this.uaNodeManager.addNodeAndReference((UaNode)objectsFolder, (UaNode)this.nsRootFolder, ReferenceTypeIdentifiers.Organizes);
            String pointsName = this.getPointsFolderName().isEmpty() ? this.getPoints().getName() : this.getPointsFolderName();
            this.setPointsFolderName(pointsName);
            NodeId myPointsFolderId = new NodeId(ns, pointsName);
            this.myPointsFolder = (FolderTypeNode)this.uaNodeManager.createInstance(FolderTypeNode.class, pointsName, myPointsFolderId);
            this.uaNodeManager.addNodeAndReference((UaNode)this.nsRootFolder, (UaNode)this.myPointsFolder, ReferenceTypeIdentifiers.Organizes);
            this.setUaNodeId(rootNode.getNodeId().toString());
            this.getPoints().setUaNodeId(myPointsFolderId.toString());
            if (Sys.atSteadyState()) {
                BOpcUaServerProxyExt[] proxyExts;
                BOpcUaServerPointFolder[] pointFolders;
                for (BOpcUaServerPointFolder pointFolder : pointFolders = (BOpcUaServerPointFolder[])CompUtil.getDescendants((BComponent)this.getPoints(), BOpcUaServerPointFolder.class)) {
                    pointFolder.updateNodeId(this.addPointsFolder(pointFolder));
                }
                for (BOpcUaServerProxyExt proxyExt : proxyExts = (BOpcUaServerProxyExt[])CompUtil.getDescendants((BComponent)this.getPoints(), BOpcUaServerProxyExt.class)) {
                    proxyExt.updateNodeId(this.addControlPoint(proxyExt));
                }
            }
            return null;
        });
    }

    public NodeManagerUaNode getUaNodeManager() {
        return this.uaNodeManager;
    }

    public void doPing() {
        this.pingOk();
    }

    public void doPoll() {
    }

    public final BOpcUaServer getOpcUaServer() {
        return (BOpcUaServer)this.getNetwork();
    }

    public String addPointsFolder(BOpcUaServerPointFolder pointFolder) {
        try {
            int ns = this.uaNodeManager.getNamespaceIndex();
            String addName = BOpcUaNamespace.getRelPathString((BComponent)this, (BComponent)pointFolder);
            NodeId myPointsFolderId = new NodeId(ns, addName);
            FolderTypeNode pointsFolder = (FolderTypeNode)this.uaNodeManager.createInstance(FolderTypeNode.class, addName, myPointsFolderId);
            UaNode uaNode = this.uaNodeManager.addNodeAndReference((UaNode)this.myPointsFolder, (UaNode)pointsFolder, ReferenceTypeIdentifiers.Organizes);
            uaNode.setDisplayName(new LocalizedText(pointFolder.getName()));
            return uaNode.getNodeId().toString();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.SEVERE, "Exception occurred while adding PointFolder", e);
            } else {
                this.logger.log(Level.SEVERE, "Exception occurred while adding PointFolder: " + e.getLocalizedMessage());
            }
            return lex.getText("namespace.error", new Object[]{e.getLocalizedMessage()});
        }
    }

    public void deletePointsFolder(BOpcUaServerPointFolder pointFolder) {
        try {
            this.deleteNode(this.uaNodeManager, pointFolder.getUaNodeId());
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.SEVERE, "Exception occurred while deleting PointFolder", e);
            }
            this.logger.log(Level.SEVERE, "Exception occurred while deleting PointFolder: " + e.getLocalizedMessage());
        }
    }

    private void deleteNode(NodeManagerUaNode nodeManagerUaNode, String uaNodeId) throws Exception {
        BOpcUaServer opcUaServer = this.getOpcUaServer();
        if (opcUaServer.server == null) {
            throw new Exception(lex.getText("namespace.error.serverNotRunning"));
        }
        NodeManagerTable addressSpace = opcUaServer.server.getAddressSpace();
        NodeId nodeId = NodeId.parseNodeId((String)uaNodeId);
        UaNode ptNode = addressSpace.getNode(nodeId);
        nodeManagerUaNode.deleteNode(ptNode, true, true);
    }

    public boolean addUaNodeHistory(String nodeId, BControlPoint point) {
        try {
            BOpcUaServer opcUaServer = this.getOpcUaServer();
            if (opcUaServer.server == null) {
                throw new Exception(lex.getText("namespace.error.serverNotRunning"));
            }
            NodeManagerTable addressSpace = opcUaServer.server.getAddressSpace();
            UaNode node = addressSpace.getNode(NodeId.parseNodeId((String)nodeId));
            boolean historizing = this.checkAddHistory((UaVariableNode)node, point);
            BOpcUaNamespace.checkAddAccessLevel((UaVariableNode)node, point, historizing);
            return true;
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.SEVERE, "Exception occurred while adding HistoryExt to UaNode", e);
            } else {
                this.logger.log(Level.SEVERE, "Exception occurred while adding HistoryExt to UaNode: " + e.getLocalizedMessage());
            }
            return false;
        }
    }

    public boolean removeUaNodeHistory(String nodeId, BControlPoint point) {
        try {
            BOpcUaServer opcUaServer = this.getOpcUaServer();
            if (opcUaServer.server == null) {
                throw new Exception(lex.getText("namespace.error.serverNotRunning"));
            }
            NodeManagerTable addressSpace = opcUaServer.server.getAddressSpace();
            UaNode node = addressSpace.getNode(NodeId.parseNodeId((String)nodeId));
            boolean historizing = this.checkRemoveHistory((UaVariableNode)node, point);
            BOpcUaNamespace.checkAddAccessLevel((UaVariableNode)node, point, historizing);
            return historizing;
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.SEVERE, "Exception occurred while removing HistoryExt from UaNode", e);
            } else {
                this.logger.log(Level.SEVERE, "Exception occurred while removing HistoryExt from UaNode: " + e.getLocalizedMessage());
            }
            return false;
        }
    }

    public boolean addUaNodeCondition(String nodeId, BControlPoint point) {
        try {
            BOpcUaServer opcUaServer = this.getOpcUaServer();
            if (opcUaServer.server == null) {
                throw new Exception(lex.getText("namespace.error.serverNotRunning"));
            }
            NodeManagerTable addressSpace = opcUaServer.server.getAddressSpace();
            UaNode node = addressSpace.getNode(NodeId.parseNodeId((String)nodeId));
            this.checkAddCondition((UaVariableNode)node, point);
            return true;
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.SEVERE, "Exception occurred while adding NodeCondition", e);
            } else {
                this.logger.log(Level.SEVERE, "Exception occurred while adding NodeCondition: " + e.getLocalizedMessage());
            }
            return false;
        }
    }

    public boolean removeUaNodeCondition(String nodeId, BControlPoint point) {
        try {
            BOpcUaServer opcUaServer = this.getOpcUaServer();
            if (opcUaServer.server == null) {
                throw new Exception(lex.getText("namespace.error.serverNotRunning"));
            }
            NodeManagerTable addressSpace = opcUaServer.server.getAddressSpace();
            UaNode node = addressSpace.getNode(NodeId.parseNodeId((String)nodeId));
            return this.checkRemoveCondition((UaVariableNode)node);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.SEVERE, "Exception occurred while removing NodeCondition", e);
            } else {
                this.logger.log(Level.SEVERE, "Exception occurred while removing NodeCondition: " + e.getLocalizedMessage());
            }
            return false;
        }
    }

    public String addControlPoint(BOpcUaServerProxyExt proxyExt) {
        try {
            BIPointFolder iPointFolder;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Adding point: " + proxyExt.getParentPoint().getDisplayName(null) + " to node space");
            }
            if ((iPointFolder = proxyExt.getParentPointFolder()) instanceof BIOpcUaServerPointFolder) {
                String uaNodeId = ((BIOpcUaServerPointFolder)iPointFolder).getUaNodeId();
                BOpcUaServer opcUaServer = this.getOpcUaServer();
                if (opcUaServer.server == null) {
                    return lex.getText("namespace.error.serverNotRunning");
                }
                NodeManagerTable addressSpace = opcUaServer.server.getAddressSpace();
                NodeId nodeId = NodeId.parseNodeId((String)uaNodeId);
                FolderTypeNode uaFolder = (FolderTypeNode)addressSpace.getNode(nodeId);
                if (proxyExt.isNumeric()) {
                    return this.addNumericPoint(uaFolder, proxyExt);
                }
                if (proxyExt.isBoolean()) {
                    return this.addBooleanPoint(uaFolder, proxyExt);
                }
                if (proxyExt.isEnum()) {
                    return this.addEnumPoint(uaFolder, proxyExt);
                }
                if (proxyExt.isString()) {
                    return this.addStringPoint(uaFolder, proxyExt);
                }
                return lex.getText("namespace.error.invalidPointType");
            }
            return lex.getText("namespace.error.invalidParentPointFolder");
        }
        catch (Exception e) {
            return lex.getText("namespace.error", new Object[]{e.getLocalizedMessage()});
        }
    }

    public void deleteControlPoint(BOpcUaServerProxyExt proxyExt) {
        try {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Removing point: " + proxyExt.getParentPoint().getDisplayName(null) + " from node space");
            }
            this.deleteNode(this.uaNodeManager, proxyExt.getUaNodeId());
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.SEVERE, "Exception occurred while deleting point", e);
            }
            this.logger.log(Level.SEVERE, "Exception occurred while deleting point: " + e.getLocalizedMessage());
        }
    }

    private String addNumericPoint(FolderTypeNode uaFolder, BOpcUaServerProxyExt proxyExt) {
        try {
            BControlPoint parentPoint = proxyExt.getParentPoint();
            String addName = BOpcUaNamespace.getRelPathString((BComponent)this, (BComponent)parentPoint);
            NodeBuilderConfiguration conf = new NodeBuilderConfiguration();
            conf.addOptional(VariableIdentifiers.BaseAnalogType_EngineeringUnits);
            conf.addOptional(new ExpandedNodeId("http://opcfoundation.org/UA/", VariableIdentifiers.BaseAnalogType_InstrumentRange.getValue()));
            conf.addOptional("Definition");
            AnalogItemType node = (AnalogItemType)this.uaNodeManager.createNodeBuilder(AnalogItemType.class, (UaNodeBuilderConfiguration)conf).setName(addName).build();
            node.setDefinition("NumericControlPoint");
            boolean historizing = this.checkAddHistory((UaVariableNode)node, parentPoint);
            BOpcUaNamespace.checkAddAccessLevel((UaVariableNode)node, parentPoint, historizing);
            this.checkAddCondition((UaVariableNode)node, parentPoint);
            BOpcUaNamespace.setTypeValueAndRangeForAnalogType(node, proxyExt.getUaDataType(), (BStatusNumeric)parentPoint.getOutStatusValue());
            UaNode uaNode = this.uaNodeManager.addNodeAndReference((UaNode)uaFolder, (UaNode)node, ReferenceTypeIdentifiers.Organizes);
            return this.getUpdatedNodeIdOfProxyExt(uaNode, proxyExt);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.SEVERE, "Exception occurred while adding numeric point", e);
            } else {
                this.logger.log(Level.SEVERE, "Exception occurred while adding numeric point: " + e.getLocalizedMessage());
            }
            return lex.getText("namespace.error", new Object[]{e.getLocalizedMessage()});
        }
    }

    public void setNumericFacets(BOpcUaServerProxyExt proxyExt) throws StatusException {
        String unitName;
        AnalogItemType node = (AnalogItemType)this.uaNodeManager.getNode(NodeId.parseNodeId((String)proxyExt.getUaNodeId()));
        BFacets deviceFacets = proxyExt.getDeviceFacets();
        BFacets defaultFacets = OpcUaServerUtil.getMinMaxFacets(proxyExt.getUaDataType(), deviceFacets);
        BUnit units = (BUnit)defaultFacets.get("units");
        BDouble min = (BDouble)defaultFacets.get("min");
        BDouble max = (BDouble)defaultFacets.get("max");
        if (units != null && (unitName = units.getUnitName()) != null) {
            int unitId = OpcUaUnitConverter.getDefault().getOpcUaUnitIdFromQudtCode(units.getQudtName());
            String unitDescription = unitName;
            if (unitId != -1) {
                unitDescription = OpcUaUnitConverter.getDefault().getUnitDescriptionFromQudtCode(units.getQudtName());
            }
            node.setEngineeringUnits(new EUInformation(this.getNamespaceUrl(), Integer.valueOf(unitId), new LocalizedText(unitName, LocalizedText.NO_LOCALE), new LocalizedText(unitDescription, LocalizedText.NO_LOCALE)));
        }
        node.setEURange(new Range(Double.valueOf(min.getDouble()), Double.valueOf(max.getDouble())));
    }

    private String addBooleanPoint(FolderTypeNode uaFolder, BOpcUaServerProxyExt proxyExt) {
        try {
            BControlPoint parentPoint = proxyExt.getParentPoint();
            String addName = BOpcUaNamespace.getRelPathString((BComponent)this, (BComponent)parentPoint);
            BFacets pointFacets = parentPoint.getFacets();
            NodeBuilderConfiguration conf = new NodeBuilderConfiguration();
            conf.addOptional(VariableIdentifiers.TwoStateDiscreteType_FalseState);
            conf.addOptional(VariableIdentifiers.TwoStateDiscreteType_TrueState);
            conf.addOptional("Definition");
            TwoStateDiscreteType node = (TwoStateDiscreteType)this.uaNodeManager.createNodeBuilder(TwoStateDiscreteType.class, (UaNodeBuilderConfiguration)conf).setName(addName).build();
            boolean historizing = this.checkAddHistory((UaVariableNode)node, parentPoint);
            BOpcUaNamespace.checkAddAccessLevel((UaVariableNode)node, parentPoint, historizing);
            this.checkAddCondition((UaVariableNode)node, parentPoint);
            node.setDefinition("BooleanControlPoint");
            String trueText = pointFacets.gets("trueText", "");
            String falseText = pointFacets.gets("falseText", "");
            if (!trueText.isEmpty()) {
                node.setTrueState(new LocalizedText(trueText, Locale.ENGLISH));
            }
            if (!falseText.isEmpty()) {
                node.setFalseState(new LocalizedText(falseText, Locale.ENGLISH));
            }
            node.setValue(new DataValue(new Variant((Object)((BIBoolean)parentPoint.getOutStatusValue()).getBoolean()), StatusCode.GOOD));
            UaNode uaNode = this.uaNodeManager.addNodeAndReference((UaNode)uaFolder, (UaNode)node, ReferenceTypeIdentifiers.Organizes);
            return this.getUpdatedNodeIdOfProxyExt(uaNode, proxyExt);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.SEVERE, "Exception occurred while adding boolean point", e);
            } else {
                this.logger.log(Level.SEVERE, "Exception occurred while adding boolean point: " + e.getLocalizedMessage());
            }
            return lex.getText("namespace.error", new Object[]{e.getLocalizedMessage()});
        }
    }

    private String addEnumPoint(FolderTypeNode uaFolder, BOpcUaServerProxyExt proxyExt) {
        try {
            BControlPoint parentPoint = proxyExt.getParentPoint();
            String addName = BOpcUaNamespace.getRelPathString((BComponent)this, (BComponent)parentPoint);
            BFacets pointFacets = parentPoint.getFacets();
            NodeBuilderConfiguration conf = new NodeBuilderConfiguration();
            conf.addOptional(VariableIdentifiers.MultiStateValueDiscreteType_EnumValues);
            conf.addOptional("Definition");
            MultiStateValueDiscreteType node = (MultiStateValueDiscreteType)this.uaNodeManager.createNodeBuilder(MultiStateValueDiscreteType.class, (UaNodeBuilderConfiguration)conf).setName(addName).build();
            boolean historizing = this.checkAddHistory((UaVariableNode)node, parentPoint);
            BOpcUaNamespace.checkAddAccessLevel((UaVariableNode)node, parentPoint, historizing);
            this.checkAddCondition((UaVariableNode)node, parentPoint);
            node.setDefinition("EnumControlPoint");
            BObject bObject = pointFacets.get("range");
            if (bObject instanceof BEnumRange) {
                BEnumRange eRange = (BEnumRange)bObject;
                Type frozenType = eRange.getFrozenType();
                if (frozenType != null) {
                    BFrozenEnum instance = (BFrozenEnum)frozenType.getInstance();
                    eRange = instance.getRange();
                }
                int[] ordinals = eRange.getOrdinals();
                String[] tags = new String[ordinals.length];
                EnumValueType[] ltArray = new EnumValueType[tags.length];
                for (int i = 0; i < ordinals.length; ++i) {
                    tags[i] = eRange.getTag(ordinals[i]);
                    String tagName = eRange.getDisplayTag(ordinals[i], Context.NULL);
                    ltArray[i] = new EnumValueType(Long.valueOf(ordinals[i]), new LocalizedText(tags[i], Locale.getDefault()), new LocalizedText(tagName, Locale.getDefault()));
                }
                if (ltArray.length > 0) {
                    node.setEnumValues(ltArray);
                }
            }
            node.setValue(new DataValue(new Variant((Object)((BIEnum)parentPoint.getOutStatusValue()).getEnum().getOrdinal()), StatusCode.GOOD));
            UaNode uaNode = this.uaNodeManager.addNodeAndReference((UaNode)uaFolder, (UaNode)node, ReferenceTypeIdentifiers.Organizes);
            return this.getUpdatedNodeIdOfProxyExt(uaNode, proxyExt);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.SEVERE, "Exception occurred while adding enum point", e);
            } else {
                this.logger.log(Level.SEVERE, "Exception occurred while adding enum point: " + e.getLocalizedMessage());
            }
            return lex.getText("namespace.error", new Object[]{e.getLocalizedMessage()});
        }
    }

    private String addStringPoint(FolderTypeNode uaFolder, BOpcUaServerProxyExt proxyExt) {
        try {
            UaNode uaNode;
            BControlPoint parentPoint = proxyExt.getParentPoint();
            BStatusString outStatusValue = (BStatusString)parentPoint.getOutStatusValue();
            String addName = BOpcUaNamespace.getRelPathString((BComponent)this, (BComponent)parentPoint);
            NodeId nodeId = new NodeId(this.getNamespaceIndex(), addName);
            NodeBuilderConfiguration conf = new NodeBuilderConfiguration();
            conf.addOptional("Definition");
            if (BUaDataType.ByteString.equals((Object)proxyExt.getUaDataType())) {
                BaseDataVariableType node = (BaseDataVariableType)this.uaNodeManager.createNodeBuilder(BaseDataVariableType.class, (UaNodeBuilderConfiguration)conf).setName(addName).build();
                boolean historizing = this.checkAddHistory((UaVariableNode)node, parentPoint);
                BOpcUaNamespace.checkAddAccessLevel((UaVariableNode)node, parentPoint, historizing);
                this.checkAddCondition((UaVariableNode)node, parentPoint);
                node.setDataTypeId(DataTypeIdentifiers.ByteString);
                node.setValue(new DataValue(new Variant((Object)ByteString.fromHex((String)outStatusValue.getValue())), StatusCode.GOOD));
                uaNode = this.uaNodeManager.addNodeAndReference((UaNode)uaFolder, (UaNode)node, ReferenceTypeIdentifiers.Organizes);
            } else if (BUaDataType.LocalizedText.equals((Object)proxyExt.getUaDataType())) {
                BaseDataVariableType node = (BaseDataVariableType)this.uaNodeManager.createNodeBuilder(BaseDataVariableType.class, (UaNodeBuilderConfiguration)conf).setName(addName).build();
                boolean historizing = this.checkAddHistory((UaVariableNode)node, parentPoint);
                BOpcUaNamespace.checkAddAccessLevel((UaVariableNode)node, parentPoint, historizing);
                this.checkAddCondition((UaVariableNode)node, parentPoint);
                node.setDataTypeId(DataTypeIdentifiers.LocalizedText);
                node.setValue(new DataValue(new Variant((Object)new LocalizedText(outStatusValue.getValue(), Locale.getDefault())), StatusCode.GOOD));
                uaNode = this.uaNodeManager.addNodeAndReference((UaNode)uaFolder, (UaNode)node, ReferenceTypeIdentifiers.Organizes);
            } else if (BUaDataType.String.equals((Object)proxyExt.getUaDataType())) {
                BaseDataVariableType node = (BaseDataVariableType)this.uaNodeManager.createNodeBuilder(BaseDataVariableType.class, (UaNodeBuilderConfiguration)conf).setName(addName).build();
                boolean historizing = this.checkAddHistory((UaVariableNode)node, parentPoint);
                BOpcUaNamespace.checkAddAccessLevel((UaVariableNode)node, parentPoint, historizing);
                this.checkAddCondition((UaVariableNode)node, parentPoint);
                node.setDataTypeId(DataTypeIdentifiers.String);
                node.setValue(new DataValue(new Variant((Object)outStatusValue.getValue()), StatusCode.GOOD));
                uaNode = this.uaNodeManager.addNodeAndReference((UaNode)uaFolder, (UaNode)node, ReferenceTypeIdentifiers.Organizes);
            } else {
                CacheVariable node = new CacheVariable(this.uaNodeManager, nodeId, addName, Locale.ENGLISH);
                boolean historizing = this.checkAddHistory((UaVariableNode)node, parentPoint);
                BOpcUaNamespace.checkAddAccessLevel((UaVariableNode)node, parentPoint, historizing);
                this.checkAddCondition((UaVariableNode)node, parentPoint);
                node.setDataTypeId(DataTypeIdentifiers.String);
                node.setValue(new DataValue(new Variant((Object)outStatusValue.getValue()), StatusCode.GOOD));
                uaNode = this.uaNodeManager.addNodeAndReference((UaNode)uaFolder, (UaNode)node, ReferenceTypeIdentifiers.Organizes);
            }
            return this.getUpdatedNodeIdOfProxyExt(uaNode, proxyExt);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.SEVERE, "Exception occurred while adding string point", e);
            } else {
                this.logger.log(Level.SEVERE, "Exception occurred while adding string point: " + e.getLocalizedMessage());
            }
            return lex.getText("namespace.error", new Object[]{e.getLocalizedMessage()});
        }
    }

    public void pointFacetsChanged(BOpcUaServerProxyExt proxyExt) {
        try {
            BControlPoint parentPoint = proxyExt.getParentPoint();
            BFacets pointFacets = parentPoint.getFacets();
            BFacets deviceFacets = proxyExt.getDeviceFacets();
            BOpcUaServer opcUaServer = this.getOpcUaServer();
            if (opcUaServer.server == null) {
                this.logger.severe(lex.getText("namespace.error.serverNotRunning"));
                return;
            }
            NodeManagerTable addressSpace = opcUaServer.server.getAddressSpace();
            NodeId nodeId = NodeId.parseNodeId((String)proxyExt.getUaNodeId());
            UaNode ptNode = addressSpace.getNode(nodeId);
            if (proxyExt.isNumeric() && ptNode instanceof AnalogItemType) {
                this.validateAndSetPointNumericFacets(parentPoint, proxyExt, pointFacets, deviceFacets);
            } else if (proxyExt.isBoolean() && ptNode instanceof TwoStateDiscreteType) {
                TwoStateDiscreteType node = (TwoStateDiscreteType)ptNode;
                String trueText = pointFacets.gets("trueText", "");
                String falseText = pointFacets.gets("falseText", "");
                if (!trueText.isEmpty()) {
                    node.setTrueState(new LocalizedText(trueText, Locale.ENGLISH));
                }
                if (!falseText.isEmpty()) {
                    node.setFalseState(new LocalizedText(falseText, Locale.ENGLISH));
                }
            } else if (proxyExt.isEnum() && ptNode instanceof MultiStateValueDiscreteType) {
                MultiStateValueDiscreteType node = (MultiStateValueDiscreteType)ptNode;
                BObject bObject = pointFacets.get("range");
                if (bObject instanceof BEnumRange) {
                    BEnumRange eRange = (BEnumRange)bObject;
                    Type frozenType = eRange.getFrozenType();
                    if (frozenType != null) {
                        BFrozenEnum instance = (BFrozenEnum)frozenType.getInstance();
                        eRange = instance.getRange();
                    }
                    int[] ordinals = eRange.getOrdinals();
                    String[] tags = new String[ordinals.length];
                    EnumValueType[] ltArray = new EnumValueType[tags.length];
                    for (int i = 0; i < ordinals.length; ++i) {
                        tags[i] = eRange.getTag(ordinals[i]);
                        String tagName = eRange.getDisplayTag(ordinals[i], Context.NULL);
                        ltArray[i] = new EnumValueType(Long.valueOf(ordinals[i]), new LocalizedText(tags[i], Locale.getDefault()), new LocalizedText(tagName, Locale.getDefault()));
                    }
                    node.setEnumValues(ltArray);
                }
            }
        }
        catch (Exception e) {
            this.logger.severe(lex.getText("namespace.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    private void validateAndSetPointNumericFacets(BControlPoint parentPoint, BOpcUaServerProxyExt proxyExt, BFacets pointFacets, BFacets deviceFacets) {
        BUnit pntUnit = (BUnit)pointFacets.get("units");
        BUnit devUnit = (BUnit)deviceFacets.get("units");
        if (pntUnit != null && devUnit != null && pntUnit.isConvertible(devUnit)) {
            BFacets defaultFacets = OpcUaServerUtil.getMinMaxFacets(proxyExt.getUaDataType(), BFacets.makeNumeric());
            BNumber curDevMin = (BNumber)deviceFacets.get("min", defaultFacets.get("min"));
            double devMin = curDevMin != BFloat.NEGATIVE_INFINITY ? devUnit.convertTo(pntUnit, curDevMin.getNumeric()) : ((BDouble)defaultFacets.get("min")).getDouble();
            BNumber curDevMax = (BNumber)deviceFacets.get("max", defaultFacets.get("max"));
            double devMax = curDevMax != BFloat.POSITIVE_INFINITY ? (double)((float)devUnit.convertTo(pntUnit, curDevMax.getNumeric())) : ((BDouble)defaultFacets.get("max")).getDouble();
            double newMin = ((BNumber)pointFacets.get("min", defaultFacets.get("min"))).getDouble();
            double newMax = ((BNumber)pointFacets.get("max", defaultFacets.get("max"))).getDouble();
            double min = Math.max(newMin, devMin);
            double max = Math.min(newMax, devMax);
            if (min != newMin || max != newMax) {
                BInteger p = (BInteger)deviceFacets.get("precision", defaultFacets.get("precision"));
                int precision = p == null ? 2 : p.getInt();
                BFacets f = BFacets.makeNumeric((BUnit)pntUnit, (int)precision, (double)min, (double)max);
                parentPoint.setFacets(f);
            }
        }
    }

    private boolean checkAddHistory(UaVariableNode node, BControlPoint point) {
        BHistoryExt historyExt = OpcUaServerUtil.getPointHistoryExt(point);
        if (historyExt == null) {
            return false;
        }
        HistoryManagerListener historian = this.uaNodeManager.getHistoryManager().getListener();
        if (historian instanceof OpcUaHistorian) {
            ((OpcUaHistorian)historian).addVariableHistory(node, historyExt);
        }
        return true;
    }

    private boolean checkRemoveHistory(UaVariableNode node, BControlPoint point) {
        HistoryManagerListener historian = this.uaNodeManager.getHistoryManager().getListener();
        if (historian instanceof OpcUaHistorian) {
            ((OpcUaHistorian)historian).removeVariableHistory(node);
        }
        return false;
    }

    private boolean checkAddCondition(UaVariableNode source, BControlPoint point) {
        Class<LimitAlarmTypeNode> alarmTypeClass;
        BAlarmSourceExt alarmExt = OpcUaServerUtil.getPointAlarmExt(point);
        if (alarmExt == null) {
            return false;
        }
        int ns = this.getNamespaceIndex();
        NodeId myAlarmId = new NodeId(ns, source.getNodeId().getValue() + ".Alarm");
        String name = source.getBrowseName().getName() + "Alarm";
        if (point instanceof BNumericPoint) {
            alarmTypeClass = LimitAlarmTypeNode.class;
        } else if (point instanceof BBooleanPoint) {
            alarmTypeClass = OffNormalAlarmType.class;
        } else if (point instanceof BEnumPoint) {
            alarmTypeClass = DiscreteAlarmTypeNode.class;
        } else if (point instanceof BStringPoint) {
            alarmTypeClass = OffNormalAlarmType.class;
        } else {
            return false;
        }
        AlarmConditionTypeNode myAlarm = OpcUaServerUtil.createAlarmTypeInstance(this.uaNodeManager, alarmTypeClass, name, myAlarmId);
        if (myAlarm == null) {
            return false;
        }
        myAlarm.setSource((UaNode)source);
        myAlarm.setInput((UaVariable)source);
        myAlarm.setSeverity(500);
        myAlarm.setEnabled(true);
        source.addComponent((UaNode)myAlarm);
        source.addReference((UaNode)myAlarm, ReferenceTypeIdentifiers.HasCondition, false);
        this.myPointsFolder.addReference((UaNode)source, ReferenceTypeIdentifiers.HasEventSource, false);
        this.nsRootFolder.addReference((UaNode)this.myPointsFolder, ReferenceTypeIdentifiers.HasNotifier, false);
        EventManagerListener eventManager = this.uaNodeManager.getEventManager().getListener();
        if (eventManager instanceof BOpcUaServerAlarmDeviceExt) {
            ((BOpcUaServerAlarmDeviceExt)eventManager).addAlarmPoint(myAlarm, point);
        }
        return true;
    }

    private boolean checkRemoveCondition(UaVariableNode node) {
        UaNode conditionNode;
        UaReference reference;
        EventManagerListener eventManager = this.uaNodeManager.getEventManager().getListener();
        if (eventManager instanceof BOpcUaServerAlarmDeviceExt && (reference = node.getReference(ReferenceTypeIdentifiers.HasCondition, false)) != null && (conditionNode = reference.getOppositeNode((UaNode)node)) instanceof AlarmConditionTypeNode) {
            ((BOpcUaServerAlarmDeviceExt)eventManager).removeAlarmPoint((AlarmConditionTypeNode)conditionNode);
        }
        return false;
    }

    private static void checkAddAccessLevel(UaVariableNode node, BControlPoint point, boolean historizing) {
        if (point instanceof BIOpcExport) {
            if (historizing) {
                node.setAccessLevel(AL_EXPORT_HISTORY);
                node.setUserAccessLevel(AL_EXPORT_HISTORY);
            } else {
                node.setAccessLevel(AL_EXPORT);
                node.setUserAccessLevel(AL_EXPORT);
            }
        } else if (historizing) {
            node.setAccessLevel(AL_IMPORT_HISTORY);
            node.setUserAccessLevel(AL_IMPORT_HISTORY);
        } else {
            node.setAccessLevel(AL_IMPORT);
            node.setUserAccessLevel(AL_IMPORT);
        }
    }

    private String getUpdatedNodeIdOfProxyExt(UaNode uaNode, BOpcUaServerProxyExt proxyExt) {
        String uaNodeId = uaNode.getNodeId().toString().substring(0, uaNode.getNodeId().toString().indexOf("=") + 1) + this.getNamespaceIndex() + uaNode.getNodeId().toString().substring(uaNode.getNodeId().toString().indexOf(";"));
        proxyExt.setUaNodeId(uaNodeId);
        return uaNodeId;
    }

    private static String getRelPathString(BComponent root, BComponent leaf) {
        String path = leaf.getSlotPath().toString();
        String rootPath = root.getSlotPath().toString();
        return path.substring(rootPath.length() + 1);
    }

    private void initializeControlPointsMap() {
        BControlPoint[] controlPoints;
        for (BControlPoint controlPoint : controlPoints = this.getPoints().getPoints()) {
            if (this.controlPointsMap.containsKey(((BOpcUaServerProxyExt)controlPoint.getProxyExt()).getUaNodeId())) continue;
            this.controlPointsMap.put(((BOpcUaServerProxyExt)controlPoint.getProxyExt()).getUaNodeId(), controlPoint);
        }
    }

    public BStatus getControlPointStatus(NodeId nodeId) {
        BControlPoint controlPoint = this.controlPointsMap.get(nodeId.toString());
        if (controlPoint != null) {
            return controlPoint.getStatus();
        }
        BControlPoint[] allPointsInServerDatabase = this.getPoints().getPoints();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Node ID: " + nodeId + " not found in subscribed control points map.");
            this.logger.log(Level.FINE, "Searching for it in the entire server database.");
        }
        for (BControlPoint point : allPointsInServerDatabase) {
            if (!nodeId.toString().equals(((BOpcUaServerProxyExt)point.getProxyExt()).getUaNodeId())) continue;
            return point.getStatus();
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Node ID: " + nodeId + " not found.");
        }
        return null;
    }

    public void addPointToControlPointsMap(BOpcUaServerProxyExt proxyExt) {
        BControlPoint controlPoint = proxyExt.getParentPoint();
        if (!this.controlPointsMap.containsKey(proxyExt.getUaNodeId())) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Adding proxy ext, Node ID: " + proxyExt.getUaNodeId() + ", to subscribed points map");
            }
            this.controlPointsMap.put(proxyExt.getUaNodeId(), controlPoint);
        }
    }

    public void removePointFromControlPointsMap(BOpcUaServerProxyExt proxyExt) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Removing proxy ext, Node ID: " + proxyExt.getUaNodeId() + ", from subscribed points map");
        }
        this.controlPointsMap.remove(proxyExt.getUaNodeId());
    }

    public static void setTypeValueAndRangeForAnalogType(AnalogItemType node, BUaDataType uaDataType, BStatusNumeric initialStatusValue) throws StatusException {
        double initialValue = initialStatusValue.getValue();
        if (BUaDataType.Byte.equals((Object)uaDataType)) {
            double max = 127.0;
            double min = -128.0;
            node.setEURange(new Range(Double.valueOf(min), Double.valueOf(max)));
            node.setValue(new DataValue(new Variant((Object)((byte)initialValue)), StatusCode.GOOD));
            node.setDataTypeId(DataTypeIdentifiers.SByte);
        } else if (BUaDataType.UnsignedByte.equals((Object)uaDataType)) {
            double max = UnsignedByte.MAX_VALUE.doubleValue();
            double min = UnsignedByte.MIN_VALUE.doubleValue();
            node.setEURange(new Range(Double.valueOf(min), Double.valueOf(max)));
            node.setValue(new DataValue(new Variant((Object)UnsignedByte.valueOf((int)((int)initialValue))), StatusCode.GOOD));
            node.setDataTypeId(DataTypeIdentifiers.Byte);
        } else if (BUaDataType.Short.equals((Object)uaDataType)) {
            double max = 32767.0;
            double min = -32768.0;
            node.setEURange(new Range(Double.valueOf(min), Double.valueOf(max)));
            node.setValue(new DataValue(new Variant((Object)((short)initialValue)), StatusCode.GOOD));
            node.setDataTypeId(DataTypeIdentifiers.Int16);
        } else if (BUaDataType.UnsignedShort.equals((Object)uaDataType)) {
            double max = UnsignedShort.MAX_VALUE.doubleValue();
            double min = UnsignedShort.MIN_VALUE.doubleValue();
            node.setEURange(new Range(Double.valueOf(min), Double.valueOf(max)));
            node.setValue(new DataValue(new Variant((Object)UnsignedShort.valueOf((int)((int)initialValue))), StatusCode.GOOD));
            node.setDataTypeId(DataTypeIdentifiers.UInt16);
        } else if (BUaDataType.Integer.equals((Object)uaDataType)) {
            double max = 2.147483647E9;
            double min = -2.147483648E9;
            node.setEURange(new Range(Double.valueOf(min), Double.valueOf(max)));
            node.setValue(new DataValue(new Variant((Object)((int)initialValue)), StatusCode.GOOD));
            node.setDataTypeId(DataTypeIdentifiers.Int32);
        } else if (BUaDataType.UnsignedInteger.equals((Object)uaDataType)) {
            double max = UnsignedInteger.MAX_VALUE.doubleValue();
            double min = UnsignedInteger.MIN_VALUE.doubleValue();
            node.setEURange(new Range(Double.valueOf(min), Double.valueOf(max)));
            node.setValue(new DataValue(new Variant((Object)UnsignedInteger.valueOf((long)((long)initialValue))), StatusCode.GOOD));
            node.setDataTypeId(DataTypeIdentifiers.UInt32);
        } else if (BUaDataType.Long.equals((Object)uaDataType)) {
            double max = 9.223372036854776E18;
            double min = -9.223372036854776E18;
            node.setEURange(new Range(Double.valueOf(min), Double.valueOf(max)));
            node.setValue(new DataValue(new Variant((Object)((long)initialValue)), StatusCode.GOOD));
            node.setDataTypeId(DataTypeIdentifiers.Int64);
        } else if (BUaDataType.UnsignedLong.equals((Object)uaDataType)) {
            double max = UnsignedLong.MAX_VALUE.doubleValue();
            double min = UnsignedLong.MIN_VALUE.doubleValue();
            node.setEURange(new Range(Double.valueOf(min), Double.valueOf(max)));
            node.setValue(new DataValue(new Variant((Object)UnsignedLong.valueOf((long)((long)initialValue))), StatusCode.GOOD));
            node.setDataTypeId(DataTypeIdentifiers.UInt64);
        } else if (BUaDataType.Float.equals((Object)uaDataType)) {
            double max = 3.4028234663852886E38;
            double min = 1.4E-45f;
            node.setEURange(new Range(Double.valueOf(min), Double.valueOf(max)));
            node.setValue(new DataValue(new Variant((Object)Float.valueOf((float)initialValue)), StatusCode.GOOD));
            node.setDataTypeId(DataTypeIdentifiers.Float);
        } else {
            double max = Double.MAX_VALUE;
            double min = Double.MIN_VALUE;
            node.setEURange(new Range(Double.valueOf(min), Double.valueOf(max)));
            node.setValue(new DataValue(new Variant((Object)initialValue), StatusCode.GOOD));
            node.setDataTypeId(DataTypeIdentifiers.Double);
        }
    }

    public void checkReadAccess(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        this.verifyMismatch(serviceContext);
        switch (serviceContext.getSession().getUserIdentity().getType()) {
            case Anonymous: {
                if (!this.logger.isLoggable(Level.FINE)) break;
                this.logger.fine("Read access granted to anonymous user.");
                break;
            }
            case Certificate: {
                if (!this.logger.isLoggable(Level.FINE)) break;
                this.logger.fine("Read access granted to certificate user.");
                break;
            }
            case UserName: {
                BPermissions bPermissions = this.verifyUserAndNodeIdAndGetPermissions(serviceContext.getSession().getUserIdentity(), nodeId);
                if (!this.hasReadPermission(bPermissions)) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Read access denied to username user: " + serviceContext.getSession().getUserIdentity().getName());
                    }
                    throw new StatusException(StatusCodes.Bad_UserAccessDenied);
                }
                if (!this.logger.isLoggable(Level.FINE)) break;
                this.logger.fine("Read access granted to username user.");
                break;
            }
            default: {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Read access denied to user with unsupported auth: " + serviceContext.getSession().getUserIdentity().getType());
                }
                throw new StatusException(StatusCodes.Bad_UserAccessDenied);
            }
        }
    }

    public void checkWriteAccess(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        this.verifyMismatch(serviceContext);
        switch (serviceContext.getSession().getUserIdentity().getType()) {
            case Anonymous: {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Write access denied to anonymous user.");
                }
                throw new StatusException(StatusCodes.Bad_UserAccessDenied);
            }
            case Certificate: {
                if (!this.logger.isLoggable(Level.FINE)) break;
                this.logger.fine("Write access granted to anonymous user.");
                break;
            }
            case UserName: {
                BPermissions bPermissions = this.verifyUserAndNodeIdAndGetPermissions(serviceContext.getSession().getUserIdentity(), nodeId);
                if (!this.hasWritePermission(bPermissions)) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Write access denied to username user: " + serviceContext.getSession().getUserIdentity().getName());
                    }
                    throw new StatusException(StatusCodes.Bad_UserAccessDenied);
                }
                if (!this.logger.isLoggable(Level.FINE)) break;
                this.logger.fine("Write access granted to username user.");
                break;
            }
            default: {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Write access denied to user with unsupported auth: " + serviceContext.getSession().getUserIdentity().getType());
                }
                throw new StatusException(StatusCodes.Bad_UserAccessDenied);
            }
        }
    }

    public void verifyMismatch(ServiceContext serviceContext) throws StatusException {
        if (serviceContext == null) {
            throw new StatusException(StatusCodes.Bad_RequestTypeInvalid);
        }
        UserTokenType requestType = serviceContext.getSession().getUserIdentity().getType();
        BOpcUserAuthenticationMethods serverAuth = this.getOpcUaServer().getUserAuthenticationMethods();
        if (requestType.equals((Object)UserTokenType.Anonymous) && !serverAuth.includesAnonymous() || requestType.equals((Object)UserTokenType.Certificate) && !serverAuth.includesCertificateEnabled() || requestType.equals((Object)UserTokenType.UserName) && !serverAuth.includesUsernamePassword()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("User access denied as request type " + requestType + " not configured in server");
            }
            throw new StatusException(StatusCodes.Bad_UserAccessDenied);
        }
    }

    public boolean hasReadPermission(BPermissions permissions) {
        return permissions != null && (permissions.hasOperatorRead() || permissions.hasAdminRead());
    }

    public boolean hasWritePermission(BPermissions permissions) {
        return permissions != null && (permissions.hasOperatorWrite() || permissions.hasAdminWrite());
    }

    public BPermissions verifyUserAndNodeIdAndGetPermissions(ServerUserIdentity userIdentity, NodeId nodeId) throws StatusException {
        String requestUsername;
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUser bUser = userService.getUser(requestUsername = userIdentity.getName().trim());
        if (bUser == null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("User access denied as username is null");
            }
            throw new StatusException(StatusCodes.Bad_UserAccessDenied);
        }
        BComponent component = this.getPoints().getComponentFromNodeId(nodeId);
        if (component == null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("User access denied as requested component not found: " + nodeId);
            }
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Access request identified for component: " + component.getAbsoluteOrd() + " by user: " + requestUsername);
        }
        return bUser.getPermissionsFor((BIProtected)component);
    }

    public AccessRestrictionType getAccessRestrictionType() {
        BOpcTcpSecurityModes opcTcpSecurityModes;
        AccessRestrictionType.Builder aBuilder = AccessRestrictionType.builder();
        BOpcUaServer opcUaServer = this.getOpcUaServer();
        BOpcUserAuthenticationMethods authenticationMethods = opcUaServer.getUserAuthenticationMethods();
        if (!authenticationMethods.includesAnonymous()) {
            aBuilder.add(new OptionSpecification[]{AccessRestrictionType.Options.SessionRequired});
        }
        if (!(opcTcpSecurityModes = opcUaServer.getOpcTcpEndpoint().getSecurityMode()).includesNone()) {
            aBuilder.add(new OptionSpecification[]{AccessRestrictionType.Options.SigningRequired});
            if (opcTcpSecurityModes.includesSignEncrypt()) {
                aBuilder.add(new OptionSpecification[]{AccessRestrictionType.Options.EncryptionRequired});
            }
        }
        return aBuilder.build();
    }
}

