/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer;

import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.types.opcua.server.BuildInfoTypeNode;
import com.tridium.opcUaServer.BOpcUaServer;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="productName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="productUri", type="String", defaultValue="", flags=1), @NiagaraProperty(name="manufacturer", type="String", defaultValue="", flags=1), @NiagaraProperty(name="softwareVersion", type="String", defaultValue="", flags=1), @NiagaraProperty(name="buildNumber", type="String", defaultValue="", flags=1), @NiagaraProperty(name="buildDate", type="String", defaultValue="", flags=1)})
@NiagaraAction(name="update", flags=16)
public final class BOpcUaBuildInfo
extends BComponent {
    @Generated
    public static final Property productName = BOpcUaBuildInfo.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property productUri = BOpcUaBuildInfo.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property manufacturer = BOpcUaBuildInfo.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property softwareVersion = BOpcUaBuildInfo.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property buildNumber = BOpcUaBuildInfo.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property buildDate = BOpcUaBuildInfo.newProperty((int)1, (String)"", null);
    @Generated
    public static final Action update = BOpcUaBuildInfo.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaBuildInfo.class);
    BOpcUaServer network = null;

    @Generated
    public String getProductName() {
        return this.getString(productName);
    }

    @Generated
    public void setProductName(String v) {
        this.setString(productName, v, null);
    }

    @Generated
    public String getProductUri() {
        return this.getString(productUri);
    }

    @Generated
    public void setProductUri(String v) {
        this.setString(productUri, v, null);
    }

    @Generated
    public String getManufacturer() {
        return this.getString(manufacturer);
    }

    @Generated
    public void setManufacturer(String v) {
        this.setString(manufacturer, v, null);
    }

    @Generated
    public String getSoftwareVersion() {
        return this.getString(softwareVersion);
    }

    @Generated
    public void setSoftwareVersion(String v) {
        this.setString(softwareVersion, v, null);
    }

    @Generated
    public String getBuildNumber() {
        return this.getString(buildNumber);
    }

    @Generated
    public void setBuildNumber(String v) {
        this.setString(buildNumber, v, null);
    }

    @Generated
    public String getBuildDate() {
        return this.getString(buildDate);
    }

    @Generated
    public void setBuildDate(String v) {
        this.setString(buildDate, v, null);
    }

    @Generated
    public void update() {
        this.invoke(update, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        BComplex complex = this.getParent();
        if (complex instanceof BOpcUaServer) {
            this.network = (BOpcUaServer)complex;
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (this.network != null) {
            return this.network.postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
        }
        return super.post(action, argument, cx);
    }

    public void subscribed() {
        if (this.network != null && this.network.getStatus().isValid()) {
            this.update();
        }
    }

    public void doUpdate() {
        if (this.network != null && this.network.getStatus().isValid() && this.network.server != null) {
            UaServer uaServer = this.network.server;
            BuildInfoTypeNode buildInfo = uaServer.getNodeManagerRoot().getServerData().getServerStatusNode().getBuildInfoNode();
            this.setProductName(buildInfo.getProductName());
            this.setProductUri(buildInfo.getProductUri());
            this.setManufacturer(buildInfo.getManufacturerName());
            this.setSoftwareVersion(buildInfo.getSoftwareVersion());
            this.setBuildNumber(buildInfo.getBuildNumber());
            this.setBuildDate(buildInfo.getBuildDate().toString());
        }
    }
}

