/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtilsNiagara.niagaranetwork;

import com.tridium.clUtils.niagaranetwork.BINiagaraNetworkHelper;
import com.tridium.clUtilsNiagara.niagaranetwork.BNiagaraRemoteStation;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxClientWebsocketBehavior;
import com.tridium.nd.BNiagaraNetwork;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasCredential;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNiagaraNetworkHelper
extends BObject
implements BINiagaraNetworkHelper {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraNetworkHelper.class);
    private static final String NIAGARA_REMOTE_PROXY_PATH = "/api/v1/proxy/";
    private final Logger log = Logger.getLogger("cloudLink.niagaraNetworkHelper");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void configureNiagaraNetwork(List<String> deviceIds, String host, BCertificateAliasCredential credentials) {
        BNiagaraNetwork niagaraNetwork;
        try {
            niagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        }
        catch (ServiceNotFoundException e) {
            this.log.log(Level.WARNING, "Cannot provision Niagara Network connections, Niagara Network not found.", e);
            throw new IllegalStateException("Niagara Network not found.");
        }
        for (BDevice device : niagaraNetwork.getDevices()) {
            if (!(device instanceof BNiagaraRemoteStation)) continue;
            if (!deviceIds.contains(((BNiagaraRemoteStation)device).getDeviceId())) {
                device.getParent().asComponent().remove((BComplex)device);
                continue;
            }
            deviceIds.remove(((BNiagaraRemoteStation)device).getDeviceId());
        }
        BOrd address = new BIpHost(host).getAbsoluteOrd();
        for (String deviceId : deviceIds) {
            BNiagaraRemoteStation station = new BNiagaraRemoteStation();
            station.setDeviceId(deviceId);
            station.setAddress(address);
            BFoxClientConnection connection = station.getClientConnection();
            connection.setPort(4911);
            connection.setUseFoxs(true);
            connection.setFoxOverWebsocket(BFoxClientWebsocketBehavior.useWebsocketOnly);
            connection.setCredentials((BIUserCredentials)credentials);
            connection.setFoxOverWebsocketPathPrefix(NIAGARA_REMOTE_PROXY_PATH + deviceId);
            try {
                niagaraNetwork.add(SlotPath.escape((String)deviceId), (BValue)station);
            }
            catch (DuplicateSlotException e) {
                this.log.warning(String.format("Unable to add station '%s' due to duplicate slot.", deviceId));
            }
        }
    }
}

