/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtilsNiagara.model;

import com.tridium.authn.AuthenticationClient;
import com.tridium.clUtils.model.BModelHelper;
import com.tridium.clUtils.model.IModelHelper;
import com.tridium.clUtilsNiagara.model.BNiagaraRemoteScheduleTarget;
import com.tridium.data.BDataRow;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.schedule.BNiagaraScheduleExport;
import com.tridium.nd.schedule.BNiagaraScheduleImportExt;
import com.tridium.sys.station.BStationScheme;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Knob;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNiagaraScheduleModelHelper
extends BModelHelper
implements BFoxClientConnection.Interest {
    public static final Type TYPE = Sys.loadType(BNiagaraScheduleModelHelper.class);
    public static final String OUT_SLOT_NAME = "out";
    public static final String LINK_TYPE = "remoteNiagaraSchedule";
    public static final String SOURCE_SLOT = "remoteScheduleSourceSlot";
    public static final String TARGET_ID = "remoteScheduleTargetId";
    public static final String TARGET_SLOT = "remoteScheduleTargetSlot";

    public Type getType() {
        return TYPE;
    }

    protected void registerSelf() {
        TypeInfo[] typeInfos;
        for (TypeInfo typeInfo : typeInfos = Sys.getRegistry().getConcreteTypes(BNiagaraScheduleImportExt.TYPE.getTypeInfo())) {
            BModelHelper.registerHelper((String)typeInfo.getTypeClassName(), (IModelHelper)this);
        }
        for (TypeInfo typeInfo : typeInfos = Sys.getRegistry().getConcreteTypes(BNiagaraScheduleExport.TYPE.getTypeInfo())) {
            BModelHelper.registerHelper((String)typeInfo.getTypeClassName(), (IModelHelper)this);
        }
    }

    public void encodeLinks(ValueDocEncoder encoder, BComponent component) {
        log.finer(() -> String.format("Niagara schedule model helper encoding additional links on %s", component.getSlotPath()));
        if (component instanceof BNiagaraScheduleImportExt) {
            BNiagaraScheduleImportExt ext = (BNiagaraScheduleImportExt)component;
            this.encodeScheduleImportTargets(encoder, (BNiagaraStation)ext.getDevice(), ext.getSupervisorId());
        } else if (component instanceof BNiagaraScheduleExport) {
            BNiagaraScheduleExport export = (BNiagaraScheduleExport)component;
            this.encodeScheduleExportTargets(encoder, (BNiagaraStation)export.getDevice(), export.getSupervisorId());
        }
    }

    private BFoxSession getSession(BNiagaraStation station) throws Exception {
        BIpHost host = (BIpHost)station.getRemoteHost();
        BFoxSession session = BFoxSession.make((String)station.getName(), (BHost)host, (int)station.getFoxPort(), (boolean)station.getClientConnection().getUseFoxs());
        if (session == null) {
            throw new IllegalStateException("Cannot establish fox session to remote station " + station.getName());
        }
        BIUserCredentials credentials = station.getClientConnection().getCredentials();
        session.setCredentials((BICredentials)credentials);
        session.getConnection().setCredentials(credentials);
        session.getConnection().setAuthenticationClient((AuthenticationClient)session.getConnection());
        session.engageNoRetry(this.toString());
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeScheduleImportTargets(ValueDocEncoder encoder, BNiagaraStation station, String supervisorId) {
        BFoxSession session = null;
        try {
            session = this.getSession(station);
            BOrd remoteSupervisorOrd = BOrd.make((BOrd)BOrd.make((BOrd)session.getAbsoluteOrd(), (OrdQuery)BStationScheme.INSTANCE.parse(null)), (String)supervisorId);
            BObject obj = remoteSupervisorOrd.resolve((BObject)session).get();
            if (obj instanceof BComponent) {
                this.encodeRemoteTargets(encoder, obj.asComponent());
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, log.isLoggable(Level.FINEST) ? e : null, () -> String.format("Cannot read Niagara schedule targets for supervisorId %s in remote station %s", supervisorId, station));
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeScheduleExportTargets(ValueDocEncoder encoder, BNiagaraStation station, String supervisorId) {
        BFoxSession session = null;
        try {
            session = this.getSession(station);
            BOrd remoteNiagaraNetworkOrd = BOrd.make((BOrd)session.getAbsoluteOrd(), (String)"service:niagaraDriver:NiagaraNetwork");
            BNiagaraNetwork remoteNiagaraNetwork = (BNiagaraNetwork)remoteNiagaraNetworkOrd.get((BObject)session).as(BNiagaraNetwork.class);
            remoteNiagaraNetwork.lease();
            BOrd localStationOrdInRemoteNetwork = this.getLocalStationOrdInRemoteNetwork(session, remoteNiagaraNetwork);
            if (localStationOrdInRemoteNetwork != null) {
                BNiagaraStation localStationInRemoteNetwork = (BNiagaraStation)localStationOrdInRemoteNetwork.get((BObject)session).as(BNiagaraStation.class);
                localStationInRemoteNetwork.lease();
                localStationInRemoteNetwork.getSchedules().lease(2);
                BNiagaraScheduleImportExt remoteImportFromLocalExport = this.getRemoteImportExt(session, localStationOrdInRemoteNetwork, supervisorId);
                if (remoteImportFromLocalExport != null) {
                    this.encodeRemoteTargets(encoder, remoteImportFromLocalExport.getParent().asComponent());
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, log.isLoggable(Level.FINER) ? e : null, () -> String.format("Cannot read Niagara schedule targets for supervisorId %s in remote station %s", supervisorId, station));
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    private BOrd getLocalStationOrdInRemoteNetwork(BFoxSession session, BNiagaraNetwork remoteNiagaraNetwork) {
        BOrd localStationOrdInRemote = null;
        String localStationInRemoteStation_queryStr = String.format("bql:select slotPath from niagaraDriver:NiagaraStation where name = '%s'", Sys.getStation().getStationName());
        BObject locStnInRemStn_queryResult = BOrd.make((BOrd)remoteNiagaraNetwork.getOrdInSession(), (String)localStationInRemoteStation_queryStr).get((BObject)session);
        if (locStnInRemStn_queryResult instanceof BITable) {
            BITable table = (BITable)locStnInRemStn_queryResult;
            try (TableCursor cursor = table.cursor();){
                if (cursor.next()) {
                    BIObject slotPathObj = ((BDataRow)cursor.get()).cell(table.getColumns().get(0));
                    localStationOrdInRemote = BOrd.make((BOrd)BOrd.make((BOrd)session.getAbsoluteOrd(), (OrdQuery)BStationScheme.INSTANCE.parse(null)), (String)slotPathObj.toString());
                    log.finer("Found NiagaraStation entry for this station in remote NiagaraNetwork: " + localStationOrdInRemote);
                } else {
                    log.finer("No remote NiagaraStation entry for this station in remote NiagaraNetwork");
                }
            }
        }
        return localStationOrdInRemote;
    }

    private BNiagaraScheduleImportExt getRemoteImportExt(BFoxSession session, BOrd localStationOrdInRemoteNetwork, String supervisorId) {
        BNiagaraScheduleImportExt remoteImportExt = null;
        String remoteImportExt_queryStr = "bql:select slotPath from niagaraDriver:NiagaraScheduleImportExt";
        BOrd remoteImportExt_queryOrd = BOrd.make((BOrd)localStationOrdInRemoteNetwork, (String)remoteImportExt_queryStr);
        BObject remoteImportExt_queryResult = remoteImportExt_queryOrd.get((BObject)session);
        if (remoteImportExt_queryResult instanceof BITable) {
            BITable table = (BITable)remoteImportExt_queryResult;
            try (TableCursor cursor = table.cursor();){
                while (cursor.next()) {
                    BIObject slotPathObj = ((BDataRow)cursor.get()).cell(table.getColumns().get(0));
                    BOrd remoteImportExtOrd = BOrd.make((BOrd)localStationOrdInRemoteNetwork, (String)slotPathObj.toString());
                    BNiagaraScheduleImportExt importExt = (BNiagaraScheduleImportExt)remoteImportExtOrd.get((BObject)session);
                    if (!importExt.getSupervisorId().equals(supervisorId)) continue;
                    remoteImportExt = importExt;
                    log.finer(() -> String.format("Found schedule import ext for supervisorId %s in remote station: %s", supervisorId, remoteImportExtOrd));
                    break;
                }
                if (remoteImportExt == null) {
                    log.finer(() -> String.format("No remote schedule import ext found for supervisor id %s", supervisorId));
                }
            }
        }
        return remoteImportExt;
    }

    private void encodeRemoteTargets(ValueDocEncoder encoder, BComponent comp) {
        comp.lease();
        Slot outSlot = comp.getSlot(OUT_SLOT_NAME);
        if (outSlot != null) {
            Knob[] knobs = comp.getKnobs(outSlot);
            Arrays.stream(knobs).forEach(knob -> {
                BComponent targetComp = (BComponent)knob.getTargetOrd().get((BObject)comp);
                this.encodeLink(encoder, new BNiagaraRemoteScheduleTarget(knob.getSourceSlotName(), targetComp.getSlotPathOrd().encodeToString(), knob.getTargetSlotName()));
            });
        }
    }

    private void encodeLink(ValueDocEncoder encoder, BNiagaraRemoteScheduleTarget scheduleTarget) {
        try {
            encoder.start("p");
            encoder.attr("linkType", LINK_TYPE);
            try {
                encoder.attr(SOURCE_SLOT, scheduleTarget.getRemoteScheduleSourceSlot());
                encoder.attr(TARGET_ID, scheduleTarget.getRemoteScheduleTargetId());
                encoder.attr(TARGET_SLOT, scheduleTarget.getRemoteScheduleTargetSlot());
            }
            finally {
                encoder.end("p");
            }
        }
        catch (IOException e) {
            log.finer("Unable to encode external link: " + scheduleTarget.toString());
        }
    }
}

