/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.util;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.commands.AddBorder;
import com.tridium.px.editor.commands.AddResponsive;
import com.tridium.px.editor.commands.NewWidget;
import com.tridium.px.editor.commands.RemoveBorder;
import com.tridium.px.editor.commands.RemoveResponsive;
import com.tridium.px.editor.studio.commands.Align;
import com.tridium.px.editor.studio.commands.Distribute;
import com.tridium.px.editor.studio.commands.Reorg;
import com.tridium.px.editor.util.SelectedWidgets;
import com.tridium.util.ClassUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.ui.BLabel;
import javax.baja.ui.BLayout;
import javax.baja.ui.BMenu;
import javax.baja.ui.BPicture;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BScaleMode;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BResponsivePane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.BFolder;

public abstract class MenuBuilder {
    public static BMenu newMenu(BPxEditorPane editorPane, BTransferWidget trans) {
        try {
            BMenu menu = new BMenu();
            BComponent root = (BComponent)BOrd.make((String)"file:!defaults/workbench/newWidgets.bog|bog:|slot:/").get();
            BComponent[] kids = root.getChildComponents();
            for (int i = 0; i < kids.length; ++i) {
                MenuBuilder.addToNewMenu(editorPane, menu, kids[i], kids[i].getDisplayName(null), trans);
            }
            return menu;
        }
        catch (UnresolvedException e) {
            BMenu menu = new BMenu();
            BLabel label = new BLabel();
            label.setLayout(BLayout.make((String)"0,0,100,20"));
            BPicture picture = new BPicture();
            picture.setScale(BScaleMode.fitRatio);
            picture.setLayout(BLayout.make((String)"0,0,100,100"));
            BSeparator sep = new BSeparator();
            BBorderPane pane = new BBorderPane();
            pane.setLayout(BLayout.make((String)"0,0,100,100"));
            MenuBuilder.addToNewMenu(editorPane, menu, (BComponent)label, "Label", trans);
            MenuBuilder.addToNewMenu(editorPane, menu, (BComponent)picture, "Picture", trans);
            MenuBuilder.addToNewMenu(editorPane, menu, (BComponent)sep, "sep", trans);
            MenuBuilder.addToNewMenu(editorPane, menu, (BComponent)pane, "BorderPane", trans);
            return menu;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void addToNewMenu(BPxEditorPane editorPane, BMenu menu, BComponent comp, String name, BTransferWidget trans) {
        if (comp instanceof BFolder) {
            BMenu subMenu = new BMenu(name);
            BComponent[] kids = comp.getChildComponents();
            for (int i = 0; i < kids.length; ++i) {
                MenuBuilder.addToNewMenu(editorPane, subMenu, kids[i], kids[i].getDisplayName(null), trans);
            }
            menu.add(null, (BValue)new BSubMenuItem((BIMenu)subMenu));
        } else if (comp instanceof BSeparator) {
            menu.add(null, (BValue)new BSeparator());
        } else if (comp instanceof BWidget) {
            menu.add(null, (Command)new NewWidget(editorPane, trans, (BWidget)comp, name));
        } else {
            System.out.println("PxEditor: Cannot add " + comp.getClass().getName() + " to NewWidget menu.");
        }
    }

    public static BMenu alignMenu(BPxEditorPane editorPane, boolean enabled) {
        BMenu menu = new BMenu();
        menu.add(null, (Command)new Align(editorPane, true, 0));
        menu.add(null, (Command)new Align(editorPane, true, 2));
        menu.add(null, (Command)new Align(editorPane, true, 1));
        menu.add(null, (Command)new Align(editorPane, false, 0));
        menu.add(null, (Command)new Align(editorPane, false, 2));
        menu.add(null, (Command)new Align(editorPane, false, 1));
        menu.setEnabled(enabled);
        return menu;
    }

    public static BMenu distributeMenu(BPxEditorPane editorPane, boolean enabled) {
        BMenu menu = new BMenu();
        menu.add(null, (Command)new Distribute(editorPane, 1));
        menu.add(null, (Command)new Distribute(editorPane, 0));
        menu.setEnabled(enabled);
        return menu;
    }

    public static BMenu reorgMenu(BPxEditorPane editorPane, boolean enabled) {
        BMenu menu = new BMenu();
        menu.add(null, (Command)new Reorg(editorPane, true, false));
        menu.add(null, (Command)new Reorg(editorPane, true, true));
        menu.add(null, (Command)new Reorg(editorPane, false, true));
        menu.add(null, (Command)new Reorg(editorPane, false, false));
        menu.setEnabled(enabled);
        return menu;
    }

    public static BMenu borderMenu(BPxEditorPane editorPane, SelectedWidgets selected) {
        BMenu menu = new BMenu();
        AddBorder addBorder = new AddBorder(editorPane);
        RemoveBorder removeBorder = new RemoveBorder(editorPane);
        addBorder.setEnabled(!editorPane.getPxEditor().isReadonly() && selected.size() > 0);
        removeBorder.setEnabled(!editorPane.getPxEditor().isReadonly() && selected.size() > 0);
        Object[] arr = selected.getWidgets();
        if (removeBorder.isEnabled()) {
            removeBorder.setEnabled(ClassUtil.all((Object[])arr, BBorderPane.class));
        }
        menu.add(null, (Command)addBorder);
        menu.add(null, (Command)removeBorder);
        menu.setEnabled(addBorder.isEnabled() || removeBorder.isEnabled());
        return menu;
    }

    public static BMenu responsiveMenu(BPxEditorPane editorPane, SelectedWidgets selected) {
        BMenu menu = new BMenu();
        AddResponsive addResponsive = new AddResponsive(editorPane);
        RemoveResponsive removeResponsive = new RemoveResponsive(editorPane);
        addResponsive.setEnabled(!editorPane.getPxEditor().isReadonly() && selected.size() > 0);
        removeResponsive.setEnabled(!editorPane.getPxEditor().isReadonly() && selected.size() > 0);
        Object[] arr = selected.getWidgets();
        if (removeResponsive.isEnabled()) {
            removeResponsive.setEnabled(ClassUtil.all((Object[])arr, BResponsivePane.class));
        }
        if (addResponsive.isEnabled()) {
            addResponsive.setEnabled(!ClassUtil.all((Object[])arr, BResponsivePane.class));
        }
        menu.add(null, (Command)addResponsive);
        menu.add(null, (Command)removeResponsive);
        menu.setEnabled(addResponsive.isEnabled() || removeResponsive.isEnabled());
        return menu;
    }
}

