/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans.path;

import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.path.Role;
import com.tridium.px.editor.studio.artisans.path.SegmentArtisan;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.shape.BPath;

public class HLineTo
extends SegmentArtisan {
    @Override
    public Point point(Point pen, IPathGeom.Segment seg) {
        IPathGeom.HLineTo hl = (IPathGeom.HLineTo)seg;
        return new Point(hl.getX(), pen.y);
    }

    @Override
    public IPathGeom.Segment move(Point pen, IPathGeom.Segment seg, double dx, double dy) {
        if (seg.isRelative()) {
            return seg;
        }
        IPathGeom.HLineTo hl = (IPathGeom.HLineTo)seg;
        return new IPathGeom.HLineTo(hl.isAbsolute(), hl.getX() + dx);
    }

    @Override
    public Point paintBars(Graphics g, TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg) {
        IPathGeom.HLineTo hl = (IPathGeom.HLineTo)seg;
        Point next = HLineTo.nextPoint(pen, hl.isAbsolute(), hl.getX(), pen.y);
        return next;
    }

    @Override
    public Point paintHandles(Graphics g, TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg) {
        IPathGeom.HLineTo hl = (IPathGeom.HLineTo)seg;
        Point next = HLineTo.nextPoint(pen, hl.isAbsolute(), hl.getX(), pen.y);
        HLineTo.paintHandle(g, studio, path, next, BColor.lime);
        return next;
    }

    @Override
    public Point addHandles(TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg, int idx, PointMap map) {
        IPathGeom.HLineTo hl = (IPathGeom.HLineTo)seg;
        Point next = HLineTo.nextPoint(pen, hl.isAbsolute(), hl.getX(), pen.y);
        HLineTo.addHandle(studio, path, next, map, MouseCursor.move, new Next(idx, next, hl));
        return next;
    }

    static class Next
    extends Role {
        Point next;
        IPathGeom.HLineTo hl;

        Next(int idx, Point next, IPathGeom.HLineTo hl) {
            super(next, idx);
            this.next = next;
            this.hl = hl;
        }

        @Override
        public IPathGeom.Segment apply(double dx, double dy) {
            return new IPathGeom.HLineTo(this.hl.isAbsolute(), this.hl.getX() + dx);
        }
    }
}

