/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.binding;

import com.tridium.file.types.bog.BBogSpace;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.commands.GotoOrd;
import com.tridium.px.editor.sidebars.binding.BNeqlizeOrds;
import com.tridium.px.editor.sidebars.binding.BRelativizeOrds;
import com.tridium.px.editor.sidebars.binding.BReplaceOrds;
import com.tridium.px.editor.sidebars.binding.ChangeOrds;
import com.tridium.px.editor.util.EventUtil;
import com.tridium.workbench.fieldeditors.BOrdFE;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.baja.file.types.text.BPxFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.px.editor.BDrawingTool;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.BPxSideBar;
import javax.baja.px.editor.event.PxComponentEvent;
import javax.baja.px.editor.event.PxEditorEvent;
import javax.baja.px.editor.event.PxEvent;
import javax.baja.px.editor.event.PxLayerEvent;
import javax.baja.px.editor.event.PxListener;
import javax.baja.px.editor.event.PxPropertyEvent;
import javax.baja.px.editor.event.PxSelectionEvent;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.px.BPxInclude;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType
@NiagaraAction(name="selectionModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")
public class BBoundOrds
extends BPxSideBar
implements PxListener {
    @Generated
    public static final Action selectionModified = BBoundOrds.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBoundOrds.class);
    private static final Version MIN_NEQLIZE_VER = new Version("4.9");
    private static final Logger LOGGER = Logger.getLogger("pxEditor");
    private static final Lexicon LEX = Lexicon.make((String)"pxEditor");
    private static final String DESC = LEX.getText("boundOrds.label");
    private static final BImage ICON = BImage.make((String)LEX.getText("boundOrds.icon"));
    private static final BOrd[] EMPTY_ORD_ARRAY = new BOrd[0];
    private static final ChangeOrds.Entry[] EMPTY_CHANGE_ORDS_ENTRY_ARRAY = new ChangeOrds.Entry[0];
    private final BPxEditor editor;
    private final BPxEditorPane editorPane;
    private final BList list = new BList();
    private Map<BOrd, List<BComponent>> ords;
    private final Relativize relativize;
    private final Replace replace;
    private final Neqlize neqlize;

    @Generated
    public void selectionModified(BWidgetEvent parameter) {
        this.invoke(selectionModified, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBoundOrds(BPxEditor editor) {
        super(editor);
        this.editor = editor;
        this.editorPane = (BPxEditorPane)editor.getContent();
        editor.addPxListener(this);
        this.list.setMultipleSelection(true);
        this.list.setController((ListController)new Controller());
        BToolBar toolbar = new BToolBar();
        this.neqlize = new Neqlize();
        toolbar.add(null, (Command)this.neqlize);
        this.relativize = new Relativize();
        toolbar.add(null, (Command)this.relativize);
        this.replace = new Replace();
        toolbar.add(null, (Command)this.replace);
        BEdgePane edge = new BEdgePane();
        edge.setRight((BWidget)toolbar);
        BEdgePane contents = new BEdgePane();
        contents.setTop((BWidget)edge);
        contents.setCenter((BWidget)this.list);
        this.setContent((BWidget)contents);
        this.linkTo("lnkSelModified", (BComponent)this.list, (Slot)BList.selectionModified, (Slot)selectionModified);
    }

    public void doSelectionModified(BWidgetEvent event) {
        ArrayList<BWidget> arr = new ArrayList<BWidget>();
        int[] items = this.list.getSelection().getItems();
        for (int i = 0; i < items.length; ++i) {
            BOrd ord = (BOrd)this.list.getItem(items[i]);
            List<BComponent> comps = this.ords.get(ord);
            for (int j = 0; j < comps.size(); ++j) {
                BComponent c = comps.get(j);
                while (!(c instanceof BWidget)) {
                    c = (BComponent)c.getParent();
                }
                arr.add((BWidget)c);
            }
        }
        BWidget[] widgets = arr.toArray(new BWidget[0]);
        this.editor.getSelection().setWidgets(widgets);
        this.editor.firePxEvent(new PxSelectionEvent(widgets));
    }

    @Override
    public void pxEvent(PxEvent event) {
        block0 : switch (event.getEventType()) {
            case 0: {
                PxEditorEvent ee = (PxEditorEvent)event;
                switch (ee.getEventId()) {
                    case 0: {
                        this.updateOrds();
                        this.checkReadonly();
                        break block0;
                    }
                    case 3: {
                        BDrawingTool tool = (BDrawingTool)((Object)ee.getEventValue());
                        this.setEnabled(tool.isNormal());
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (((PxPropertyEvent)event).getEventId()) {
                    case 1: 
                    case 2: {
                        this.updateOrds();
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (((PxLayerEvent)event).getEventId()) {
                    case 1: 
                    case 2: {
                        this.checkReadonly();
                        break block0;
                    }
                }
                break;
            }
            case 5: 
            case 6: {
                this.updateOrds();
                break;
            }
            case 2: {
                this.checkReadonly();
                break;
            }
            case 3: 
            case 4: {
                switch (EventUtil.getEventType((PxComponentEvent)event)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        this.updateOrds();
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private void updateOrds() {
        this.remove("lnkSelModified");
        this.list.getSelection().deselectAll();
        this.list.removeAllItems();
        this.ords = this.ords();
        for (BOrd ord : this.ords.keySet()) {
            this.list.addItem((Object)ord);
        }
        this.relayout();
        this.linkTo("lnkSelModified", (BComponent)this.list, (Slot)BList.selectionModified, (Slot)selectionModified);
    }

    private void checkReadonly() {
        this.relativize.setEnabled(true);
        this.replace.setEnabled(true);
        if (this.editor.isReadonly() || !this.editorPane.getLayerManager().allNormal(this.editor.getSelection().getWidgets())) {
            this.relativize.setEnabled(false);
            this.replace.setEnabled(false);
        } else {
            this.relativize.setEnabled(!this.editor.isFileBased() || this.editorPane.getPxRootComponent() != null);
        }
        BComponent baseComponent = this.getBaseComponent();
        if (this.editor.isFileBased() || this.editor.isReadonly() || baseComponent == null || baseComponent.getComponentSpace() instanceof BBogSpace) {
            this.neqlize.setEnabled(false);
        } else {
            BISession currentSession = baseComponent.getSession();
            Version remoteVersion = (Version)((BObject)currentSession).fw(404, (Object)"tagdictionary", null, null, null);
            this.neqlize.setEnabled(remoteVersion != null && remoteVersion.compareTo(MIN_NEQLIZE_VER) >= 0);
        }
    }

    private BComponent getBaseComponent() {
        BComponent baseComponent = null;
        BObject baseObject = this.editor.getCurrentValue();
        if (baseObject instanceof BComponent) {
            baseComponent = (BComponent)baseObject;
        }
        return baseComponent;
    }

    public CommandArtifact relativizeORds() {
        try {
            return new Relativize(false).doInvoke();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Map<BOrd, List<BComponent>> ords() {
        TreeMap<BOrd, List<BComponent>> map = new TreeMap<BOrd, List<BComponent>>();
        BBoundOrds.findOrds((BComponent)this.editor.getWidget(), map);
        return map;
    }

    private static void findOrds(BComponent component, Map<BOrd, List<BComponent>> map) {
        BComponent[] kids;
        if (component instanceof BBinding || component instanceof BPxInclude) {
            SlotCursor c = component.getProperties();
            while (c.next(BOrd.class)) {
                BOrd ord = (BOrd)c.get();
                if (ord.equals((Object)BOrd.NULL)) continue;
                List<BComponent> comps = map.get(ord);
                if (comps == null) {
                    comps = new ArrayList<BComponent>();
                    map.put(ord, comps);
                }
                comps.add(component);
            }
        }
        for (BComponent kid : kids = BBoundOrds.getKidsForOrds(component)) {
            BBoundOrds.findOrds(kid, map);
        }
    }

    private static BComponent[] getKidsForOrds(BComponent component) {
        if (component instanceof BPxInclude) {
            return (BComponent[])component.getChildren(BBinding.class);
        }
        return component.getChildComponents();
    }

    @Override
    public BImage getSideBarIcon() {
        return ICON;
    }

    @Override
    public String getSideBarDescription() {
        return DESC;
    }

    class Controller
    extends ListController {
        Controller() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void itemPressed(BMouseEvent event, int index) {
            super.itemPressed(event, index);
            BOrd ord = (BOrd)BBoundOrds.this.list.getItem(index);
            if (event.isButton1Down()) {
                if (event.getClickCount() != 2 || BBoundOrds.this.editor.isReadonly()) return;
                BOrdFE fe = new BOrdFE();
                fe.loadValue((BObject)ord);
                int r = BDialog.open((BWidget)BBoundOrds.this.editor, (String)LEX.getText("boundOrds.edit"), (Object)fe, (int)3);
                if (r != 1) return;
                try {
                    BOrd newOrd = (BOrd)fe.saveValue();
                    ArrayList<ChangeOrds.Entry> entries = new ArrayList<ChangeOrds.Entry>();
                    this.swapOrd(ord, newOrd, (BComponent)BBoundOrds.this.editor.getWidget(), entries);
                    ChangeOrds.Entry[] e = entries.toArray(new ChangeOrds.Entry[0]);
                    if (e.length <= 0) return;
                    new ChangeOrds(BBoundOrds.this.editor, e).invoke();
                    return;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            } else {
                if (!event.isButton3Down()) return;
                BMenu menu = new BMenu();
                menu.add(null, (Command)new GotoOrd((BWidget)BBoundOrds.this, ord));
                menu.open((BWidget)BBoundOrds.this, event.getX(), event.getY());
            }
        }

        private void swapOrd(BOrd from, BOrd to, BComponent component, List<ChangeOrds.Entry> entries) {
            if (component instanceof BBinding || component instanceof BPxInclude) {
                SlotCursor c = component.getProperties();
                while (c.next(BOrd.class)) {
                    BOrd ord = (BOrd)c.get();
                    if (!ord.equals((Object)from)) continue;
                    entries.add(new ChangeOrds.Entry(component, c.property(), ord, to));
                }
            }
            BComponent[] kids = BBoundOrds.getKidsForOrds(component);
            for (int i = 0; i < kids.length; ++i) {
                this.swapOrd(from, to, kids[i], entries);
            }
        }
    }

    class Neqlize
    extends Command {
        Neqlize() {
            super((BWidget)BBoundOrds.this.editor, LEX, "boundOrds.neqlize");
        }

        public CommandArtifact doInvoke() throws Exception {
            BComponent baseComponent = BBoundOrds.this.getBaseComponent();
            if (baseComponent == null) {
                BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("boundOrds.noTargetComponent.title"), (Object)LEX.getText("boundOrds.noTargetComponent.message"));
                return null;
            }
            BISession componentSession = baseComponent.getSession();
            if (!(componentSession instanceof BFoxSession)) {
                BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("boundOrds.noFoxSession.title"), (Object)LEX.getText("boundOrds.noFoxSession.message"));
                return null;
            }
            BOrd[] before = BBoundOrds.this.ords().keySet().toArray(EMPTY_ORD_ARRAY);
            try {
                BNeqlizeOrds dialog = new BNeqlizeOrds(BBoundOrds.this.editor, before, baseComponent);
                dialog.init();
                if (!dialog.refresh(true)) {
                    return null;
                }
                String title = LEX.getText("boundOrds.neqlize.label");
                int r = BDialog.open((BWidget)BBoundOrds.this.editor, (String)title, (Object)((Object)dialog), (int)3);
                if (r != 1) {
                    return null;
                }
                ArrayList<ChangeOrds.Entry> entries = new ArrayList<ChangeOrds.Entry>();
                this.replaceInOrds(dialog.selected(), dialog, (BComponent)BBoundOrds.this.editor.getWidget(), entries);
                ChangeOrds.Entry[] e = entries.toArray(EMPTY_CHANGE_ORDS_ENTRY_ARRAY);
                if (e.length > 0) {
                    return new ChangeOrds(BBoundOrds.this.editor, e).doInvoke();
                }
            }
            catch (Exception e) {
                throw new BajaRuntimeException(LEX.getText("boundOrds.conversionFailed"), (Throwable)e);
            }
            return null;
        }

        private void replaceInOrds(Set<BOrd> selectedOrds, BNeqlizeOrds dialog, BComponent component, List<ChangeOrds.Entry> entries) {
            BComponent[] kids;
            if (component instanceof BBinding || component instanceof BPxInclude) {
                SlotCursor c = component.getProperties();
                while (c.next(BOrd.class)) {
                    BOrd oldOrd = (BOrd)c.get();
                    if (!selectedOrds.contains(oldOrd)) continue;
                    BNeqlizeOrds.NeqlizeData data = dialog.getNeqlizeData(oldOrd);
                    BOrd newOrd = BNeqlizeOrds.makeAfterOrd(data, true);
                    entries.add(new ChangeOrds.Entry(component, c.property(), oldOrd, newOrd));
                }
            }
            for (BComponent kid : kids = BBoundOrds.getKidsForOrds(component)) {
                this.replaceInOrds(selectedOrds, dialog, kid, entries);
            }
        }
    }

    class Replace
    extends Command {
        Replace() {
            super((BWidget)BBoundOrds.this.editor, LEX, "boundOrds.replace");
        }

        public CommandArtifact doInvoke() throws Exception {
            BOrd[] before = BBoundOrds.this.ords().keySet().toArray(new BOrd[0]);
            BReplaceOrds dialog = new BReplaceOrds(BBoundOrds.this.editor, before);
            dialog.init();
            String title = LEX.getText("boundOrds.replace.label");
            int r = BDialog.open((BWidget)BBoundOrds.this.editor, (String)title, (Object)((Object)dialog), (int)3);
            if (r != 1) {
                return null;
            }
            String from = dialog.from.getTextAndSave();
            String to = dialog.to.getTextAndSave();
            if (from.isEmpty()) {
                return null;
            }
            ArrayList<ChangeOrds.Entry> entries = new ArrayList<ChangeOrds.Entry>();
            this.replaceInOrds(dialog.selected(), from, to, (BComponent)BBoundOrds.this.editor.getWidget(), entries);
            ChangeOrds.Entry[] e = entries.toArray(new ChangeOrds.Entry[0]);
            if (e.length > 0) {
                return new ChangeOrds(BBoundOrds.this.editor, e).doInvoke();
            }
            return null;
        }

        private void replaceInOrds(Set<BOrd> selectedOrds, String fromStr, String toStr, BComponent component, List<ChangeOrds.Entry> entries) {
            BComponent[] kids;
            if (component instanceof BBinding || component instanceof BPxInclude) {
                SlotCursor c = component.getProperties();
                while (c.next(BOrd.class)) {
                    String str;
                    BOrd oldOrd = (BOrd)c.get();
                    if (!selectedOrds.contains(oldOrd) || !(str = oldOrd.toString()).contains(fromStr)) continue;
                    entries.add(new ChangeOrds.Entry(component, c.property(), oldOrd, BOrd.make((String)TextUtil.replace((String)str, (String)fromStr, (String)toStr))));
                }
            }
            for (BComponent kid : kids = BBoundOrds.getKidsForOrds(component)) {
                this.replaceInOrds(selectedOrds, fromStr, toStr, kid, entries);
            }
        }
    }

    class Relativize
    extends Command {
        boolean promptEnable;

        Relativize() {
            super((BWidget)BBoundOrds.this.editor, LEX, "boundOrds.relativize");
            this.promptEnable = true;
            this.promptEnable = true;
        }

        Relativize(boolean promptEnable) {
            super((BWidget)BBoundOrds.this.editor, LEX, "boundOrds.relativize");
            this.promptEnable = true;
            this.promptEnable = promptEnable;
        }

        public CommandArtifact doInvoke() throws Exception {
            BObject currentValue = BBoundOrds.this.editor.getCurrentValue();
            BComponent pxRootComponent = BBoundOrds.this.editorPane.getPxRootComponent();
            BComponent comp = currentValue instanceof BPxFile && pxRootComponent != null ? pxRootComponent : (BComponent)currentValue;
            String[] baseNames = comp.getSlotPath().getNames();
            BOrd[] before = BBoundOrds.this.ords().keySet().toArray(new BOrd[0]);
            BRelativizeOrds dialog = new BRelativizeOrds(BBoundOrds.this.editor, baseNames, before);
            dialog.init();
            if (this.promptEnable) {
                String title = LEX.getText("boundOrds.relativize.label");
                int r = BDialog.open((BWidget)BBoundOrds.this.editor, (String)title, (Object)((Object)dialog), (int)3);
                if (r != 1) {
                    return null;
                }
            }
            ArrayList<ChangeOrds.Entry> entries = new ArrayList<ChangeOrds.Entry>();
            this.relativizeComponent(dialog.selected(), baseNames, (BComponent)BBoundOrds.this.editor.getWidget(), entries);
            ChangeOrds.Entry[] e = entries.toArray(new ChangeOrds.Entry[0]);
            if (e.length > 0) {
                return new ChangeOrds(BBoundOrds.this.editor, e).doInvoke();
            }
            return null;
        }

        private void relativizeComponent(Set<BOrd> selectedOrds, String[] baseNames, BComponent component, List<ChangeOrds.Entry> entries) {
            if (component instanceof BBinding || component instanceof BPxInclude) {
                SlotCursor c = component.getProperties();
                while (c.next(BOrd.class)) {
                    BOrd newOrd;
                    BOrd oldOrd = (BOrd)c.get();
                    if (!selectedOrds.contains(oldOrd) || (newOrd = BRelativizeOrds.relativizeOrd(baseNames, oldOrd)) == null) continue;
                    entries.add(new ChangeOrds.Entry(component, c.property(), oldOrd, newOrd));
                }
            }
            BComponent[] kids = BBoundOrds.getKidsForOrds(component);
            for (int i = 0; i < kids.length; ++i) {
                this.relativizeComponent(selectedOrds, baseNames, kids[i], entries);
            }
        }
    }
}

