/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui;

import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.ToggleButtonTheme;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class JobTable {
    public static final BImage unknownIcon = BImage.make((String)"module://icons/x16/job/unknown.png");
    public static final BImage runningIcon = BImage.make((String)"module://icons/x16/job/running.png");
    public static final BImage canceledIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    public static final BImage successIcon = BImage.make((String)"module://icons/x16/job/success.png");
    public static final BImage failedIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    public static final BImage messageIcon = BImage.make((String)"module://icons/x16/info.png");
    public static final BImage openIcon = BImage.make((String)"module://icons/x16/doubleArrowRight.png");
    public static final BImage disposeIcon = BImage.make((String)"module://icons/x16/close.png");
    public static final Lexicon lex = Lexicon.make((String)"batchJob");
    public static final String lexStatus = UiLexicon.bajaui().getText("status");
    public static final String lexTimestamp = UiLexicon.bajaui().getText("timestamp");
    public static final String lexMessage = UiLexicon.bajaui().getText("message");
    public static final String lexDetails = UiLexicon.bajaui().getText("details");
    public static final String lexCancel = UiLexicon.bajaui().getText("cancel");
    public static final String lexLog = UiLexicon.bajaui().getText("log");
    public static final String lexJobLog = UiLexicon.bajaui().getText("job.log");
    public static final String lexLogDetails = UiLexicon.bajaui().getText("log.details");

    public static BCommandBoundTable makeListTable(TableModel model, CommandBindings bindings, int buttonsCol, Command openCommand, Command disposeCommand) {
        return JobTable.makeListTable(model, new ListTableController(bindings, buttonsCol, openCommand, disposeCommand));
    }

    public static BCommandBoundTable makeListTable(TableModel model, int buttonsCol, Command openCommand, Command disposeCommand) {
        return JobTable.makeListTable(model, new ListTableController(new CommandBindings(), buttonsCol, openCommand, disposeCommand));
    }

    public static BCommandBoundTable makeListTable(TableModel model, ListTableController controller) {
        BCommandBoundTable result = new BCommandBoundTable(model, (CommandBindings.TableController)controller);
        result.setCellRenderer((TableCellRenderer)new ListTableRenderer());
        return result;
    }

    public static void showLogDialog(BWidget owner, String logContents) throws Exception {
        JobTable.showLogDialog(owner, JobLog.decode((String)logContents));
    }

    public static void showLogDialog(BWidget owner, BJob job) throws Exception {
        JobTable.showLogDialog(owner, job.readLog().toString());
    }

    public static void showLogDialog(BWidget owner, JobLog log) {
        BConstrainedPane pane = new BConstrainedPane((BWidget)JobTable.makeLogDisplay(log));
        pane.setFixedSize(800.0, 400.0);
        BDialog.open((BWidget)owner, (String)lexJobLog, (Object)pane, (int)1);
    }

    public static BTable makeLogDisplay(JobLog log) {
        return new BTable((TableModel)new LogModel(log), (TableController)new LogController());
    }

    public static BTable makeLogDisplay() {
        return new BTable((TableModel)new LogModel(), (TableController)new LogController());
    }

    public static BImage stateToIcon(BJobState state) {
        switch (state.getOrdinal()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return canceledIcon;
            }
            case 4: {
                return successIcon;
            }
            case 5: {
                return failedIcon;
            }
        }
        return unknownIcon;
    }

    public static BImage itemToIcon(JobLogItem item) {
        switch (item.getId()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return successIcon;
            }
            case 4: {
                return failedIcon;
            }
        }
        return messageIcon;
    }

    private static class LogController
    extends TableController {
        private LogController() {
        }

        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
            JobLogItem item = ((LogModel)this.getModel()).items[row];
            BTextEditor text = new BTextEditor(item.toString(null), false);
            BTextEditorPane pane = new BTextEditorPane(text, 40, 80);
            BDialog.open((BWidget)this.getTable(), (String)lexLogDetails, (Object)pane, (int)1);
        }
    }

    public static class LogModel
    extends TableModel {
        private JobLogItem[] items;
        private String[] messages;
        private String[] details;

        public LogModel() {
        }

        public LogModel(JobLog log) {
            this.load(log);
        }

        public void load(BJob job) throws Exception {
            this.load(job.readLog().toString());
        }

        public void load(String logContents) throws Exception {
            this.load(JobLog.decode((String)logContents));
        }

        public void load(JobLog log) {
            this.items = log.getItems();
            this.messages = new String[this.items.length];
            this.details = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                this.messages[i] = this.str(this.items[i].getMessage(null));
                this.details[i] = this.str(this.items[i].getDetails(null));
            }
            this.updateTable(true);
        }

        private String str(String s) {
            if (s == null) {
                return "";
            }
            int n = s.indexOf(10);
            if (n < 0) {
                return s;
            }
            return s.substring(0, n);
        }

        public int getRowCount() {
            return this.items.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lexStatus;
                }
                case 1: {
                    return lexTimestamp;
                }
                case 2: {
                    return lexMessage;
                }
                case 3: {
                    return lexDetails;
                }
            }
            return "???";
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.items[row].getIdString(null);
                }
                case 1: {
                    return this.items[row].getTimestamp();
                }
                case 2: {
                    return this.messages[row];
                }
                case 3: {
                    return this.details[row];
                }
            }
            return "???";
        }

        public Object getSubject(int row) {
            return this.items[row];
        }

        public BObject export(int row, int col) {
            switch (col) {
                case 0: {
                    return this.export(this.items[row].getIdString(null));
                }
                case 1: {
                    return this.items[row].getTimestamp();
                }
                case 2: {
                    return this.export(this.items[row].getMessage(null));
                }
                case 3: {
                    return this.export(this.items[row].getDetails(null));
                }
            }
            return BString.DEFAULT;
        }

        private BString export(String s) {
            if (s == null) {
                return BString.DEFAULT;
            }
            return BString.make((String)s);
        }

        public BImage getRowIcon(int row) {
            return JobTable.itemToIcon(this.items[row]);
        }
    }

    public static class ListTableRenderer
    extends TableCellRenderer {
        protected ListTableController controller() {
            return (ListTableController)this.getController();
        }

        public double getCellHeight() {
            return Math.max(Theme.table().getCellFont().getHeight() + 3.0, 20.0);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            double result = super.getPreferredCellWidth(cell);
            if (cell.column == this.controller().getButtonsCol()) {
                result += 37.0;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintImageBorder(Graphics g, TableCellRenderer.Cell cell, double x) {
            g.push();
            try {
                double w = 18.0;
                double h = 18.0;
                g.translate(x, (cell.height - h) / 2.0);
                ToggleButtonTheme t = Theme.toggleButton();
                g.setBrush(t.getControlForeground());
                g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
                if (this.controller().isMouseDown()) {
                    g.setBrush(t.getControlShadow());
                } else {
                    g.setBrush(t.getControlHighlight());
                }
                g.strokeLine(1.0, 1.0, w - 3.0, 1.0);
                g.strokeLine(1.0, 1.0, 1.0, h - 3.0);
                if (this.controller().isMouseDown()) {
                    g.setBrush(t.getControlShadow());
                } else {
                    g.setBrush(t.getControlAuxiliary());
                }
                g.strokeLine(w - 2.0, 1.0, w - 2.0, h - 2.0);
                g.strokeLine(1.0, h - 2.0, w - 2.0, h - 2.0);
            }
            finally {
                g.pop();
            }
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            if (cell.column == this.controller().getButtonsCol()) {
                this.paintCellBackground(g, cell);
                double y = (cell.height - 16.0) / 2.0;
                String s = this.getCellText(cell);
                BFont font = this.getFont(cell);
                double tw = font.width(s) + 2.0;
                double x = cell.width - tw - 2.0;
                if (this.controller().openVisible()) {
                    x -= 20.0;
                }
                if (this.controller().disposeVisible()) {
                    x -= 20.0;
                }
                g.setFont(font);
                g.drawString(s, x, font.getAscent() + 2.0);
                x += tw;
                if (this.controller().openVisible()) {
                    if (this.controller().getRowHoveredOpen() == cell.row) {
                        this.paintImageBorder(g, cell, x);
                    }
                    g.drawImage(openIcon, x + 1.0, y);
                    x += 20.0;
                }
                if (this.controller().disposeVisible()) {
                    if (this.controller().getRowHoveredDispose() == cell.row) {
                        this.paintImageBorder(g, cell, x);
                    }
                    g.drawImage(disposeIcon, x + 1.0, y);
                }
            } else {
                super.paintCell(g, cell);
            }
        }
    }

    public static class ListTableController
    extends CommandBindings.TableController {
        private int buttonsCol;
        private int overDispose = -1;
        private int overOpen = -1;
        private boolean mouseDown = false;
        private Command disposeCommand = null;
        private Command openCommand = null;

        public ListTableController(CommandBindings bindings, int buttonsCol, Command openCommand, Command disposeCommand) {
            super(bindings);
            this.buttonsCol = buttonsCol;
            this.disposeCommand = disposeCommand;
            this.openCommand = openCommand;
        }

        protected void cellEntered(BMouseEvent event, int row, int column) {
            this.cellMoved(event, row, column);
        }

        private boolean overDispose(int row, double eventX) {
            double w;
            if (this.disposeCommand == null) {
                return false;
            }
            RectGeom cellBounds = this.getTable().getCellBounds(row, this.buttonsCol);
            double x = eventX - cellBounds.x();
            if (this.getTable().getHscrollBar().isVisible()) {
                x += (double)this.getTable().getHscrollBar().getPosition();
            }
            if ((w = cellBounds.width()) < 40.0) {
                return w >= 20.0 && x > w - 20.0;
            }
            return x > w - 20.0;
        }

        private boolean overOpen(int row, double eventX) {
            if (this.openCommand == null) {
                return false;
            }
            RectGeom cellBounds = this.getTable().getCellBounds(row, this.buttonsCol);
            double x = eventX - cellBounds.x();
            if (this.getTable().getHscrollBar().isVisible()) {
                x += (double)this.getTable().getHscrollBar().getPosition();
            }
            double w = cellBounds.width();
            if (this.disposeVisible()) {
                return w >= 40.0 && x <= w - 20.0 && x > w - 40.0;
            }
            if (w < 40.0) {
                return w >= 20.0 && x > w - 20.0;
            }
            return x > w - 20.0;
        }

        protected void cellPressed(BMouseEvent event, int row, int column) {
            this.mouseDown = true;
            super.cellPressed(event, row, column);
            if (column == this.buttonsCol) {
                this.getTable().repaint();
            }
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            this.mouseDown = false;
            super.cellReleased(event, row, column);
            if (column == this.buttonsCol) {
                this.getTable().repaint();
                if (!event.isPopupTrigger() && event.getClickCount() == 1) {
                    if (this.overDispose(row, event.getX()) && this.disposeCommand.isEnabled()) {
                        this.disposeCommand.invoke();
                    }
                    if (this.overOpen(row, event.getX())) {
                        this.getSelection().select(row, true);
                        if (this.openCommand.isEnabled()) {
                            this.openCommand.invoke();
                        }
                    }
                }
            }
        }

        protected void cellMoved(BMouseEvent event, int row, int column) {
            BWidgetShell shell = this.getShell();
            if (column == this.buttonsCol) {
                if (this.overDispose(row, event.getX())) {
                    if (shell != null) {
                        shell.showStatus(this.disposeCommand.getDescription());
                    }
                    this.overDispose = row;
                    this.overOpen = -1;
                } else if (this.overOpen(row, event.getX())) {
                    if (shell != null) {
                        shell.showStatus(this.openCommand.getDescription());
                    }
                    this.overDispose = -1;
                    this.overOpen = row;
                } else {
                    if (shell != null) {
                        shell.showStatus("");
                    }
                    this.overDispose = -1;
                    this.overOpen = -1;
                }
                this.getTable().repaint();
            } else {
                if (this.overDispose != -1) {
                    if (shell != null) {
                        shell.showStatus("");
                    }
                    this.overDispose = -1;
                    this.getTable().repaint();
                }
                if (this.overOpen != -1) {
                    if (shell != null) {
                        shell.showStatus("");
                    }
                    this.overOpen = -1;
                    this.getTable().repaint();
                }
            }
        }

        protected void cellExited(BMouseEvent event, int row, int column) {
            if (column == this.buttonsCol) {
                BWidgetShell shell = this.getShell();
                if (this.overDispose == row) {
                    if (shell != null) {
                        shell.showStatus("");
                    }
                    this.overDispose = -1;
                    this.getTable().repaint();
                }
                if (this.overOpen == row) {
                    if (shell != null) {
                        shell.showStatus("");
                    }
                    this.overOpen = -1;
                    this.getTable().repaint();
                }
            }
        }

        public int getRowHoveredOpen() {
            return this.overOpen;
        }

        public int getRowHoveredDispose() {
            return this.overDispose;
        }

        public boolean isMouseDown() {
            return this.mouseDown;
        }

        public int getButtonsCol() {
            return this.buttonsCol;
        }

        public boolean openVisible() {
            return this.openCommand != null;
        }

        public boolean disposeVisible() {
            return this.disposeCommand != null;
        }
    }
}

