/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.ui.JobTable;
import com.tridium.batchJob.ui.ViewQueryParameter;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.retention.ui.BRetentionPolicyFE;
import com.tridium.ui.util.LabelUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobPrototype;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BIBatchJobSummary;
import javax.baja.batchJob.BIJobQueryManager;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.retention.BRetentionPolicy;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"batchJob:BatchJobPrototype"})})
public class BPrototypeJobList
extends BWbComponentView
implements CommandBindings.Support {
    @Generated
    public static final Type TYPE = Sys.loadType(BPrototypeJobList.class);
    protected Model model;
    protected LogCommand logCommand;
    protected DisposeCommand disposeCommand;
    protected CancelCommand cancelCommand;
    protected BBatchJobService batchJobService = null;
    protected BButtonPane lowerButtons;
    protected BWbFieldEditor checkFrequencyFe;
    protected BRetentionPolicyFE retentionPolicyFe;
    protected static final Lexicon LEX = Lexicon.make((String)"batchJob");
    public static final int COL_JOB_START = 0;
    public static final int COL_JOB_END = 1;
    public static final int COL_JOB_USER = 2;
    public static final int COL_BUTTONS = 3;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPrototypeJobList() {
        this.autoRegisterForComponentEvents = false;
        BGridPane upperPane = new BGridPane(2);
        upperPane.setHalign(BHalign.left);
        this.retentionPolicyFe = new BRetentionPolicyFE();
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"PrototypeJobList.retentionPolicy"), (BWidget)this.retentionPolicyFe);
        this.checkFrequencyFe = BWbFieldEditor.makeFor((BObject)BRelTime.HOUR);
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"PrototypeJobList.checkFrequency"), (BWidget)this.checkFrequencyFe);
        this.linkTo(null, (BComponent)this.retentionPolicyFe, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.checkFrequencyFe, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        CommandBindings bindings = new CommandBindings();
        bindings.setSupport((CommandBindings.Support)this);
        this.logCommand = new LogCommand();
        bindings.addCommand((Command)this.logCommand, BCommandEnablePolicy.singleSelection);
        OpenCommand openCommand = new OpenCommand();
        bindings.addCommand((Command)openCommand, BCommandEnablePolicy.singleSelection);
        this.cancelCommand = new CancelCommand();
        bindings.addCommand((Command)this.cancelCommand, BCommandEnablePolicy.anySelection);
        this.disposeCommand = new DisposeCommand();
        bindings.addCommand((Command)this.disposeCommand, BCommandEnablePolicy.anySelection);
        bindings.setDoubleClickCommand((Command)this.logCommand);
        BGridPane rightButtons = new BGridPane(1);
        rightButtons.setValign(BValign.top);
        rightButtons.setColumnAlign(BHalign.fill);
        rightButtons.setRowGap(4.0);
        BButton button = new BButton((Command)new SubmitCommand(), true, false);
        rightButtons.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        button = new BButton((Command)this.logCommand, true, false);
        rightButtons.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        button = new BButton((Command)openCommand, true, false);
        rightButtons.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        button = new BButton((Command)this.cancelCommand, true, false);
        rightButtons.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        button = new BButton((Command)this.disposeCommand, true, false);
        rightButtons.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.model = new Model();
        BCommandBoundTable table = JobTable.makeListTable(this.model, bindings, 3, openCommand, this.disposeCommand);
        table.setMultipleSelection(true);
        this.lowerButtons = new BButtonPane();
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)upperPane, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), (BWidget)new BBorderPane((BWidget)this.lowerButtons, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, (BWidget)new BBorderPane((BWidget)rightButtons, 0.0, 0.0, 0.0, 3.0), (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)table), BBorder.inset, BInsets.DEFAULT)), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        BBatchJobPrototype proto = (BBatchJobPrototype)value;
        this.retentionPolicyFe.loadValue((BObject)proto.getRetentionPolicy(), this.makePropertyContext(proto, "retentionPolicy", context));
        this.checkFrequencyFe.loadValue((BObject)proto.getRetentionPolicyCheckFrequency(), this.makePropertyContext(proto, "retentionPolicyCheckFrequency", context));
        this.model.load(proto);
        BWbShell shell = this.getWbShell();
        if (shell != null) {
            this.lowerButtons.add(shell.getRefreshCommand(), true, true);
            this.lowerButtons.add(shell.getSaveCommand(), true, true);
        }
    }

    private Context makePropertyContext(BBatchJobPrototype proto, String propName, Context orig) {
        Property prop = proto.getProperty(propName);
        if (orig == null) {
            return proto.getSlotFacets((Slot)prop);
        }
        return new BasicContext(orig, proto.getSlotFacets((Slot)prop));
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BBatchJobPrototype proto = (BBatchJobPrototype)value;
        proto.setRetentionPolicy((BRetentionPolicy)this.retentionPolicyFe.saveValue((BObject)proto.getRetentionPolicy(), cx));
        proto.setRetentionPolicyCheckFrequency((BRelTime)this.checkFrequencyFe.saveValue((BObject)proto.getRetentionPolicyCheckFrequency(), cx));
        return proto;
    }

    protected BBatchJobPrototype getPrototype() {
        return (BBatchJobPrototype)this.getCurrentValue();
    }

    protected BBatchJobService getBatchJobService() {
        if (this.batchJobService == null) {
            this.batchJobService = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get((BObject)this.getPrototype());
        }
        return this.batchJobService;
    }

    protected BIJobQueryManager getQueryManager() {
        return this.getBatchJobService().getJobQueryManager();
    }

    public void handleComponentEvent(BComponentEvent evt) {
        if (evt.getSourceComponent() instanceof BBatchJobService) {
            if (evt.getId() == 5 && evt.getSlot() == BBatchJobService.jobDisposed) {
                this.model.handleJobDisposed((BAbsTime)evt.getValue());
            }
        } else if (evt.getSourceComponent() instanceof BJobService) {
            if (evt.getId() == 1 && evt.getValue() instanceof BBatchJob) {
                BBatchJob job = (BBatchJob)evt.getValue();
                this.model.updateJob(job);
                this.registerForComponentEvents((BComponent)job, 1);
            }
        } else if (evt.getSourceComponent() instanceof BBatchJob) {
            this.model.updateJob((BBatchJob)evt.getSourceComponent());
        }
    }

    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        if (command == this.disposeCommand) {
            for (int row : this.model.getSelection().getRows()) {
                if (this.model.summary(row).getJobState().isComplete()) continue;
                command.setEnabled(false);
                return;
            }
        } else if (command == this.cancelCommand) {
            for (int row : this.model.getSelection().getRows()) {
                if (this.model.summary(row).getJobState() == BJobState.running || this.model.summary(row).getJobState() == BJobState.unknown) continue;
                command.setEnabled(false);
                return;
            }
        }
        command.setEnabled(bindingBasedState);
    }

    protected class CancelCommand
    extends Command {
        public CancelCommand() {
            super((BWidget)BPrototypeJobList.this, LEX, "BatchJobList.cancelCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BPrototypeJobList.this.model.getTable(), (String)LEX.getText("BatchJobList.cancelCommand.dlgTitle"), (Object)LEX.getText("BatchJobList.cancelCommand.dlgMessage"))) {
                    BPrototypeJobList.this.model.cancel(BPrototypeJobList.this.model.getTable().getSelection().getRows());
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    protected class DisposeCommand
    extends Command {
        public DisposeCommand() {
            super((BWidget)BPrototypeJobList.this, LEX, "BatchJobList.disposeCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BPrototypeJobList.this.model.getTable(), (String)LEX.getText("BatchJobList.disposeCommand.dlgTitle"), (Object)LEX.getText("BatchJobList.disposeCommand.dlgMessage"))) {
                    BPrototypeJobList.this.model.dispose(BPrototypeJobList.this.model.getTable().getSelection().getRows());
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    protected class LogCommand
    extends Command {
        public LogCommand() {
            super((BWidget)BPrototypeJobList.this, LEX, "BatchJobList.logCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BBatchJob job = BPrototypeJobList.this.model.summary(BPrototypeJobList.this.model.getTable().getSelection().getRow()).getJob(BPrototypeJobList.this.getCurrentValue());
                JobTable.showLogDialog((BWidget)BPrototypeJobList.this.model.getTable(), (BJob)job);
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    protected class OpenCommand
    extends Command {
        public OpenCommand() {
            super((BWidget)BPrototypeJobList.this, LEX, "BatchJobList.openCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd ord;
                BIBatchJobSummary summary = BPrototypeJobList.this.model.summary(BPrototypeJobList.this.model.getTable().getSelection().getRow());
                BBatchJob job = summary.getJob(BPrototypeJobList.this.getCurrentValue());
                if (job.getParent() instanceof BJobService) {
                    ord = BOrd.make((BOrd)BPrototypeJobList.this.getBatchJobService().getAbsoluteOrd(), (BOrd)job.getHandleOrd());
                } else {
                    BBatchJobLogFile logFile = BBatchJobLogFile.find((BBatchJob)job, (BObject)BPrototypeJobList.this.getCurrentValue());
                    ord = BOrd.make((BOrd)BPrototypeJobList.this.getBatchJobService().getAbsoluteOrd(), (BOrd)logFile.getOrdInSession());
                    ord = BOrd.make((BOrd)ord, (OrdQuery)new ViewQuery("?displayTzId=" + ViewQueryParameter.encode((BIEncodable)BString.make((String)summary.getStartTime().getTimeZone().getId()))));
                }
                BPrototypeJobList.this.getWbShell().hyperlink(ord);
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    protected class SubmitCommand
    extends Command {
        public SubmitCommand() {
            super((BWidget)BPrototypeJobList.this, LEX, "PrototypeJobList.submitCommand");
        }

        public CommandArtifact doInvoke() {
            ((BBatchJobPrototype)BPrototypeJobList.this.getCurrentValue()).submitJob();
            return null;
        }
    }

    protected class Model
    extends TableModel {
        private List<BIBatchJobSummary> rows = new ArrayList<BIBatchJobSummary>();
        private Map<BAbsTime, BIBatchJobSummary> summaryByStartTime = new HashMap<BAbsTime, BIBatchJobSummary>();

        public synchronized void updateJob(BBatchJob job) {
            if (job.getPrototypeOrd().equals((Object)BPrototypeJobList.this.getPrototype().getOrdInSpace())) {
                BIBatchJobSummary summary = this.summaryByStartTime.get(job.getStartTime());
                if (summary == null) {
                    this.getSelection().deselectAll();
                    summary = BPrototypeJobList.this.getQueryManager().makeJobSummary(job);
                    this.rows.add(0, summary);
                    this.summaryByStartTime.put(job.getStartTime(), summary);
                } else {
                    summary.updateJob(job);
                }
                this.updateTable(true);
            }
        }

        public synchronized void handleJobDisposed(BAbsTime jobStart) {
            BIBatchJobSummary summary = this.summaryByStartTime.get(jobStart);
            if (summary != null) {
                this.getSelection().deselectAll();
                this.rows.remove(summary);
                this.summaryByStartTime.remove(jobStart);
                this.updateTable(false);
            }
        }

        public synchronized void dispose(int[] rows) {
            for (int row : rows) {
                BPrototypeJobList.this.getBatchJobService().disposeJob(this.summary(row).getStartTime());
            }
        }

        public synchronized void cancel(int[] rows) throws Exception {
            for (int row : rows) {
                this.summary(row).getJob(BPrototypeJobList.this.getCurrentValue()).cancel();
            }
        }

        public synchronized void load(BBatchJobPrototype proto) throws Exception {
            BJobService jobSvc = (BJobService)BOrd.make((String)"service:baja:JobService").get((BObject)proto);
            jobSvc.lease(2);
            BOrd protoOrd = proto.getOrdInSpace();
            ArrayList<BIBatchJobSummary> tempRows = new ArrayList<BIBatchJobSummary>();
            HashMap<BAbsTime, BIBatchJobSummary> tempSummaryByStartTime = new HashMap<BAbsTime, BIBatchJobSummary>();
            SlotCursor c = jobSvc.getProperties();
            while (c.next(BBatchJob.class)) {
                BBatchJob job = (BBatchJob)c.get();
                if (!job.getPrototypeOrd().equals((Object)protoOrd) || job.getJobState().isComplete()) continue;
                BIBatchJobSummary summary = BPrototypeJobList.this.getQueryManager().makeJobSummary(job);
                tempRows.add(summary);
                tempSummaryByStartTime.put(job.getStartTime(), summary);
            }
            c = proto.listBatchJobSummaries();
            while (c.next()) {
                BIBatchJobSummary summary = (BIBatchJobSummary)c.get();
                tempRows.add(summary);
                tempSummaryByStartTime.put(summary.getStartTime(), summary);
            }
            tempRows.sort(Comparator.comparing(BIBatchJobSummary::getStartTime).reversed());
            this.summaryByStartTime = tempSummaryByStartTime;
            this.rows = tempRows;
            this.getSelection().deselectAll();
            this.updateTable(true);
            BPrototypeJobList.this.registerForComponentEvents((BComponent)jobSvc, 2);
            BPrototypeJobList.this.registerForComponentEvents((BComponent)BPrototypeJobList.this.getBatchJobService(), 1);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return LEX.getText("BatchJobList.col.jobStart");
                }
                case 1: {
                    return LEX.getText("BatchJobList.col.jobEnd");
                }
                case 2: {
                    return LEX.getText("BatchJobList.col.user");
                }
                case 3: {
                    return "";
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.summary(row).getStartTime().toString();
                }
                case 1: {
                    return this.summary(row).getEndTime() == null ? "" : this.summary(row).getEndTime().toString();
                }
                case 2: {
                    return this.summary(row).getSubmitUser();
                }
                case 3: {
                    return this.summary(row).getJobState();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BIBatchJobSummary summary(int row) {
            return this.rows.get(row);
        }

        public BImage getRowIcon(int row) {
            return JobTable.stateToIcon(this.summary(row).getJobState());
        }
    }
}

