/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaraSystemIndex;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.fox.sys.data.BIPostQueryFilter;
import com.tridium.fox.sys.data.BIPreQueryValidator;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BReachableStationInfo;
import com.tridium.nd.util.BNiagaraRemoteQueryFilter;
import com.tridium.nd.util.NiagaraDriverUtil;
import com.tridium.niagaraSystemIndex.BAbstractSystemIndexDeviceExt;
import com.tridium.niagaraSystemIndex.BNiagaraSystemIndexDescriptor;
import com.tridium.niagaraSystemIndex.BReachableStationSystemIndexDeviceExt;
import com.tridium.systemIndex.BSystemIndexer;
import com.tridium.systemIndex.SystemIndexLog;
import java.util.List;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BNiagaraSystemIndexImport
extends BNiagaraSystemIndexDescriptor {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraSystemIndexImport.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"index.png"), (BIcon)BIcon.std((String)"badges/import.png"));
    private volatile String lastLimitExceededMsg;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        try {
            this.checkLicenseForIndexing(null);
        }
        catch (Exception e) {
            this.executeFail(e);
            return null;
        }
        return super.postExecute(action, arg, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeIndex(SystemIndexLog log, Context cx) throws Exception {
        int limit = this.checkLicenseForIndexing(log);
        BFoxClientConnection connection = ((BNiagaraStation)this.getDevice()).getClientConnection();
        try {
            BAbstractSystemIndexDeviceExt.getCategoryService(true);
            BAbstractSystemIndexDeviceExt.getNiagaraNetwork(true);
            connection.engageNoRetry((BFoxClientConnection.Interest)this);
            BDataChannel channel = (BDataChannel)connection.getChannels().get("data", BDataChannel.TYPE);
            BNiagaraRemoteQueryFilter[] queryFilters = new BNiagaraRemoteQueryFilter[]{BNiagaraRemoteQueryFilter.make((boolean)true, (boolean)((BAbstractSystemIndexDeviceExt)this.getDeviceExt()).getReceiveExportedIndexFromRemoteStation())};
            BAbstractSystemIndexDeviceExt deviceExt = (BAbstractSystemIndexDeviceExt)this.getDeviceExt();
            BReachableStationInfo info = deviceExt.getReachableStationInfo();
            List entitiesList = channel.resolveReachableStationEntitiesToList(this.getOperationalIndexQueries(), 0, -1, null, (BIPreQueryValidator[])queryFilters, (BIPostQueryFilter[])queryFilters, info != null ? NiagaraDriverUtil.parseRouteToStation((String)info.getRouteToStation(), (boolean)false) : null);
            int size = limit != Integer.MAX_VALUE ? entitiesList.size() : -1;
            String stationNameStr = deviceExt.getStationName();
            connection.disengage((BFoxClientConnection.Interest)this);
            BSystemIndexer.systemIndexToSystemDb((String)stationNameStr, BAbstractSystemIndexDeviceExt.toEntityStream(stationNameStr, entitiesList, size, limit, info), (SystemIndexLog)log, (Context)BAbstractSystemIndexDeviceExt.SystemIndexContextHolder.INDEX_CONTEXT);
            if (size > limit) {
                String[] args = new String[]{stationNameStr, Integer.toString(size), Integer.toString(limit)};
                this.lastLimitExceededMsg = Lexicon.make((String)"systemIndex").getText("systemIndex.exceededEntityLimit", (Object[])args);
                this.setFaultCause(this.lastLimitExceededMsg);
                if (log.isLoggingEnabled()) {
                    log.message("systemIndex", "systemIndex.exceededEntityLimit.noLineFeeds", args);
                }
            } else {
                this.lastLimitExceededMsg = null;
                this.setFaultCause("");
            }
        }
        finally {
            if (connection != null && connection.isEngaged((BFoxClientConnection.Interest)this)) {
                connection.disengage((BFoxClientConnection.Interest)this);
            }
        }
    }

    public void executeOk() {
        String oldFaultCause = this.getFaultCause();
        super.executeOk();
        if (oldFaultCause.equals(this.lastLimitExceededMsg)) {
            this.setFaultCause(oldFaultCause);
        }
    }

    protected void indexDescriptorStarted() throws Exception {
        super.indexDescriptorStarted();
        if (Sys.isStationStarted()) {
            BReachableStationSystemIndexDeviceExt.updateReachableStationMonitor(this.getParent());
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        if (Sys.getStation().isRunning()) {
            BReachableStationSystemIndexDeviceExt.updateReachableStationMonitor(this.getParent());
        }
    }

    protected void indexDescriptorChanged(Property property, Context context) {
        if (this.isRunning() && status.equals(property)) {
            BReachableStationSystemIndexDeviceExt.updateReachableStationMonitor(this.getParent());
        }
        super.indexDescriptorChanged(property, context);
    }

    protected String getIndexDescription(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.indexImport", new Object[]{((BAbstractSystemIndexDeviceExt)this.getDeviceExt()).getStationName()});
    }

    public BIcon getIcon() {
        return icon;
    }

    private int checkLicenseForIndexing(SystemIndexLog log) throws Exception {
        BSystemIndexer.checkServicesOperational((SystemIndexLog)log);
        return ((BAbstractSystemIndexDeviceExt)this.getDeviceExt()).checkLicenseForIndexing();
    }
}

