/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.util;

import javax.baja.query.BNull;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordHistory;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BqlUtil {
    public static Type toType(Class<?> cls) {
        if (BObject.class.isAssignableFrom(cls)) {
            return Sys.getType(cls);
        }
        if (cls == Type.class) {
            return BTypeSpec.TYPE;
        }
        if (cls == String.class) {
            return BString.TYPE;
        }
        if (cls == Long.TYPE) {
            return BLong.TYPE;
        }
        if (cls == Double.TYPE) {
            return BDouble.TYPE;
        }
        if (cls == Float.TYPE) {
            return BFloat.TYPE;
        }
        if (cls == Integer.TYPE) {
            return BInteger.TYPE;
        }
        if (cls == Boolean.TYPE) {
            return BBoolean.TYPE;
        }
        return BString.TYPE;
    }

    public static BObject toBObject(Object o) {
        if (o instanceof BObject) {
            return (BObject)o;
        }
        if (o instanceof String) {
            return BString.make((String)((String)o));
        }
        if (o instanceof Long) {
            return BLong.make((long)((Long)o));
        }
        if (o instanceof Double) {
            return BDouble.make((double)((Double)o));
        }
        if (o instanceof Float) {
            return BFloat.make((float)((Float)o).floatValue());
        }
        if (o instanceof Boolean) {
            return BBoolean.make((boolean)((Boolean)o));
        }
        if (o instanceof Integer) {
            return BInteger.make((int)((Integer)o));
        }
        if (o instanceof Type) {
            return ((Type)o).getTypeSpec();
        }
        if (o == null) {
            return BNull.NULL;
        }
        return BString.make((String)o.toString());
    }

    public static boolean excludeFromResults(Object resultCandidate) {
        return resultCandidate instanceof BPassword || resultCandidate instanceof BPasswordHistory || resultCandidate instanceof BICredentials || resultCandidate instanceof BAbstractAuthenticator;
    }

    public static Context mergeCursorContextFacets(Context originalCx, Context cursorCx) {
        BFacets cursorFacets;
        Context cx = originalCx;
        if (cursorCx != null && (cursorFacets = cursorCx.getFacets()) != null && !cursorFacets.isNull()) {
            BFacets origCxFacets = cx != null ? cx.getFacets() : BFacets.NULL;
            cx = new BasicContext(cx, BFacets.make((BFacets)cursorFacets, (BFacets)origCxFacets));
        }
        return cx;
    }
}

