/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.projection;

import com.tridium.bql.expression.ExprEngine;
import com.tridium.bql.projection.ProjectionColumn;
import com.tridium.bql.projection.ProjectionTableCursor;
import com.tridium.bql.query.BqlVisitor;
import javax.baja.query.BExpression;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public class ExprProjectionColumn
extends ProjectionColumn {
    private final Type type;
    private final BExpression expr;
    private final String name;
    private final ExprEngine engine;
    private final Context cx;

    public ExprProjectionColumn(String name, BExpression expr, Type type, String displayName, ExprEngine engine, Context context) {
        super(displayName);
        this.name = name;
        this.type = type;
        this.expr = expr;
        this.engine = engine;
        this.cx = context;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getDefaultDisplayName(Context cx) {
        BqlVisitor v = new BqlVisitor();
        v.visit(this.expr);
        return v.getQueryString();
    }

    public Type getType() {
        return this.type;
    }

    public int getFlags() {
        return 0;
    }

    public BFacets getFacets() {
        return BFacets.NULL;
    }

    @Override
    public BIObject getProjectionCell(ProjectionTableCursor.ProjectionRow<? extends BIObject> row) {
        return this.engine.evaluate(this.expr, (BObject)row.rowObject(), this.cx);
    }

    @Override
    public String toString() {
        return this.getName() + ',' + this.getType();
    }
}

