/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.filter;

import javax.baja.bql.BIBqlFilter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.BIQueryFilter;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:Enum"})})
@NiagaraProperties(value={@NiagaraProperty(name="enumType", type="BEnum", defaultValue="BDynamicEnum.DEFAULT"), @NiagaraProperty(name="enumValues", type="BVector", defaultValue="new BVector()")})
public class BEnumFilter
extends BComponent
implements BIBqlFilter,
BIQueryFilter {
    @Generated
    public static final Property enumType = BEnumFilter.newProperty((int)0, (BValue)BDynamicEnum.DEFAULT, null);
    @Generated
    public static final Property enumValues = BEnumFilter.newProperty((int)0, (BValue)new BVector(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BEnumFilter.class);

    @Generated
    public BEnum getEnumType() {
        return (BEnum)this.get(enumType);
    }

    @Generated
    public void setEnumType(BEnum v) {
        this.set(enumType, (BValue)v, null);
    }

    @Generated
    public BVector getEnumValues() {
        return (BVector)this.get(enumValues);
    }

    @Generated
    public void setEnumValues(BVector v) {
        this.set(enumValues, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BEnumFilter() {
    }

    public BEnumFilter(BEnum e) {
        this.setEnumType(e);
    }

    public BEnumFilter(BEnum e, BEnum[] initialEnumValues) {
        this.setEnumType(e);
        BVector enumValues = this.getEnumValues();
        enumValues.removeAll();
        for (BEnum enumValue : initialEnumValues) {
            this.getEnumValues().add("e?", (BValue)enumValue);
        }
    }

    @Override
    public void init(BObject o) {
        BEnum e = (BEnum)o;
        this.setEnumType(e);
    }

    @Override
    public String getPredicate(String columnName) {
        BEnum[] enums = this.getEnums();
        if (enums.length == 0) {
            return "";
        }
        StringBuilder s = new StringBuilder(64);
        s.append("(");
        for (int i = 0; i < enums.length; ++i) {
            if (i > 0) {
                s.append(" or ");
            }
            s.append(columnName).append(".ordinal = ").append(enums[i].getOrdinal());
        }
        s.append(")");
        return s.toString();
    }

    public BExpression getExpression(BExpression columnExpression) {
        ExpressionBuilder b = new ExpressionBuilder();
        BEnum[] enumArr = (BEnum[])this.getEnumValues().getChildren(BEnum.class);
        if (enumArr.length == 0) {
            return null;
        }
        for (int i = 0; i < enumArr.length; ++i) {
            b.or(Predicates.eq((BExpression)((BExpression)columnExpression.newCopy()), (BSimple)enumArr[i]));
        }
        return b.getExpression();
    }

    @Override
    public boolean accept(BObject o) {
        BEnum enumToTest = (BEnum)o;
        for (BEnum en : this.getEnums()) {
            if (enumToTest.getOrdinal() != en.getOrdinal()) continue;
            return true;
        }
        return false;
    }

    private BEnum[] getEnums() {
        return (BEnum[])this.getEnumValues().getChildren(BEnum.class);
    }
}

