/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.expression;

import com.tridium.bql.BBqlInterval;
import com.tridium.bql.BDateTimeSource;
import com.tridium.bql.FunctionUtil;
import com.tridium.bql.compiler.Constants;
import com.tridium.bql.compiler.ExprParser;
import com.tridium.bql.compiler.ExprUtil;
import com.tridium.bql.expression.BAggregateFunction;
import com.tridium.bql.expression.BBqlFunction;
import com.tridium.bql.expression.BPath;
import com.tridium.bql.expression.BScalarFunction;
import com.tridium.bql.expression.Pattern;
import com.tridium.expressions.IDateTimeSource;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.baja.naming.UnresolvedException;
import javax.baja.query.BExpression;
import javax.baja.query.BNull;
import javax.baja.query.expression.BBinaryExpression;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.query.expression.BListExpression;
import javax.baja.query.expression.BSimpleExpression;
import javax.baja.query.expression.BUnaryExpression;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BInterface;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.util.BAbsTimeRange;
import javax.baja.util.BTypeSpec;

public class ExprEngine
implements Constants {
    private final IDateTimeSource dts;
    private final HashMap<String, Pattern> patterns;
    private final HashMap<BScalarFunction, Method> scalars;
    private final HashMap<BExpression, BObject> constants;
    private final MorphUtil morpher;
    private BObject target;
    private Context cx;

    public ExprEngine(IDateTimeSource dts) {
        this.dts = dts == null ? new BDateTimeSource() : dts;
        this.patterns = new HashMap();
        this.scalars = new HashMap();
        this.constants = new HashMap();
        this.morpher = new MorphUtil();
    }

    public static BObject instantEval(BExpression expr, BObject target, Context cx) {
        return new ExprEngine(null).evaluate(expr, target, cx);
    }

    public BObject evaluate(BExpression expr, BObject target, Context cx) {
        this.target = target;
        this.cx = cx;
        return this.eval(expr);
    }

    protected BObject eval(BExpression expr) {
        BNull val = BNull.NULL;
        if (this.constants.get(expr) != null) {
            val = this.constants.get(expr);
        } else if (expr instanceof BFieldExpression) {
            val = this.field((BFieldExpression)expr);
        } else if (expr instanceof BBinaryExpression) {
            BBinaryExpression binary = (BBinaryExpression)expr;
            int id = ExprUtil.getOpId(expr);
            switch (id) {
                case 13: {
                    val = this.and(binary);
                    break;
                }
                case 14: {
                    val = this.or(binary);
                    break;
                }
                case 5: {
                    val = this.eq(binary);
                    break;
                }
                case 6: {
                    val = this.ne(binary);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    val = this.comparison(binary, id);
                    break;
                }
                case 11: {
                    val = this.like(binary);
                    break;
                }
                case 15: {
                    val = this.in(binary);
                    break;
                }
                case 0: {
                    val = this.add(binary);
                    break;
                }
                case 1: {
                    val = this.subtract(binary);
                    break;
                }
                case 2: {
                    val = this.multiply(binary);
                    break;
                }
                case 3: {
                    val = this.divide(binary);
                    break;
                }
                case 4: {
                    val = this.modulo(binary);
                    break;
                }
                default: {
                    throw new IllegalStateException("Op id: " + id);
                }
            }
            if (ExprUtil.isConstant(expr)) {
                this.constants.put(expr, (BObject)val);
            }
        } else if (expr instanceof BUnaryExpression) {
            BObject a = this.eval(((BUnaryExpression)expr).operand());
            int id = ExprUtil.getOpId(expr);
            switch (id) {
                case 0: {
                    val = a instanceof BNumber ? a : BNull.NULL;
                    break;
                }
                case 1: {
                    val = BNull.NULL;
                    if (!(a instanceof BNumber)) break;
                    BNumber n = (BNumber)a;
                    if (n instanceof BDouble) {
                        val = BDouble.make((double)(-n.getDouble()));
                        break;
                    }
                    if (n instanceof BFloat) {
                        val = BFloat.make((float)(-n.getFloat()));
                        break;
                    }
                    if (n instanceof BLong) {
                        val = BLong.make((long)(-n.getLong()));
                        break;
                    }
                    if (n instanceof BInteger) {
                        val = BInteger.make((int)(-n.getInt()));
                        break;
                    }
                    throw new IllegalStateException(n.toString());
                }
                case 12: {
                    val = a instanceof BBoolean ? ((BBoolean)a).not() : BNull.NULL;
                    break;
                }
                default: {
                    throw new IllegalStateException("Op id: " + id);
                }
            }
            if (ExprUtil.isConstant(expr)) {
                this.constants.put(expr, (BObject)val);
            }
        } else if (expr instanceof BSimpleExpression) {
            val = ((BSimpleExpression)expr).getSimpleValue();
        } else if (expr instanceof BBqlFunction) {
            val = ((BBqlFunction)expr).isScalar() ? this.scalar((BScalarFunction)expr) : ((BAggregateFunction)expr).evaluate(this.target, this.cx);
        } else {
            throw new IllegalStateException(expr.getType().toString());
        }
        return val;
    }

    protected BObject field(BFieldExpression node) {
        BPath path = null;
        path = node instanceof BPath ? (BPath)node : new BPath(node.getField());
        BObject result = path.evaluate(this.target, this.cx);
        return result == null ? BNull.NULL : result;
    }

    protected BObject and(BBinaryExpression node) {
        BObject objResult = this.eval(node.lhs());
        if (!(objResult instanceof BBoolean)) {
            return BNull.NULL;
        }
        BBoolean lhsResult = (BBoolean)objResult;
        if (!lhsResult.getBoolean()) {
            return BBoolean.FALSE;
        }
        objResult = this.eval(node.rhs());
        if (!(objResult instanceof BBoolean)) {
            return BNull.NULL;
        }
        return objResult;
    }

    protected BObject or(BBinaryExpression node) {
        BObject objResult = this.eval(node.lhs());
        if (objResult == BNull.NULL) {
            objResult = BBoolean.FALSE;
        }
        if (!(objResult instanceof BBoolean)) {
            return BNull.NULL;
        }
        BBoolean lhsResult = (BBoolean)objResult;
        if (lhsResult.getBoolean()) {
            return BBoolean.TRUE;
        }
        objResult = this.eval(node.rhs());
        if (!(objResult instanceof BBoolean)) {
            return BNull.NULL;
        }
        return objResult;
    }

    protected BObject eq(BBinaryExpression node) {
        return this.eq(this.eval(node.lhs()), this.eval(node.rhs()));
    }

    protected BBoolean eq(BObject lhs, BObject rhs) {
        try {
            MorphUtil.MorphedTuple mt = this.morpher.morph(lhs, rhs);
            lhs = mt.lhs;
            rhs = mt.rhs;
            if (lhs.isNull()) {
                return BBoolean.make((boolean)rhs.isNull());
            }
            if (rhs.isNull()) {
                return BBoolean.FALSE;
            }
            if (this.bothComparable(lhs, rhs)) {
                return BBoolean.make((this.doCompare(lhs, rhs) == 0 ? 1 : 0) != 0);
            }
            if (lhs instanceof BTypeSpec && rhs instanceof BTypeSpec) {
                Type lType = ((BTypeSpec)lhs).getResolvedType();
                Type rType = ((BTypeSpec)rhs).getResolvedType();
                return BBoolean.make((boolean)lType.is(rType));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return BBoolean.make((boolean)lhs.equals((Object)rhs));
    }

    protected BObject ne(BBinaryExpression node) {
        return ((BBoolean)this.eq(node)).not();
    }

    protected BObject comparison(BBinaryExpression node, int id) {
        BObject lhs = this.eval(node.lhs());
        BObject rhs = this.eval(node.rhs());
        MorphUtil.MorphedTuple mt = this.morpher.morph(lhs, rhs);
        lhs = mt.lhs;
        rhs = mt.rhs;
        if (this.bothComparable(lhs, rhs)) {
            try {
                switch (id) {
                    case 7: {
                        return BBoolean.make((this.doCompare(lhs, rhs) > 0 ? 1 : 0) != 0);
                    }
                    case 8: {
                        return BBoolean.make((this.doCompare(lhs, rhs) >= 0 ? 1 : 0) != 0);
                    }
                    case 9: {
                        return BBoolean.make((this.doCompare(lhs, rhs) < 0 ? 1 : 0) != 0);
                    }
                    case 10: {
                        return BBoolean.make((this.doCompare(lhs, rhs) <= 0 ? 1 : 0) != 0);
                    }
                }
                throw new IllegalArgumentException("Invalid comparison operator id: " + id);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return BNull.NULL;
    }

    protected BObject like(BBinaryExpression node) {
        String test = null;
        BObject lhs = this.eval(node.lhs());
        String pStr = ((BString)this.eval(node.rhs())).getString();
        test = lhs instanceof BString ? ((BString)lhs).getString() : lhs.toString();
        Pattern p = null;
        p = this.patterns.get(pStr);
        if (p == null) {
            p = new Pattern(pStr);
            this.patterns.put(pStr, p);
        }
        return p.isMatch(test) ? BBoolean.TRUE : BBoolean.FALSE;
    }

    protected BObject in(BBinaryExpression node) {
        BObject lhs = this.eval(node.lhs());
        if (lhs.isNull()) {
            return BNull.NULL;
        }
        if (node.rhs() instanceof BListExpression) {
            BListExpression list = (BListExpression)node.rhs();
            BExpression[] exprs = list.getExpressions();
            for (int i = 0; i < exprs.length; ++i) {
                if (!this.eq(lhs, this.eval(exprs[i])).getBoolean()) continue;
                return BBoolean.TRUE;
            }
            return BBoolean.FALSE;
        }
        if (node.rhs() instanceof BScalarFunction) {
            if (!(lhs instanceof BAbsTime)) {
                return BNull.NULL;
            }
            BScalarFunction f = (BScalarFunction)node.rhs();
            BObject rhs = this.eval((BExpression)f);
            if (!(rhs instanceof BAbsTimeRange)) {
                return BNull.NULL;
            }
            return BBoolean.make((boolean)((BAbsTimeRange)rhs).includes((BAbsTime)lhs));
        }
        return BNull.NULL;
    }

    protected BObject add(BBinaryExpression node) {
        BObject lhs = this.eval(node.lhs());
        BObject rhs = this.eval(node.rhs());
        if (lhs instanceof BNumber && rhs instanceof BNumber) {
            BNumber a = (BNumber)lhs;
            BNumber b = (BNumber)rhs;
            if (a instanceof BDouble || b instanceof BDouble) {
                return BDouble.make((double)(a.getDouble() + b.getDouble()));
            }
            if (a instanceof BFloat || b instanceof BFloat) {
                return BFloat.make((float)(a.getFloat() + b.getFloat()));
            }
            if (a instanceof BLong || b instanceof BLong) {
                return BLong.make((long)(a.getLong() + b.getLong()));
            }
            return BInteger.make((int)(a.getInt() + b.getInt()));
        }
        if (lhs instanceof BAbsTime && this.canAddToAbsTime(rhs)) {
            return this.addTime((BAbsTime)lhs, rhs);
        }
        if (lhs instanceof BString) {
            return BString.make((String)lhs.toString().concat(rhs.toString()));
        }
        if (rhs instanceof BAbsTime && this.canAddToAbsTime(lhs)) {
            return this.addTime((BAbsTime)rhs, lhs);
        }
        if (rhs instanceof BString) {
            return BString.make((String)lhs.toString().concat(rhs.toString()));
        }
        return BNull.NULL;
    }

    protected BObject addTime(BAbsTime t1, BObject t2) {
        if (t2 instanceof BRelTime) {
            return t1.add((BRelTime)t2);
        }
        if (t2 instanceof BBqlInterval) {
            return ((BBqlInterval)t2).addTo(t1);
        }
        return BNull.NULL;
    }

    protected boolean canAddToAbsTime(BObject v) {
        return v instanceof BRelTime || v instanceof BBqlInterval;
    }

    protected BObject subtract(BBinaryExpression node) {
        BObject lhs = this.eval(node.lhs());
        BObject rhs = this.eval(node.rhs());
        if (lhs instanceof BNumber && rhs instanceof BNumber) {
            BNumber a = (BNumber)lhs;
            BNumber b = (BNumber)rhs;
            if (a instanceof BDouble || b instanceof BDouble) {
                return BDouble.make((double)(a.getDouble() - b.getDouble()));
            }
            if (a instanceof BFloat || b instanceof BFloat) {
                return BFloat.make((float)(a.getFloat() - b.getFloat()));
            }
            if (a instanceof BLong || b instanceof BLong) {
                return BLong.make((long)(a.getLong() - b.getLong()));
            }
            return BInteger.make((int)(a.getInt() - b.getInt()));
        }
        if (lhs instanceof BAbsTime) {
            return this.subtractTime((BAbsTime)lhs, rhs);
        }
        return BNull.NULL;
    }

    protected BObject subtractTime(BAbsTime t1, BObject t2) {
        if (t2 instanceof BRelTime) {
            return t1.subtract((BRelTime)t2);
        }
        if (t2 instanceof BBqlInterval) {
            return ((BBqlInterval)t2).subtractFrom(t1);
        }
        return BNull.NULL;
    }

    protected BObject multiply(BBinaryExpression node) {
        BObject lhs = this.eval(node.lhs());
        BObject rhs = this.eval(node.rhs());
        if (lhs instanceof BNumber && rhs instanceof BNumber) {
            BNumber a = (BNumber)lhs;
            BNumber b = (BNumber)rhs;
            if (a instanceof BDouble || b instanceof BDouble) {
                return BDouble.make((double)(a.getDouble() * b.getDouble()));
            }
            if (a instanceof BFloat || b instanceof BFloat) {
                return BFloat.make((float)(a.getFloat() * b.getFloat()));
            }
            if (a instanceof BLong || b instanceof BLong) {
                return BLong.make((long)(a.getLong() * b.getLong()));
            }
            return BInteger.make((int)(a.getInt() * b.getInt()));
        }
        return BNull.NULL;
    }

    protected BObject divide(BBinaryExpression node) {
        BObject lhs = this.eval(node.lhs());
        BObject rhs = this.eval(node.rhs());
        if (lhs instanceof BNumber && rhs instanceof BNumber) {
            BNumber a = (BNumber)lhs;
            BNumber b = (BNumber)rhs;
            try {
                if (a instanceof BDouble || b instanceof BDouble) {
                    return BDouble.make((double)(a.getDouble() / b.getDouble()));
                }
                if (a instanceof BFloat || b instanceof BFloat) {
                    return BFloat.make((float)(a.getFloat() / b.getFloat()));
                }
                if (a instanceof BLong || b instanceof BLong) {
                    return BLong.make((long)(a.getLong() / b.getLong()));
                }
                return BInteger.make((int)(a.getInt() / b.getInt()));
            }
            catch (ArithmeticException divByZero) {
                return BNull.NULL;
            }
        }
        return BNull.NULL;
    }

    protected BObject modulo(BBinaryExpression node) {
        BObject lhs = this.eval(node.lhs());
        BObject rhs = this.eval(node.rhs());
        if (lhs instanceof BNumber && rhs instanceof BNumber) {
            BNumber a = (BNumber)lhs;
            BNumber b = (BNumber)rhs;
            try {
                if (a instanceof BDouble || b instanceof BDouble) {
                    return BDouble.make((double)(a.getDouble() % b.getDouble()));
                }
                if (a instanceof BFloat || b instanceof BFloat) {
                    return BFloat.make((float)(a.getFloat() % b.getFloat()));
                }
                if (a instanceof BLong || b instanceof BLong) {
                    return BLong.make((long)(a.getLong() % b.getLong()));
                }
                return BInteger.make((int)(a.getInt() % b.getInt()));
            }
            catch (ArithmeticException divByZero) {
                return BNull.NULL;
            }
        }
        return BNull.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BObject scalar(BScalarFunction scalarFunc) {
        BExpression[] paramExprs = scalarFunc.getParameters();
        BObject[] actualParams = new BObject[paramExprs.length + 1];
        actualParams[0] = ExprParser.TIME_LIB.equals((Object)scalarFunc.getLib()) ? this.dts.currentAbsTime() : this.target;
        for (int i = 0; i < paramExprs.length; ++i) {
            actualParams[i + 1] = this.eval(paramExprs[i]);
            if (!actualParams[i + 1].isNull()) continue;
            return BNull.NULL;
        }
        Method method = null;
        ExprEngine exprEngine = this;
        synchronized (exprEngine) {
            method = this.scalars.get((Object)scalarFunc);
            if (method == null) {
                method = this.resolveFunction(scalarFunc, actualParams);
                this.scalars.put(scalarFunc, method);
            }
        }
        if (method == null) {
            return BNull.NULL;
        }
        try {
            return (BObject)method.invoke(null, (Object[])actualParams);
        }
        catch (Exception x) {
            x.printStackTrace();
            return BNull.NULL;
        }
    }

    private boolean bothComparable(BObject a, BObject b) {
        return a instanceof Comparable && b instanceof Comparable;
    }

    private int doCompare(BObject lhs, BObject rhs) throws ClassCastException {
        Comparable lcomp = (Comparable)lhs;
        Comparable rcomp = (Comparable)rhs;
        if (lhs.getClass() == rhs.getClass()) {
            return lcomp.compareTo(rcomp);
        }
        if (lhs.getClass().isInstance(rhs)) {
            return lcomp.compareTo(rcomp);
        }
        if (rhs.getClass().isInstance(lhs)) {
            return -rcomp.compareTo(lcomp);
        }
        throw new ClassCastException(lhs.getType() + " not comparable to " + rhs.getType());
    }

    private Method resolveFunction(BBqlFunction func, BObject[] params) {
        Method method = null;
        Class[] paramTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i].getClass();
        }
        try {
            method = FunctionUtil.getFunction(func.getLib().getResolvedType().getTypeClass(), func.getFunctionName(), paramTypes, true);
        }
        catch (Exception i) {
            // empty catch block
        }
        if (method == null) {
            throw new UnresolvedException("Function not found with matching parameters: " + BBqlFunction.toFunctionDebug(func.getFunctionName(), paramTypes));
        }
        Class<?> retType = method.getReturnType();
        if (!BObject.class.isAssignableFrom(retType) && !BInterface.class.isAssignableFrom(retType)) {
            throw new UnresolvedException("Return type must be a BObject.  Return type for " + func.getFunctionName() + " is " + method.getReturnType().getName());
        }
        try {
            func.setReturnType(BTypeSpec.make((Type)((Type)method.getReturnType().getField("TYPE").get(null))));
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new UnresolvedException("Could not set return type for the function: " + func.getFunctionName());
        }
        return method;
    }

    public static final class MorphUtil {
        public MorphedTuple morph(BObject lhs, BObject rhs) {
            if (lhs.getClass() == rhs.getClass()) {
                return new MorphedTuple(lhs, rhs);
            }
            if (this.isNumber(lhs) && this.isNumber(rhs)) {
                return this.morphNumbers((BNumber)lhs, (BNumber)rhs);
            }
            if (this.isMorphable(rhs)) {
                if (this.isNumber(rhs) && this.isString(lhs)) {
                    return new MorphedTuple(lhs, (BObject)BString.make((String)rhs.toString()));
                }
                if (this.isString(rhs)) {
                    return new MorphedTuple(lhs, this.morphAs((BString)rhs, lhs));
                }
            } else if (this.isMorphable(lhs) && this.isString(lhs)) {
                return new MorphedTuple(this.morphAs((BString)lhs, rhs), rhs);
            }
            return new MorphedTuple(lhs, rhs);
        }

        private BObject morphAs(BString str, BObject prototype) {
            if (!prototype.isSimple()) {
                return str;
            }
            String encoding = str.toString();
            if (prototype.getType().is(BBoolean.TYPE)) {
                if (encoding.equalsIgnoreCase("true")) {
                    return BBoolean.TRUE;
                }
                if (encoding.equalsIgnoreCase("false")) {
                    return BBoolean.FALSE;
                }
                return str;
            }
            try {
                return prototype.asSimple().decodeFromString(encoding);
            }
            catch (Exception x) {
                return str;
            }
        }

        private MorphedTuple morphNumbers(BNumber lhs, BNumber rhs) {
            if (lhs instanceof BDouble || rhs instanceof BDouble) {
                return new MorphedTuple((BObject)BDouble.make((double)lhs.getDouble()), (BObject)BDouble.make((double)rhs.getDouble()));
            }
            if (lhs instanceof BFloat || rhs instanceof BFloat) {
                return new MorphedTuple((BObject)BFloat.make((float)lhs.getFloat()), (BObject)BFloat.make((float)rhs.getFloat()));
            }
            if (lhs instanceof BLong || rhs instanceof BLong) {
                return new MorphedTuple((BObject)BLong.make((long)lhs.getLong()), (BObject)BLong.make((long)rhs.getLong()));
            }
            return new MorphedTuple((BObject)BInteger.make((int)lhs.getInt()), (BObject)BInteger.make((int)rhs.getInt()));
        }

        public boolean isMorphable(BObject v) {
            return this.isString(v) || this.isNumber(v);
        }

        private boolean isNumber(BObject v) {
            return v instanceof BNumber;
        }

        private boolean isString(BObject v) {
            return v instanceof BString;
        }

        public static final class MorphedTuple {
            public BObject lhs;
            public BObject rhs;

            public MorphedTuple(BObject lhs, BObject rhs) {
                this.lhs = lhs;
                this.rhs = rhs;
            }
        }
    }
}

