/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.collection;

import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.sys.BajaRuntimeException;

public class BqlColumnList
implements ColumnList {
    private ArrayList<Column> list;
    private HashMap<String, Column> table;

    public BqlColumnList() {
        this.list = new ArrayList(5);
        this.table = new HashMap();
    }

    public BqlColumnList(Column column) {
        this();
        this.addColumn(column);
    }

    public BqlColumnList(Column[] columns) {
        this.list = new ArrayList(columns.length);
        this.table = new HashMap();
        for (int i = 0; i < columns.length; ++i) {
            this.addColumn(columns[i]);
        }
    }

    public void addColumn(Column column) {
        this.list.add(column);
        this.table.put(column.getName(), column);
        if (this.list.size() != this.table.size()) {
            throw new BajaRuntimeException("Duplicate column: " + column.getName());
        }
    }

    public int size() {
        return this.list.size();
    }

    public Column get(int index) {
        return this.list.get(index);
    }

    public Column get(String name) {
        return this.table.get(name);
    }

    public int indexOf(String name) {
        int count = this.list.size();
        for (int i = 0; i < count; ++i) {
            if (!this.list.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public Column[] list() {
        return this.list.toArray(new Column[0]);
    }
}

