/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.collection;

import com.tridium.bql.collection.BObjectTable;
import com.tridium.collection.BListTable;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BObjectList
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BObjectList.class);
    private final ArrayList<BIObject> list;
    private final Context context;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BObjectList(Cursor<? extends BIObject> c) {
        this.context = c.getContext();
        this.list = new ArrayList(16);
        while (c.next()) {
            this.list.add((BIObject)c.get());
        }
    }

    public Cursor<? extends BIObject> cursor() {
        return new ObjectListCursor(this.list, this.context);
    }

    public int size() {
        return this.list.size();
    }

    public BObject get(int index) {
        return (BObject)this.list.get(index);
    }

    public BObject[] list() {
        return this.list.toArray(new BObject[0]);
    }

    public BObject[] list(BObject[] in) {
        return this.list.toArray(in);
    }

    public BITable<? extends BIObject> toTable() {
        return new BObjectTable((BITable<? extends BIObject>)new BListTable(this.list));
    }

    private static class ObjectListCursor
    implements IterableCursor<BIObject> {
        private final ArrayList<? extends BIObject> list;
        private final Context context;
        private int index;

        public ObjectListCursor(ArrayList<? extends BIObject> list, Context context) {
            this.list = list;
            this.context = context;
            this.index = -1;
        }

        public Context getContext() {
            return this.context;
        }

        public boolean next() {
            int size = this.list.size();
            if (this.index == size) {
                return false;
            }
            ++this.index;
            return this.index != size;
        }

        public BIObject get() {
            return this.list.get(this.index);
        }

        public void close() {
            this.index = this.list.size();
        }
    }
}

