/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql;

import com.tridium.bql.RangeSet;
import com.tridium.bql.RangeSetImpl;
import javax.baja.query.BNull;
import javax.baja.sys.BSimple;

public class Range
implements RangeSet,
Comparable<Range> {
    public static final Range ALL = new Range(null, false, null, false);
    public static final Range NONE = new Range(null, true, null, true);
    public final BSimple min;
    public final boolean minInclusive;
    public final BSimple max;
    public final boolean maxInclusive;

    public Range(BSimple singleton) {
        this(singleton, true, singleton, true);
    }

    public Range(BSimple min, boolean minInclusive, BSimple max, boolean maxInclusive) {
        if (min != null && min.equals((Object)BNull.NULL)) {
            min = null;
        }
        if (max != null && max.equals((Object)BNull.NULL)) {
            max = null;
        }
        this.min = min;
        this.max = max;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        if (min != null && max != null) {
            if (!min.getType().equals(max.getType())) {
                throw new IllegalStateException("min and max must have same type.");
            }
            if (!(min instanceof Comparable) && !this.isSingletonRange()) {
                throw new IllegalStateException("must be a singleton range if items in range are not Comparable.");
            }
        }
    }

    public boolean isSingletonRange() {
        return this.minInclusive && this.maxInclusive && this.min != null && this.max != null && this.min.equals((Object)this.max);
    }

    public BSimple getSingleton() {
        if (!this.isSingletonRange()) {
            throw new IllegalStateException("Not singleton range.");
        }
        return this.min;
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public Range getRange(int index) {
        if (index == 0) {
            return this;
        }
        throw new ArrayIndexOutOfBoundsException(index + 62 + 0);
    }

    @Override
    public RangeSet intersection() {
        return this;
    }

    @Override
    public boolean isAll() {
        return this.min == null && !this.minInclusive && this.max == null && !this.maxInclusive;
    }

    @Override
    public boolean isNone() {
        return this.min == null && this.minInclusive && this.max == null && this.maxInclusive;
    }

    @Override
    public RangeSet not() {
        Range r1 = null;
        Range r2 = null;
        if (this.isAll()) {
            return NONE;
        }
        if (this.isNone()) {
            return ALL;
        }
        if (this.min != null) {
            r1 = new Range(null, false, this.min, !this.minInclusive);
        }
        if (this.max != null) {
            r2 = new Range(this.max, !this.maxInclusive, null, false);
        }
        if (r1 != null && r2 != null) {
            return new RangeSetImpl(new Range[]{r1, r2});
        }
        if (r1 != null) {
            return r1;
        }
        return r2;
    }

    @Override
    public void sort() {
    }

    @Override
    public RangeSet union() {
        return this;
    }

    @Override
    public int compareTo(Range o) {
        int result;
        Range r1 = this;
        Range r2 = o;
        if (r1.isAll() || r2.isAll()) {
            if (r1.isAll() && r2.isAll()) {
                return 0;
            }
            if (r1.isAll()) {
                return 1;
            }
            return -1;
        }
        if (r1.isNone() || r2.isNone()) {
            if (r1.isNone() && r2.isNone()) {
                return 0;
            }
            if (r1.isNone()) {
                return -1;
            }
            return 1;
        }
        if (r1.min == null && r2.min != null) {
            return -1;
        }
        if (r1.min != null && r2.min == null) {
            return 1;
        }
        if (r1.min != null && r2.min != null) {
            if (r1.min instanceof Comparable) {
                result = ((Comparable)r1.min).compareTo(r2.min);
                if (result != 0) {
                    return result;
                }
                if (r1.minInclusive && !r2.minInclusive) {
                    return -1;
                }
                if (!r1.minInclusive && r2.minInclusive) {
                    return 1;
                }
            } else {
                if (!r1.isSingletonRange() || !r2.isSingletonRange()) {
                    throw new IllegalStateException("cannot compare non-Comparables that are not singleton ranges.");
                }
                if (r1.min.equals((Object)r2.min)) {
                    return 0;
                }
                return r1.min.toString().compareTo(r2.min.toString());
            }
        }
        if (r1.max == null && r2.max != null) {
            return 1;
        }
        if (r1.max != null && r2.max == null) {
            return -1;
        }
        if (r1.max != null && r2.max != null) {
            result = ((Comparable)r1.max).compareTo(r2.max);
            if (result != 0) {
                return result;
            }
            if (r1.maxInclusive && !r2.maxInclusive) {
                return 1;
            }
            if (!r1.maxInclusive && r2.maxInclusive) {
                return -1;
            }
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
        result = 31 * result + (this.maxInclusive ? 1231 : 1237);
        result = 31 * result + (this.min == null ? 0 : this.min.hashCode());
        result = 31 * result + (this.minInclusive ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        if (this.max == null ? other.max != null : !this.max.equals((Object)other.max)) {
            return false;
        }
        if (this.maxInclusive != other.maxInclusive) {
            return false;
        }
        if (this.min == null ? other.min != null : !this.min.equals((Object)other.min)) {
            return false;
        }
        return this.minInclusive == other.minInclusive;
    }

    public String toString() {
        if (this.isAll()) {
            return "(-inf, inf)";
        }
        if (this.isNone()) {
            return "()";
        }
        StringBuilder sb = new StringBuilder(16);
        if (this.min == null) {
            sb.append("(-inf");
        } else {
            if (this.minInclusive) {
                sb.append('[');
            } else {
                sb.append('(');
            }
            sb.append(this.min);
        }
        sb.append(", ");
        if (this.max == null) {
            sb.append("inf)");
        } else {
            sb.append(this.max);
            if (this.maxInclusive) {
                sb.append(']');
            } else {
                sb.append(')');
            }
        }
        return sb.toString();
    }

    public final BSimple getMin() {
        return this.min;
    }

    public final BSimple getMax() {
        return this.max;
    }

    public final boolean getMinInclusive() {
        return this.minInclusive;
    }

    public final boolean getMaxInclusive() {
        return this.maxInclusive;
    }

    public static RangeSet union(Range r1, Range r2) {
        Range temp = null;
        if (r1.equals(r2)) {
            return r1;
        }
        if (r1.isSingletonRange() && r2.isSingletonRange()) {
            return new RangeSetImpl(new Range[]{r1, r2});
        }
        if (r1.compareTo(r2) > 0) {
            temp = r1;
            r1 = r2;
            r2 = temp;
        }
        if (r1.isNone()) {
            return r2;
        }
        if (Range.intersection(r1, r2).isNone()) {
            Range tempR1 = new Range(r1.max, true, null, false);
            Range tempR2 = new Range(r2.min, true, null, false);
            if (tempR1.compareTo(tempR2) == 0 && (r1.maxInclusive || r2.minInclusive)) {
                return new Range(r1.min, r1.minInclusive, r2.max, r2.maxInclusive);
            }
            return new RangeSetImpl(new Range[]{r1, r2});
        }
        if (r1.min == null && r2.max == null) {
            return ALL;
        }
        temp = new Range(r1.min, r1.minInclusive, r2.max, r2.maxInclusive);
        if (r1.compareTo(temp) < 0) {
            return temp;
        }
        return r1;
    }

    public static Range intersection(Range r1, Range r2) {
        Range temp;
        if (r1.isAll()) {
            return r2;
        }
        if (r2.isAll()) {
            return r1;
        }
        if (r1.isNone() || r2.isNone()) {
            return NONE;
        }
        if (r1.equals(r2)) {
            return r1;
        }
        if (r1.compareTo(r2) > 0) {
            temp = r1;
            r1 = r2;
            r2 = temp;
        }
        Range lowBound = null;
        Range highBound = null;
        Range result = null;
        lowBound = new Range(r1.max, true, null, false);
        highBound = new Range(r2.min, true, null, false);
        if (lowBound.compareTo(highBound) == 0) {
            if (!r1.maxInclusive || !r2.minInclusive) {
                return NONE;
            }
            return new Range(r1.max);
        }
        result = new Range(r2.min, r2.minInclusive, r1.max, r1.maxInclusive);
        if (r2.min != null && result.compareTo(temp = new Range(r2.min, r2.minInclusive, r2.min, r2.minInclusive)) < 0) {
            return NONE;
        }
        temp = new Range(result.min, result.minInclusive, r2.max, r2.maxInclusive);
        if (result.compareTo(temp) > 0) {
            result = temp;
        }
        return result;
    }
}

