/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss.dashboard;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.json.JSONObject;
import com.tridium.nss.dashboard.AbstractFoxRemoteDashboardDataRetriever;
import com.tridium.nss.dashboard.BFoxSecurityDashboardChannel;
import com.tridium.nss.dashboard.BSecurityDashboardDataImport;
import com.tridium.nss.dashboard.DashboardNotSupportedException;
import com.tridium.nss.dashboard.IRemoteDashboardDataRetriever;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.baja.entityIo.json.JsonEntityEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;

public final class FoxRemoteDashboardDataRetriever
extends AbstractFoxRemoteDashboardDataRetriever
implements IRemoteDashboardDataRetriever,
BFoxClientConnection.Interest {
    public FoxRemoteDashboardDataRetriever(BSecurityDashboardDataImport importDescriptor) {
        super(importDescriptor);
    }

    @Override
    protected void checkRemoteVersion() throws DashboardNotSupportedException {
        if (this.getRemoteVersion().compareTo(BFoxSecurityDashboardChannel.VERSION_4_8) < 0) {
            throw new DashboardNotSupportedException(LEX_MOD.get("foxDataRetriever.remoteVersionUnsupported", null));
        }
    }

    @Override
    protected void checkRemoteStationForNssModule() throws DashboardNotSupportedException {
        this.checkForNssModule(new String[0]);
    }

    @Override
    protected void checkRemoteStationForSecurityService() throws DashboardNotSupportedException {
        boolean hasEnabledSecurityService;
        try {
            BOrd query = BOrd.make((String)"station:|slot:/Services|bql:select * from nss:SecurityService where enabled = true");
            BOrdList queries = BOrdList.make((BOrd)query);
            Stream remoteEntities = this.getDataChannel().resolveEntities(queries, -1, 1, JsonEntityEncoder.NO_TAGS_OR_RELATIONS, null, null);
            hasEnabledSecurityService = remoteEntities.findFirst().isPresent();
        }
        catch (Exception e) {
            hasEnabledSecurityService = true;
            LOGGER.log(Level.FINE, "Could not determine if remote station has an enabled SecurityService", e);
        }
        if (!hasEnabledSecurityService) {
            throw new DashboardNotSupportedException(LEX_MOD.get("foxDataRetriever.remoteStationHasNoSecurityService", null));
        }
    }

    @Override
    protected JSONObject getRemoteStationDashboardInfo(BFoxSecurityDashboardChannel foxChannel) throws Exception {
        return foxChannel.getStationDashboardInfo(new String[0]);
    }
}

