/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss.dashboard;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxClientWebsocketBehavior;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nss.BSystemDashboardStationLinkMode;
import com.tridium.nss.dashboard.BAbstractSecurityDashboardDeviceExt;
import com.tridium.nss.dashboard.FoxRemoteDashboardDataRetriever;
import com.tridium.nss.dashboard.IRemoteDashboardDataRetriever;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraStation"})})
public final class BSecurityDashboardDeviceExt
extends BAbstractSecurityDashboardDeviceExt {
    @Generated
    public static final Type TYPE = Sys.loadType(BSecurityDashboardDeviceExt.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    IRemoteDashboardDataRetriever getDataRetriever() {
        return new FoxRemoteDashboardDataRetriever(this.getDataImporter());
    }

    @Override
    public String getStationName() {
        return this.getDevice().getName();
    }

    @Override
    protected BStatus getStatus() {
        return this.getDevice().getStatus();
    }

    @Override
    protected boolean isStationUnavailable() {
        return this.getDataImporter().isUnoperational() || this.getDevice().isFault() || this.getDevice().isDown() || this.getDevice().isDisabled();
    }

    @Override
    protected Optional<String> getRemoteHostSecurityDashboardViewFoxOrd() {
        try {
            BFoxClientConnection clientConnection = this.getClientConnection();
            BOrd foxSessionOrd = BFoxClientWebsocketBehavior.useWebsocketOnly.equals((Object)clientConnection.getFoxOverWebsocket()) ? BOrd.make((String)("foxwss:" + clientConnection.getFoxOverWebsocketPort())) : (clientConnection.getUseFoxs() ? BOrd.make((String)("foxs:" + clientConnection.getPort())) : BOrd.make((String)("fox:" + clientConnection.getPort())));
            BOrd foxBase = BOrd.make((BOrd)clientConnection.getRemoteHost().getAbsoluteOrd(), (BOrd)foxSessionOrd);
            return Optional.of(BOrd.make((BOrd)foxBase, (BOrd)SECURITY_SERVICE_DASHBOARD_VIEW_ORD).toString());
        }
        catch (Exception e) {
            Level level;
            BDevice device = this.getDevice();
            String message = "Could not get security dashboard view ord for remote station " + (device != null ? device.getName() : "");
            Level level2 = level = LOGGER.isLoggable(Level.FINE) ? Level.FINE : Level.INFO;
            if (LOGGER.isLoggable(level)) {
                LOGGER.log(level, message);
            }
            return Optional.empty();
        }
    }

    @Override
    protected Optional<String> getRemoteHostSecurityDashboardViewHttpUri() {
        return this.getHttpsPort().map(httpsPort -> "https://" + this.getClientConnection().getRemoteHost().getHostname() + ":" + httpsPort + "/ord/" + SECURITY_SERVICE_DASHBOARD_VIEW_ORD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refreshHttpsPort() {
        this.remoteHttpsPort = null;
        if (!this.isStationUnavailable()) {
            try {
                try {
                    this.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Could not connect to NiagaraNetwork station <" + this.getNiagaraStation().getName() + "> to determine HTTPS port. Security dashboard link will be disabled", e);
                    }
                    if (this.getClientConnection().isEngaged((BFoxClientConnection.Interest)this)) {
                        this.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                    }
                    return;
                }
                BDataChannel dataChannel = (BDataChannel)((BNiagaraStation)this.getDevice()).getClientConnection().getChannels().get("data", BDataChannel.TYPE);
                BOrd query = BOrd.make((String)"station:|slot:/Services|bql:select httpsPort.publicServerPort from web:WebService where httpsEnabled = true");
                BITable table = (BITable)dataChannel.resolve(query, new String[0]);
                ColumnList columns = table.getColumns();
                Column firstColumn = columns.get(0);
                try (TableCursor cursor = table.cursor();){
                    if (cursor.next()) {
                        this.remoteHttpsPort = ((BInteger)cursor.cell(firstColumn).as(BInteger.class)).getInt();
                    }
                }
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Could not determine HTTPS port for NiagaraNetwork station <" + this.getNiagaraStation().getName() + ">. Security dashboard link will be disabled", e);
                }
            }
            finally {
                if (this.getClientConnection().isEngaged((BFoxClientConnection.Interest)this)) {
                    this.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                }
            }
        }
    }

    @Override
    protected boolean shouldDisplayRemoteLink(BSystemDashboardStationLinkMode linkMode) {
        return linkMode.equals((Object)BSystemDashboardStationLinkMode.remoteAndReachable) || linkMode.equals((Object)BSystemDashboardStationLinkMode.remote);
    }

    @Override
    protected void doCheckParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BNiagaraStation.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
    }
}

