/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss.dashboard;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.UnreachableStationException;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BReachableStationInfo;
import com.tridium.nd.sysdef.BReachableStations;
import com.tridium.nd.util.NiagaraDriverUtil;
import com.tridium.nss.BSystemDashboardStationLinkMode;
import com.tridium.nss.dashboard.BAbstractSecurityDashboardDeviceExt;
import com.tridium.nss.dashboard.IRemoteDashboardDataRetriever;
import com.tridium.nss.dashboard.ReachableStationFoxRemoteDashboardDataRetriever;
import com.tridium.util.CompUtil;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:ReachableStationInfo"})})
@NiagaraProperty(name="usedByLastSecurityDashboardDataImport", type="boolean", defaultValue="false", flags=1)
public class BReachableStationSecurityDashboardDeviceExt
extends BAbstractSecurityDashboardDeviceExt {
    @Generated
    public static final Property usedByLastSecurityDashboardDataImport = BReachableStationSecurityDashboardDeviceExt.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BReachableStationSecurityDashboardDeviceExt.class);
    private BStatus reachableStatus = BStatus.ok;

    @Generated
    public boolean getUsedByLastSecurityDashboardDataImport() {
        return this.getBoolean(usedByLastSecurityDashboardDataImport);
    }

    @Generated
    public void setUsedByLastSecurityDashboardDataImport(boolean v) {
        this.setBoolean(usedByLastSecurityDashboardDataImport, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    IRemoteDashboardDataRetriever getDataRetriever() {
        return new ReachableStationFoxRemoteDashboardDataRetriever(this.getDataImporter());
    }

    @Override
    public String getStationName() {
        return ((BReachableStationInfo)this.getParent()).getStationName();
    }

    @Override
    protected BStatus getStatus() {
        return BStatus.make((int)(this.reachableStatus.getBits() | this.getDevice().getStatus().getBits()));
    }

    @Override
    protected boolean isStationUnavailable() {
        return this.getDataImporter().isUnoperational() || this.getDevice().isFault() || this.getDevice().isDown() || this.getDevice().isDisabled() || this.getReachableStations().isFault() || this.getReachableStations().isDown() || this.getReachableStations().isDisabled();
    }

    @Override
    protected Optional<String> getRemoteHostSecurityDashboardViewFoxOrd() {
        try {
            URI reachableStationURI = this.getReachableStationInfo().getReachableStationURI();
            BOrd foxBase = BOrd.make((BOrd)new BIpHost(reachableStationURI.getHost()).getAbsoluteOrd(), (BOrd)BOrd.make((String)(reachableStationURI.getScheme() + ":" + reachableStationURI.getPort())));
            return Optional.of(BOrd.make((BOrd)foxBase, (BOrd)SECURITY_SERVICE_DASHBOARD_VIEW_ORD).toString());
        }
        catch (Exception e) {
            String message = "Could not get security dashboard view ord for reachable station " + this.getStationName() + ":" + e.getMessage();
            LOGGER.log(Level.WARNING, message, LOGGER.isLoggable(Level.FINE) ? e : null);
            return Optional.empty();
        }
    }

    @Override
    protected Optional<String> getRemoteHostSecurityDashboardViewHttpUri() {
        try {
            return this.getHttpsPort().map(httpsPort -> "https://" + this.getReachableStationInfo().getReachableStationURI().getHost() + ":" + httpsPort + "/ord/" + SECURITY_SERVICE_DASHBOARD_VIEW_ORD);
        }
        catch (Exception e) {
            String message = "Could not get security dashboard view uri for reachable station " + this.getStationName() + ":" + e.getMessage();
            LOGGER.log(Level.WARNING, message, LOGGER.isLoggable(Level.FINE) ? e : null);
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refreshHttpsPort() {
        this.remoteHttpsPort = null;
        if (!this.isStationUnavailable()) {
            try {
                try {
                    this.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Could not connect to NiagaraNetwork station <" + this.getNiagaraStation().getName() + "> to determine HTTPS port. Security dashboard link will be disabled", e);
                    }
                    if (this.getClientConnection().isEngaged((BFoxClientConnection.Interest)this)) {
                        this.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                    }
                    return;
                }
                BDataChannel dataChannel = (BDataChannel)((BNiagaraStation)this.getDevice()).getClientConnection().getChannels().get("data", BDataChannel.TYPE);
                BOrd query = BOrd.make((String)"station:|slot:/Services|bql:select httpsPort.publicServerPort from web:WebService where httpsEnabled = true");
                BITable table = (BITable)dataChannel.resolve(query, NiagaraDriverUtil.parseRouteToStation((String)this.getReachableStationInfo().getRouteToStation(), (boolean)false));
                ColumnList columns = table.getColumns();
                Column firstColumn = columns.get(0);
                try (TableCursor cursor = table.cursor();){
                    if (cursor.next()) {
                        this.remoteHttpsPort = ((BInteger)cursor.cell(firstColumn).as(BInteger.class)).getInt();
                    }
                }
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Could not determine HTTPS port for NiagaraNetwork station <" + this.getNiagaraStation().getName() + ">. Security dashboard link will be disabled", e);
                }
            }
            finally {
                if (this.getClientConnection().isEngaged((BFoxClientConnection.Interest)this)) {
                    this.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                }
            }
        }
    }

    @Override
    protected boolean shouldDisplayRemoteLink(BSystemDashboardStationLinkMode linkMode) {
        return linkMode.equals((Object)BSystemDashboardStationLinkMode.remoteAndReachable);
    }

    @Override
    protected void executeOk() {
        this.reachableStatus = BStatus.ok;
    }

    @Override
    protected void executeFail(Throwable reason) {
        this.reachableStatus = UnreachableStationException.extractUnoperationalStationException((Throwable)reason).isPresent() ? BStatus.down : BStatus.ok;
    }

    @Override
    protected void doCheckParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BReachableStationInfo.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
    }

    private BReachableStations getReachableStations() {
        return (BReachableStations)CompUtil.closestAncestor((BComplex)this, BReachableStations.class).get();
    }

    private BReachableStationInfo getReachableStationInfo() {
        return (BReachableStationInfo)CompUtil.closestAncestor((BComplex)this, BReachableStationInfo.class).get();
    }

    public static BReachableStationSecurityDashboardDeviceExt getBestReachableStation(List<BReachableStationInfo> reachableStationInfos) {
        if (BAbstractSecurityDashboardDeviceExt.isSystemSecurityDashboardUnoperational()) {
            return null;
        }
        BReachableStationSecurityDashboardDeviceExt bestActiveReachableStationDeviceExt = null;
        BReachableStationSecurityDashboardDeviceExt bestDownReachableStationDeviceExt = null;
        for (BReachableStationInfo info : reachableStationInfos) {
            boolean isInfoActive = info.getRouteEnabled() && !info.getReachableStationsContainer().isDisabled() && !info.getReachableStationsContainer().getNiagaraStation().isDisabled() && !info.getReachableStationsContainer().getNiagaraStation().isFatalFault();
            SlotCursor props = info.getProperties();
            while (props.next(BReachableStationSecurityDashboardDeviceExt.class)) {
                BReachableStationSecurityDashboardDeviceExt deviceExt = (BReachableStationSecurityDashboardDeviceExt)props.get();
                if (isInfoActive && bestActiveReachableStationDeviceExt == null && !deviceExt.getDataImporter().isDisabled() && !deviceExt.getDataImporter().isFatalFault() && deviceExt.getDataImporter().remoteStationSupported.get()) {
                    if (!deviceExt.getStatus().isDown()) {
                        bestActiveReachableStationDeviceExt = deviceExt;
                        continue;
                    }
                    if (bestDownReachableStationDeviceExt == null) {
                        bestDownReachableStationDeviceExt = deviceExt;
                    }
                }
                deviceExt.setUsedByLastSecurityDashboardDataImport(false);
            }
        }
        BReachableStationSecurityDashboardDeviceExt deviceExt = bestActiveReachableStationDeviceExt != null ? bestActiveReachableStationDeviceExt : bestDownReachableStationDeviceExt;
        if (deviceExt != null) {
            deviceExt.setUsedByLastSecurityDashboardDataImport(true);
        }
        return deviceExt;
    }
}

