/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.NiagaraNetwork;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.nd.sysdef.BReachableStationInfo;
import com.tridium.nd.sysdef.BReachableStations;
import com.tridium.nss.BCertificateFolder;
import com.tridium.nss.BCertificateInfo;
import com.tridium.nss.BSystemDashboardStationLinkMode;
import com.tridium.nss.dashboard.BAbstractSecurityDashboardDeviceExt;
import com.tridium.nss.dashboard.BFoxSecurityDashboardChannel;
import com.tridium.nss.dashboard.BIStationSecurityDashboard;
import com.tridium.nss.dashboard.BISystemSecurityDashboard;
import com.tridium.nss.dashboard.BReachableStationSecurityDashboardDeviceExt;
import com.tridium.nss.dashboard.BSecurityDashboardDeviceExt;
import com.tridium.security.BISecurityInfoSource;
import com.tridium.security.BISecurityService;
import com.tridium.security.BSecurityInfo;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.security.PermissionException;
import javax.baja.security.dashboard.BISecurityDashboardItemProvider;
import javax.baja.security.dashboard.BISecurityDashboardProvider;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.sys.TypeSubscriber;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.PatternFilter;
import javax.baja.util.Version;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="certificates", type="BCertificateFolder", defaultValue="new BCertificateFolder()"), @NiagaraProperty(name="saveDashboardDataToBog", type="boolean", defaultValue="false"), @NiagaraProperty(name="stationLinkConfig", type="BSystemDashboardStationLinkMode", defaultValue="BSystemDashboardStationLinkMode.DEFAULT"), @NiagaraProperty(name="includeReachableStationsOnSystemDashboard", type="boolean", defaultValue="BBoolean.FALSE")})
@NiagaraAction(name="refreshSystemDashboardData", parameterType="BString", defaultValue="BString.make(\"*\")")
public final class BSecurityService
extends BAbstractService
implements BISecurityService,
BIRestrictedComponent,
BIStationSecurityDashboard,
BISystemSecurityDashboard {
    @Generated
    public static final Property certificates = BSecurityService.newProperty((int)0, (BValue)new BCertificateFolder(), null);
    @Generated
    public static final Property saveDashboardDataToBog = BSecurityService.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property stationLinkConfig = BSecurityService.newProperty((int)0, (BValue)BSystemDashboardStationLinkMode.DEFAULT, null);
    @Generated
    public static final Property includeReachableStationsOnSystemDashboard = BSecurityService.newProperty((int)0, (BValue)BBoolean.FALSE, null);
    @Generated
    public static final Action refreshSystemDashboardData = BSecurityService.newAction((int)0, (BValue)BString.make((String)"*"), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSecurityService.class);
    private static final BIcon icon = BIcon.std((String)"shield.png");
    private static final String NTWK_MISSING_LEX_KEY = "securityDashboard.noNiagaraNetwork";
    private static final Logger LOGGER = Logger.getLogger("niagara.securityService");
    private static final Logger DASHBOARD_LOGGER = Logger.getLogger("securityDashboard");
    private static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    private final Map<BIObject, List<ObjectProvider>> dashboardObjects = Collections.synchronizedMap(new LinkedHashMap());
    private static Boolean isSystemViewLicensed;

    @Generated
    public BCertificateFolder getCertificates() {
        return (BCertificateFolder)this.get(certificates);
    }

    @Generated
    public void setCertificates(BCertificateFolder v) {
        this.set(certificates, (BValue)v, null);
    }

    @Generated
    public boolean getSaveDashboardDataToBog() {
        return this.getBoolean(saveDashboardDataToBog);
    }

    @Generated
    public void setSaveDashboardDataToBog(boolean v) {
        this.setBoolean(saveDashboardDataToBog, v, null);
    }

    @Generated
    public BSystemDashboardStationLinkMode getStationLinkConfig() {
        return (BSystemDashboardStationLinkMode)this.get(stationLinkConfig);
    }

    @Generated
    public void setStationLinkConfig(BSystemDashboardStationLinkMode v) {
        this.set(stationLinkConfig, (BValue)v, null);
    }

    @Generated
    public boolean getIncludeReachableStationsOnSystemDashboard() {
        return this.getBoolean(includeReachableStationsOnSystemDashboard);
    }

    @Generated
    public void setIncludeReachableStationsOnSystemDashboard(boolean v) {
        this.setBoolean(includeReachableStationsOnSystemDashboard, v, null);
    }

    @Generated
    public void refreshSystemDashboardData(BString parameter) {
        this.invoke(refreshSystemDashboardData, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE, BISecurityService.TYPE};
    }

    public void register(BISecurityInfoSource component) {
        BSecurityInfo securityInfo = component.getSecurityInfo();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Registering " + securityInfo.getSourceName() + " at " + securityInfo.getHyperlink());
        }
        this.addDataToCertificates(securityInfo);
    }

    public void unregister(BISecurityInfoSource component) {
        BSecurityInfo securityInfo = component.getSecurityInfo();
        this.removeDataFromCertificates(securityInfo);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Unregistering " + securityInfo.getSourceName() + " at " + securityInfo.getHyperlink());
        }
    }

    public void serviceStarted() {
        if (this.isOperational()) {
            this.getComponentSpace().enableMixIn(BSecurityDashboardDeviceExt.TYPE);
            if (this.getIncludeReachableStationsOnSystemDashboard()) {
                this.getComponentSpace().enableMixIn(BReachableStationSecurityDashboardDeviceExt.TYPE);
            }
            try {
                BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
                if (registry.get("securityDashboard") == null) {
                    registry.add("securityDashboard", (BValue)new BFoxSecurityDashboardChannel());
                }
            }
            catch (Exception e) {
                LOGGER.severe("Unable to add BFoxSecurityDashboardChannel");
            }
            this.setDashboardDataTransient(null);
        }
    }

    public void serviceStopped() {
        this.getComponentSpace().disableMixIn(BSecurityDashboardDeviceExt.TYPE);
        this.getComponentSpace().disableMixIn(BReachableStationSecurityDashboardDeviceExt.TYPE);
        try {
            BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
            if (registry.get("securityDashboard") != null) {
                registry.remove("securityDashboard");
            }
        }
        catch (Exception e) {
            LOGGER.severe("Unable to remove BFoxSecurityDashboardChannel");
        }
    }

    protected void enabled() {
        this.serviceStarted();
    }

    protected void disabled() {
        this.serviceStopped();
    }

    public void stationStarted() {
        this.initSecurityDashboard();
    }

    public void started() {
        if (Sys.isStationStarted()) {
            this.initSecurityDashboard();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (context == Context.decoding) {
            return;
        }
        if (property.equals(saveDashboardDataToBog)) {
            this.setDashboardDataTransient(context);
        }
        if (this.isRunning() && (property.equals(includeReachableStationsOnSystemDashboard) || property.equals(enabled) || property.equals(status))) {
            if (this.isOperational() && this.getIncludeReachableStationsOnSystemDashboard()) {
                this.getComponentSpace().enableMixIn(BReachableStationSecurityDashboardDeviceExt.TYPE);
            } else {
                this.getComponentSpace().disableMixIn(BReachableStationSecurityDashboardDeviceExt.TYPE);
            }
        }
    }

    public static boolean isSystemSecurityDashboardLicensed() {
        if (!Sys.isStation()) {
            return true;
        }
        if (isSystemViewLicensed == null) {
            BSecurityService.checkLicense();
        }
        return isSystemViewLicensed;
    }

    private static void checkLicense() {
        try {
            Feature f = Sys.getLicenseManager().checkFeature("tridium", "securityDashboard");
            isSystemViewLicensed = f.getb("system", false);
        }
        catch (FeatureNotLicensedException ex) {
            isSystemViewLicensed = false;
        }
    }

    private void addDataToCertificates(BSecurityInfo securityInfo) {
        Property certAlias = securityInfo.getProperty("alias");
        if (certAlias != null) {
            String alias = securityInfo.getString(certAlias);
            BCertificateInfo info = this.getCertificates().getOrAddCertificate(alias);
            boolean found = false;
            for (BOrd ord : (BOrd[])info.getUsedIn().getChildren(BOrd.class)) {
                if (!ord.equals((Object)securityInfo.getHyperlink())) continue;
                found = true;
                break;
            }
            if (!found) {
                info.getUsedIn().add(securityInfo.getSourceName() + '?', (BValue)securityInfo.getHyperlink(), 3);
            }
        }
    }

    private void removeDataFromCertificates(BSecurityInfo securityInfo) {
        BOrd unregisteredComponent = securityInfo.getHyperlink();
        for (BCertificateInfo info : this.getCertificates().getCertificates()) {
            SlotCursor properties = info.getUsedIn().getProperties();
            while (properties.next(BOrd.class)) {
                BOrd ord = (BOrd)properties.get().as(BOrd.class);
                if (!ord.equals((Object)unregisteredComponent)) continue;
                info.getUsedIn().remove(properties.property());
            }
        }
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkContextForSuperUser((BIRestrictedComponent)this, (Context)cx);
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public void doRefreshSystemDashboardData(BString includeStations, Context cx) {
        PatternFilter[] filters = PatternFilter.parseList((String)includeStations.toString());
        if (filters.length == 1 && !filters[0].hasWildChars()) {
            this.refreshSingleStation(filters[0].getPattern(), cx);
        } else {
            this.refreshMultipleStations(filters, cx);
        }
    }

    private void refreshSingleStation(String stationName, Context cx) {
        if (stationName.equals(Sys.getStation().getStationName())) {
            if (DASHBOARD_LOGGER.isLoggable(Level.INFO)) {
                DASHBOARD_LOGGER.info("System Security Dashboard refresh requested on self [" + stationName + "].");
            }
            return;
        }
        try {
            this.findDeviceExt(stationName).refreshSystemDashboardData(cx);
            if (DASHBOARD_LOGGER.isLoggable(Level.INFO)) {
                DASHBOARD_LOGGER.info("System Security Dashboard refresh requested on single station [" + stationName + "].");
            }
        }
        catch (Exception e) {
            DASHBOARD_LOGGER.log(Level.WARNING, "Unable to request refresh of System Security Dashboard on single station [" + stationName + "].", e);
        }
    }

    private void refreshMultipleStations(PatternFilter[] filters, Context cx) {
        this.findNiagaraNetwork().orElseThrow(() -> new LocalizableRuntimeException("nss", NTWK_MISSING_LEX_KEY, new Object[]{Sys.getStation().getStationName()}));
        LinkedList<String> matchedStations = null;
        if (DASHBOARD_LOGGER.isLoggable(Level.FINE)) {
            matchedStations = new LinkedList<String>();
        }
        Set<BAbstractSecurityDashboardDeviceExt> exts = this.findAllDeviceExts(true);
        for (BAbstractSecurityDashboardDeviceExt ext : exts) {
            String stationName = ext.getStationName();
            if (!BSecurityService.matchesFilter(stationName, filters)) continue;
            try {
                ext.refreshSystemDashboardData(cx);
                if (matchedStations == null) continue;
                matchedStations.add(stationName);
            }
            catch (Exception e) {
                DASHBOARD_LOGGER.log(Level.FINE, "Unable to refresh system dashboard data for " + stationName, e);
            }
        }
        DASHBOARD_LOGGER.info("Refresh attempted on multiple stations.");
        if (DASHBOARD_LOGGER.isLoggable(Level.FINE) && matchedStations != null) {
            String message = "Matched " + matchedStations.size() + " of " + exts.size() + " stations." + System.lineSeparator() + "Stations matched: " + String.join((CharSequence)", ", matchedStations) + System.lineSeparator() + "Given patterns: " + Arrays.toString(filters);
            DASHBOARD_LOGGER.fine(message);
        }
    }

    private static boolean matchesFilter(String stationName, PatternFilter[] filters) {
        for (PatternFilter filter : filters) {
            if (!filter.accept(stationName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStationDashboardEnabled() {
        return this.getEnabled();
    }

    @Override
    public JSONObject getStationDashboardData(Context cx) {
        if (!this.isRunning()) {
            return null;
        }
        if (!this.getPermissions(cx).hasAdminRead()) {
            throw new PermissionException(cx.getUser().toString() + " does not have admin read permissions.");
        }
        JSONObject stationData = new JSONObject().put("version", 1).put("stationName", (Object)Sys.getStation().getStationName()).put("timestamp", (Object)BSecurityService.getCurrentTime());
        JSONArray sectionArray = new JSONArray();
        for (List<ObjectProvider> objectProviders : this.dashboardObjects.values()) {
            for (ObjectProvider objectProvider : objectProviders) {
                try {
                    sectionArray.put((Object)BSecurityService.getStationSectionData(objectProvider, cx));
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Could not get Security Dashboard data for provider " + objectProvider.provider, e);
                }
            }
        }
        stationData.put("sections", (Object)sectionArray);
        return stationData;
    }

    private static JSONObject getStationSectionData(ObjectProvider objectProvider, Context cx) {
        JSONObject sectionData = new JSONObject();
        BISecurityDashboardProvider provider = objectProvider.provider;
        LexiconFormatInfo sectionHeader = provider.getSecurityDashboardSectionHeader(cx);
        if (sectionHeader == null) {
            Type type = provider.getType();
            sectionHeader = LexiconFormatInfo.make((Type)type, (String)(type.getTypeName() + ".displayName"));
        }
        sectionData.put("sectionHeader", (Object)sectionHeader.toJSON());
        BOrd hyperlink = provider.getSecurityDashboardSectionHyperlinkOrd();
        if (hyperlink == null) {
            hyperlink = BOrd.DEFAULT;
        }
        sectionData.put("ord", (Object)hyperlink.toString(null));
        JSONArray subsectionArray = new JSONArray();
        for (BISecurityDashboardItemProvider itemProvider : objectProvider.itemProviders) {
            try {
                subsectionArray.put((Object)BSecurityService.getStationSubsectionData(itemProvider, cx));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not get Security Dashboard data for item provider " + itemProvider.getType(), e);
            }
        }
        sectionData.put("subsections", (Object)subsectionArray);
        return sectionData;
    }

    private static JSONObject getStationSubsectionData(BISecurityDashboardItemProvider itemProvider, Context cx) {
        JSONObject subsectionData = new JSONObject().put("subsectionVersion", itemProvider.getSecurityDashboardItemsVersion()).put("subsectionProviderType", (Object)itemProvider.getType().toString());
        List<Object> items = itemProvider.isItemProviderEnabled() ? itemProvider.getSecurityDashboardItems(cx) : Collections.singletonList(itemProvider.getDisabledSecurityDashboardItem(cx));
        if (items == null) {
            items = Collections.emptyList();
        }
        JSONArray itemArray = new JSONArray();
        for (SecurityDashboardItem securityDashboardItem : items) {
            itemArray.put((Object)securityDashboardItem.toJSON());
        }
        subsectionData.put("dashboardItems", (Object)itemArray);
        return subsectionData;
    }

    private static String getCurrentTime() {
        OffsetDateTime now = OffsetDateTime.now(ZoneOffset.UTC);
        return now.toString();
    }

    private void initSecurityDashboard() {
        SecurityDashboardSubscriber subscriber = new SecurityDashboardSubscriber(this.getComponentSpace());
        subscriber.subscribe(BSecurityService.getAllTypesToSubscribe(), null);
        this.fetchSecurityDashboardSections();
    }

    private static Type[] getAllTypesToSubscribe() {
        ArrayList<Type> typeList = new ArrayList<Type>();
        for (TypeInfo typeInfo : Sys.getRegistry().getConcreteTypes(BISecurityDashboardProvider.TYPE.getTypeInfo())) {
            Type type = typeInfo.getTypeSpec().getResolvedType();
            if (type == TYPE || !type.is(BComponent.TYPE)) continue;
            typeList.add(type);
        }
        typeList.addAll(BSecurityService.getSecurityDashboardProvidersFromAgents());
        return typeList.toArray(EMPTY_TYPE_ARRAY);
    }

    private static List<Type> getSecurityDashboardProvidersFromAgents() {
        HashSet<Type> typeSet = new HashSet<Type>();
        for (TypeInfo typeInfo : Sys.getRegistry().getConcreteTypes(BISecurityDashboardProviderAgent.TYPE.getTypeInfo())) {
            for (TypeInfo info : typeInfo.getAgentInfo().getAgentOn()) {
                Type type = info.getTypeSpec().getResolvedType();
                if (type == TYPE || !type.is(BComponent.TYPE)) continue;
                typeSet.add(type);
            }
        }
        return new ArrayList<Type>(typeSet);
    }

    private void fetchSecurityDashboardSections() {
        Iterator components = Sys.getStation().getComponentSpace().iterateAllComponents();
        while (components.hasNext()) {
            BComponent component = (BComponent)components.next();
            if (component instanceof BISecurityDashboardProvider) {
                this.addProvider((BISecurityDashboardProvider)component);
                continue;
            }
            this.addProviderAgents((BObject)component);
        }
    }

    private void setDashboardDataTransient(Context context) {
        Optional<NiagaraNetwork> niagaraNetwork = this.findNiagaraNetwork();
        if (!niagaraNetwork.isPresent()) {
            return;
        }
        if (!this.getPermissions(context).hasAdminWrite()) {
            return;
        }
        for (BAbstractSecurityDashboardDeviceExt ext : this.findAllDeviceExts(false)) {
            Slot dashboardDataSlot = ext.getSlot(ext.getDashboardData().getName());
            int dashboardDataSlotFlags = ext.getFlags(dashboardDataSlot);
            if (this.getSaveDashboardDataToBog()) {
                ext.setFlags(dashboardDataSlot, dashboardDataSlotFlags & 0xFFFFFFFD, null);
                continue;
            }
            ext.setFlags(dashboardDataSlot, dashboardDataSlotFlags | 2, null);
        }
    }

    @Override
    public boolean isSystemDashboardEnabled() {
        return BSecurityService.isSystemSecurityDashboardLicensed() && this.getEnabled();
    }

    @Override
    public JSONObject getSystemDashboardData(Context cx) {
        if (!this.isRunning()) {
            return null;
        }
        if (!this.getPermissions(cx).hasAdminRead()) {
            throw new PermissionException(cx.getUser() + " does not have admin read permissions.");
        }
        JSONObject systemData = new JSONObject();
        systemData.put("version", 1);
        JSONArray stationArray = new JSONArray();
        int missingStationCount = this.getRemoteStationData(stationArray, cx);
        if (this.getIncludeReachableStationsOnSystemDashboard()) {
            missingStationCount += this.getReachableStationData(stationArray, cx);
        }
        JSONObject localStationSystemData = new JSONObject().put("stationName", (Object)Sys.getStation().getStationName()).put("ord", (Object)BOrd.make((BOrd)this.getNavOrd().relativizeToHost(), (String)"view:nss:SecurityDashboardView?selectedMode=stationView")).put("stationDashboardData", (Object)this.getStationDashboardData(cx));
        stationArray.put((Object)localStationSystemData);
        systemData.put("stations", (Object)stationArray);
        systemData.put("missingStationCount", missingStationCount);
        return systemData;
    }

    private int getRemoteStationData(JSONArray stationArray, Context cx) {
        BDevice[] devices;
        Optional<NiagaraNetwork> niagaraNetwork = this.findNiagaraNetwork();
        if (!niagaraNetwork.isPresent()) {
            DASHBOARD_LOGGER.fine("No Niagara Network found. Only the local station will be displayed on dashboard.");
            return 0;
        }
        if (!(niagaraNetwork.get() instanceof BDeviceNetwork)) {
            DASHBOARD_LOGGER.fine("Found Niagara Network is not a BDeviceNetwork. Only the local station will be displayed on dashboard.");
            return 0;
        }
        int missingStationCount = 0;
        for (BDevice device : devices = ((BDeviceNetwork)niagaraNetwork.get()).getDevices()) {
            BSecurityDashboardDeviceExt ext = BSecurityService.findNiagaraStationDeviceExt(device);
            if (ext == null) {
                if (DASHBOARD_LOGGER.isLoggable(Level.WARNING)) {
                    DASHBOARD_LOGGER.warning("NiagaraStation " + device.getName() + " does not have a BSecurityDashboardDeviceExt");
                }
                ++missingStationCount;
                continue;
            }
            try {
                JSONObject stationData = ext.getSystemDashboardData(null, cx);
                if (stationData == null) {
                    ++missingStationCount;
                    continue;
                }
                stationArray.put((Object)stationData);
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
        }
        return missingStationCount;
    }

    private int getReachableStationData(JSONArray stationArray, Context cx) {
        if (!this.getIncludeReachableStationsOnSystemDashboard()) {
            DASHBOARD_LOGGER.fine("Include Reachable Stations is set to false. Reachable stations will not be displayed on dashboard.");
            return 0;
        }
        Optional<NiagaraNetwork> niagaraNetwork = this.findNiagaraNetwork();
        if (!niagaraNetwork.isPresent()) {
            DASHBOARD_LOGGER.fine("No Niagara Network found. Reachable stations will not be displayed on dashboard.");
            return 0;
        }
        if (!(niagaraNetwork.get() instanceof BDeviceNetwork)) {
            DASHBOARD_LOGGER.fine("Found Niagara Network is not a BDeviceNetwork. Reachable stations will not  be displayed on dashboard.");
            return 0;
        }
        int missingStationCount = 0;
        if (this.getIncludeReachableStationsOnSystemDashboard()) {
            Map reachableStations = BReachableStations.findAllReachableStations((BObject)this, (boolean)true, (boolean)true, (boolean)true, (Version)BFoxSecurityDashboardChannel.VERSION_4_8, (Version)BFoxSecurityDashboardChannel.VERSION_4_14, null, (String[])new String[0]);
            for (Map.Entry reachableStationEntry : reachableStations.entrySet()) {
                String stationName = (String)reachableStationEntry.getKey();
                List infos = (List)reachableStations.get(stationName);
                if (infos.isEmpty()) continue;
                BReachableStationSecurityDashboardDeviceExt deviceExt = BReachableStationSecurityDashboardDeviceExt.getBestReachableStation(infos);
                if (deviceExt == null) {
                    if (DASHBOARD_LOGGER.isLoggable(Level.WARNING)) {
                        DASHBOARD_LOGGER.warning("Could not find route to reachable station " + stationName);
                    }
                    ++missingStationCount;
                    continue;
                }
                try {
                    JSONObject stationData = deviceExt.getSystemDashboardData(null, cx);
                    if (stationData == null) {
                        ++missingStationCount;
                        continue;
                    }
                    stationArray.put((Object)stationData);
                }
                catch (PermissionException permissionException) {}
            }
        }
        return missingStationCount;
    }

    @Override
    public JSONObject getSystemDashboardDataForStation(String stationName, String lastDataTimestamp, Context cx) {
        if (!this.isRunning()) {
            return null;
        }
        if (!this.getPermissions(cx).hasAdminRead()) {
            throw new PermissionException(cx.getUser() + " does not have admin read permissions.");
        }
        JSONObject systemData = new JSONObject();
        systemData.put("version", 1);
        JSONArray stationArray = new JSONArray();
        int missingStationCount = 0;
        if (Sys.getStation().getStationName().equals(stationName)) {
            JSONObject localStationSystemData = new JSONObject().put("stationName", (Object)Sys.getStation().getStationName()).put("ord", (Object)BOrd.make((BOrd)this.getNavOrd().relativizeToHost(), (String)"view:nss:SecurityDashboardView?selectedMode=stationView")).put("stationDashboardData", (Object)this.getStationDashboardData(cx));
            stationArray.put((Object)localStationSystemData);
        } else {
            BAbstractSecurityDashboardDeviceExt ext = this.findDeviceExt(stationName);
            JSONObject stationData = ext.getSystemDashboardData(lastDataTimestamp, cx);
            if (stationData == null) {
                ++missingStationCount;
            } else {
                stationArray.put((Object)stationData);
            }
        }
        systemData.put("stations", (Object)stationArray);
        systemData.put("missingStationCount", missingStationCount);
        return systemData;
    }

    @Override
    public JSONObject refreshSystemDashboardDataForStation(String stationName, Context cx) {
        if (!this.isRunning()) {
            return null;
        }
        if (!this.getPermissions(cx).hasAdminRead()) {
            throw new PermissionException(cx.getUser() + " does not have admin read permissions.");
        }
        if (Sys.getStation().getStationName().equals(stationName)) {
            return new JSONObject().put("stationStatus", (Object)BStatus.DEFAULT.getEmptyTag()).put("refreshStatus", (Object)"success");
        }
        BAbstractSecurityDashboardDeviceExt ext = this.findDeviceExt(stationName);
        return ext.refreshSystemDashboardData(cx);
    }

    private BAbstractSecurityDashboardDeviceExt findDeviceExt(String stationName) {
        BAbstractSecurityDashboardDeviceExt ext;
        block4: {
            this.findNiagaraNetwork().orElseThrow(() -> new BajaRuntimeException("Cannot find NiagaraStation " + stationName + ". No NiagaraNetwork found."));
            try {
                BDevice niagaraStation = this.findNiagaraStation(stationName);
                ext = BSecurityService.findNiagaraStationDeviceExt(niagaraStation);
                if (ext == null) {
                    throw new BajaRuntimeException("NiagaraStation " + niagaraStation.getName() + " does not contain a BSecurityDashboardDeviceExt");
                }
            }
            catch (BajaRuntimeException e) {
                if (!this.getIncludeReachableStationsOnSystemDashboard() || !e.getMessage().equals("Cannot find NiagaraStation " + stationName)) {
                    throw e;
                }
                ext = this.findReachableStationDeviceExt(stationName);
                if (ext != null) break block4;
                throw new BajaRuntimeException("Cannot find a BSecurityDashboardDeviceExt for reachable station " + stationName);
            }
        }
        return ext;
    }

    private Set<BAbstractSecurityDashboardDeviceExt> findAllDeviceExts(boolean useBestReachableOnly) {
        BDevice[] devices;
        HashSet<BAbstractSecurityDashboardDeviceExt> exts = new HashSet<BAbstractSecurityDashboardDeviceExt>();
        Optional<NiagaraNetwork> niagaraNetwork = this.findNiagaraNetwork();
        if (!niagaraNetwork.isPresent()) {
            return exts;
        }
        for (BDevice device : devices = ((BDeviceNetwork)this.findNiagaraNetwork().get()).getDevices()) {
            BSecurityDashboardDeviceExt ext = BSecurityService.findNiagaraStationDeviceExt(device);
            if (ext == null) continue;
            exts.add(ext);
        }
        if (this.getIncludeReachableStationsOnSystemDashboard()) {
            Map reachableStations = BReachableStations.findAllReachableStations((BObject)this, (boolean)false, (boolean)true, (boolean)true, (Version)BFoxSecurityDashboardChannel.VERSION_4_8, (Version)BFoxSecurityDashboardChannel.VERSION_4_14, null, (String[])new String[0]);
            for (Map.Entry reachableStationEntry : reachableStations.entrySet()) {
                List infos = (List)reachableStations.get(reachableStationEntry.getKey());
                if (useBestReachableOnly) {
                    BReachableStationSecurityDashboardDeviceExt ext = BReachableStationSecurityDashboardDeviceExt.getBestReachableStation(infos);
                    if (ext == null) continue;
                    exts.add(BReachableStationSecurityDashboardDeviceExt.getBestReachableStation(infos));
                    continue;
                }
                for (BReachableStationInfo info : infos) {
                    BReachableStationSecurityDashboardDeviceExt ext = BSecurityService.findDeviceExt(info);
                    if (ext == null) continue;
                    exts.add(BSecurityService.findDeviceExt(info));
                }
            }
        }
        return exts;
    }

    private static BSecurityDashboardDeviceExt findNiagaraStationDeviceExt(BDevice device) {
        BSecurityDashboardDeviceExt[] exts = (BSecurityDashboardDeviceExt[])device.getChildren(BSecurityDashboardDeviceExt.class);
        return exts.length > 0 ? exts[0] : null;
    }

    private static BReachableStationSecurityDashboardDeviceExt findDeviceExt(BReachableStationInfo info) {
        BReachableStationSecurityDashboardDeviceExt[] exts = (BReachableStationSecurityDashboardDeviceExt[])info.getChildren(BReachableStationSecurityDashboardDeviceExt.class);
        return exts.length > 0 ? exts[0] : null;
    }

    private BDevice findNiagaraStation(String name) {
        NiagaraNetwork niagaraNetwork = this.findNiagaraNetwork().orElseThrow(() -> new BajaRuntimeException("Cannot find NiagaraStation " + name + ". No NiagaraNetwork found."));
        NiagaraStation niagaraStation = niagaraNetwork.getStation(name);
        if (niagaraStation == null) {
            throw new BajaRuntimeException("Cannot find NiagaraStation " + name);
        }
        return (BDevice)niagaraStation;
    }

    private BReachableStationSecurityDashboardDeviceExt findReachableStationDeviceExt(String name) {
        if (!this.getIncludeReachableStationsOnSystemDashboard()) {
            throw new BajaRuntimeException("Cannot find NiagaraStation " + name + ". Reachable stations are disabled.");
        }
        Map reachableStations = BReachableStations.findAllReachableStations((BObject)this, (boolean)false, (boolean)true, (boolean)true, (Version)BFoxSecurityDashboardChannel.VERSION_4_8, (Version)BFoxSecurityDashboardChannel.VERSION_4_14, null, (String[])new String[0]);
        List infos = (List)reachableStations.get(name);
        if (infos == null || infos.isEmpty()) {
            throw new BajaRuntimeException("Cannot find NiagaraStation " + name);
        }
        return BReachableStationSecurityDashboardDeviceExt.getBestReachableStation(infos);
    }

    private Optional<NiagaraNetwork> findNiagaraNetwork() {
        try {
            return Optional.of((NiagaraNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get((BObject)this));
        }
        catch (UnresolvedException e) {
            return Optional.empty();
        }
    }

    private void addProvider(BISecurityDashboardProvider provider) {
        ObjectProvider objectProvider = this.addObjectProvider(provider, (BObject)provider);
        objectProvider.itemProviders.addAll(BSecurityService.getItemProviderAgents(provider, (BObject)provider));
        this.addProviderAgents((BObject)provider);
    }

    private void addProviderAgents(BObject object) {
        AgentInfo[] providerAgentInfo;
        for (AgentInfo info : providerAgentInfo = BSecurityService.getProviderAgents(object)) {
            BISecurityDashboardProviderAgent agent = (BISecurityDashboardProviderAgent)info.getInstance();
            agent.setSecurityDashboardItemsSource((BIObject)object);
            ObjectProvider objectProvider = this.addObjectProvider((BISecurityDashboardProvider)agent, object);
            objectProvider.itemProviders.addAll(BSecurityService.getItemProviderAgents((BISecurityDashboardProvider)agent, object));
        }
    }

    private ObjectProvider addObjectProvider(BISecurityDashboardProvider provider, BObject target) {
        List objectProviders = this.dashboardObjects.computeIfAbsent((BIObject)target, k -> new ArrayList());
        ObjectProvider objectProvider = new ObjectProvider(provider);
        objectProviders.add(objectProvider);
        return objectProvider;
    }

    private static List<BISecurityDashboardItemProvider> getItemProviderAgents(BISecurityDashboardProvider provider, BObject itemsSource) {
        AgentInfo[] itemProviderAgentInfo;
        List<BISecurityDashboardItemProvider> itemProviderAgents = null;
        for (AgentInfo info : itemProviderAgentInfo = BSecurityService.getItemProviderAgents((BObject)provider)) {
            BISecurityDashboardItemProvider itemProvider = (BISecurityDashboardItemProvider)info.getInstance();
            itemProvider.setSecurityDashboardItemsSource((BIObject)itemsSource);
            if (itemProviderAgents == null) {
                itemProviderAgents = new ArrayList<BISecurityDashboardItemProvider>();
            }
            itemProviderAgents.add(itemProvider);
        }
        return itemProviderAgents != null ? itemProviderAgents : Collections.emptyList();
    }

    private static AgentInfo[] getProviderAgents(BObject provider) {
        try {
            Type type = provider.getType();
            AgentList agentList = Sys.getRegistry().getAgents(type.getTypeInfo());
            AgentInfo[] agents = agentList.filter(AgentFilter.is((TypeInfo)BISecurityDashboardProviderAgent.TYPE.getTypeInfo())).list();
            return agents;
        }
        catch (TypeNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Type not found when getting provider agents ", e);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to get provider agents ", e);
        }
        return null;
    }

    private static AgentInfo[] getItemProviderAgents(BObject provider) {
        return provider.getAgents(null).filter(AgentFilter.and((AgentFilter)AgentFilter.is((TypeInfo)BISecurityDashboardItemProvider.TYPE.getTypeInfo()), (AgentFilter)AgentFilter.not((AgentFilter)AgentFilter.is((TypeInfo)BISecurityDashboardProvider.TYPE.getTypeInfo())))).list();
    }

    public BIcon getIcon() {
        return icon;
    }

    public static class ObjectProvider {
        public final BISecurityDashboardProvider provider;
        public List<BISecurityDashboardItemProvider> itemProviders = new ArrayList<BISecurityDashboardItemProvider>();

        ObjectProvider(BISecurityDashboardProvider provider) {
            this.provider = provider;
            this.itemProviders.add((BISecurityDashboardItemProvider)provider);
        }
    }

    private class SecurityDashboardSubscriber
    extends TypeSubscriber {
        SecurityDashboardSubscriber(BComponentSpace space) {
            super(space);
        }

        public void event(BComponentEvent event) {
            int id = event.getId();
            BComponent sourceComponent = event.getSourceComponent();
            if (id == 19) {
                if (sourceComponent instanceof BISecurityDashboardProvider) {
                    BSecurityService.this.addProvider((BISecurityDashboardProvider)sourceComponent);
                } else {
                    BSecurityService.this.addProviderAgents((BObject)sourceComponent);
                }
            } else if (id == 20) {
                BSecurityService.this.dashboardObjects.remove(sourceComponent);
            }
        }
    }
}

