/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtils.util;

import com.tridium.clUtils.util.IHistoryImportResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BHistoryImportHelper
extends BSingleton {
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryImportHelper.class);
    private static Map<String, IHistoryImportResolver> helperMap;
    protected static final Logger log;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static Optional<String> getReference(BHistoryImport history) {
        if (helperMap == null) {
            BHistoryImportHelper.registerHelpers();
        }
        if (!helperMap.containsKey(history.getClass().getName())) {
            return Optional.empty();
        }
        return helperMap.get(history.getClass().getName()).getReference(history);
    }

    protected static void registerHelper(String className, IHistoryImportResolver resolver) {
        helperMap.put(className, resolver);
    }

    private static void registerHelpers() {
        try {
            TypeInfo[] helperInfos = Sys.getRegistry().getConcreteTypes(TYPE.getTypeInfo());
            helperMap = new HashMap<String, IHistoryImportResolver>();
            for (TypeInfo helperInfo : helperInfos) {
                BHistoryImportHelper helper = (BHistoryImportHelper)helperInfo.getInstance().as(BHistoryImportHelper.class);
                helper.registerSelf();
            }
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Cannot add history import helper implementation", log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    protected abstract void registerSelf();

    static {
        log = Logger.getLogger("cloudLink.modelDiscovery");
    }
}

