/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtils.model;

import com.tridium.clUtils.model.IModelHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.io.ValueDocEncoder;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BModelHelper
extends BObject
implements IModelHelper {
    public static final Type TYPE = Sys.loadType(BModelHelper.class);
    protected static final Logger log = Logger.getLogger("cloudLink.modelHelper");
    private static Map<String, IModelHelper> helperMap;
    public static final String PROPERTY_NAME = "p";
    public static final String LINK_TYPE_KEY = "linkType";

    public Type getType() {
        return TYPE;
    }

    protected abstract void registerSelf();

    public static void applyHelper(Object object) {
        if (helperMap == null) {
            BModelHelper.registerHelpers();
        }
        if (helperMap.containsKey(object.getClass().getName())) {
            helperMap.get(object.getClass().getName()).apply(object);
        }
    }

    public static void addHelperTags(ValueDocEncoder encoder, BComponent component) {
        if (helperMap == null) {
            BModelHelper.registerHelpers();
        }
        if (helperMap.containsKey(component.getClass().getName())) {
            helperMap.get(component.getClass().getName()).encodeTags(encoder, component);
        }
    }

    public static void addHelperRelations(ValueDocEncoder encoder, BComponent component) {
        if (helperMap == null) {
            BModelHelper.registerHelpers();
        }
        if (helperMap.containsKey(component.getClass().getName())) {
            helperMap.get(component.getClass().getName()).encodeRelations(encoder, component);
        }
    }

    public static void addHelperLinks(ValueDocEncoder encoder, BComponent component) {
        if (helperMap == null) {
            BModelHelper.registerHelpers();
        }
        if (helperMap.containsKey(component.getClass().getName())) {
            helperMap.get(component.getClass().getName()).encodeLinks(encoder, component);
        }
    }

    protected static void registerHelper(String className, IModelHelper helper) {
        if (helperMap == null) {
            helperMap = new HashMap<String, IModelHelper>();
        }
        helperMap.put(className, helper);
    }

    protected static void registerHelpers() {
        TypeInfo[] helperInfos = Sys.getRegistry().getConcreteTypes(TYPE.getTypeInfo());
        helperMap = new HashMap<String, IModelHelper>();
        for (TypeInfo helperInfo : helperInfos) {
            try {
                BModelHelper helper = (BModelHelper)helperInfo.getInstance().as(BModelHelper.class);
                helper.registerSelf();
            }
            catch (Exception cannotRegister) {
                log.log(Level.INFO, "Cannot register model helper: " + helperInfo, log.isLoggable(Level.FINE) ? cannotRegister : null);
            }
        }
    }
}

