/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtils.job;

import com.tridium.clUtils.BModelDiscoverer;
import com.tridium.clUtils.BModelDiscoveryService;
import com.tridium.driver.file.util.CsvParser;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BProxyCreationJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BProxyCreationJob.class);
    protected static final Lexicon lex = Lexicon.make((String)"clUtils");
    private static final int CREATION_INFO_INDEX = 5;
    private static final String CREATION_INFO_HEADER = "CreationInfo";
    private static final String NIAGARA_TYPE = "n:type";
    private BModelDiscoveryService service;
    private final Map<String, BModelDiscoverer> networkMap = new HashMap<String, BModelDiscoverer>();
    private final Map<String, JSONObject> deviceMap = new HashMap<String, JSONObject>();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BProxyCreationJob() {
        try {
            this.service = (BModelDiscoveryService)Sys.getService((Type)BModelDiscoveryService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            this.service = null;
        }
    }

    public BProxyCreationJob(BModelDiscoveryService service) {
        this.service = service;
    }

    public void run(Context cx) throws Exception {
        Objects.requireNonNull(this.service, "Model Discovery Service not configured");
        BOrd fileOrd = this.service.getCreationFile();
        BIFile creationFile = BFileSystem.INSTANCE.findFile((FilePath)fileOrd.parse()[0]);
        if (creationFile == null) {
            String message = lex.getText("modelDiscovery.creation.fileNotFound");
            this.log().failed(message);
            throw new Exception(message);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(creationFile.getInputStream(), StandardCharsets.UTF_8));){
            CsvParser parser = new CsvParser(reader);
            String[][] csvData = parser.parseAll();
            if (csvData.length < 1 || csvData[0].length <= 5 || !CREATION_INFO_HEADER.equals(csvData[0][5].trim())) {
                String message = lex.getText("modelDiscovery.creation.badFileFormat");
                this.log().failed(message);
                throw new Exception(message);
            }
            fileOrd = this.service.getModelFile();
            BIFile modelFile = BFileSystem.INSTANCE.makeFile((FilePath)fileOrd.parse()[0]);
            try (ZipFile zipFile = new ZipFile(((BLocalFileStore)modelFile.getStore()).getLocalFile());){
                for (int lcv = 1; lcv < csvData.length; ++lcv) {
                    this.progress(lcv, csvData.length);
                    if (csvData[lcv].length <= 5) {
                        this.log().message(lex.getText("modelDiscovery.creation.missingInfo", new Object[]{lcv}));
                        continue;
                    }
                    try {
                        byte[] creationBytes = Base64.getDecoder().decode(csvData[lcv][5]);
                        JSONObject creationInfo = new JSONObject(new String(creationBytes, StandardCharsets.UTF_8));
                        String entryName = creationInfo.getString("name");
                        URI path = new URI(entryName);
                        String networkEntryName = path.resolve("../networkInfo.json").getPath();
                        BModelDiscoverer networkDiscoverer = this.getNetworkAgent(zipFile, networkEntryName);
                        String deviceEntryName = path.resolve("deviceInfo.json").getPath();
                        JSONObject deviceInfo = this.getDeviceInfo(zipFile, deviceEntryName);
                        JSONObject discoveryInfo = BProxyCreationJob.extractJsonData(zipFile, entryName);
                        networkDiscoverer.createImport(discoveryInfo, deviceInfo, (BJob)this);
                        continue;
                    }
                    catch (Exception ex) {
                        this.log().message(lex.getText("modelDiscovery.creation.error", new Object[]{lcv, ex.getLocalizedMessage()}));
                    }
                }
            }
        }
    }

    public void checkCancel() {
        if (!this.isAlive()) {
            this.log().message(lex.getText("modelDiscovery.creation.canceled"));
            throw new JobCancelException(lex.getText("modelDiscovery.creation.canceled"));
        }
    }

    public void progress(int progres) {
        int progress = this.getProgress();
        if (progres > progress) {
            super.progress(progres);
        } else {
            this.heartbeat();
        }
    }

    public void progress(int count, int size) {
        int prog = (int)((float)(count - 1) / (float)(size - 1) * 100.0f);
        this.progress(prog);
    }

    protected static JSONObject extractJsonData(ZipFile zipFile, String entryName) throws IOException {
        ZipEntry entry = zipFile.getEntry(entryName);
        InputStream inputStream = zipFile.getInputStream(entry);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            JSONObject jSONObject = new JSONObject(new JSONTokener((Reader)bufferedReader));
            return jSONObject;
        }
    }

    protected BModelDiscoverer getNetworkAgent(ZipFile zipFile, String entryName) throws IOException {
        JSONObject networkInfo;
        String networkTypeName;
        AgentList netAgents;
        if (!this.networkMap.containsKey(entryName) && (netAgents = Sys.getType((String)(networkTypeName = (networkInfo = BProxyCreationJob.extractJsonData(zipFile, entryName)).getString(NIAGARA_TYPE))).getInstance().getAgents().filter(AgentFilter.is((Type)BModelDiscoverer.TYPE))).size() > 0) {
            AgentInfo netInfo = netAgents.getDefault();
            this.networkMap.put(entryName, (BModelDiscoverer)netInfo.getInstance().as(BModelDiscoverer.class));
        }
        return this.networkMap.get(entryName);
    }

    protected JSONObject getDeviceInfo(ZipFile zipFile, String entryName) throws IOException {
        if (!this.deviceMap.containsKey(entryName)) {
            this.deviceMap.put(entryName, BProxyCreationJob.extractJsonData(zipFile, entryName));
        }
        return this.deviceMap.get(entryName);
    }
}

