/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtils;

import com.tridium.clUtils.ModelDiscoveryConstants;
import com.tridium.json.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.driver.BDevice;
import javax.baja.job.BJob;
import javax.baja.job.JobLog;
import javax.baja.naming.SlotPath;
import javax.baja.util.Lexicon;

public final class DiscoveryUtils {
    private static final Pattern COMPILE = Pattern.compile("/", 16);
    private static final Lexicon lex = Lexicon.make((String)"clUtils");

    private DiscoveryUtils() {
    }

    public static String getDevicePathFromNetwork(BDevice dev) {
        SlotPath spdev = dev.getSlotPath();
        SlotPath spnet = dev.getNetwork().getSlotPath();
        String[] devnames = spdev.getNames();
        String[] newnames = new String[spdev.depth() - spnet.depth() + 1];
        System.arraycopy(devnames, spnet.depth() - 1, newnames, 0, newnames.length);
        return COMPILE.matcher(new SlotPath("slot", newnames).getBody().substring(1)).replaceAll(ModelDiscoveryConstants.ZIP_PATH_SEPARATOR.toString());
    }

    public static JSONObject readJSONObject(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            int c;
            while ((c = r.read()) != -1) {
                sb.append((char)c);
            }
            JSONObject jSONObject = new JSONObject(sb.toString());
            return jSONObject;
        }
    }

    public static void waitForJob(BJob job, JobLog log, String jobName) {
        int count = 0;
        while (job.isAlive() && !job.getJobState().isComplete()) {
            if (++count % 5 == 0) {
                log.message(lex.getText("modelDiscovery.discovery.wait", new Object[]{jobName}));
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                log.endFailed(lex.getText("modelDiscovery.discovery.exception", new Object[]{jobName}), (Throwable)e);
            }
        }
    }

    public static String makeCloudId() {
        return UUID.randomUUID().toString();
    }

    public static void writeZipEntry(String basePath, String name, JSONObject ptInfo, ZipOutputStream out) throws IOException {
        out.putNextEntry(new ZipEntry(basePath + name + ".json"));
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
        osw.write(ptInfo.toString());
        osw.flush();
        out.closeEntry();
    }
}

