/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtils;

import com.tridium.clUtils.DiscoveryTagUtils;
import com.tridium.clUtils.DiscoveryUtils;
import com.tridium.clUtils.ModelDiscoveryConstants;
import com.tridium.clUtils.idm.HistoryInfo;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.agent.BIAgent;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.job.BJob;
import javax.baja.job.JobLog;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMarker;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Entity;
import javax.baja.tag.Tag;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"driver:DeviceNetwork", "driver:Device"})})
public class BModelDiscoverer
extends BComponent
implements BIAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BModelDiscoverer.class);
    public static final Pattern FWD_SLASH_MATCHER = Pattern.compile("/", 16);
    public static final String NETWORK_INFO = "networkInfo.json";
    public static final String DEVICE_INFO = "deviceInfo.json";
    private static final Lexicon lex = Lexicon.make((String)"clUtils");
    protected static final Logger logger = Logger.getLogger("cloudLink.modelDiscovery");
    protected Map<String, Entity> pointsMap;
    protected Map<String, BFacets> facetsMap = new HashMap<String, BFacets>();
    protected Map<String, HistoryInfo> historiesMap = new HashMap<String, HistoryInfo>();
    protected Map<String, String> historyToCloudIdMap = new HashMap<String, String>();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void addNetworkEntry(ZipOutputStream out, BDeviceNetwork net, BDevice[] devices) throws IOException {
        out.putNextEntry(new ZipEntry(net.getName() + ModelDiscoveryConstants.ZIP_PATH_SEPARATOR + NETWORK_INFO));
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
        JSONWriter writer = QuickJSONWriter.make((Appendable)osw);
        writer.object().key("networkName").value((Object)net.getName()).key("n:displayName").value((Object)net.getDisplayName(null)).key("cloudId").value((Object)DiscoveryTagUtils.getOrAddCloudId((BIEntity)net));
        writer.key("devices").array();
        for (BDevice device : devices) {
            writer.value((Object)DiscoveryTagUtils.getOrAddCloudId((BIEntity)device));
        }
        writer.endArray();
        writer.endObject();
        osw.flush();
        out.closeEntry();
    }

    public boolean discoverModelInfo(ZipOutputStream out, BDeviceNetwork network, BJob job) throws Exception {
        job.log().message(lex.getText("modelDiscoverer.network.discoverModelInfo.notImplemented", new Object[]{network.getType(), network.getName()}));
        return false;
    }

    public void addDeviceEntry(ZipOutputStream out, BDevice dev) throws IOException {
        out.putNextEntry(new ZipEntry(DiscoveryUtils.getDevicePathFromNetwork(dev) + ModelDiscoveryConstants.ZIP_PATH_SEPARATOR + DEVICE_INFO));
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
        JSONWriter writer = QuickJSONWriter.make((Appendable)osw);
        writer.object().key("deviceName").value((Object)dev.getName()).key("n:displayName").value((Object)dev.getDisplayName(null)).key("cloudId").value((Object)DiscoveryTagUtils.getOrAddCloudId((BIEntity)dev));
        writer.key("points").array();
        writer.endArray();
        writer.key("histories").array();
        writer.endArray();
        writer.endObject();
        osw.flush();
        out.closeEntry();
    }

    public boolean discoverModelInfo(ZipOutputStream out, BDevice device, BJob job) throws Exception {
        job.log().message(lex.getText("modelDiscoverer.device.discoverModelInfo.notImplemented", new Object[]{device.getType(), device.getName()}));
        return false;
    }

    public String getPointCreationName(String slotpath, Entity e) {
        Optional optName = e.tags().get(ModelDiscoveryConstants.ID_DISPLAY_NAME);
        if (optName.isPresent()) {
            return ((BIDataValue)optName.get()).toString();
        }
        return slotpath.substring(slotpath.lastIndexOf(47) + 1);
    }

    public static String removePrefixOrd(BOrd ord, String schemeToRemove) {
        OrdQuery[] oqs = ord.parse();
        if (schemeToRemove == null || schemeToRemove.isEmpty()) {
            return ord.toString();
        }
        if (schemeToRemove.equals(oqs[0].getScheme())) {
            return oqs[1].getBody();
        }
        return oqs[0].getBody();
    }

    public String makeCloudId(Entity pointEntity) {
        Optional optHist;
        String cloudId = null;
        if (pointEntity != null && pointEntity.tags().contains(ModelDiscoveryConstants.ID_HISTORY) && (optHist = pointEntity.tags().get(ModelDiscoveryConstants.ID_HISTORY)) != null && optHist.isPresent()) {
            String historyId = ((BIDataValue)optHist.get()).toString();
            cloudId = this.historyToCloudIdMap.get(historyId);
        }
        if (cloudId == null) {
            cloudId = DiscoveryUtils.makeCloudId();
        }
        return cloudId;
    }

    public void releaseMaps() {
        this.pointsMap.clear();
        this.facetsMap.clear();
        this.historiesMap.clear();
        this.historyToCloudIdMap.clear();
        this.pointsMap = null;
        this.facetsMap = null;
        this.historiesMap = null;
        this.historyToCloudIdMap = null;
    }

    public JSONObject makeDiscoveryPoint(String slotpath, Entity e, BFacets f) {
        JSONObject o = new JSONObject();
        o.put("point", true);
        o.put("cloudId", (Object)this.makeCloudId(e));
        o.put("create", (Object)new JSONObject().put("slotpath", (Object)slotpath).put("name", (Object)this.getPointCreationName(slotpath, e)));
        JSONArray attrs = new JSONArray();
        for (Tag tag : e.tags()) {
            if (tag.getValue().equals(BMarker.MARKER)) {
                attrs.put((Object)new JSONObject().put("name", (Object)tag.getId().toString()));
                continue;
            }
            attrs.put((Object)new JSONObject().put("name", (Object)tag.getId().toString()).put("value", (Object)Objects.toString(tag.getValue())));
        }
        if (f != null) {
            String[] fKeys;
            for (String k : fKeys = f.list()) {
                attrs.put((Object)new JSONObject().put("name", (Object)k).put("value", (Object)f.get(k)));
            }
        }
        o.put("attrs", (Object)attrs);
        return o;
    }

    public void writePointInfo(Map<String, Entity> pointsMap, Map<String, BFacets> facetsMap, String basePath, ZipOutputStream out, JobLog log, Lexicon lex, String lexErrorKey) {
        for (Map.Entry<String, Entity> mapEntry : pointsMap.entrySet()) {
            try {
                JSONObject obj = this.makeDiscoveryPoint(mapEntry.getKey(), mapEntry.getValue(), facetsMap.get(mapEntry.getKey()));
                DiscoveryUtils.writeZipEntry(basePath, mapEntry.getKey(), obj, out);
            }
            catch (Exception e) {
                logger.info("Exception writing model discovery result for point:" + mapEntry.getKey() + ": " + e);
                log.message(lex.getText(lexErrorKey, new Object[]{mapEntry.getKey()}), e.toString());
            }
        }
    }

    public static String getHistoryCreationName(HistoryInfo info) {
        String name = info.historyName;
        if (name == null || name.isEmpty()) {
            name = FWD_SLASH_MATCHER.matcher(info.hId.substring(1)).replaceAll(Matcher.quoteReplacement("_"));
        }
        return name;
    }

    public boolean createImport(JSONObject discoveryInfo, JSONObject deviceInfo, BJob job) {
        job.log().message(lex.getText("modelDiscoverer.createImport.notImplemented"));
        return false;
    }

    protected JSONObject makeDiscoveryHistory(HistoryInfo info) {
        JSONObject o = new JSONObject();
        o.put("history", true);
        String cloudId = DiscoveryUtils.makeCloudId();
        o.put("cloudId", (Object)cloudId);
        this.historyToCloudIdMap.put(info.hId, cloudId);
        o.put("create", (Object)new JSONObject().put("historyId", (Object)info.hId).put("name", (Object)BModelDiscoverer.getHistoryCreationName(info)));
        o.put("pointRef", (Object)info.source);
        JSONArray attrs = new JSONArray();
        attrs.put((Object)new JSONObject().put("name", (Object)"sourceHandle").put("value", (Object)info.sourceHandle));
        attrs.put((Object)new JSONObject().put("name", (Object)"source").put("value", (Object)info.source));
        attrs.put((Object)new JSONObject().put("name", (Object)"recordType").put("value", (Object)info.recordType));
        attrs.put((Object)new JSONObject().put("name", (Object)"systemTags").put("value", (Object)info.systemTags));
        if (info.recordType.contains("Boolean")) {
            attrs.put((Object)new JSONObject().put("name", (Object)"digital"));
        }
        if (info.recordType.contains("Numeric")) {
            attrs.put((Object)new JSONObject().put("name", (Object)"analog"));
        }
        if (info.recordType.contains("Enum")) {
            attrs.put((Object)new JSONObject().put("name", (Object)"multistate"));
        }
        if (info.valueFacets != null) {
            String[] fKeys;
            for (String k : fKeys = info.valueFacets.list()) {
                attrs.put((Object)new JSONObject().put("name", (Object)k).put("value", (Object)info.valueFacets.get(k)));
            }
        }
        o.put("attrs", (Object)attrs);
        return o;
    }

    protected void writeHistoryInfo(Map<String, HistoryInfo> historiesMap, String basePath, ZipOutputStream out, JobLog log, Lexicon lex, String lexErrorKey) {
        for (Map.Entry<String, HistoryInfo> mapEntry : historiesMap.entrySet()) {
            try {
                JSONObject obj = this.makeDiscoveryHistory(mapEntry.getValue());
                DiscoveryUtils.writeZipEntry(basePath, mapEntry.getKey(), obj, out);
            }
            catch (Exception e) {
                logger.info("Exception writing model discovery result for history:" + mapEntry.getKey() + ": " + e);
                log.message(lex.getText(lexErrorKey, new Object[]{mapEntry.getKey(), e.toString()}));
            }
        }
    }
}

