/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.datatypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BSubnetNode
extends BSimple
implements LonAddress {
    public static final BSubnetNode DEFAULT = new BSubnetNode(0, 0);
    public static final Type TYPE = Sys.loadType(BSubnetNode.class);
    static IntHashMap cache = new IntHashMap();
    private int subnetId;
    private int nodeId;
    private static Lexicon LON_LEX = Lexicon.make((String)"lonworks");

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BSubnetNode make(int subnetId, int nodeId) {
        BSubnetNode sn;
        IntHashMap intHashMap = cache;
        synchronized (intHashMap) {
            int hash = subnetId << 8 | nodeId;
            sn = (BSubnetNode)cache.get(hash);
            if (sn == null) {
                sn = new BSubnetNode(subnetId, nodeId);
                cache.put(hash, (Object)sn);
            }
        }
        return sn;
    }

    public BSubnetNode makeFrom(int subnetId, int nodeId) {
        return BSubnetNode.make(subnetId, nodeId);
    }

    private BSubnetNode(int subnetId, int nodeId) {
        if (subnetId < 0 || subnetId > 255 || nodeId < 0 || nodeId > 127) {
            throw new BajaRuntimeException(LON_LEX.getText("SubnetNode.invalidInput.message", new Object[]{subnetId, nodeId}));
        }
        this.subnetId = subnetId;
        this.nodeId = nodeId;
    }

    public int getSubnetId() {
        return this.subnetId;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public int hashCode() {
        return 0x1000000 | this.subnetId << 8 | this.nodeId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BSubnetNode)) {
            return false;
        }
        BSubnetNode comp = (BSubnetNode)obj;
        return this.compare(comp.subnetId, comp.nodeId);
    }

    private boolean compare(int subnet, int node) {
        return this.subnetId == subnet && this.nodeId == node;
    }

    public String toString(Context context) {
        return this.subnetId + "/" + this.nodeId;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.subnetId);
        out.writeInt(this.nodeId);
    }

    public BObject decode(DataInput in) throws IOException {
        return this.makeFrom(in.readInt(), in.readInt());
    }

    public String encodeToString() throws IOException {
        return this.subnetId + "/" + this.nodeId;
    }

    public BObject decodeFromString(String s) throws IOException {
        int pos = s.indexOf("/");
        int subnet = Integer.parseInt(s.substring(0, pos));
        int node = Integer.parseInt(s.substring(pos + 1));
        return this.makeFrom(subnet, node);
    }

    @Override
    public int getAddressType() {
        return 1;
    }
}

