/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.device.BDownloadJob;
import com.tridium.lonworks.device.BUploadJob;
import com.tridium.lonworks.device.NvDev;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDeviceFolder;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="upload", parameterType="BUploadParameters", defaultValue="new BUploadParameters()"), @NiagaraAction(name="download", parameterType="BDownloadParameters", defaultValue="new BDownloadParameters()")})
public class BLonDeviceFolder
extends BDeviceFolder {
    @Generated
    public static final Action upload = BLonDeviceFolder.newAction((int)0, (BValue)new BUploadParameters(), null);
    @Generated
    public static final Action download = BLonDeviceFolder.newAction((int)0, (BValue)new BDownloadParameters(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLonDeviceFolder.class);

    @Generated
    public void upload(BUploadParameters parameter) {
        this.invoke(upload, (BValue)parameter, null);
    }

    @Generated
    public void download(BDownloadParameters parameter) {
        this.invoke(download, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BLonNetwork.TYPE) || parent.getType().is(TYPE);
    }

    public boolean isChildLegal(BComponent child) {
        return !child.getType().is(BDeviceFolder.TYPE) || child.getType().is(TYPE);
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value.getType().is(BLocalLonDevice.TYPE)) {
            throw new LocalizableRuntimeException("lonworks", "addLocalDeviceError");
        }
    }

    public void added(Property prop, Context context) {
        try {
            if (!this.isRunning()) {
                return;
            }
            if (prop.getType().is(BLonDevice.TYPE)) {
                this.getLonNetwork().netmgmt().deviceAdded((BLonDevice)this.get(prop));
            } else if (prop.getType().is(BLonRouter.TYPE)) {
                this.getLonNetwork().netmgmt().routerAdded((BLonRouter)this.get(prop));
            }
        }
        finally {
            super.added(prop, context);
        }
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        return NvDev.fixWireSheet(list, cx);
    }

    public final BLonNetwork getLonNetwork() {
        for (BComplex p = this.getParent(); p != null; p = p.getParent()) {
            if (!p.getType().is(BLonNetwork.TYPE)) continue;
            return (BLonNetwork)p;
        }
        throw new IllegalStateException();
    }

    public void doUpload(BUploadParameters params, Context cx) throws Exception {
        new BUploadJob((BIDeviceFolder)this, params, cx).submit(cx);
    }

    public void doDownload(BDownloadParameters params, Context cx) throws Exception {
        new BDownloadJob((BIDeviceFolder)this, params, cx).submit(cx);
    }
}

