/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.datatypes.BAppDownloadParameter;
import com.tridium.lonworks.datatypes.BCommissionParameter;
import com.tridium.lonworks.datatypes.BDescriptorTable;
import com.tridium.lonworks.datatypes.BDeviceEntry;
import com.tridium.lonworks.datatypes.BDeviceEntryTable;
import com.tridium.lonworks.datatypes.BDiscoverParameter;
import com.tridium.lonworks.datatypes.BLearnParameter;
import com.tridium.lonworks.datatypes.BLinkEntryTable;
import com.tridium.lonworks.datatypes.BMatchParameter;
import com.tridium.lonworks.datatypes.BRouterEntry;
import com.tridium.lonworks.datatypes.BRouterEntryTable;
import com.tridium.lonworks.datatypes.BServicePinData;
import com.tridium.lonworks.datatypes.BSetServiceTypeParameter;
import com.tridium.lonworks.datatypes.BTagLinkEntry;
import com.tridium.lonworks.datatypes.BTagLinkEntryTable;
import com.tridium.lonworks.datatypes.BUtilitiesCommand;
import com.tridium.lonworks.netmessages.ServicePin;
import com.tridium.lonworks.netmgmt.BLonAppDownloadJob;
import com.tridium.lonworks.netmgmt.BLonBindJob;
import com.tridium.lonworks.netmgmt.BLonCommissionJob;
import com.tridium.lonworks.netmgmt.BLonCommissionRouterJob;
import com.tridium.lonworks.netmgmt.BLonDiscoverJob;
import com.tridium.lonworks.netmgmt.BLonLearnJob;
import com.tridium.lonworks.netmgmt.BLonLearnLinksJob;
import com.tridium.lonworks.netmgmt.BLonReplaceJob;
import com.tridium.lonworks.netmgmt.BLonSetServiceTypeJob;
import com.tridium.lonworks.netmgmt.BLonUpdateRoutersJob;
import com.tridium.lonworks.netmgmt.ConnectionTable;
import com.tridium.lonworks.netmgmt.LonUtilRequest;
import com.tridium.lonworks.netmgmt.ProcessServicePin;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.RouterUtil;
import com.tridium.sys.station.Station;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAuthenticationKey;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="deviceDiscoverTable", type="BDeviceEntryTable", defaultValue="new BDeviceEntryTable()", flags=6), @NiagaraProperty(name="routerDiscoverTable", type="BRouterEntryTable", defaultValue="new BRouterEntryTable()", flags=6), @NiagaraProperty(name="domainId", type="BDomainId", defaultValue="BDomainId.DEFAULT"), @NiagaraProperty(name="authenticate", type="boolean", defaultValue="false"), @NiagaraProperty(name="authenticationKey", type="BAuthenticationKey", defaultValue="BAuthenticationKey.DEFAULT"), @NiagaraProperty(name="linkDescriptors", type="BDescriptorTable", defaultValue="new BDescriptorTable()"), @NiagaraProperty(name="nonGroupTimer", type="int", defaultValue="4"), @NiagaraProperty(name="channelPriorities", type="int", defaultValue="0"), @NiagaraProperty(name="debug", type="boolean", defaultValue="false"), @NiagaraProperty(name="verifyNvDir", type="boolean", defaultValue="false"), @NiagaraProperty(name="servicePinWait", type="int", defaultValue="300", facets={@Facet(value="BFacets.makeInt(UnitDatabase.getUnit(\"second\"))")}), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true", flags=7), @NiagaraProperty(name="tempBridge", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="useLonObjects", type="boolean", defaultValue="false"), @NiagaraProperty(name="alwaysInZeroLengthDomain", type="boolean", defaultValue="false")})
@NiagaraActions(value={@NiagaraAction(name="discover", returnType="BOrd", flags=4), @NiagaraAction(name="discoverSelect", parameterType="BDiscoverParameter", defaultValue="new BDiscoverParameter()", returnType="BOrd", flags=4), @NiagaraAction(name="learn", parameterType="BLearnParameter", defaultValue="new BLearnParameter()", returnType="BOrd", flags=4), @NiagaraAction(name="match", parameterType="BMatchParameter", defaultValue="new BMatchParameter()", returnType="BBoolean", flags=4), @NiagaraAction(name="commissionDevice", parameterType="BCommissionParameter", defaultValue="new BCommissionParameter()", returnType="BOrd", flags=4), @NiagaraAction(name="replaceDevice", parameterType="BCommissionParameter", defaultValue="new BCommissionParameter()", returnType="BOrd", flags=4), @NiagaraAction(name="commissionRouter", parameterType="BCommissionParameter", defaultValue="new BCommissionParameter()", returnType="BOrd", flags=4), @NiagaraAction(name="replaceRouter", parameterType="BCommissionParameter", defaultValue="new BCommissionParameter()", returnType="BOrd", flags=4), @NiagaraAction(name="setServiceType", parameterType="BSetServiceTypeParameter", defaultValue="new BSetServiceTypeParameter()", returnType="BOrd", flags=4), @NiagaraAction(name="bind", returnType="BOrd", flags=4), @NiagaraAction(name="bindLinkEntry", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BOrd", flags=4), @NiagaraAction(name="bindTagLinkEntry", parameterType="BTagLinkEntry", defaultValue="new BTagLinkEntry()", returnType="BOrd", flags=4), @NiagaraAction(name="bindDevice", parameterType="BLonDevice", defaultValue="new BLonDevice()", returnType="BOrd", flags=4), @NiagaraAction(name="refreshLinkTable", flags=4), @NiagaraAction(name="tempBridgeOn"), @NiagaraAction(name="tempBridgeOff"), @NiagaraAction(name="appDownLoad", parameterType="BAppDownloadParameter", defaultValue="new BAppDownloadParameter()", returnType="BOrd", flags=4), @NiagaraAction(name="deviceForSubnetNodeId", parameterType="BSubnetNode", defaultValue="BSubnetNode.DEFAULT", returnType="BOrd", flags=4), @NiagaraAction(name="deviceForNeuronId", parameterType="BNeuronId", defaultValue="BNeuronId.DEFAULT", returnType="BOrd", flags=4), @NiagaraAction(name="updateRouters", returnType="BOrd"), @NiagaraAction(name="cancelServicePin")})
@NiagaraTopics(value={@NiagaraTopic(name="deviceDiscoveryUpdated", eventType="BDeviceEntryTable"), @NiagaraTopic(name="routerDiscoveryUpdated", eventType="BRouterEntryTable"), @NiagaraTopic(name="devicesUpdated", eventType="BDeviceEntryTable"), @NiagaraTopic(name="routersUpdated", eventType="BRouterEntryTable"), @NiagaraTopic(name="linksUpdated", eventType="BLinkEntryTable"), @NiagaraTopic(name="tagLinksUpdated", eventType="BTagLinkEntryTable"), @NiagaraTopic(name="servicePinReceived", eventType="BServicePinData"), @NiagaraTopic(name="learnComplete")})
public class BLonNetmgmt
extends BComponent {
    @Generated
    public static final Property deviceDiscoverTable = BLonNetmgmt.newProperty((int)6, (BValue)new BDeviceEntryTable(), null);
    @Generated
    public static final Property routerDiscoverTable = BLonNetmgmt.newProperty((int)6, (BValue)new BRouterEntryTable(), null);
    @Generated
    public static final Property domainId = BLonNetmgmt.newProperty((int)0, (BValue)BDomainId.DEFAULT, null);
    @Generated
    public static final Property authenticate = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property authenticationKey = BLonNetmgmt.newProperty((int)0, (BValue)BAuthenticationKey.DEFAULT, null);
    @Generated
    public static final Property linkDescriptors = BLonNetmgmt.newProperty((int)0, (BValue)new BDescriptorTable(), null);
    @Generated
    public static final Property nonGroupTimer = BLonNetmgmt.newProperty((int)0, (int)4, null);
    @Generated
    public static final Property channelPriorities = BLonNetmgmt.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property debug = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property verifyNvDir = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property servicePinWait = BLonNetmgmt.newProperty((int)0, (int)300, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"second")));
    @Generated
    public static final Property enabled = BLonNetmgmt.newProperty((int)7, (boolean)true, null);
    @Generated
    public static final Property tempBridge = BLonNetmgmt.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property useLonObjects = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property alwaysInZeroLengthDomain = BLonNetmgmt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Action discover = BLonNetmgmt.newAction((int)4, null);
    @Generated
    public static final Action discoverSelect = BLonNetmgmt.newAction((int)4, (BValue)new BDiscoverParameter(), null);
    @Generated
    public static final Action learn = BLonNetmgmt.newAction((int)4, (BValue)new BLearnParameter(), null);
    @Generated
    public static final Action match = BLonNetmgmt.newAction((int)4, (BValue)new BMatchParameter(), null);
    @Generated
    public static final Action commissionDevice = BLonNetmgmt.newAction((int)4, (BValue)new BCommissionParameter(), null);
    @Generated
    public static final Action replaceDevice = BLonNetmgmt.newAction((int)4, (BValue)new BCommissionParameter(), null);
    @Generated
    public static final Action commissionRouter = BLonNetmgmt.newAction((int)4, (BValue)new BCommissionParameter(), null);
    @Generated
    public static final Action replaceRouter = BLonNetmgmt.newAction((int)4, (BValue)new BCommissionParameter(), null);
    @Generated
    public static final Action setServiceType = BLonNetmgmt.newAction((int)4, (BValue)new BSetServiceTypeParameter(), null);
    @Generated
    public static final Action bind = BLonNetmgmt.newAction((int)4, null);
    @Generated
    public static final Action bindLinkEntry = BLonNetmgmt.newAction((int)4, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action bindTagLinkEntry = BLonNetmgmt.newAction((int)4, (BValue)new BTagLinkEntry(), null);
    @Generated
    public static final Action bindDevice = BLonNetmgmt.newAction((int)4, (BValue)new BLonDevice(), null);
    @Generated
    public static final Action refreshLinkTable = BLonNetmgmt.newAction((int)4, null);
    @Generated
    public static final Action tempBridgeOn = BLonNetmgmt.newAction((int)0, null);
    @Generated
    public static final Action tempBridgeOff = BLonNetmgmt.newAction((int)0, null);
    @Generated
    public static final Action appDownLoad = BLonNetmgmt.newAction((int)4, (BValue)new BAppDownloadParameter(), null);
    @Generated
    public static final Action deviceForSubnetNodeId = BLonNetmgmt.newAction((int)4, (BValue)BSubnetNode.DEFAULT, null);
    @Generated
    public static final Action deviceForNeuronId = BLonNetmgmt.newAction((int)4, (BValue)BNeuronId.DEFAULT, null);
    @Generated
    public static final Action updateRouters = BLonNetmgmt.newAction((int)0, null);
    @Generated
    public static final Action cancelServicePin = BLonNetmgmt.newAction((int)0, null);
    @Generated
    public static final Topic deviceDiscoveryUpdated = BLonNetmgmt.newTopic((int)0, null);
    @Generated
    public static final Topic routerDiscoveryUpdated = BLonNetmgmt.newTopic((int)0, null);
    @Generated
    public static final Topic devicesUpdated = BLonNetmgmt.newTopic((int)0, null);
    @Generated
    public static final Topic routersUpdated = BLonNetmgmt.newTopic((int)0, null);
    @Generated
    public static final Topic linksUpdated = BLonNetmgmt.newTopic((int)0, null);
    @Generated
    public static final Topic tagLinksUpdated = BLonNetmgmt.newTopic((int)0, null);
    @Generated
    public static final Topic servicePinReceived = BLonNetmgmt.newTopic((int)0, null);
    @Generated
    public static final Topic learnComplete = BLonNetmgmt.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLonNetmgmt.class);
    private static final BIcon icon = BIcon.std((String)"match.png");

    @Generated
    public BDeviceEntryTable getDeviceDiscoverTable() {
        return (BDeviceEntryTable)this.get(deviceDiscoverTable);
    }

    @Generated
    public void setDeviceDiscoverTable(BDeviceEntryTable v) {
        this.set(deviceDiscoverTable, (BValue)v, null);
    }

    @Generated
    public BRouterEntryTable getRouterDiscoverTable() {
        return (BRouterEntryTable)this.get(routerDiscoverTable);
    }

    @Generated
    public void setRouterDiscoverTable(BRouterEntryTable v) {
        this.set(routerDiscoverTable, (BValue)v, null);
    }

    @Generated
    public BDomainId getDomainId() {
        return (BDomainId)this.get(domainId);
    }

    @Generated
    public void setDomainId(BDomainId v) {
        this.set(domainId, (BValue)v, null);
    }

    @Generated
    public boolean getAuthenticate() {
        return this.getBoolean(authenticate);
    }

    @Generated
    public void setAuthenticate(boolean v) {
        this.setBoolean(authenticate, v, null);
    }

    @Generated
    public BAuthenticationKey getAuthenticationKey() {
        return (BAuthenticationKey)this.get(authenticationKey);
    }

    @Generated
    public void setAuthenticationKey(BAuthenticationKey v) {
        this.set(authenticationKey, (BValue)v, null);
    }

    @Generated
    public BDescriptorTable getLinkDescriptors() {
        return (BDescriptorTable)this.get(linkDescriptors);
    }

    @Generated
    public void setLinkDescriptors(BDescriptorTable v) {
        this.set(linkDescriptors, (BValue)v, null);
    }

    @Generated
    public int getNonGroupTimer() {
        return this.getInt(nonGroupTimer);
    }

    @Generated
    public void setNonGroupTimer(int v) {
        this.setInt(nonGroupTimer, v, null);
    }

    @Generated
    public int getChannelPriorities() {
        return this.getInt(channelPriorities);
    }

    @Generated
    public void setChannelPriorities(int v) {
        this.setInt(channelPriorities, v, null);
    }

    @Generated
    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    @Generated
    public void setDebug(boolean v) {
        this.setBoolean(debug, v, null);
    }

    @Generated
    public boolean getVerifyNvDir() {
        return this.getBoolean(verifyNvDir);
    }

    @Generated
    public void setVerifyNvDir(boolean v) {
        this.setBoolean(verifyNvDir, v, null);
    }

    @Generated
    public int getServicePinWait() {
        return this.getInt(servicePinWait);
    }

    @Generated
    public void setServicePinWait(int v) {
        this.setInt(servicePinWait, v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public boolean getTempBridge() {
        return this.getBoolean(tempBridge);
    }

    @Generated
    public void setTempBridge(boolean v) {
        this.setBoolean(tempBridge, v, null);
    }

    @Generated
    public boolean getUseLonObjects() {
        return this.getBoolean(useLonObjects);
    }

    @Generated
    public void setUseLonObjects(boolean v) {
        this.setBoolean(useLonObjects, v, null);
    }

    @Generated
    public boolean getAlwaysInZeroLengthDomain() {
        return this.getBoolean(alwaysInZeroLengthDomain);
    }

    @Generated
    public void setAlwaysInZeroLengthDomain(boolean v) {
        this.setBoolean(alwaysInZeroLengthDomain, v, null);
    }

    @Generated
    public BOrd discover() {
        return (BOrd)this.invoke(discover, null, null);
    }

    @Generated
    public BOrd discoverSelect(BDiscoverParameter parameter) {
        return (BOrd)this.invoke(discoverSelect, (BValue)parameter, null);
    }

    @Generated
    public BOrd learn(BLearnParameter parameter) {
        return (BOrd)this.invoke(learn, (BValue)parameter, null);
    }

    @Generated
    public BBoolean match(BMatchParameter parameter) {
        return (BBoolean)this.invoke(match, (BValue)parameter, null);
    }

    @Generated
    public BOrd commissionDevice(BCommissionParameter parameter) {
        return (BOrd)this.invoke(commissionDevice, (BValue)parameter, null);
    }

    @Generated
    public BOrd replaceDevice(BCommissionParameter parameter) {
        return (BOrd)this.invoke(replaceDevice, (BValue)parameter, null);
    }

    @Generated
    public BOrd commissionRouter(BCommissionParameter parameter) {
        return (BOrd)this.invoke(commissionRouter, (BValue)parameter, null);
    }

    @Generated
    public BOrd replaceRouter(BCommissionParameter parameter) {
        return (BOrd)this.invoke(replaceRouter, (BValue)parameter, null);
    }

    @Generated
    public BOrd setServiceType(BSetServiceTypeParameter parameter) {
        return (BOrd)this.invoke(setServiceType, (BValue)parameter, null);
    }

    @Generated
    public BOrd bind() {
        return (BOrd)this.invoke(bind, null, null);
    }

    @Generated
    public BOrd bindLinkEntry(BString parameter) {
        return (BOrd)this.invoke(bindLinkEntry, (BValue)parameter, null);
    }

    @Generated
    public BOrd bindTagLinkEntry(BTagLinkEntry parameter) {
        return (BOrd)this.invoke(bindTagLinkEntry, (BValue)parameter, null);
    }

    @Generated
    public BOrd bindDevice(BLonDevice parameter) {
        return (BOrd)this.invoke(bindDevice, (BValue)parameter, null);
    }

    @Generated
    public void refreshLinkTable() {
        this.invoke(refreshLinkTable, null, null);
    }

    @Generated
    public void tempBridgeOn() {
        this.invoke(tempBridgeOn, null, null);
    }

    @Generated
    public void tempBridgeOff() {
        this.invoke(tempBridgeOff, null, null);
    }

    @Generated
    public BOrd appDownLoad(BAppDownloadParameter parameter) {
        return (BOrd)this.invoke(appDownLoad, (BValue)parameter, null);
    }

    @Generated
    public BOrd deviceForSubnetNodeId(BSubnetNode parameter) {
        return (BOrd)this.invoke(deviceForSubnetNodeId, (BValue)parameter, null);
    }

    @Generated
    public BOrd deviceForNeuronId(BNeuronId parameter) {
        return (BOrd)this.invoke(deviceForNeuronId, (BValue)parameter, null);
    }

    @Generated
    public BOrd updateRouters() {
        return (BOrd)this.invoke(updateRouters, null, null);
    }

    @Generated
    public void cancelServicePin() {
        this.invoke(cancelServicePin, null, null);
    }

    @Generated
    public void fireDeviceDiscoveryUpdated(BDeviceEntryTable event) {
        this.fire(deviceDiscoveryUpdated, (BValue)event, null);
    }

    @Generated
    public void fireRouterDiscoveryUpdated(BRouterEntryTable event) {
        this.fire(routerDiscoveryUpdated, (BValue)event, null);
    }

    @Generated
    public void fireDevicesUpdated(BDeviceEntryTable event) {
        this.fire(devicesUpdated, (BValue)event, null);
    }

    @Generated
    public void fireRoutersUpdated(BRouterEntryTable event) {
        this.fire(routersUpdated, (BValue)event, null);
    }

    @Generated
    public void fireLinksUpdated(BLinkEntryTable event) {
        this.fire(linksUpdated, (BValue)event, null);
    }

    @Generated
    public void fireTagLinksUpdated(BTagLinkEntryTable event) {
        this.fire(tagLinksUpdated, (BValue)event, null);
    }

    @Generated
    public void fireServicePinReceived(BServicePinData event) {
        this.fire(servicePinReceived, (BValue)event, null);
    }

    @Generated
    public void fireLearnComplete(BValue event) {
        this.fire(learnComplete, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        if (!(parent instanceof BLonNetwork)) {
            return false;
        }
        return !parent.getProperties().next(BLonNetmgmt.class);
    }

    public BLonNetwork lonNetwork() {
        return (BLonNetwork)this.getParent();
    }

    public Logger log() {
        return this.lonNetwork().log();
    }

    public final void started() {
        boolean disableNetmgmt = Boolean.getBoolean("lonworks.disableNetmgmt");
        this.setEnabled(!disableNetmgmt);
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning() || context == BLonNetwork.lonNoWrite) {
            return;
        }
        if (prop == domainId || prop == authenticationKey) {
            try {
                NmUtil.updateDomainTable(this.lonNetwork().getLocalLonDevice(), this.getDomainId(), this.getAuthenticationKey(), false);
            }
            catch (LonException e) {
                this.log().log(Level.SEVERE, "Unable to update local domain table ", (Throwable)((Object)e));
            }
        }
    }

    public void doRefreshLinkTable() {
        BComponentSpace cs = this.getComponentSpace();
        if (cs == null || cs != Station.space) {
            return;
        }
        Runnable req = new Runnable(){

            @Override
            public void run() {
                BLonNetmgmt.this.asyncRefreshLinkTable();
            }
        };
        this.lonNetwork().postAsync(req);
    }

    private void asyncRefreshLinkTable() {
        try {
            ConnectionTable connTable = new ConnectionTable(this.lonNetwork());
            this.updateLinkTable(connTable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BOrd doBind() {
        return new BLonBindJob(this, null, null, this.getDebug()).submit(null);
    }

    public BOrd doBindDevice(BLonDevice dev) {
        return new BLonBindJob(this, dev, this.getDebug()).submit(null);
    }

    public BOrd doBindLinkEntry(BString selects) {
        return new BLonBindJob(this, selects, null, this.getDebug()).submit(null);
    }

    public BOrd doBindTagLinkEntry(BTagLinkEntry entry) {
        return new BLonBindJob(this, null, entry, this.getDebug()).submit(null);
    }

    void updateLinkTable(ConnectionTable connTable) {
        BLinkEntryTable lnkTab = connTable.getLonLinkTable();
        lnkTab.setExceededMaximumConnections(connTable.isExceededMaximumConnections());
        this.fireLinksUpdated(lnkTab);
        BTagLinkEntryTable tagTab = connTable.getLonMessageTagTable();
        this.fireTagLinksUpdated(tagTab);
    }

    public void deviceAdded(BLonDevice dev) {
        BDeviceEntry e = this.getDeviceDiscoverTable().findEntry(dev.getDeviceData().getNeuronId());
        if (e != null) {
            this.getDeviceDiscoverTable().removeEntry(e);
        }
        this.fireDeviceDiscoveryUpdated(this.getDeviceDiscoverTable());
    }

    public void routerAdded(BLonRouter dev) {
        BRouterEntry e = this.getRouterDiscoverTable().findEntry(dev.getNearDeviceData().getNeuronId());
        if (e != null) {
            this.getRouterDiscoverTable().removeEntry(e);
        }
        this.fireRouterDiscoveryUpdated(this.getRouterDiscoverTable());
    }

    public void receiveServicePin(ServicePin msg) {
        this.lonNetwork().postAsync(new ProcessServicePin(this, msg));
        this.fireServicePinReceived(new BServicePinData(msg.getNeuronId(), msg.getIdString()));
    }

    public BOrd doDiscover() {
        return new BLonDiscoverJob(this).submit(null);
    }

    public BOrd doDiscoverSelect(BDiscoverParameter param) {
        return new BLonDiscoverJob(this, param).submit(null);
    }

    public BOrd doLearn(BLearnParameter param) {
        if (param.isSelectedDevices()) {
            return new BLonLearnLinksJob(this, param).submit(null);
        }
        return new BLonLearnJob(this, param).submit(null);
    }

    public void doCancelServicePin() {
        this.lonNetwork().netMessageReceiver().cancelServicePin();
    }

    public BOrd doCommissionDevice(BCommissionParameter param) {
        return new BLonCommissionJob(this, param).submit(null);
    }

    public BOrd doCommissionRouter(BCommissionParameter param) {
        return new BLonCommissionRouterJob(this, param).submit(null);
    }

    public BOrd doReplaceDevice(BCommissionParameter param) {
        return new BLonReplaceJob(this, param).submit(null);
    }

    public BOrd doReplaceRouter(BCommissionParameter param) {
        return new BLonCommissionRouterJob(this, param).submit(null);
    }

    public void doTempBridgeOn() {
        Runnable req = new Runnable(){

            @Override
            public void run() {
                BLonNetmgmt.this.setTempBridge(true);
                RouterUtil.setTemporaryBridge(BLonNetmgmt.this.lonNetwork());
            }
        };
        this.lonNetwork().postAsync(req);
    }

    public void doTempBridgeOff() {
        Runnable req = new Runnable(){

            @Override
            public void run() {
                BLonNetmgmt.this.setTempBridge(false);
                RouterUtil.clearTemporaryBridge(BLonNetmgmt.this.lonNetwork());
            }
        };
        this.lonNetwork().postAsync(req);
    }

    public BOrd doAppDownLoad(BAppDownloadParameter param) {
        return new BLonAppDownloadJob(this, param).submit(null);
    }

    public BOrd doSetServiceType(BSetServiceTypeParameter param) {
        return new BLonSetServiceTypeJob(this, param).submit(null);
    }

    public BBoolean doMatch(BMatchParameter param) {
        BLonDevice dbDev = this.lonNetwork().addressManager().getDeviceByAddress(param.getDbDevSubnetNode());
        BDeviceEntry devEntry = param.getDeviceEntry();
        if (dbDev == null || devEntry == null) {
            return BBoolean.TRUE;
        }
        BDeviceData dd = dbDev.getDeviceData();
        BSubnetNode sn = BSubnetNode.make(devEntry.getSubnet(), devEntry.getNode());
        BLonDevice snDev = this.lonNetwork().addressManager().getDeviceByAddress(sn);
        if (snDev != null && snDev != dbDev) {
            return BBoolean.FALSE;
        }
        dd.set(BDeviceData.neuronId, (BValue)devEntry.getNeuronId(), AddressManager.noDeviceChange);
        dd.set(BDeviceData.subnetNodeId, (BValue)sn, AddressManager.noDeviceChange);
        dd.set(BDeviceData.nodeState, (BValue)devEntry.getState(), AddressManager.noDeviceChange);
        dd.set(BDeviceData.programId, (BValue)devEntry.getProgramId(), AddressManager.noDeviceChange);
        dd.setInt(BDeviceData.channelId, devEntry.getChannelId(), AddressManager.noDeviceChange);
        String n = devEntry.getDevName();
        if (!n.equals(dbDev.getName())) {
            dbDev.getParent().asComponent().rename(dbDev.getPropertyInParent(), n);
        }
        return BBoolean.TRUE;
    }

    public BOrd doDeviceForSubnetNodeId(BSubnetNode addr) {
        if (this.lonNetwork().addressManager() == null) {
            return null;
        }
        BLonDevice dev = this.lonNetwork().addressManager().getDeviceByAddress(addr);
        if (dev != null) {
            return dev.getHandleOrd();
        }
        BLonRouter rtr = this.lonNetwork().addressManager().getRouterByAddress(addr);
        if (rtr != null) {
            return rtr.getHandleOrd();
        }
        return null;
    }

    public BOrd doDeviceForNeuronId(BNeuronId nid) {
        if (this.lonNetwork().addressManager() == null) {
            return null;
        }
        BLonDevice dev = this.lonNetwork().addressManager().getDeviceByAddress(nid);
        if (dev != null) {
            return dev.getHandleOrd();
        }
        BLonRouter rtr = this.lonNetwork().addressManager().getRouterByAddress(nid);
        if (rtr != null) {
            return rtr.getHandleOrd();
        }
        return null;
    }

    public void executeUtilitiesCommand(BUtilitiesCommand cmd, PrintWriter out) {
        LonUtilRequest r = new LonUtilRequest(cmd, this, out);
        r.run();
        out.flush();
    }

    public BOrd doUpdateRouters() {
        return new BLonUpdateRoutersJob(this).submit(null);
    }

    public BIcon getIcon() {
        return icon;
    }
}

