/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSerial.qnx;

import com.tridium.platSerial.BSerialPort;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Objects;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialFlowControlMode;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.serial.PortDeniedException;
import javax.baja.sys.Action;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="modulePosition", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="vendor", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="product", type="String", defaultValue="unknown", flags=3), @NiagaraProperty(name="enablePortResetOnError", type="boolean", defaultValue="true")})
@NiagaraAction(name="resetPort", flags=16)
public class BSerialPortQnx
extends BSerialPort {
    @Generated
    public static final Property modulePosition = BSerialPortQnx.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property vendor = BSerialPortQnx.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property product = BSerialPortQnx.newProperty((int)3, (String)"unknown", null);
    @Generated
    public static final Property enablePortResetOnError = BSerialPortQnx.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action resetPort = BSerialPortQnx.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSerialPortQnx.class);
    private static final String STATION_PREFIX = "station:";
    private int fd = 0;
    private BBaudRate baudRate = BSerialBaudRate.baud9600;
    private BSerialDataBits dataBits = BSerialDataBits.dataBits8;
    private BSerialStopBits stopBits = BSerialStopBits.stopBit1;
    private BSerialParity parity = BSerialParity.none;
    private BSerialFlowControlMode flowControl = BSerialFlowControlMode.none;
    private int rcvThreshold = -1;
    private int rcvTimeout = -1;
    private static final String _TEMP_DIRECTORY = "/dev/shmem";
    private static final int NULL_BUFFER_ON_WRITE = -1;
    private static final int EOK = 0;
    private static final int EAGAIN = 11;

    @Generated
    public int getModulePosition() {
        return this.getInt(modulePosition);
    }

    @Generated
    public void setModulePosition(int v) {
        this.setInt(modulePosition, v, null);
    }

    @Generated
    public String getVendor() {
        return this.getString(vendor);
    }

    @Generated
    public void setVendor(String v) {
        this.setString(vendor, v, null);
    }

    @Generated
    public String getProduct() {
        return this.getString(product);
    }

    @Generated
    public void setProduct(String v) {
        this.setString(product, v, null);
    }

    @Generated
    public boolean getEnablePortResetOnError() {
        return this.getBoolean(enablePortResetOnError);
    }

    @Generated
    public void setEnablePortResetOnError(boolean v) {
        this.setBoolean(enablePortResetOnError, v, null);
    }

    @Generated
    public void resetPort() {
        this.invoke(resetPort, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSerialPortQnx() {
    }

    public BSerialPortQnx(String osName, int portIndex) {
        this.setOsPortName(osName);
        this.setPortIndex(portIndex);
        this.initOwner();
    }

    public BSerialPortQnx(String osName, int portIndex, int position, String vendorStr, String productStr) {
        this.setOsPortName(osName);
        this.setPortIndex(portIndex);
        this.setModulePosition(position);
        this.setVendor(vendorStr);
        this.setProduct(productStr);
        this.initOwner();
    }

    private String getLockFileName() {
        if (this.getOsPortName().contains("gprs")) {
            return _TEMP_DIRECTORY + File.separatorChar + "sergprs" + this.getPortIndex() + ".owner";
        }
        return _TEMP_DIRECTORY + File.separatorChar + "ser" + this.getPortIndex() + ".owner";
    }

    public synchronized void lock(String owner) throws PortDeniedException {
        this.checkOwner();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Attempting to lock " + this.getName() + " for owner " + owner);
        }
        if (!"none".equalsIgnoreCase(this.getOwner())) {
            throw new PortDeniedException("Unable to create lock for " + this.getName() + " for owner " + owner + ", already owned by " + this.getOwner());
        }
        this.setOwner(owner);
        this.locked = true;
        FileOutputStream fos = null;
        try {
            try {
                fos = AccessController.doPrivileged(() -> new FileOutputStream(this.getLockFileName()));
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            fos.write((STATION_PREFIX + owner).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            this.setOwner("none");
            this.locked = false;
            throw new PortDeniedException("Unable to create lock for " + this.getName() + " for owner " + owner + ": " + e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.getName() + " locked for owner " + owner);
        }
    }

    public synchronized void unlock() throws PortDeniedException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Attempting to unlock " + this.getName() + " as " + this.getOwner());
        }
        if (!this.locked) {
            throw new PortDeniedException("Unable to unlock " + this.getName() + ", " + this.getOwner() + " does not have the port lock");
        }
        File file = new File(this.getLockFileName());
        boolean result = AccessController.doPrivileged(file::delete);
        if (!result) {
            throw new PortDeniedException("Unable to unlock " + this.getName() + ", failed to delete " + this.getLockFileName());
        }
        this.setOwner("none");
        this.locked = false;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.getName() + " unlocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getLockFileOwner(String lockFileName) throws Exception {
        FileInputStream fis = null;
        try {
            try {
                fis = AccessController.doPrivileged(() -> new FileInputStream(lockFileName));
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            StringBuilder buf = new StringBuilder();
            int c = fis.read();
            while (c != -1) {
                buf.append((char)c);
                c = fis.read();
            }
            String owner = buf.toString().trim();
            owner = TextUtil.replace((String)owner, (String)"\n", (String)"");
            String string = owner = TextUtil.replace((String)owner, (String)"\r", (String)"");
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void initOwner() {
        try {
            String owner = this.getLockFileOwner(this.getLockFileName());
            if (owner.startsWith(STATION_PREFIX)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Cleaning up old lock file " + this.getLockFileName() + ", old owner: " + owner);
                }
                AccessController.doPrivileged(() -> new File(this.getLockFileName()).delete());
                this.setOwner("none");
                this.locked = false;
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Can not initialize owner of " + this.getOsPortName() + ", port already owned by " + owner + ", lock file " + this.getLockFileName());
                }
                this.setOwner(owner);
                this.locked = true;
            }
            return;
        }
        catch (FileNotFoundException owner) {
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Problem reading lock file for " + this.getOsPortName(), e);
        }
        this.locked = false;
        this.setOwner("none");
    }

    public synchronized void checkOwner() {
        try {
            String owner = this.getLockFileOwner(this.getLockFileName());
            if (owner.startsWith(STATION_PREFIX)) {
                owner = owner.substring(STATION_PREFIX.length());
            }
            this.locked = true;
            this.setOwner(owner);
            return;
        }
        catch (FileNotFoundException owner) {
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Problem reading lock file " + this.getLockFileName() + " for " + this.getName() + " defaulting to no ownership", e);
        }
        this.locked = false;
        this.setOwner("none");
    }

    protected void openPort() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Opening " + this.getOsPortName() + "...");
        }
        this.fd = this.open0(this.getOsPortName());
        if (this.fd <= 0) {
            LOG.severe("Failed to open " + this.getOsPortName());
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Port " + this.getOsPortName() + " is open, file descriptor is " + this.fd);
        }
    }

    protected void closePort() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Closing " + this.getOsPortName() + ", file descriptor is " + this.fd + "...");
        }
        if (this.fd > 0) {
            this.close0(this.fd);
            this.fd = 0;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Port " + this.getOsPortName() + " is closed");
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Can not close port " + this.getOsPortName() + " invalid file descriptor");
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.fd <= 0) {
            throw new IOException("Can not obtain input stream, invalid file descriptor " + this.fd);
        }
        return new SerialInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.fd <= 0) {
            throw new IOException("Can not obtain output stream, invalid file descriptor " + this.fd);
        }
        return new SerialOutputStream();
    }

    public void enableReceiveThreshold(int i) throws UnsupportedOperationException {
        if (i <= 0) {
            throw new UnsupportedOperationException("Threshold must be >= 1");
        }
        this.rcvThreshold = i;
    }

    public void disableReceiveThreshold() {
        this.rcvThreshold = -1;
    }

    public boolean isReceiveThresholdEnabled() {
        return this.rcvThreshold >= 0;
    }

    public int getReceiveThreshold() {
        return this.rcvThreshold;
    }

    public void enableReceiveTimeout(int i) throws UnsupportedOperationException {
        this.rcvTimeout = i;
    }

    public void disableReceiveTimeout() {
        this.rcvTimeout = -1;
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.rcvTimeout >= 0;
    }

    public int getReceiveTimeout() {
        return this.rcvTimeout;
    }

    public BBaudRate getBaudRate() {
        return this.baudRate;
    }

    public BSerialDataBits getDataBits() {
        return this.dataBits;
    }

    public BSerialStopBits getStopBits() {
        return this.stopBits;
    }

    public BSerialParity getParity() {
        return this.parity;
    }

    public void sendBreak(int i) {
        if (this.fd <= 0) {
            return;
        }
        this.sendBreak0(this.fd, i);
    }

    public void setFlowControlMode(BSerialFlowControlMode mode) throws UnsupportedOperationException {
        if (this.fd <= 0) {
            return;
        }
        this.setFlowControlMode0(this.fd, mode.getBits());
        this.flowControl = mode;
    }

    public BSerialFlowControlMode getFlowControlMode() {
        return this.flowControl;
    }

    public void setSerialPortParams(BBaudRate baudRate, BSerialDataBits dataBits, BSerialStopBits stopBits, BSerialParity parity) throws UnsupportedOperationException {
        if (this.fd <= 0) {
            return;
        }
        this.setSerialPortParams0(this.fd, baudRate.getOrdinal(), dataBits.getOrdinal(), stopBits.getOrdinal(), parity.getOrdinal());
        this.baudRate = baudRate;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.parity = parity;
    }

    public void setDTR(boolean flag) {
        if (this.fd <= 0) {
            return;
        }
        this.setDTR0(this.fd, flag);
    }

    public boolean isDTR() {
        return this.fd > 0 && this.isDTR0(this.fd);
    }

    public void setRTS(boolean flag) {
        if (this.fd <= 0) {
            return;
        }
        this.setRTS0(this.fd, flag);
    }

    public boolean isRTS() {
        return this.fd > 0 && this.isRTS0(this.fd);
    }

    public boolean isCTS() {
        return this.fd > 0 && this.isCTS0(this.fd);
    }

    public boolean isDSR() {
        return this.fd > 0 && this.isDSR0(this.fd);
    }

    public boolean isRI() {
        return this.fd > 0 && this.isRI0(this.fd);
    }

    public boolean isCD() {
        return this.fd > 0 && this.isCD0(this.fd);
    }

    public void doResetPort() {
        if (!this.getEnablePortResetOnError()) {
            LOG.info("resetPort is disabled on " + this.getOsPortName());
            return;
        }
        LOG.info("resetPort invocation on " + this.getOsPortName());
        int resetResult = this.resetSerialDriver0(this.fd);
        if (resetResult == 0) {
            this.setSerialPortParams0(this.fd, this.baudRate.getOrdinal(), this.dataBits.getOrdinal(), this.stopBits.getOrdinal(), this.parity.getOrdinal());
            LOG.info("resetPort invocation on " + this.getOsPortName() + " success");
        }
    }

    private native int open0(String var1);

    private native int available0(int var1);

    private native void close0(int var1);

    private native int read0(int var1, int var2);

    private native int read0(int var1, int var2, int var3, byte[] var4, int var5, int var6);

    private native int write0(int var1, int var2);

    private native int write0(int var1, byte[] var2, int var3, int var4);

    private native void flush0(int var1);

    private native void setSerialPortParams0(int var1, int var2, int var3, int var4, int var5);

    private native boolean isCD0(int var1);

    private native boolean isCTS0(int var1);

    private native boolean isDSR0(int var1);

    private native boolean isDTR0(int var1);

    private native boolean isRI0(int var1);

    private native boolean isRTS0(int var1);

    private native void setFlowControlMode0(int var1, int var2);

    private native void setRTS0(int var1, boolean var2);

    private native void setDTR0(int var1, boolean var2);

    private native void sendBreak0(int var1, int var2);

    private native int resetSerialDriver0(int var1);

    class SerialOutputStream
    extends OutputStream {
        boolean closed = false;

        SerialOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Output stream has been closed.");
            }
            int rc = BSerialPortQnx.this.write0(BSerialPortQnx.this.fd, b);
            if (rc != 0) {
                BSerialPort.LOG.warning("Failed to write byte to serial device " + BSerialPortQnx.this.getOsPortName() + " (write failed): errno = " + rc);
                if (rc == 11) {
                    int resetResult;
                    if (BSerialPortQnx.this.getEnablePortResetOnError() && (resetResult = BSerialPortQnx.this.resetSerialDriver0(BSerialPortQnx.this.fd)) == 0) {
                        BSerialPortQnx.this.setSerialPortParams0(BSerialPortQnx.this.fd, BSerialPortQnx.this.baudRate.getOrdinal(), BSerialPortQnx.this.dataBits.getOrdinal(), BSerialPortQnx.this.stopBits.getOrdinal(), BSerialPortQnx.this.parity.getOrdinal());
                        BSerialPort.LOG.warning("serial device " + BSerialPortQnx.this.getOsPortName() + " was reset in response to EAGAIN");
                    }
                } else {
                    throw new IOException("Failed to write byte to serial device " + BSerialPortQnx.this.getOsPortName() + " (write failed): errno = " + rc);
                }
            }
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int offset, int length) throws IOException {
            if (this.closed) {
                throw new IOException("Output stream has been closed.");
            }
            Objects.requireNonNull(bytes, "Write buffer can not be null");
            if (offset < 0 || length < 0) {
                throw new IOException("Write offset (" + offset + ") or length (" + length + ") less than zero");
            }
            if (offset + length > bytes.length) {
                throw new IOException("Write offset (" + offset + ") + length (" + length + ") exceeds array length (" + bytes.length + ")");
            }
            int rc = BSerialPortQnx.this.write0(BSerialPortQnx.this.fd, bytes, offset, length);
            if (rc != 0) {
                BSerialPort.LOG.warning("Failed to write bytes to serial device " + BSerialPortQnx.this.getOsPortName() + " (write failed): errno = " + rc);
                if (rc == 11) {
                    int resetResult;
                    if (BSerialPortQnx.this.getEnablePortResetOnError() && (resetResult = BSerialPortQnx.this.resetSerialDriver0(BSerialPortQnx.this.fd)) == 0) {
                        BSerialPortQnx.this.setSerialPortParams0(BSerialPortQnx.this.fd, BSerialPortQnx.this.baudRate.getOrdinal(), BSerialPortQnx.this.dataBits.getOrdinal(), BSerialPortQnx.this.stopBits.getOrdinal(), BSerialPortQnx.this.parity.getOrdinal());
                        BSerialPort.LOG.warning("serial device " + BSerialPortQnx.this.getOsPortName() + " was reset in response to EAGAIN");
                    }
                } else if (rc != -1) {
                    throw new IOException("Failed to write bytes to serial device " + BSerialPortQnx.this.getOsPortName() + " (write failed): errno = " + rc);
                }
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Output stream has been closed.");
            }
            BSerialPortQnx.this.flush0(BSerialPortQnx.this.fd);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    class SerialInputStream
    extends InputStream {
        boolean closed = false;

        SerialInputStream() {
        }

        @Override
        public int available() throws IOException {
            if (this.closed) {
                throw new IOException("Input stream has been closed.");
            }
            int bytes = BSerialPortQnx.this.available0(BSerialPortQnx.this.fd);
            if (bytes < 0) {
                throw new IOException("Unable to read available bytes");
            }
            return bytes;
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("Input stream has been closed.");
            }
            return BSerialPortQnx.this.read0(BSerialPortQnx.this.fd, BSerialPortQnx.this.rcvTimeout);
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            return this.read(bytes, 0, bytes.length);
        }

        @Override
        public int read(byte[] bytes, int offset, int length) throws IOException {
            if (this.closed) {
                throw new IOException("Input stream has been closed.");
            }
            Objects.requireNonNull(bytes, "Read buffer can not be null");
            if (offset < 0 || length < 0) {
                throw new IOException("Read offset (" + offset + ") or length (" + length + ") less than zero");
            }
            if (offset + length > bytes.length) {
                throw new IOException("Read offset (" + offset + ") + length (" + length + ") exceeds array length (" + bytes.length + ")");
            }
            return BSerialPortQnx.this.read0(BSerialPortQnx.this.fd, BSerialPortQnx.this.rcvTimeout, BSerialPortQnx.this.rcvThreshold, bytes, offset, length);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

