/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.comm;

import com.tridium.andoverAC256.BAndoverNetwork;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverReceivedMessage;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.ReceivedMessage;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;

public class AndoverCommReceiver
extends CommReceiver
implements AndoverMessageConst {
    private ByteBuffer rcv = new ByteBuffer();
    private int state;
    private int lastState;
    private int unknownCharCount = 0;
    private BAndoverNetwork network;

    public AndoverCommReceiver(BAndoverNetwork net) {
        this.network = net;
        this.state = 0;
    }

    public void setDriverState(int newstate) {
        this.state = newstate;
        if (this.state != this.lastState) {
            this.network.getLog().trace("rx setDriverState from " + rxstates[this.lastState] + " to " + rxstates[this.state]);
        }
        this.lastState = this.state;
        if (this.state == 3) {
            this.unknownCharCount = 0;
        }
    }

    public int getDriverState() {
        return this.state;
    }

    protected ReceivedMessage receive() throws Exception {
        boolean done = false;
        this.rcv.reset();
        while (!done) {
            int charIn = this.getInputStream().read();
            boolean newChar = charIn != -1;
            charIn &= 0xFF;
            if (!newChar) continue;
            byte b = (byte)(charIn & 0xFF);
            switch (this.state) {
                case 1: {
                    this.rcv.write((int)b);
                    if (charIn != 62) break;
                    done = true;
                    break;
                }
                case 2: {
                    this.rcv.write((int)b);
                    if (charIn != 62 && charIn != 63) break;
                    done = true;
                    break;
                }
                case 4: {
                    if (charIn != 17) break;
                    this.network.fireTerminalUpdated((BValue)BString.make((String)"Received RELOAD_RUN"));
                    this.state = 3;
                    this.network.getLog().trace("rx driver change from " + rxstates[this.lastState] + " to " + rxstates[this.state]);
                    this.lastState = this.state;
                    this.rcv.write((int)b);
                    done = true;
                    break;
                }
                case 3: {
                    if (charIn == 19) {
                        this.network.fireTerminalUpdated((BValue)BString.make((String)"Received RELOAD_PAUSE"));
                        this.state = 4;
                        this.network.getLog().trace("rx driver change from " + rxstates[this.lastState] + " to " + rxstates[this.state]);
                        this.lastState = this.state;
                        this.rcv.write((int)b);
                        done = true;
                        break;
                    }
                    if (charIn == 10) {
                        this.rcv.write((int)b);
                        done = true;
                        break;
                    }
                    ++this.unknownCharCount;
                    if (this.unknownCharCount < 10) {
                        this.network.fireTerminalUpdated((BValue)BString.make((String)("WARNING: received illegal character during restore:" + TextUtil.byteToHexString((int)b) + "\n")));
                    }
                    this.rcv.write((int)b);
                    break;
                }
                case 7: {
                    if (charIn != 10) {
                        this.rcv.write((int)b);
                    }
                    done = true;
                }
            }
        }
        ((BAndoverNetwork)this.getComm().getNetwork()).fireTerminalUpdated((BValue)BString.make((String)new String(this.rcv.toByteArray())));
        AndoverReceivedMessage msg = this.state == 7 ? new AndoverReceivedMessage(this.rcv.toByteArray(), true) : new AndoverReceivedMessage(this.rcv.toByteArray());
        if (this.state == 3 || this.state == 4 || this.state == 7) {
            msg.setUnsolicited(true);
        }
        return msg;
    }
}

