/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxMonnitDriver.ui;

import com.lynxspring.onyxxMonnitDriver.BOnyxxMonnitDevice;
import com.tridium.ui.theme.Theme;
import java.util.HashMap;
import javax.baja.driver.BDeviceFolder;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableCellRenderer;
import javax.baja.workbench.mgr.MgrColumn;

public class MonnitRssiColumn
extends MgrColumn {
    static final BImage defaultIcon = BImage.make((String)"module://icons/x16/object.png");
    TableCellRenderer renderer = new CellRenderer();
    BImage rssiIcon;
    double prefWidth;

    public MonnitRssiColumn(BOnyxxMonnitDevice dev) {
        this(dev, 0);
    }

    public MonnitRssiColumn(BOnyxxMonnitDevice dev, int flags) {
        super("Signal Strength", flags);
        dev.lease();
        this.rssiIcon = this.getRssiImage(dev.getSignalStrength());
        this.prefWidth = 28.0;
    }

    private BImage getRssiImage(int rssi) {
        BImage rssiImage = BImage.make((String)"module://icons/x16/zeroBars.png");
        switch (rssi) {
            case 1: {
                rssiImage = BImage.make((String)"module://icons/x16/oneBar.png");
                break;
            }
            case 2: {
                rssiImage = BImage.make((String)"module://icons/x16/twoBars.png");
                break;
            }
            case 3: {
                rssiImage = BImage.make((String)"module://icons/x16/threeBars.png");
                break;
            }
            case 4: {
                rssiImage = BImage.make((String)"module://icons/x16/fourBars.png");
                break;
            }
            case 5: {
                rssiImage = BImage.make((String)"module://icons/x16/fiveBars.png");
            }
        }
        return rssiImage;
    }

    public Object get(Object row) {
        return row;
    }

    public TableCellRenderer getCellRenderer() {
        return this.renderer;
    }

    class CellRenderer
    extends ComponentTableCellRenderer {
        HashMap cache = new HashMap();

        CellRenderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (cell.value instanceof BDeviceFolder) {
                return Theme.table().getGridBrush();
            }
            return super.getBackground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            return MonnitRssiColumn.this.prefWidth;
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            this.paintCellBackground(g, cell);
            if (cell.value instanceof BDeviceFolder) {
                return;
            }
            BImage image = MonnitRssiColumn.this.rssiIcon;
            if (cell.value instanceof BOnyxxMonnitDevice) {
                image = MonnitRssiColumn.this.getRssiImage(((BOnyxxMonnitDevice)cell.value).getSignalStrength());
            }
            g.drawImage(image, 24.0, (cell.height - 16.0) / 2.0);
        }

        protected BComponentTable getComponentTable() {
            return MonnitRssiColumn.this.getManager().getModel().getTable();
        }
    }
}

