/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.ui;

import com.lynxspring.onyxxDriver.conv.BTabularThermistorConversion;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.ord.BFileOrdChooser;
import java.io.InputStream;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.file.types.text.BXmlFile;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.Position;
import javax.baja.util.Lexicon;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;
import javax.baja.xml.XWriter;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="setModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BOnyxxTabularThermistorDialog
extends BDialog {
    public static final Action okButtonPressed = BOnyxxTabularThermistorDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action cancelButtonPressed = BOnyxxTabularThermistorDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action setModified = BOnyxxTabularThermistorDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BOnyxxTabularThermistorDialog.class);
    static Lexicon onyxxLex = Lexicon.make((String)"onyxxDriver");
    static BImage editIcon = BImage.make((String)"module://icons/x32/edit.png");
    private BGridPane tablePane;
    private BButton okButton;
    private BTextField desc;
    private int nextIndex;
    private Array map = new Array();
    private BTabularThermistorConversion conversion = null;

    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    public void setModified(BWidgetEvent parameter) {
        this.invoke(setModified, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static final BTabularThermistorConversion show(BWidget owner, BTabularThermistorConversion src) {
        BOnyxxTabularThermistorDialog dialog = new BOnyxxTabularThermistorDialog(owner, src);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getConversion();
    }

    private BOnyxxTabularThermistorDialog(BWidget parent, BTabularThermistorConversion src) {
        super(parent, onyxxLex.get("tabularDialog.title"), true);
        BLabel descLabel = new BLabel(onyxxLex.get("tabularDialog.descriptionLabel"));
        this.desc = new BTextField("");
        this.desc.setText(src.getDescription());
        this.desc.getSelection().deselect();
        this.desc.moveCaretPosition(new Position(0, 0));
        this.linkTo(null, (BComponent)this.desc, (Slot)BTextField.textModified, (Slot)setModified);
        BGridPane descPane = new BGridPane(2);
        descPane.add(null, (BValue)descLabel);
        descPane.add(null, (BValue)this.desc);
        descPane.setHalign(BHalign.left);
        descPane.setStretchColumn(1);
        descPane.setColumnAlign(BHalign.fill);
        this.tablePane = new BGridPane(3);
        this.tablePane.setColumnAlign(BHalign.center);
        this.tablePane.setRowAlign(BValign.fill);
        this.tablePane.setValign(BValign.top);
        Array points = src.getPoints();
        this.buildTablePane(points);
        BButton addButton = new BButton((Command)new AddCmd());
        BButton resortButton = new BButton((Command)new ResortCmd());
        BButton deleteAllButton = new BButton((Command)new DeleteAllCmd());
        BButton importButton = new BButton((Command)new ImportCmd());
        BButton exportButton = new BButton((Command)new ExportCmd());
        this.linkTo(null, (BComponent)addButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)resortButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)deleteAllButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)importButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)exportButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        BGridPane addbuttonPane = new BGridPane(1);
        addbuttonPane.setUniformColumnWidth(true);
        addbuttonPane.setColumnAlign(BHalign.fill);
        addbuttonPane.setValign(BValign.top);
        addbuttonPane.add(null, (BValue)addButton);
        addbuttonPane.add(null, (BValue)resortButton);
        addbuttonPane.add(null, (BValue)deleteAllButton);
        addbuttonPane.add(null, (BValue)importButton);
        addbuttonPane.add(null, (BValue)exportButton);
        BGridPane okbuttonPane = new BGridPane(2);
        okbuttonPane.setColumnAlign(BHalign.fill);
        okbuttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(onyxxLex.get("tabularDialog.okButtonLabel"));
        okbuttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(false);
        BButton cancelButton = new BButton(onyxxLex.get("tabularDialog.cancelButtonLabel"));
        okbuttonPane.add(null, (BValue)cancelButton);
        this.linkTo("linkB", (BComponent)cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        BEdgePane outerPane = new BEdgePane();
        outerPane.setTop((BWidget)new BBorderPane((BWidget)descPane, 7.0, 7.0, 0.0, 7.0));
        BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.tablePane, 7.0, 7.0, 7.0, 7.0));
        scrollPane.setVpolicy(BScrollBarPolicy.always);
        scrollPane.setHpolicy(BScrollBarPolicy.never);
        scrollPane.setViewportBackground(Theme.widget().getControlBackground());
        BConstrainedPane constrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)scrollPane, BBorder.inset, BInsets.DEFAULT));
        constrainedPane.setFixedSize(205.0, 250.0);
        outerPane.setCenter((BWidget)new BBorderPane((BWidget)constrainedPane, 7.0, 7.0, 7.0, 7.0));
        outerPane.setRight((BWidget)new BBorderPane((BWidget)addbuttonPane, 7.0, 7.0, 0.0, 0.0));
        outerPane.setBottom((BWidget)new BBorderPane((BWidget)okbuttonPane, 0.0, 0.0, 7.0, 0.0));
        this.setContent((BWidget)outerPane);
        this.setDefaultButton(this.okButton);
    }

    private void buildTablePane(Array points) {
        this.tablePane.removeAll();
        this.map.clear();
        this.nextIndex = 0;
        int size = points.size();
        if (size > 0) {
            this.tablePane.add("xh", (BValue)new BLabel(onyxxLex.get("tabularDialog.ohmsColumnLabel")));
            this.tablePane.add("yh", (BValue)new BLabel(onyxxLex.get("tabularDialog.celsiusColumnLabel")));
            this.tablePane.add("dh", (BValue)new BNullWidget());
            for (int i = 0; i < size; ++i) {
                BTextField yfield;
                BTextField xfield;
                Object pnt;
                if (points.get(i) instanceof BTabularThermistorConversion.XYPoint) {
                    pnt = (BTabularThermistorConversion.XYPoint)points.get(i);
                    xfield = new BTextField(pnt.x() + "", 10);
                    yfield = new BTextField(pnt.y() + "", 10);
                } else {
                    pnt = (TextXYPoint)points.get(i);
                    xfield = new BTextField(((TextXYPoint)pnt).x(), 10);
                    yfield = new BTextField(((TextXYPoint)pnt).y(), 10);
                }
                DeleteCmd deleteCmd = new DeleteCmd(i);
                BButton dfield = new BButton((Command)deleteCmd);
                this.linkTo(null, (BComponent)dfield, (Slot)BButton.actionPerformed, (Slot)setModified);
                dfield.setButtonStyle(BButtonStyle.toolBar);
                xfield.setExpandHeight(true);
                yfield.setExpandHeight(true);
                this.tablePane.add("x" + i, (BValue)xfield);
                this.tablePane.add("y" + i, (BValue)yfield);
                this.tablePane.add("d" + i, (BValue)dfield);
                this.linkTo(null, (BComponent)xfield, (Slot)BTextField.textModified, (Slot)setModified);
                this.linkTo(null, (BComponent)yfield, (Slot)BTextField.textModified, (Slot)setModified);
                this.linkTo(null, (BComponent)dfield, (Slot)BButton.actionPerformed, (Slot)setModified);
                this.map.add((Object)new Integer(i));
            }
            this.nextIndex = size;
        }
    }

    public BTabularThermistorConversion getConversion() {
        return this.conversion;
    }

    public void doOkButtonPressed(BWidgetEvent event) {
        if (this.map.size() < 2) {
            BDialog.error((BWidget)this, (Object)onyxxLex.get("tabularDialog.twoPointsError"));
            return;
        }
        BTabularThermistorConversion conv = BTabularThermistorConversion.make();
        for (int i = 0; i < this.map.size(); ++i) {
            double y;
            double x;
            String xname = "x" + this.map.get(i);
            String yname = "y" + this.map.get(i);
            BTextField xfield = (BTextField)this.tablePane.get(xname);
            BTextField yfield = (BTextField)this.tablePane.get(yname);
            try {
                x = Double.parseDouble(xfield.getText());
                y = Double.parseDouble(yfield.getText());
            }
            catch (NumberFormatException n) {
                BDialog.error((BWidget)this, (Object)onyxxLex.get("tabularDialog.invalidFormatError"));
                return;
            }
            conv.add(x, y);
        }
        conv.regen();
        conv.setDescription(this.desc.getText());
        this.conversion = conv;
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.close();
    }

    public void doSetModified(BWidgetEvent event) {
        this.okButton.setEnabled(true);
    }

    class TextXYPoint
    implements Comparable {
        String x;
        String y;

        public TextXYPoint(String x, String y) {
            this.x = x;
            this.y = y;
        }

        public int compareTo(Object o) {
            if (o instanceof TextXYPoint) {
                TextXYPoint src = (TextXYPoint)o;
                try {
                    double srcxv = Double.parseDouble(src.x);
                    double xv = Double.parseDouble(this.x);
                    if (srcxv > xv) {
                        return -1;
                    }
                    if (srcxv < xv) {
                        return 1;
                    }
                    return 0;
                }
                catch (NumberFormatException e) {
                    return 1;
                }
            }
            throw new ClassCastException("can't compare TextXYPoint");
        }

        public String toString() {
            return "{x=" + this.x + ",y=" + this.y + "}";
        }

        public String x() {
            return this.x;
        }

        public String y() {
            return this.y;
        }
    }

    class ExportCmd
    extends Command {
        public ExportCmd() {
            super((BWidget)BOnyxxTabularThermistorDialog.this, Lexicon.make((String)"onyxxDriver"), "tabularThermistor.exportButton");
        }

        public CommandArtifact doInvoke() {
            BFacets facets = BFacets.make((String)"save", (BIDataValue)BBoolean.TRUE);
            String defaultName = "thermistor_table.xml";
            try {
                defaultName = BOnyxxTabularThermistorDialog.this.desc.getText();
                defaultName = defaultName.replaceAll("\\s+", "_");
                defaultName = defaultName.replaceAll("[^a-zA-Z0-9_]+", "");
                defaultName = defaultName.toLowerCase();
                if (defaultName.trim().length() == 0) {
                    defaultName = "thermistor_table";
                }
                defaultName = defaultName + ".xml";
            }
            catch (Exception exception) {
                // empty catch block
            }
            facets = BFacets.make((BFacets)facets, (String)"defaultFileName", (BIDataValue)BString.make((String)defaultName));
            BFileOrdChooser chooser = new BFileOrdChooser();
            chooser.addFilter((IFileFilter)new ExtFileFilter("Xml Files (*.xml)", "xml"));
            BOrd ord = chooser.openChooser((BWidget)BOnyxxTabularThermistorDialog.this, (BObject)BOnyxxTabularThermistorDialog.this, BOrd.make((String)"file:^"), (Context)facets);
            if (ord == null) {
                return null;
            }
            try {
                this.saveFile(ord);
            }
            catch (Exception e) {
                BDialog.error((BWidget)BOnyxxTabularThermistorDialog.this, (String)BDialog.TITLE_ERROR, (Object)onyxxLex.get("tabularDialog.exportError"), (Throwable)e);
            }
            return null;
        }

        private void saveFile(BOrd fileOrd) throws Exception {
            if (BOnyxxTabularThermistorDialog.this.map.size() < 2) {
                BDialog.error((BWidget)BOnyxxTabularThermistorDialog.this, (Object)onyxxLex.get("tabularDialog.twoPointsError"));
                return;
            }
            XElem xroot = new XElem("thermistor");
            XElem xdesc = new XElem("description");
            xdesc.addContent((XContent)new XText(BOnyxxTabularThermistorDialog.this.desc.getText()));
            xroot.addContent((XContent)xdesc);
            XElem xtable = new XElem("table");
            xroot.addContent((XContent)xtable);
            for (int i = 0; i < BOnyxxTabularThermistorDialog.this.map.size(); ++i) {
                String xname = "x" + BOnyxxTabularThermistorDialog.this.map.get(i);
                String yname = "y" + BOnyxxTabularThermistorDialog.this.map.get(i);
                BTextField xfield = (BTextField)BOnyxxTabularThermistorDialog.this.tablePane.get(xname);
                BTextField yfield = (BTextField)BOnyxxTabularThermistorDialog.this.tablePane.get(yname);
                try {
                    double x = Double.parseDouble(xfield.getText());
                    double y = Double.parseDouble(yfield.getText());
                    XElem point = new XElem("point");
                    point.setAttr("ohms", xfield.getText());
                    point.setAttr("celsius", yfield.getText());
                    xtable.addContent((XContent)point);
                    continue;
                }
                catch (NumberFormatException n) {
                    BDialog.error((BWidget)BOnyxxTabularThermistorDialog.this, (Object)onyxxLex.get("tabularDialog.invalidFormatError"));
                    return;
                }
            }
            try {
                BIFile file = (BIFile)fileOrd.get();
                XWriter xwriter = new XWriter(file.getOutputStream());
                xwriter.prolog();
                xroot.write(xwriter);
                xwriter.close();
            }
            catch (Exception e) {
                BDialog.error((BWidget)BOnyxxTabularThermistorDialog.this, (String)onyxxLex.get("tabularDialog.writingError"), (Object)e);
                return;
            }
        }
    }

    class ImportCmd
    extends Command {
        public ImportCmd() {
            super((BWidget)BOnyxxTabularThermistorDialog.this, Lexicon.make((String)"onyxxDriver"), "tabularThermistor.importButton");
        }

        public CommandArtifact doInvoke() {
            BFileOrdChooser chooser = new BFileOrdChooser();
            chooser.addFilter((IFileFilter)new ExtFileFilter("Xml Files (*.xml)", "xml"));
            BOrd ord = chooser.openChooser((BWidget)BOnyxxTabularThermistorDialog.this, (BObject)BOnyxxTabularThermistorDialog.this, BOrd.make((String)"file:^"), null);
            if (ord == null) {
                return null;
            }
            if (BDialog.confirm((BWidget)BOnyxxTabularThermistorDialog.this, (String)BDialog.TITLE_CONFIRM, (Object)onyxxLex.get("tabularDialog.confirmMessage")) == 8) {
                return null;
            }
            try {
                this.loadFile(ord);
            }
            catch (Exception e) {
                BDialog.error((BWidget)BOnyxxTabularThermistorDialog.this, (String)BDialog.TITLE_ERROR, (Object)onyxxLex.get("tabularDialog.importError"), (Throwable)e);
            }
            return null;
        }

        private void loadFile(BOrd fileOrd) throws Exception {
            BTabularThermistorConversion conv = BTabularThermistorConversion.make();
            double[] ohms = null;
            double[] celsius = null;
            InputStream stream = null;
            try {
                BXmlFile file = (BXmlFile)fileOrd.get();
                if (file == null) {
                    throw new Exception("File not defined.");
                }
                stream = file.getInputStream();
                XParser parser = XParser.make((InputStream)stream);
                XElem thermistorElem = parser.parse();
                XElem descriptionElem = thermistorElem.elem("description");
                String description = descriptionElem.string();
                if (description != null) {
                    conv.setDescription(description);
                } else {
                    conv.setDescription("");
                }
                XElem tableElem = thermistorElem.elem("table");
                if (tableElem == null) {
                    throw new Exception("Improperly formatted file: No 'table' elemnent.");
                }
                XElem[] pointElems = tableElem.elems("point");
                if (pointElems.length < 2) {
                    throw new Exception("Must have at least two points.");
                }
                ohms = new double[pointElems.length];
                celsius = new double[pointElems.length];
                for (int i = 0; i < pointElems.length; ++i) {
                    ohms[i] = pointElems[i].getd("ohms");
                    celsius[i] = pointElems[i].getd("celsius");
                    conv.add(ohms[i], celsius[i]);
                }
            }
            catch (Exception e) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new Exception(e.getMessage());
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            BOnyxxTabularThermistorDialog.this.desc.setText(conv.getDescription());
            BOnyxxTabularThermistorDialog.this.desc.getSelection().deselect();
            BOnyxxTabularThermistorDialog.this.desc.moveCaretPosition(new Position(0, 0));
            conv.regen();
            BOnyxxTabularThermistorDialog.this.buildTablePane(conv.getPoints());
        }
    }

    class DeleteAllCmd
    extends Command {
        public DeleteAllCmd() {
            super((BWidget)BOnyxxTabularThermistorDialog.this, Lexicon.make((String)"onyxxDriver"), "tabularThermistor.deleteAllButton");
        }

        public CommandArtifact doInvoke() {
            if (BOnyxxTabularThermistorDialog.this.map.size() == 0) {
                return null;
            }
            for (int i = 0; i < BOnyxxTabularThermistorDialog.this.map.size(); ++i) {
                String xname = "x" + BOnyxxTabularThermistorDialog.this.map.get(i);
                String yname = "y" + BOnyxxTabularThermistorDialog.this.map.get(i);
                String dname = "d" + BOnyxxTabularThermistorDialog.this.map.get(i);
                BOnyxxTabularThermistorDialog.this.tablePane.remove(xname);
                BOnyxxTabularThermistorDialog.this.tablePane.remove(yname);
                BOnyxxTabularThermistorDialog.this.tablePane.remove(dname);
            }
            BOnyxxTabularThermistorDialog.this.map.clear();
            BOnyxxTabularThermistorDialog.this.tablePane.remove("xh");
            BOnyxxTabularThermistorDialog.this.tablePane.remove("yh");
            BOnyxxTabularThermistorDialog.this.tablePane.remove("dh");
            BOnyxxTabularThermistorDialog.this.nextIndex = 0;
            BOnyxxTabularThermistorDialog.this.desc.setText("");
            BOnyxxTabularThermistorDialog.this.desc.getSelection().deselect();
            BOnyxxTabularThermistorDialog.this.desc.moveCaretPosition(new Position(0, 0));
            return null;
        }
    }

    class ResortCmd
    extends Command {
        public ResortCmd() {
            super((BWidget)BOnyxxTabularThermistorDialog.this, Lexicon.make((String)"onyxxDriver"), "tabularThermistor.resortButton");
        }

        public CommandArtifact doInvoke() {
            Array array = new Array(TextXYPoint.class);
            for (int i = 0; i < BOnyxxTabularThermistorDialog.this.map.size(); ++i) {
                String xname = "x" + BOnyxxTabularThermistorDialog.this.map.get(i);
                String yname = "y" + BOnyxxTabularThermistorDialog.this.map.get(i);
                BTextField xfield = (BTextField)BOnyxxTabularThermistorDialog.this.tablePane.get(xname);
                BTextField yfield = (BTextField)BOnyxxTabularThermistorDialog.this.tablePane.get(yname);
                TextXYPoint pnt = new TextXYPoint(xfield.getText(), yfield.getText());
                array.add((Object)pnt);
            }
            array = array.sort();
            BOnyxxTabularThermistorDialog.this.buildTablePane(array);
            return null;
        }
    }

    class AddCmd
    extends Command {
        public AddCmd() {
            super((BWidget)BOnyxxTabularThermistorDialog.this, Lexicon.make((String)"onyxxDriver"), "tabularThermistor.addButton");
        }

        public CommandArtifact doInvoke() {
            BTextField xfield = new BTextField("", 10);
            BTextField yfield = new BTextField("", 10);
            DeleteCmd deleteCmd = new DeleteCmd(BOnyxxTabularThermistorDialog.this.nextIndex);
            BButton dfield = new BButton((Command)deleteCmd);
            dfield.setButtonStyle(BButtonStyle.toolBar);
            BOnyxxTabularThermistorDialog.this.linkTo(null, (BComponent)dfield, (Slot)BButton.actionPerformed, (Slot)setModified);
            if (BOnyxxTabularThermistorDialog.this.map.size() == 0) {
                BOnyxxTabularThermistorDialog.this.tablePane.add("xh", (BValue)new BLabel(onyxxLex.get("tabularDialog.ohmsColumnLabel")));
                BOnyxxTabularThermistorDialog.this.tablePane.add("yh", (BValue)new BLabel(onyxxLex.get("tabularDialog.celsiusColumnLabel")));
                BOnyxxTabularThermistorDialog.this.tablePane.add("dh", (BValue)new BNullWidget());
            }
            xfield.setExpandHeight(true);
            yfield.setExpandHeight(true);
            BOnyxxTabularThermistorDialog.this.tablePane.add("x" + BOnyxxTabularThermistorDialog.this.nextIndex, (BValue)xfield);
            BOnyxxTabularThermistorDialog.this.tablePane.add("y" + BOnyxxTabularThermistorDialog.this.nextIndex, (BValue)yfield);
            BOnyxxTabularThermistorDialog.this.tablePane.add("d" + BOnyxxTabularThermistorDialog.this.nextIndex, (BValue)dfield);
            BOnyxxTabularThermistorDialog.this.linkTo(null, (BComponent)xfield, (Slot)BTextField.textModified, (Slot)setModified);
            BOnyxxTabularThermistorDialog.this.linkTo(null, (BComponent)yfield, (Slot)BTextField.textModified, (Slot)setModified);
            BOnyxxTabularThermistorDialog.this.linkTo(null, (BComponent)dfield, (Slot)BButton.actionPerformed, (Slot)setModified);
            BOnyxxTabularThermistorDialog.this.map.add((Object)new Integer(BOnyxxTabularThermistorDialog.this.nextIndex));
            BOnyxxTabularThermistorDialog.this.nextIndex++;
            return null;
        }
    }

    class DeleteCmd
    extends Command {
        private int index;

        public DeleteCmd(int index) {
            super((BWidget)BOnyxxTabularThermistorDialog.this, Lexicon.make((String)"onyxxDriver"), "tabularThermistor.deleteButton");
            this.index = index;
        }

        public CommandArtifact doInvoke() {
            BOnyxxTabularThermistorDialog.this.tablePane.remove("x" + this.index);
            BOnyxxTabularThermistorDialog.this.tablePane.remove("y" + this.index);
            BOnyxxTabularThermistorDialog.this.tablePane.remove("d" + this.index);
            BOnyxxTabularThermistorDialog.this.map.remove((Object)new Integer(this.index));
            if (BOnyxxTabularThermistorDialog.this.map.size() == 0) {
                BOnyxxTabularThermistorDialog.this.tablePane.remove("xh");
                BOnyxxTabularThermistorDialog.this.tablePane.remove("yh");
                BOnyxxTabularThermistorDialog.this.tablePane.remove("dh");
            }
            return null;
        }
    }
}

