/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.ui;

import com.lynxspring.onyxxDriver.conv.BThermistorType3Conversion;
import com.lynxspring.onyxxDriver.enums.BIoTypeEnum;
import com.lynxspring.onyxxDriver.enums.BPointTypeEnum;
import com.lynxspring.onyxxDriver.learn.BOnyxxPointEntry;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BLinearCalibrationExt;
import com.lynxspring.onyxxDriver.point.BOnyxxBooleanInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxBooleanOutputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxCounterInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxCurrentInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxDigitalBooleanInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxInternalTemperatureInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxInternalVoltageRegulator15VInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxInternalVoltageRegulator3_3VInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxInternalVoltageRegulator5VInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxPointDeviceExt;
import com.lynxspring.onyxxDriver.point.BOnyxxProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxResistiveInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxVavPressureInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxVoltageInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxVoltageOutputProxyExt;
import java.util.ArrayList;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"onyxxDriver:OnyxxPointDeviceExt", "onyxxDriver:OnyxxPointFolder"})})
public class BOnyxxDriverPointManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType(BOnyxxDriverPointManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(1);
    MgrColumn colAddress = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BOnyxxProxyExt.portAddress}, 1);
    MgrColumn collPollFrequency = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BOnyxxProxyExt.pollFrequency}, 1);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BOnyxxProxyExt.conversion}, 1);
    MgrColumn colFacets = new MgrColumn.Prop(BControlPoint.facets, 1);
    MgrColumn colPointType = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BOnyxxProxyExt.pointType}, 5);
    MgrColumn colString = new MgrColumn.ToString(lex.getText("pointManager.out"), 0);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colAddress, this.collPollFrequency, this.colConversion, this.colPointType, this.colString, this.colFacets};
    private BOnyxxPointDeviceExt deviceExt = null;
    private BOnyxxPointEntry[] lastLearn = null;
    static Lexicon lex = Lexicon.make(BOnyxxDriverPointManager.class);
    static BImage floatIcon = BImage.make((String)"module://icons/x16/statusNumeric.png");
    static BImage booleanIcon = BImage.make((String)"module://icons/x16/statusBoolean.png");
    static BImage mixIcon = BImage.make((String)"module://icons/x16/statusMixed.png");

    public Type getType() {
        return TYPE;
    }

    protected void init() {
        super.init();
        try {
            this.deviceExt = (BOnyxxPointDeviceExt)((BIPointFolder)this.getCurrentValue()).getDeviceExt();
            if (this.getCurrentValue() != this.deviceExt) {
                this.registerForComponentEvents((BComponent)this.deviceExt);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected MgrModel makeModel() {
        return new Model();
    }

    protected MgrController makeController() {
        return new Controller();
    }

    protected MgrLearn makeLearn() {
        return new Learn();
    }

    private final void updateDiscoveryRows(BComponent paramBComponent) {
        Object[] arrayOfBOnyxxPointEntry = (BOnyxxPointEntry[])paramBComponent.getChildren(BOnyxxPointEntry.class);
        this.lastLearn = arrayOfBOnyxxPointEntry;
        for (int i = 0; i < arrayOfBOnyxxPointEntry.length; ++i) {
            arrayOfBOnyxxPointEntry[i].loadSlots();
        }
        this.getLearn().updateRoots(arrayOfBOnyxxPointEntry);
    }

    static /* synthetic */ BOnyxxPointEntry[] access$202(BOnyxxDriverPointManager x0, BOnyxxPointEntry[] x1) {
        x0.lastLearn = x1;
        return x1;
    }

    static class State
    extends MgrState {
        BOnyxxPointEntry[] lastLearn = null;

        State() {
        }

        protected void saveForOrd(BAbstractManager paramBAbstractManager) {
            super.saveForOrd(paramBAbstractManager);
            BOnyxxDriverPointManager localBOnyxxPointManager = (BOnyxxDriverPointManager)paramBAbstractManager;
            this.lastLearn = localBOnyxxPointManager.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager paramBAbstractManager) {
            super.restoreForOrd(paramBAbstractManager);
            BOnyxxDriverPointManager localBOnyxxPointManager = (BOnyxxDriverPointManager)paramBAbstractManager;
            if (this.lastLearn != null) {
                BOnyxxDriverPointManager.access$202(localBOnyxxPointManager, this.lastLearn);
                localBOnyxxPointManager.getLearn().updateRoots((Object[])this.lastLearn);
            }
        }
    }

    class Learn
    extends MgrLearn {
        Learn() {
            super((BAbstractManager)BOnyxxDriverPointManager.this);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BOnyxxPointEntry.pointType, 0), new MgrColumn.Prop(BOnyxxPointEntry.address, 0)};
        }

        public void jobComplete(BJob paramBJob) {
            super.jobComplete(paramBJob);
            BOnyxxDriverPointManager.this.updateDiscoveryRows((BComponent)paramBJob);
        }

        public BImage getIcon(Object paramObject) {
            BOnyxxPointEntry pointEntry = (BOnyxxPointEntry)paramObject;
            if (pointEntry.getPointType() == BIoTypeEnum.universalInput) {
                return mixIcon;
            }
            if (pointEntry.getPointType() == BIoTypeEnum.analogOutput || pointEntry.getPointType() == BIoTypeEnum.pressureInput || pointEntry.getPointType() == BIoTypeEnum.internalTemperatureInput || pointEntry.getPointType() == BIoTypeEnum.internalVoltageRegulator3_3VInput || pointEntry.getPointType() == BIoTypeEnum.internalVoltageRegulator5VInput || pointEntry.getPointType() == BIoTypeEnum.internalVoltageRegulator15VInput || pointEntry.getPointType() == BIoTypeEnum.digitalInput) {
                return floatIcon;
            }
            return booleanIcon;
        }

        public MgrTypeInfo[] toTypes(Object paramObject) {
            ArrayList<OnyxxMgrTypeInfo> list = new ArrayList<OnyxxMgrTypeInfo>();
            BOnyxxPointEntry pointEntry = (BOnyxxPointEntry)paramObject;
            if (pointEntry.getPointType() == BIoTypeEnum.universalInput) {
                list.add(new OnyxxMgrTypeInfo(BOnyxxVoltageInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.voltageInput, "type.OnyxxVoltageInputProxyExtPoint"));
                list.add(new OnyxxMgrTypeInfo(BOnyxxResistiveInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.resistiveInput, "type.OnyxxResistiveInputProxyExtPoint"));
                list.add(new OnyxxMgrTypeInfo(BOnyxxResistiveInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), (BProxyConversion)BThermistorType3Conversion.DEFAULT, BPointTypeEnum.resistiveInput, "type.OnyxxThermistorInputProxyExtPoint"));
                list.add(new OnyxxMgrTypeInfo(BOnyxxCurrentInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.currentInput, "type.OnyxxCurrentInputProxyExtPoint"));
                list.add(new OnyxxMgrTypeInfo(BOnyxxCounterInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.resistivePulseInput, "type.OnyxxCounterInputProxyExtPoint"));
                list.add(new OnyxxMgrTypeInfo(BOnyxxBooleanInputProxyExt.TYPE.getTypeInfo(), BBooleanPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.booleanResistiveInput, "type.OnyxxBooleanInputResistiveProxyExtPoint"));
                list.add(new OnyxxMgrTypeInfo(BOnyxxBooleanInputProxyExt.TYPE.getTypeInfo(), BBooleanPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.booleanVoltageInput, "type.OnyxxBooleanInputVoltageProxyExtPoint"));
                list.add(new OnyxxMgrTypeInfo(BOnyxxBooleanInputProxyExt.TYPE.getTypeInfo(), BBooleanPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.booleanCurrentInput, "type.OnyxxBooleanInputCurrentProxyExtPoint"));
                list.add(new OnyxxMgrTypeInfo(BOnyxxDigitalBooleanInputProxyExt.TYPE.getTypeInfo(), BBooleanPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.digitalBooleanInput, "type.OnyxxDigitalBooleanInputProxyExtPoint"));
            } else if (pointEntry.getPointType() == BIoTypeEnum.analogOutput) {
                list.add(new OnyxxMgrTypeInfo(BOnyxxVoltageOutputProxyExt.TYPE.getTypeInfo(), BNumericWritable.TYPE.getTypeInfo(), null, BPointTypeEnum.voltageOutput, "type.OnyxxVoltageOutputProxyExtWritable"));
            } else if (pointEntry.getPointType() == BIoTypeEnum.booleanOutput) {
                list.add(new OnyxxMgrTypeInfo(BOnyxxBooleanOutputProxyExt.TYPE.getTypeInfo(), BBooleanWritable.TYPE.getTypeInfo(), null, BPointTypeEnum.booleanOutput, "type.OnyxxBooleanOutputProxyExtWritable"));
            } else if (pointEntry.getPointType() == BIoTypeEnum.pressureInput) {
                list.add(new OnyxxMgrTypeInfo(BOnyxxVavPressureInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.pressureInput, "type.OnyxxVavPressureInputProxyExtPoint"));
            } else if (pointEntry.getPointType() == BIoTypeEnum.internalTemperatureInput) {
                list.add(new OnyxxMgrTypeInfo(BOnyxxInternalTemperatureInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.internalTemperatureInput, "type.OnyxxInternalTemperatureInputProxyExtPoint"));
            } else if (pointEntry.getPointType() == BIoTypeEnum.internalVoltageRegulator3_3VInput) {
                list.add(new OnyxxMgrTypeInfo(BOnyxxInternalVoltageRegulator3_3VInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.internalVoltageRegulator3_3VInput, "type.OnyxxInternalVoltageRegulator3_3VInputProxyExtPoint"));
            } else if (pointEntry.getPointType() == BIoTypeEnum.internalVoltageRegulator5VInput) {
                list.add(new OnyxxMgrTypeInfo(BOnyxxInternalVoltageRegulator5VInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.internalVoltageRegulator5VInput, "type.OnyxxInternalVoltageRegulator5VInputProxyExtPoint"));
            } else if (pointEntry.getPointType() == BIoTypeEnum.internalVoltageRegulator15VInput) {
                list.add(new OnyxxMgrTypeInfo(BOnyxxInternalVoltageRegulator15VInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.internalVoltageRegulator15VInput, "type.OnyxxInternalVoltageRegulator15VInputProxyExtPoint"));
            } else {
                BOnyxxNetwork.LOG.error("did not find a valid point type: " + pointEntry.getPointType());
                return new MgrTypeInfo[0];
            }
            return list.toArray(new MgrTypeInfo[list.size()]);
        }

        public void toRow(Object paramObject, MgrEditRow paramMgrEditRow) {
            BOnyxxPointEntry pointEntry = (BOnyxxPointEntry)paramObject;
            BOnyxxProxyExt ext = (BOnyxxProxyExt)((BControlPoint)paramMgrEditRow.getTarget()).getProxyExt();
            paramMgrEditRow.setDefaultName(lex.getText("default." + pointEntry.getPointType().getTag() + "Name"));
            paramMgrEditRow.setCell(BOnyxxDriverPointManager.this.colAddress, (BValue)BInteger.make((int)pointEntry.getAddress()));
            paramMgrEditRow.setCell(BOnyxxDriverPointManager.this.colPointType, (BValue)ext.getPointType());
        }

        public boolean isExisting(Object paramObject, BComponent paramBComponent) {
            try {
                BOnyxxPointEntry pointEntry = (BOnyxxPointEntry)paramObject;
                return pointEntry.is(paramBComponent);
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    class Controller
    extends PointController {
        Controller() {
            super((BPointManager)BOnyxxDriverPointManager.this);
        }

        public MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newCommand, this.newFolder, this.allDescendants, this.edit, this.learnMode, this.discover, this.add, this.match};
        }

        public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand command) {
            return null;
        }

        public CommandArtifact doDiscover(Context paramContext) throws Exception {
            super.doDiscover(paramContext);
            BOnyxxDriverPointManager.this.getLearn().setJob(BOnyxxDriverPointManager.this.deviceExt.submitDiscoveryJob());
            return null;
        }
    }

    class OnyxxMgrTypeInfo
    extends MgrTypeInfo {
        private TypeInfo extType;
        private TypeInfo pntType;
        private String displayName;
        private BProxyConversion converter;
        private BPointTypeEnum typeEnum;

        OnyxxMgrTypeInfo(TypeInfo proxy, TypeInfo point, BProxyConversion conv, BPointTypeEnum typeEnum, String dis) {
            this.extType = proxy;
            this.pntType = point;
            this.converter = conv;
            this.typeEnum = typeEnum;
            this.displayName = lex.getText(dis);
            if (this.converter == null) {
                this.converter = BDefaultProxyConversion.DEFAULT;
            }
        }

        OnyxxMgrTypeInfo(BComponent point) {
            BOnyxxProxyExt proxy = (BOnyxxProxyExt)((BControlPoint)point).getProxyExt();
            this.pntType = point.getType().getTypeInfo();
            this.extType = proxy.getType().getTypeInfo();
            this.converter = proxy.getConversion();
            this.typeEnum = proxy.getPointType();
            this.displayName = this.converter instanceof BThermistorType3Conversion ? lex.getText("type.OnyxxThermistorInputProxyExtPoint") : (this.pntType.is(BIWritablePoint.TYPE) ? lex.getText("type." + this.extType.getTypeName() + "Writable") : lex.getText("type." + this.extType.getTypeName() + "Point"));
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public TypeInfo getPointTypeInfo() {
            return this.pntType;
        }

        public TypeInfo getExtTypeInfo() {
            return this.extType;
        }

        public BProxyConversion getConverter() {
            return this.converter;
        }

        public BImage getIcon() {
            return null;
        }

        public BComponent newInstance() {
            BControlPoint point = (BControlPoint)this.pntType.getInstance();
            BOnyxxProxyExt proxy = (BOnyxxProxyExt)this.extType.getInstance();
            proxy.setConversion(this.converter);
            proxy.setPointType(this.typeEnum);
            point.setProxyExt((BAbstractProxyExt)proxy);
            BFacets facets = BFacets.make((BFacets)point.getFacets(), (String)"precision", (BIDataValue)BInteger.make((int)2));
            if (this.converter instanceof BThermistorType3Conversion) {
                facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)BUnit.getUnit((String)"celsius"));
            } else {
                BIDataValue units = (BIDataValue)proxy.getDeviceFacets().get("units");
                if (units != null) {
                    facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)units);
                }
            }
            point.setFacets(facets);
            if (proxy instanceof BOnyxxVoltageInputProxyExt) {
                point.add("linearCalibration", (BValue)new BLinearCalibrationExt(BUnit.getUnit((String)"volt")), 0);
            }
            if (proxy instanceof BOnyxxResistiveInputProxyExt) {
                if (this.converter instanceof BThermistorType3Conversion) {
                    point.add("linearCalibration", (BValue)new BLinearCalibrationExt(BUnit.getUnit((String)"celsius")), 0);
                } else {
                    point.add("linearCalibration", (BValue)new BLinearCalibrationExt(BUnit.getUnit((String)"ohm")), 0);
                }
            }
            return point;
        }

        public boolean isMatchable(BComponent paramBComponent) {
            return paramBComponent.getType().is(this.getPointTypeInfo());
        }
    }

    class Model
    extends PointModel {
        Model() {
            super((BPointManager)BOnyxxDriverPointManager.this);
        }

        protected MgrColumn[] makeColumns() {
            return BOnyxxDriverPointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo typeInfo) {
            OnyxxMgrTypeInfo info = (OnyxxMgrTypeInfo)typeInfo;
            return (BControlPoint)info.newInstance();
        }

        public MgrTypeInfo toType(BComponent comp) {
            return new OnyxxMgrTypeInfo(comp);
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList<OnyxxMgrTypeInfo> list = new ArrayList<OnyxxMgrTypeInfo>();
            list.add(new OnyxxMgrTypeInfo(BOnyxxVoltageInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.voltageInput, "type.OnyxxVoltageInputProxyExtPoint"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxResistiveInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.resistiveInput, "type.OnyxxResistiveInputProxyExtPoint"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxResistiveInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), (BProxyConversion)BThermistorType3Conversion.DEFAULT, BPointTypeEnum.resistiveInput, "type.OnyxxThermistorInputProxyExtPoint"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxCurrentInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.currentInput, "type.OnyxxCurrentInputProxyExtPoint"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxCounterInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.resistivePulseInput, "type.OnyxxCounterInputProxyExtPoint"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxBooleanInputProxyExt.TYPE.getTypeInfo(), BBooleanPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.booleanResistiveInput, "type.OnyxxBooleanInputResistiveProxyExtPoint"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxBooleanInputProxyExt.TYPE.getTypeInfo(), BBooleanPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.booleanVoltageInput, "type.OnyxxBooleanInputVoltageProxyExtPoint"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxBooleanInputProxyExt.TYPE.getTypeInfo(), BBooleanPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.booleanCurrentInput, "type.OnyxxBooleanInputCurrentProxyExtPoint"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxVoltageOutputProxyExt.TYPE.getTypeInfo(), BNumericWritable.TYPE.getTypeInfo(), null, BPointTypeEnum.voltageOutput, "type.OnyxxVoltageOutputProxyExtWritable"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxBooleanOutputProxyExt.TYPE.getTypeInfo(), BBooleanWritable.TYPE.getTypeInfo(), null, BPointTypeEnum.booleanOutput, "type.OnyxxBooleanOutputProxyExtWritable"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxBooleanOutputProxyExt.TYPE.getTypeInfo(), BBooleanWritable.TYPE.getTypeInfo(), null, BPointTypeEnum.booleanOutput, "type.OnyxxBooleanOutputProxyExtWritable"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxInternalTemperatureInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.internalTemperatureInput, "type.OnyxxInternalTemperatureInputProxyExtPoint"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxInternalVoltageRegulator3_3VInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.internalVoltageRegulator3_3VInput, "type.OnyxxInternalVoltageRegulator3_3VInputProxyExtPoint"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxInternalVoltageRegulator5VInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.internalVoltageRegulator5VInput, "type.OnyxxInternalVoltageRegulator5VInputProxyExtPoint"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxInternalVoltageRegulator15VInputProxyExt.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.internalVoltageRegulator15VInput, "type.OnyxxInternalVoltageRegulator15VInputProxyExtPoint"));
            list.add(new OnyxxMgrTypeInfo(BOnyxxDigitalBooleanInputProxyExt.TYPE.getTypeInfo(), BBooleanPoint.TYPE.getTypeInfo(), null, BPointTypeEnum.digitalBooleanInput, "type.OnyxxDigitalBooleanInputProxyExtPoint"));
            return list.toArray(new MgrTypeInfo[list.size()]);
        }
    }
}

