/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxConverter.ui;

import com.lynxspring.onyxxConverter.BOnyxxImportDevice;
import com.lynxspring.onyxxConverter.ui.BOnyxxConverterDeviceManager;
import com.lynxspring.onyxxConverter.util.BOnyxxConverterParameters;
import com.lynxspring.onyxxDriver.devices.BOnyxx534Device;
import com.lynxspring.onyxxDriver.devices.BOnyxxDevice;
import com.lynxspring.onyxxDriver.devices.BOnyxxXm34Device;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.BTemplateTable;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;

public class OnyxxConverterDeviceController
extends FolderController {
    public final MgrController.MgrCommand importDevice;
    private boolean importJobInProgress;

    public OnyxxConverterDeviceController(BDeviceManager manager) {
        super((BFolderManager)manager);
        this.importDevice = new ImportDevice((BWidget)manager);
        this.importDevice.setFlags(23);
        this.importDevice.setEnabled(false);
        this.importJobInProgress = false;
        this.add.setEnabled(false);
        this.cancel.setEnabled(false);
        this.deploy.setEnabled(false);
        this.edit.setEnabled(false);
        this.match.setEnabled(false);
        this.newCommand.setEnabled(false);
        this.newFolder.setEnabled(false);
        this.quickAdd.setEnabled(false);
        this.quickMatch.setEnabled(false);
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        return new MgrController.IMgrCommand[]{this.discover, this.importDevice};
    }

    public void updateCommands() {
        int[] learnSelected = this.getLearnSelectedRows();
        int[] selected = this.getSelectedRows();
        if (learnSelected.length == 1 && selected.length == 1 && !this.importJobInProgress) {
            BOnyxxImportDevice dis = (BOnyxxImportDevice)this.getLearnTable().getSelectedObject();
            BOnyxxDevice db = (BOnyxxDevice)this.getTable().getSelectedComponent();
            this.importDevice.setEnabled(this.isImportable(dis, db));
        } else {
            this.importDevice.setEnabled(false);
        }
    }

    public CommandArtifact drop(BMgrTable table, TransferContext cx) throws Exception {
        return null;
    }

    public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
    }

    public void cellDoubleClicked(BLearnTable table, BMouseEvent event, int row, int col) {
    }

    public void cellDoubleClicked(BTreeTable table, BMouseEvent event, int row, int col) {
    }

    public void cellDoubleClicked(BTemplateTable table, BMouseEvent event, int row, int col) {
    }

    public CommandArtifact doImportDevice(Context cx) throws Exception {
        if (!this.getManager().isLearnable()) {
            return null;
        }
        BOnyxxImportDevice dis = (BOnyxxImportDevice)this.getLearnTable().getSelectedObject();
        if (dis == null) {
            return null;
        }
        BOnyxxDevice db = (BOnyxxDevice)this.getTable().getSelectedComponent();
        if (db != null) {
            BOnyxxConverterParameters deviceParams = new BOnyxxConverterParameters(dis.getDeviceHandle(), db.getHandleOrd(), this.getLearnTable().getSelection().getRow());
            this.getManager().getLearn().setJob(((BOnyxxConverterDeviceManager)this.getManager()).getNetwork().submitIoDeviceImportJob(deviceParams));
            this.setImportJobInProgress(true);
            BDialog.info((BWidget)this.getManager(), (String)"Import In Progress", (Object)("Point Import Job Started For " + dis.getDeviceName() + " To " + db.getName()));
        }
        return null;
    }

    public void setImportJobInProgress(boolean status) {
        this.importJobInProgress = status;
        this.updateCommands();
    }

    public CommandArtifact doDiscover(Context cx) throws Exception {
        this.learnMode.setSelected(true);
        this.getManager().getLearn().setJob(((BOnyxxConverterDeviceManager)this.getManager()).getNetwork().submitIoDeviceDiscoveryJob());
        return null;
    }

    private boolean isImportable(BOnyxxImportDevice ioDev, BOnyxxDevice onyxxDev) {
        if (onyxxDev.getType() != BOnyxx534Device.TYPE && onyxxDev.getType() != BOnyxxXm34Device.TYPE) {
            return false;
        }
        if (onyxxDev.get("ioImportTag") != null) {
            String ioDevImported = ioDev.getImported();
            String onyxxDevImported = onyxxDev.get("ioImportTag").toString();
            if (!ioDevImported.isEmpty() && !onyxxDevImported.isEmpty()) {
                String[] ioDevImportedNameArray = ioDevImported.split(";");
                String[] onyxxDevImportedHandleArray = onyxxDevImported.split(";");
                for (int x = 0; x < ioDevImportedNameArray.length; ++x) {
                    String currentImp = ioDevImportedNameArray[x];
                    if (!currentImp.equals(onyxxDev.getName())) continue;
                    for (int y = 0; y < onyxxDevImportedHandleArray.length; ++y) {
                        String currentHandle = onyxxDevImportedHandleArray[y];
                        if (!currentHandle.equals(ioDev.getDeviceHandle().toString())) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    class ImportDevice
    extends MgrController.MgrCommand {
        ImportDevice(BWidget owner) {
            super(owner, "Import Device");
        }

        public CommandArtifact doInvoke() throws Exception {
            return OnyxxConverterDeviceController.this.doImportDevice(null);
        }
    }
}

