/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxConverter.ui;

import com.lynxspring.onyxxConverter.BOnyxxImportDevice;
import com.lynxspring.onyxxConverter.jobs.BOnyxxConverterDeviceDiscoveryJob;
import com.lynxspring.onyxxConverter.jobs.BOnyxxConverterImportJob;
import com.lynxspring.onyxxConverter.ui.OnyxxConverterDeviceController;
import com.lynxspring.onyxxDriver.devices.BOnyxxDevice;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.tridium.util.ArrayUtil;
import com.tridium.workbench.job.BJobBar;
import javax.baja.driver.BDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTagDictionary;
import javax.baja.workbench.mgr.MgrTemplate;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"onyxxDriver:OnyxxNetwork"})})
public class BOnyxxConverterDeviceManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType(BOnyxxConverterDeviceManager.class);
    BOnyxxImportDevice[] lastLearn;
    public BOnyxxNetwork network = null;
    public static final String TAG_PROP_LABEL = "ioImportTag";

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
    }

    protected MgrLearn makeLearn() {
        return new Learn((BAbstractManager)this);
    }

    protected MgrState makeState() {
        return null;
    }

    protected MgrTagDictionary makeTagDictionary() {
        return null;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrTemplate makeTemplate() {
        return null;
    }

    public boolean supportsTemplates() {
        return false;
    }

    protected MgrController makeController() {
        return new OnyxxConverterDeviceController(this);
    }

    public BOnyxxNetwork getNetwork() {
        if (this.network == null) {
            this.network = (BOnyxxNetwork)this.getCurrentValue();
        }
        return this.network;
    }

    public MgrTypeInfo[] toTypes() {
        return MgrTypeInfo.makeArray((Type)BOnyxxDevice.TYPE);
    }

    protected TypeInfo getDefaultType() {
        return BOnyxxDevice.TYPE.getTypeInfo();
    }

    private void updateDiscoveryRows(BComponent event) {
        Object[] rows = null;
        if (event.getType().is(BOnyxxConverterDeviceDiscoveryJob.TYPE)) {
            rows = (BOnyxxImportDevice[])event.getChildren(BOnyxxImportDevice.class);
            this.lastLearn = rows;
        } else if (event.getType().is(BOnyxxConverterImportJob.TYPE)) {
            BOnyxxConverterImportJob imjob = (BOnyxxConverterImportJob)event;
            imjob.lease(1);
            if (imjob.getIoDeviceForImportRowIndex() >= 0) {
                this.lastLearn[imjob.getIoDeviceForImportRowIndex()].setImported(imjob.getImportedStringValue());
            }
            rows = this.lastLearn;
        }
        this.getLearn().updateRoots(rows);
    }

    class Learn
    extends MgrLearn {
        BComponent target;
        MgrColumn colDevName;
        MgrColumn colDevType;
        MgrColumn colDevOrd;
        MgrColumn colImportTag;

        public Learn(BAbstractManager manager) {
            super(manager);
            this.colDevName = new MgrColumn.Prop(BOnyxxImportDevice.deviceName, 1);
            this.colDevType = new MgrColumn.Prop(BOnyxxImportDevice.deviceType, 1);
            this.colDevOrd = new MgrColumn.Prop(BOnyxxImportDevice.deviceHandle, 1);
            this.colImportTag = new MgrColumn.Prop(BOnyxxImportDevice.imported, 1);
        }

        public BComponent getTarget() {
            return this.target;
        }

        protected BWidget makeJobBar() {
            return new BJobBar();
        }

        public void load(BComponent target) {
            super.load(target);
            this.target = target;
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{this.colDevName, this.colDevType, this.colDevOrd, this.colImportTag};
        }

        public MgrTypeInfo[] toTypes(Object o) throws Exception {
            return MgrTypeInfo.makeArray((Type)BOnyxxImportDevice.TYPE);
        }

        public void toRow(Object o, MgrEditRow row) throws Exception {
            BOnyxxImportDevice impDev = (BOnyxxImportDevice)o;
            row.setName(impDev.getDeviceName());
            row.setCell(this.colDevName, (BValue)BString.make((String)impDev.getDeviceName()));
            row.setCell(this.colDevType, (BValue)BString.make((String)impDev.getDeviceType()));
            row.setCell(this.colDevOrd, (BValue)impDev.getDeviceHandle());
            row.setCell(this.colImportTag, (BValue)BString.make((String)impDev.getImported()));
        }

        public boolean isMatchable(Object discovery, BComponent database) {
            return super.isMatchable(discovery, database);
        }

        public BImage getIcon(Object node) {
            return BImage.DEFAULT;
        }

        public boolean hasChildren(Object node) {
            return false;
        }

        public Object[] getChildren(Object node) {
            return new Object[0];
        }

        public boolean isExisting(Object dis, BComponent comp) {
            return false;
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            BOnyxxConverterDeviceManager.this.updateDiscoveryRows((BComponent)job);
            if (job.getType().is(BOnyxxConverterImportJob.TYPE)) {
                ((OnyxxConverterDeviceController)this.getManager().getController()).setImportJobInProgress(false);
            }
        }
    }

    class Model
    extends DeviceModel {
        MgrColumn[] ourModelCols;

        Model(BOnyxxConverterDeviceManager manager) {
            super((BDeviceManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            Property[] props = new BOnyxxDevice().getPropertiesArray();
            this.ourModelCols = super.makeColumns();
            Object[] ourColumns = new MgrColumn[props.length];
            for (int i = 0; i < props.length; ++i) {
                Property prop = props[i];
                int propFlags = prop.getDefaultFlags();
                int colFlags = 0;
                if ((propFlags & 8) == 0) {
                    colFlags |= 2;
                }
                ourColumns[i] = new MgrColumn.Prop(props[i], colFlags);
            }
            this.ourModelCols = (MgrColumn[])ArrayUtil.add((Object[])this.ourModelCols, (Object[])ourColumns);
            this.ourModelCols = (MgrColumn[])ArrayUtil.addOne((Object[])this.ourModelCols, (Object)new MgrColumn.PropString(BOnyxxConverterDeviceManager.TAG_PROP_LABEL, 1));
            return this.ourModelCols;
        }

        public Type getFolderType() {
            return BDeviceFolder.TYPE;
        }

        private BOnyxxConverterDeviceManager getOnyxxConverterDeviceManager() {
            BOnyxxConverterDeviceManager manager = (BOnyxxConverterDeviceManager)this.getManager();
            return manager;
        }

        public MgrTypeInfo[] getNewTypes() {
            return this.getOnyxxConverterDeviceManager().toTypes();
        }
    }
}

