/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.schema.ui;

import com.tridium.seriestransform.graph.BNodeContainer;
import com.tridium.seriestransform.schema.ui.BNodeSchemaEditor;
import com.tridium.workbench.fieldeditors.BDialogFE;
import java.util.ArrayList;
import java.util.List;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.seriestransform.exceptions.SchemaException;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BRoundedDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"seriesTransform:SeriesSchema"})})
@NiagaraAction(name="loadFromSource", parameterType="BOrd", defaultValue="BOrd.NULL")
public class BNodeSchemaFE
extends BDialogFE {
    @Generated
    public static final Action loadFromSource = BNodeSchemaFE.newAction((int)0, (BValue)BOrd.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNodeSchemaFE.class);
    private static final Lexicon lex = Lexicon.make(BNodeSchemaEditor.class);
    private static final String TITLE = "nodeschemeeditor.title";
    private static final String LEX_COL_NAME = lex.getText("schemaeditor.colname");
    private static final String LEX_COL_TYPE = lex.getText("schemaeditor.coltype");
    private static final int COL_NAME = 0;
    private static final int COL_TYPE = 1;
    private BSeriesSchema schema;
    private BOrd srcOrd = BOrd.DEFAULT;
    private boolean readonly;
    private final BTable display;
    private final List<SchemaRecord> rows = new ArrayList<SchemaRecord>();

    @Generated
    public void loadFromSource(BOrd parameter) {
        this.invoke(loadFromSource, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNodeSchemaFE() {
        this.display = new BTable((TableModel)new Model());
        BScrollPane scroll = new BScrollPane((BWidget)this.display);
        scroll.setVpolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane pane = new BConstrainedPane((BWidget)scroll);
        pane.setMinHeight(100.0);
        pane.setMinWidth(200.0);
        BFlowPane flow = new BFlowPane();
        flow.add(null, (BValue)pane);
        flow.add(null, (BValue)this.getEditButton());
        this.setContent((BWidget)flow);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        Property[] properties;
        this.schema = (BSeriesSchema)value;
        BPermissions permissions = this.schema.getPermissions(context);
        this.setReadonly(!permissions.hasOperatorWrite());
        this.schema.lease();
        this.rows.clear();
        for (Property p : properties = this.schema.getDynamicPropertiesArray()) {
            String name = p.getName();
            BValue v = this.get(p);
            SchemaRecord r = new SchemaRecord(name, v.toString());
            this.rows.add(r);
        }
        this.display.getModel().updateTable();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        return this.schema;
    }

    protected void doSetReadonly(boolean readonly) {
        this.readonly = readonly;
        this.updateEditButtonDisplay();
    }

    private void updateEditButtonDisplay() {
        this.getEditButton().setVisible(!this.readonly && this.srcOrd == BOrd.DEFAULT);
    }

    public void doEditPressed() {
        BNodeSchemaEditor editor = new BNodeSchemaEditor(this.schema);
        Context cx = this.getCurrentContext();
        int result = BRoundedDialog.open((BWidget)this, (String)lex.getText(TITLE), (Object)((Object)editor), (int)3);
        if (result == 1) {
            BComplex parent;
            String[] fieldNames;
            BSeriesSchema sch = editor.getSchema();
            this.schema.removeAll();
            for (String fieldName : fieldNames = sch.getFieldNames()) {
                BTypeSpec fieldType = sch.getFieldType(fieldName);
                BFacets fieldFacets = sch.getFieldFacets(fieldName);
                if (this.schema.hasField(fieldName)) continue;
                this.schema.addField(fieldName, fieldType, fieldFacets);
            }
            this.loadValue((BObject)this.schema, cx);
            this.setModified();
            for (parent = this.schema.getParent(); null != parent && !(parent instanceof BNodeContainer); parent = parent.getParent()) {
            }
            if (parent instanceof BNodeContainer) {
                ((BNodeContainer)parent).forceSchemaCheck();
            }
        }
    }

    public void doLoadFromSource(BOrd srcOrd) {
        BObject src = null;
        this.srcOrd = srcOrd;
        this.updateEditButtonDisplay();
        if (srcOrd != BOrd.NULL) {
            src = srcOrd.resolve((BObject)this.schema).get();
        }
        if (null == src) {
            return;
        }
        try {
            this.schema.loadSchema(src);
        }
        catch (SchemaException e) {
            throw new BajaRuntimeException(e.getMessage());
        }
        this.loadValue((BObject)this.schema, this.getCurrentContext());
        this.setModified();
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return LEX_COL_NAME;
                }
                case 1: {
                    return LEX_COL_TYPE;
                }
            }
            return "?";
        }

        public int getRowCount() {
            return BNodeSchemaFE.this.rows.size();
        }

        public Object getValueAt(int row, int col) {
            if (row >= BNodeSchemaFE.this.rows.size()) {
                return null;
            }
            SchemaRecord record = (SchemaRecord)BNodeSchemaFE.this.rows.get(row);
            switch (col) {
                case 0: {
                    return record.colName;
                }
                case 1: {
                    return record.colType;
                }
            }
            return "?";
        }
    }

    private static class SchemaRecord {
        public String colName;
        public String colType;

        public SchemaRecord(String name, String type) {
            this.colName = name;
            this.colType = type;
        }
    }
}

