/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.functions.ui;

import com.tridium.seriestransform.functions.BFindAverage;
import com.tridium.seriestransform.functions.BFunctionMap;
import com.tridium.seriestransform.functions.BFunctionMapping;
import com.tridium.seriestransform.functions.BPassThrough;
import com.tridium.seriestransform.functions.ui.BFunctionMappingConf;
import com.tridium.seriestransform.functions.ui.BFunctionMappingConfEditor;
import com.tridium.seriestransform.graph.ui.BConfigEditor;
import com.tridium.seriestransform.graph.ui.BConfigItem;
import com.tridium.seriestransform.graph.ui.BSchemaConfigEditor;
import com.tridium.seriestransform.rollup.BRollupNode;
import com.tridium.seriestransform.terminal.ui.BTerminalConfig;
import com.tridium.util.EscUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BRoundedDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
public class BFunctionMapBuilder
extends BSchemaConfigEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BFunctionMapBuilder.class);
    private static final Lexicon lex = Lexicon.make(BFunctionMapBuilder.class);
    private static final String TITLE = lex.getText("functionRefEditor.title");
    private static final String DISPLAY_TITLE = lex.getText("outputSchemaEditor.schema");
    private static final Command[] EMPTY_COMMANDS = new Command[0];
    private final List<BLink> confModifiedLinks = new LinkedList<BLink>();
    private BGraphNode srcNode;
    private BFunctionMap mappings;
    private final Set<String> addedMappings = new HashSet<String>();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BFunctionMap open(BWidget owner, BFunctionMap collection) throws Exception {
        if (null == collection) {
            throw new Exception("Cannot edit NULL function map.");
        }
        BFunctionMapBuilder fre = new BFunctionMapBuilder(collection);
        int r = BRoundedDialog.open((BWidget)owner, (String)TITLE, (Object)((Object)fre), (int)3);
        if (r != 1) {
            return null;
        }
        collection = fre.saveMappings();
        return collection;
    }

    public BFunctionMapBuilder() {
    }

    public BFunctionMapBuilder(BFunctionMap mappings) {
        mappings.lease();
        this.mappings = mappings;
        this.srcNode = (BGraphNode)mappings.getParent();
        BWidget display = this.buildTableDisplay(DISPLAY_TITLE, new Command[]{new PopulateDefaultsCmd((BWidget)this), new AddFunctionCmd((BWidget)this)});
        this.setCenter(display);
        this.addKeyFieldDisplay();
        this.loadMappingConfigs();
    }

    private void addKeyFieldDisplay() {
        BSeriesSchema schema = this.srcNode.getSchema();
        schema.lease();
        String keyField = schema.getKeyField();
        BTypeSpec keyType = schema.getFieldType(keyField);
        BFacets keyFacets = schema.getFieldFacets(keyField);
        if (null == keyType) {
            return;
        }
        String note = "";
        if (null != keyFacets) {
            try {
                note = keyFacets.toString((Context)keyFacets);
            }
            catch (RuntimeException re) {
                log.log(Level.SEVERE, re.getMessage(), re);
            }
        }
        BTerminalConfig keyElement = new BTerminalConfig(keyField, keyType.toString(), note);
        this.addConfig(keyElement, EMPTY_COMMANDS);
    }

    private void loadMappingConfigs() {
        BFunctionMapping[] savedMappings;
        this.addedMappings.clear();
        this.mappings.lease();
        for (BFunctionMapping mapping : savedMappings = (BFunctionMapping[])this.mappings.getChildren(BFunctionMapping.class)) {
            mapping.lease();
            this.addFunctionMappingConfig(mapping);
        }
    }

    private void addFunctionMappingConfig(BFunctionMapping mapping) {
        String descName = mapping.getOutputField();
        if (!this.addedMappings.contains(descName)) {
            BFunctionMappingConf descConf = new BFunctionMappingConf(mapping, this.srcNode);
            this.addedMappings.add(descName);
            this.rows.add(descConf);
            BLink link = this.linkTo((BComponent)descConf, (Slot)BConfigItem.modified, (Slot)setModified);
            this.confModifiedLinks.add(link);
            Command[] commands = new Command[]{new EditFunctionCmd((BWidget)this, descConf), new RemoveFunctionCmd((BWidget)this, descConf)};
            this.addConfig(descConf, commands);
        }
    }

    public BFunctionMap saveMappings() throws Exception {
        this.mappings.removeAll();
        for (BConfigItem item : this.rows) {
            BFunctionMappingConf conf = (BFunctionMappingConf)item;
            BFunctionMapping mapping = conf.saveMapping();
            this.normalizeUnits(mapping);
            this.mappings.add(null, mapping.newCopy(true));
        }
        return this.mappings;
    }

    private void normalizeUnits(BFunctionMapping mapping) {
        String[] inputFields;
        mapping.lease();
        BFacets facets = mapping.getFacets();
        BUnit unitFacets = (BUnit)facets.get("units", (BObject)BUnit.DEFAULT);
        if (unitFacets != BUnit.DEFAULT) {
            return;
        }
        BUnit commonUnit = BUnit.DEFAULT;
        BGraphNode[] sources = this.srcNode.getSources();
        for (String fieldName : inputFields = mapping.getArgumentFields()) {
            String[] split = TextUtil.split((String)fieldName, (char)'.');
            String srcName = split[0];
            BSeriesSchema srcSchema = null;
            for (BGraphNode source : sources) {
                if (!source.getName().equals(srcName)) continue;
                srcSchema = source.getSchema();
                break;
            }
            if (null == srcSchema) continue;
            srcSchema.lease();
            BFacets fieldFacets = srcSchema.getFieldFacets(split[1]);
            BUnit fieldUnits = (BUnit)fieldFacets.get("units", (BObject)BUnit.DEFAULT);
            if (fieldUnits == BUnit.DEFAULT) continue;
            if (commonUnit == BUnit.DEFAULT) {
                commonUnit = fieldUnits;
                continue;
            }
            if (commonUnit == fieldUnits) continue;
            return;
        }
        if (commonUnit != BUnit.DEFAULT) {
            facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)commonUnit);
            mapping.setFacets(facets);
        }
    }

    @Override
    public void doSetReadonly(boolean readonly) {
        super.doSetReadonly(readonly);
    }

    protected class PopulateDefaultsCmd
    extends Command {
        public PopulateDefaultsCmd(BWidget owner) {
            super(owner, "");
        }

        public BImage getIcon() {
            return BConfigEditor.populateDefaults;
        }

        public CommandArtifact doInvoke() throws Exception {
            BGraphNode[] sources = BFunctionMapBuilder.this.srcNode.getSources();
            if (sources.length == 0) {
                return null;
            }
            BSeriesSchema srcSchema = sources[0].getSchema();
            srcSchema.lease();
            String seriesName = sources[0].getName();
            String[] inputFields = srcSchema.getFieldNames();
            BTypeSpec defaultFunctionType = BPassThrough.TYPE.getTypeSpec();
            if (BFunctionMapBuilder.this.srcNode instanceof BRollupNode) {
                defaultFunctionType = BFindAverage.TYPE.getTypeSpec();
            }
            this.addDefaultFunctions(srcSchema, defaultFunctionType, seriesName, inputFields);
            List functions = BTransformFunction.getAllFunctions();
            for (BTransformFunction function : functions) {
                if (function.getType().is(BPassThrough.TYPE)) continue;
                Type[] argumentTypes = function.getArgumentTypes();
                String functionName = function.getFunctionName();
                BFunctionMapping mapping = new BFunctionMapping();
                BVector vector = new BVector();
                HashSet<BFacets> inputFacets = new HashSet<BFacets>();
                block1: for (String fieldName : inputFields) {
                    BTypeSpec fieldType = srcSchema.getFieldType(fieldName);
                    BFacets fieldFacets = srcSchema.getFieldFacets(fieldName);
                    TypeInfo typeInfo = fieldType.getTypeInfo();
                    for (Type argumentType : argumentTypes) {
                        if (!typeInfo.is(argumentType)) continue;
                        inputFacets.add(fieldFacets);
                        vector.add(null, (BValue)BString.make((String)(seriesName + "." + fieldName)));
                        continue block1;
                    }
                }
                if (vector.getPropertiesArray().length == 0) continue;
                mapping.setInputFields(vector);
                mapping.setFunctionTypeSpec(function.getType().getTypeSpec());
                mapping.setOutputField(EscUtil.slot.escape(functionName));
                if (inputFacets.size() == 1) {
                    Iterator facetsIt = inputFacets.iterator();
                    BFacets facets = (BFacets)facetsIt.next();
                    mapping.setFacets(facets);
                }
                BFunctionMapBuilder.this.addFunctionMappingConfig(mapping);
            }
            BFunctionMapBuilder.this.setModified();
            return null;
        }

        private void addDefaultFunctions(BSeriesSchema srcSchema, BTypeSpec functionType, String seriesName, String[] inputFields) {
            String keyField = srcSchema.getKeyField();
            for (String inputField : inputFields) {
                String fieldName = inputField;
                if (fieldName.equals(keyField)) continue;
                BFunctionMapping mapping = new BFunctionMapping();
                BVector vector = new BVector();
                mapping.setFunctionTypeSpec(functionType);
                vector.add(null, (BValue)BString.make((String)(seriesName + "." + fieldName)));
                mapping.setInputFields(vector);
                fieldName = TextUtil.replace((String)fieldName, (String)".", (String)"_");
                mapping.setOutputField(fieldName);
                mapping.setFacets(srcSchema.getFieldFacets(fieldName));
                BFunctionMapBuilder.this.addFunctionMappingConfig(mapping);
            }
        }
    }

    protected class EditFunctionCmd
    extends Command {
        BFunctionMappingConf conf;

        public EditFunctionCmd(BWidget owner, BFunctionMappingConf conf) {
            super(owner, "");
            this.conf = conf;
        }

        public BImage getIcon() {
            return BConfigEditor.editIcon;
        }

        public CommandArtifact doInvoke() {
            String oldName = this.conf.getOutputField();
            try {
                BFunctionMapping mapping = BFunctionMappingConfEditor.open((BWidget)this.getShell(), this.conf.saveMapping(), BFunctionMapBuilder.this.srcNode);
                if (null != mapping) {
                    BFunctionMapBuilder.this.addedMappings.remove(oldName);
                    this.conf.setFunctionMapping(mapping);
                    BFunctionMapBuilder.this.addedMappings.add(mapping.getOutputField());
                }
            }
            catch (Exception e) {
                throw new BajaRuntimeException(e.getMessage());
            }
            return null;
        }
    }

    protected class RemoveFunctionCmd
    extends Command {
        private final BFunctionMappingConf conf;

        public RemoveFunctionCmd(BWidget owner, BFunctionMappingConf conf) {
            super(owner, "");
            this.conf = conf;
        }

        public CommandArtifact doInvoke() throws Exception {
            BFunctionMapBuilder.this.rows.remove((Object)this.conf);
            BFunctionMapBuilder.this.setModified();
            BFunctionMapBuilder.this.removeConfig((BWidget)this.conf);
            return null;
        }

        public BImage getIcon() {
            return minusIcon;
        }
    }

    protected class AddFunctionCmd
    extends Command {
        public AddFunctionCmd(BWidget owner) {
            super(owner, "");
        }

        public CommandArtifact doInvoke() throws Exception {
            BFunctionMapping mapping = BFunctionMappingConfEditor.open((BWidget)this.getShell(), null, BFunctionMapBuilder.this.srcNode);
            if (null != mapping && mapping.getInputFields().getDynamicPropertiesArray().length > 0) {
                BFunctionMapBuilder.this.addFunctionMappingConfig(mapping);
                BFunctionMapBuilder.this.setModified();
            }
            return null;
        }

        public BImage getIcon() {
            return addIcon;
        }
    }
}

