/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.composite.ui;

import com.tridium.seriestransform.SeriesColumn;
import com.tridium.seriestransform.graph.ui.BConfigEditor;
import com.tridium.seriestransform.graph.ui.BSchemaConfigItem;
import com.tridium.seriestransform.schema.ui.BSchemaFacetsFE;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.workbench.BWbPlugin;

@NiagaraType
@NiagaraProperty(name="invalidSrc", type="boolean", defaultValue="false")
@NiagaraActions(value={@NiagaraAction(name="checkSrcField"), @NiagaraAction(name="updateFacets")})
public class BCompositeConfig
extends BSchemaConfigItem {
    @Generated
    public static final Property invalidSrc = BCompositeConfig.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Action checkSrcField = BCompositeConfig.newAction((int)0, null);
    @Generated
    public static final Action updateFacets = BCompositeConfig.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCompositeConfig.class);
    private static final Logger log = Logger.getLogger("seriesTransform");
    private final BListDropDown inputs = new BListDropDown();
    private final BSchemaFacetsFE facetsFE = new BSchemaFacetsFE();
    private BLabel facetsDisplay;
    private String[] validInputFields = new String[0];

    @Generated
    public boolean getInvalidSrc() {
        return this.getBoolean(invalidSrc);
    }

    @Generated
    public void setInvalidSrc(boolean v) {
        this.setBoolean(invalidSrc, v, null);
    }

    @Generated
    public void checkSrcField() {
        this.invoke(checkSrcField, null, null);
    }

    @Generated
    public void updateFacets() {
        this.invoke(updateFacets, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCompositeConfig() {
    }

    public BCompositeConfig(String[] inputColumns) {
        this(inputColumns, null, null, BFacets.DEFAULT);
    }

    public BCompositeConfig(String[] inputColumns, String selectedColumn, String outputColName, BFacets fieldFacets) {
        this.validInputFields = inputColumns;
        this.facetsFE.loadValue((BObject)fieldFacets);
        if (null != outputColName) {
            this.outputField.setText(SlotPath.unescape((String)outputColName));
        }
        this.linkTo((BComponent)this.outputField, (Slot)BTextEditor.textModified, (Slot)modified);
        this.linkTo((BComponent)this.inputs, (Slot)BDropDown.valueModified, (Slot)checkSrcField);
        this.linkTo((BComponent)this.inputs, (Slot)BDropDown.valueModified, (Slot)modified);
        this.linkTo((BComponent)this.facetsFE, (Slot)BWbPlugin.setModified, (Slot)updateFacets);
        this.linkTo((BComponent)this.facetsFE, (Slot)BWbPlugin.setModified, (Slot)modified);
        if (inputColumns.length > 0) {
            this.buildSrcFieldSelector(inputColumns, selectedColumn);
        } else {
            this.inputs.getList().addItem((Object)outputColName);
            this.inputs.setSelectedIndex(0);
        }
        this.buildUI();
    }

    public BCompositeConfig(String selectedCol, String outputCol, BFacets fieldFacets) {
        this.outputField.setText(SlotPath.unescape((String)outputCol));
        this.outputField.setEnabled(false);
        this.facetsFE.loadValue((BObject)fieldFacets);
        this.facetsFE.setEnabled(false);
        this.facetsFE.setVisible(false);
        this.inputs.getList().addItem((Object)selectedCol);
        this.inputs.setSelectedIndex(0);
        this.inputs.setEnabled(false);
        this.linkTo((BComponent)this.facetsFE, (Slot)BWbPlugin.setModified, (Slot)updateFacets);
        this.linkTo((BComponent)this.facetsFE, (Slot)BWbPlugin.setModified, (Slot)modified);
        this.buildUI();
    }

    private void buildSrcFieldSelector(String[] inputColumns, String selectedColumn) {
        int index = -1;
        int i = 0;
        for (String colName : inputColumns) {
            String[] split = TextUtil.split((String)colName, (char)'.');
            if (split[split.length - 1].equals(SeriesColumn.COL_TIMESTAMP)) {
                --i;
                continue;
            }
            this.inputs.getList().addItem((Object)colName);
            if (null != selectedColumn && colName.equalsIgnoreCase(selectedColumn)) {
                index = i;
            }
            ++i;
        }
        if (index < 0) {
            this.inputs.getList().addItem((Object)selectedColumn);
            this.inputs.setSelectedItem((Object)selectedColumn);
            this.setInvalidSrc(true);
        } else {
            this.inputs.setSelectedIndex(index);
        }
    }

    private void buildUI() {
        this.facetsDisplay = BConfigEditor.makeNoteLabel(this.facetsFE.getFacetString());
        BGridPane pane = new BGridPane(4);
        pane.add(null, (BValue)this.statusIcon);
        pane.add(null, (BValue)this.outputField);
        pane.add(null, (BValue)this.inputs);
        pane.add(null, (BValue)this.facetsFE);
        BGridPane display = new BGridPane(2);
        display.add(null, (BValue)new BLabel(BConfigEditor.IMG_BLANK));
        display.add(null, (BValue)this.facetsDisplay);
        BGridPane content = new BGridPane(1);
        content.add(null, (BValue)pane);
        content.add(null, (BValue)display);
        content.setHalign(BHalign.left);
        this.setCenter((BWidget)content);
    }

    public String getInputField() {
        return (String)this.inputs.getSelectedItem();
    }

    public BFacets getFieldFacets() {
        try {
            return (BFacets)this.facetsFE.saveValue();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return BFacets.DEFAULT;
        }
    }

    public void setReadonly(boolean readonly) {
        this.outputField.setEnabled(!readonly);
        this.inputs.setEnabled(!readonly);
    }

    public void doCheckSrcField() {
        String selectedSrcField = (String)this.inputs.getSelectedItem();
        for (String validInputField : this.validInputFields) {
            if (!validInputField.equals(selectedSrcField)) continue;
            this.setInvalidSrc(false);
            return;
        }
        this.setInvalidSrc(true);
    }

    public void doUpdateFacets() {
        this.facetsDisplay.setText(this.facetsFE.getFacetString());
    }

    @Override
    public void changed(Property prop, Context context) {
        if (prop == invalidName || prop == duplicateName || prop == invalidSrc) {
            boolean invName = this.getInvalidName();
            boolean dup = this.getDuplicateName();
            boolean invSrc = this.getInvalidSrc();
            this.setDisplayWarningStatus(invName || dup || invSrc);
        }
    }
}

