/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.rp.servlet;

import com.tridium.saml.authnScheme.BSAMLAuthenticationScheme;
import com.tridium.saml.rp.AuthnRequest;
import com.tridium.saml.utils.SAMLUtils;
import com.tridium.security.SAMLPermission;
import java.security.Permission;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class SAMLUuidMap<T> {
    private static final long EXECUTOR_DELAY = TimeUnit.MINUTES.toMillis(1L);
    private static final long EXECUTOR_FREQUENCY = TimeUnit.MINUTES.toMillis(5L);
    private Map<UUID, AbstractMap.SimpleEntry<T, Long>> map;
    private ScheduledFuture<?> task;
    private ScheduledExecutorService executor;
    private final long staleThreshold;
    public static final SAMLUuidMap<BSAMLAuthenticationScheme> IN_RESPONSE_TO_SCHEME_MAP = new SAMLUuidMap(TimeUnit.MINUTES.toMillis(10L));
    public static final SAMLUuidMap<AuthnRequest> UUID_TO_AUTHN_REQUEST_MAP = new SAMLUuidMap(TimeUnit.MINUTES.toMillis(2L));

    private SAMLUuidMap(long staleThreshold) {
        this.staleThreshold = staleThreshold;
    }

    public synchronized void init() {
        this.checkSamlPermission();
        if (this.task != null || this.executor != null || this.map != null) {
            this.destroy();
        }
        if (SAMLUtils.isLoggable(Level.FINEST)) {
            SAMLUtils.log(Level.FINEST, "Starting SAML uuid/item map cleanup task executor.");
        }
        this.map = new HashMap<UUID, AbstractMap.SimpleEntry<T, Long>>();
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.task = this.executor.scheduleAtFixedRate(new CleanupTask(this.map), EXECUTOR_DELAY, EXECUTOR_FREQUENCY, TimeUnit.MILLISECONDS);
    }

    public synchronized void destroy() {
        this.checkSamlPermission();
        if (SAMLUtils.isLoggable(Level.FINEST)) {
            SAMLUtils.log(Level.FINEST, "Shutting down SAML uuid/item map cleanup task executor.");
        }
        if (this.task != null) {
            this.task.cancel(true);
            this.task = null;
            if (SAMLUtils.isLoggable(Level.FINEST)) {
                SAMLUtils.log(Level.FINEST, "SAML uuid/item map cleanup task cancelled.");
            }
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
            if (SAMLUtils.isLoggable(Level.FINEST)) {
                SAMLUtils.log(Level.FINEST, "SAML uuid/item map cleanup task executor shutdown.");
            }
        }
        if (this.map != null) {
            this.map.clear();
            this.map = null;
            if (SAMLUtils.isLoggable(Level.FINEST)) {
                SAMLUtils.log(Level.FINEST, "SAML uuid/item map cleared.");
            }
        }
    }

    public synchronized void put(UUID id, T item, long timeSkewMillis) {
        this.checkSamlPermission();
        if (this.map == null) {
            return;
        }
        AbstractMap.SimpleEntry<T, Long> pair = new AbstractMap.SimpleEntry<T, Long>(item, System.currentTimeMillis() + timeSkewMillis);
        this.map.put(id, pair);
    }

    public synchronized T get(UUID uuid) {
        this.checkSamlPermission();
        if (this.map == null) {
            return null;
        }
        AbstractMap.SimpleEntry<T, Long> pair = this.map.get(uuid);
        T scheme = pair == null ? null : (T)pair.getKey();
        this.map.remove(uuid);
        return scheme;
    }

    private void checkSamlPermission() {
        SAMLPermission permission = new SAMLPermission("addAuthnInfo");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)permission);
        }
    }

    private class CleanupTask
    extends TimerTask {
        private final Map<UUID, AbstractMap.SimpleEntry<T, Long>> map;

        public CleanupTask(Map<UUID, AbstractMap.SimpleEntry<T, Long>> map) {
            this.map = map;
        }

        @Override
        public void run() {
            this.cleanup();
        }

        private synchronized void cleanup() {
            if (this.map == null) {
                return;
            }
            if (SAMLUtils.isLoggable(Level.FINEST)) {
                SAMLUtils.log(Level.FINEST, "Cleaning up SAML uuid/item Map.");
            }
            long threshold = System.currentTimeMillis() - SAMLUuidMap.this.staleThreshold;
            Iterator<UUID> iterator = this.map.keySet().iterator();
            while (iterator.hasNext()) {
                UUID uuid = iterator.next();
                if (this.map.get(uuid).getValue().compareTo(threshold) >= 0) continue;
                if (SAMLUtils.isLoggable(Level.FINEST)) {
                    SAMLUtils.log(Level.FINEST, "Removing " + uuid.toString() + " from SAML uuid/item Map.");
                }
                iterator.remove();
            }
        }
    }
}

